/*
 * Decompiled with CFR 0.152.
 */
package org.exparity.expectamundo.core;

import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.HashMap;
import java.util.Map;
import net.sf.cglib.proxy.MethodProxy;
import org.apache.commons.lang.StringUtils;
import org.exparity.expectamundo.core.PrototypeValue;

public class PrototypeProperty
implements PrototypeValue {
    private final Method method;
    private final MethodProxy proxy;
    private final Object[] args;
    private final Map<String, Class<?>> typeParameters;
    private PrototypeProperty parent;

    public PrototypeProperty(PrototypeProperty parent, Method method, MethodProxy proxy, Object[] args, Map<String, Class<?>> typeParameters) {
        this.parent = parent;
        this.method = method;
        this.args = args;
        this.proxy = proxy;
        this.typeParameters = typeParameters;
    }

    @Override
    public Object getValue(Object actual) {
        try {
            return this.proxy.invoke(this.parent != null ? this.parent.getValue(actual) : actual, this.args);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return "<INDEX OUT OF BOUNDS>";
        }
        catch (ClassCastException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String getLabel() {
        return this.getPath();
    }

    public String getPath() {
        return this.parent != null ? this.parent.getPath() + "." + this.stripPrefix(this.method.getName()) : this.stripPrefix(this.method.getName());
    }

    private String stripPrefix(String name) {
        return this.args.length == 0 ? name + "()" : name + "(" + StringUtils.join((Object[])this.args, (String)",") + ")";
    }

    public Type getGenericReturnType() {
        return this.method.getGenericReturnType();
    }

    public Map<String, Class<?>> getGenericTypeArguments() {
        HashMap parameterizedTypes = new HashMap();
        if (this.method.getGenericReturnType() instanceof ParameterizedType) {
            Type[] typeArguments = ((ParameterizedType)this.method.getGenericReturnType()).getActualTypeArguments();
            TypeVariable<Class<T>>[] typeKeys = ((Class)((ParameterizedType)this.method.getGenericReturnType()).getRawType()).getTypeParameters();
            for (int i = 0; i < typeKeys.length; ++i) {
                Class<?> resolvedType;
                if (typeArguments[i] instanceof Class) {
                    parameterizedTypes.put(typeKeys[i].getName(), (Class)typeArguments[i]);
                    continue;
                }
                if (!(typeArguments[i] instanceof TypeVariable) || (resolvedType = this.resolveType((TypeVariable)typeArguments[i])) == null) continue;
                parameterizedTypes.put(typeKeys[i].getName(), resolvedType);
            }
            return parameterizedTypes;
        }
        return parameterizedTypes;
    }

    private Class<?> resolveType(TypeVariable<?> type) {
        return this.typeParameters.get(type.getName());
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [" + this.method.getDeclaringClass().getSimpleName() + ":" + this.proxy.getSignature().getName() + "]";
    }
}

