/*
 * Decompiled with CFR 0.152.
 */
package org.exparity.expectamundo.core.hamcrest;

import java.util.List;
import org.exparity.expectamundo.core.PrototypeValueMatcher;
import org.exparity.expectamundo.core.Prototyped;
import org.hamcrest.Description;
import org.hamcrest.Factory;
import org.hamcrest.TypeSafeDiagnosingMatcher;

public class PrototypeMatcher<T>
extends TypeSafeDiagnosingMatcher<T> {
    private final Class<T> rawType;
    private final List<PrototypeValueMatcher> expectations;

    @Factory
    public static <M> PrototypeMatcher<M> matchesPrototype(M prototype) {
        return new PrototypeMatcher<M>(prototype);
    }

    public PrototypeMatcher(T stub) {
        if (!Prototyped.class.isInstance(stub)) {
            throw new IllegalArgumentException("You can only match an expectation for a type created with Expectamundo.prototype()");
        }
        this.rawType = ((Prototyped)stub).getRawType();
        this.expectations = ((Prototyped)stub).getExpectations();
    }

    public void describeTo(Description description) {
        description.appendText("a ").appendText(this.rawType.getSimpleName());
        if (!this.expectations.isEmpty()) {
            description.appendText(" containing properties :");
            for (PrototypeValueMatcher expecation : this.expectations) {
                description.appendText("\n\t").appendText(expecation.getPropertyPath()).appendText(" ").appendText(expecation.getExpectation());
            }
        }
    }

    protected boolean matchesSafely(T actual, Description mismatchDescription) {
        mismatchDescription.appendText("a ").appendText(actual.getClass().getSimpleName()).appendText(" containing properties :\n");
        boolean matches = true;
        for (PrototypeValueMatcher expectation : this.expectations) {
            Object actualValue;
            if (expectation.matches(actualValue = expectation.getPropertyValue(actual))) continue;
            mismatchDescription.appendText("\t").appendText(expectation.getPropertyPath()).appendText(" ").appendValue(actualValue);
            matches = false;
        }
        return matches;
    }
}

