/*
 * Decompiled with CFR 0.152.
 */
package org.exparity.expectamundo;

import java.util.Collection;
import java.util.Date;
import org.exparity.expectamundo.core.Prototype;
import org.exparity.expectamundo.core.PrototypeChecker;
import org.exparity.expectamundo.core.PrototypeFactory;
import org.exparity.expectamundo.core.PrototypeListVerifier;
import org.exparity.expectamundo.core.PrototypeMatcherContext;
import org.exparity.expectamundo.core.PrototypeProperty;
import org.exparity.expectamundo.core.PrototypeValue;
import org.exparity.expectamundo.core.PrototypeVerifier;
import org.exparity.expectamundo.core.Prototyped;
import org.exparity.expectamundo.core.TypeReference;
import org.exparity.expectamundo.core.array.PrototypeArrayExpectation;
import org.exparity.expectamundo.core.collection.PrototypeCollectionExpectation;
import org.exparity.expectamundo.core.comparable.PrototypeComparableExpectation;
import org.exparity.expectamundo.core.date.PrototypeDateExpectation;
import org.exparity.expectamundo.core.hamcrest.PrototypeMatcher;
import org.exparity.expectamundo.core.object.PrototypeObjectExpectation;
import org.exparity.expectamundo.core.string.PrototypeStringExpectation;
import org.hamcrest.Matcher;

public class Expectamundo {
    private static PrototypeFactory factory = new PrototypeFactory();

    public static <T> T prototype(Class<T> type) {
        return factory.createPrototype(type);
    }

    public static <T> T prototype(TypeReference<T> typeRef) {
        return (T)factory.createPrototype(typeRef.getType());
    }

    public static <E, T extends Collection<E>> PrototypeCollectionExpectation<E, T> expect(T property) {
        return new PrototypeCollectionExpectation(Expectamundo.currentPrototype(), Expectamundo.currentValue(property));
    }

    public static <T extends Comparable<T>> PrototypeComparableExpectation<T> expect(T property) {
        return new PrototypeComparableExpectation(Expectamundo.currentPrototype(), Expectamundo.currentValue(property));
    }

    public static <T> PrototypeArrayExpectation<T> expect(T[] property) {
        return new PrototypeArrayExpectation(Expectamundo.currentPrototype(), Expectamundo.currentValue(property));
    }

    public static PrototypeStringExpectation expect(String property) {
        return new PrototypeStringExpectation(Expectamundo.currentPrototype(), Expectamundo.currentValue(property));
    }

    public static PrototypeDateExpectation expect(Date property) {
        return new PrototypeDateExpectation(Expectamundo.currentPrototype(), Expectamundo.currentValue(property));
    }

    public static <T> PrototypeObjectExpectation<T> expect(T property) {
        return new PrototypeObjectExpectation(Expectamundo.currentPrototype(), Expectamundo.currentValue(property));
    }

    public static <T> PrototypeVerifier<T> expectThat(T actual) {
        return new PrototypeVerifier<T>(actual);
    }

    public static <E, T extends Collection<E>> PrototypeListVerifier<E, T> expectThat(T actual) {
        return new PrototypeListVerifier(actual);
    }

    public static <T> PrototypeChecker<T> checkThat(T actual) {
        return new PrototypeChecker<T>(actual);
    }

    public static <V, T extends V> T cast(V value, Class<T> type) {
        T prototype = factory.createPrototype(type, Expectamundo.currentProperty(), Expectamundo.currentPrototype());
        Expectamundo.currentPrototype().addChild((Prototyped)prototype);
        return prototype;
    }

    @Deprecated
    public static <T> Matcher<T> matcherFor(T prototype) {
        return Expectamundo.matchesPrototype(prototype);
    }

    public static <T> Matcher<T> matchesPrototype(T prototype) {
        return PrototypeMatcher.matchesPrototype(prototype);
    }

    public static boolean isPrototype(Object obj) {
        return obj instanceof Prototyped;
    }

    private static <T> PrototypeValue currentValue(T value) {
        PrototypeProperty currentProperty = Expectamundo.currentPrototype().getActiveProperty();
        if (currentProperty != null) {
            return currentProperty;
        }
        if (Expectamundo.isPrototype(value)) {
            return (PrototypeValue)value;
        }
        throw new IllegalArgumentException("You can only set an expectation on an instance created with Expectamundo.prototype()");
    }

    private static Prototype<?> currentPrototype() {
        Prototype<?> currentPrototype = PrototypeMatcherContext.currentPrototype();
        if (currentPrototype == null) {
            throw new IllegalArgumentException("You can only set an expectation on an instance created with Expectamundo.prototype()");
        }
        return currentPrototype;
    }

    private static PrototypeProperty currentProperty() {
        PrototypeProperty activeProperty = Expectamundo.currentPrototype().getActiveProperty();
        if (activeProperty == null) {
            throw new IllegalArgumentException("You can only set an expectation for a property");
        }
        return activeProperty;
    }
}

