/*
 * Decompiled with CFR 0.152.
 */
package org.exparity.expectamundo.core;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.sf.cglib.proxy.MethodInterceptor;
import net.sf.cglib.proxy.MethodProxy;
import org.exparity.expectamundo.core.PrototypeInterceptor;
import org.exparity.expectamundo.core.PrototypeProperty;
import org.exparity.expectamundo.core.PrototypeValue;
import org.exparity.expectamundo.core.PrototypeValueMatcher;
import org.exparity.expectamundo.core.Prototyped;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Prototype<T>
implements Prototyped<T>,
MethodInterceptor,
PrototypeValue {
    private static Logger LOG = LoggerFactory.getLogger(Prototype.class);
    private final Class<T> rawType;
    private final PrototypeInterceptor interceptor;
    private final List<Prototyped<?>> children = new ArrayList();
    private final List<PrototypeValueMatcher> expectations = new ArrayList<PrototypeValueMatcher>();
    private final Map<String, Class<?>> typeParameters;
    private PrototypeProperty parentProperty = null;
    private PrototypeProperty activeProperty = null;

    public Prototype(PrototypeProperty parentProperty, Class<T> rawType, Map<String, Class<?>> typeParameters, PrototypeInterceptor proxier) {
        this.parentProperty = parentProperty;
        this.rawType = rawType;
        this.interceptor = proxier;
        this.typeParameters = typeParameters;
    }

    public Prototype(Class<T> rawType, Map<String, Class<?>> typeParameters, PrototypeInterceptor proxier) {
        this.rawType = rawType;
        this.interceptor = proxier;
        this.typeParameters = typeParameters;
    }

    public void addChild(Prototyped<?> child) {
        this.children.add(child);
    }

    public PrototypeProperty getParentProperty() {
        return this.parentProperty;
    }

    public void setActiveProperty(PrototypeProperty activeProperty) {
        LOG.debug("Current Property {}", (Object)(activeProperty == null ? "NONE" : activeProperty.getPath()));
        this.activeProperty = activeProperty;
    }

    public PrototypeProperty getActiveProperty() {
        return this.activeProperty;
    }

    @Override
    public List<PrototypeValueMatcher> getExpectations() {
        ArrayList<PrototypeValueMatcher> expectations = new ArrayList<PrototypeValueMatcher>();
        expectations.addAll(this.expectations);
        for (Prototyped<?> child : this.children) {
            expectations.addAll(child.getExpectations());
        }
        return expectations;
    }

    public void addExpectation(PrototypeValueMatcher expecation) {
        LOG.info("Expects {} {}", (Object)expecation.getPropertyPath(), (Object)expecation.getExpectation());
        this.expectations.add(expecation);
    }

    @Override
    public Class<T> getRawType() {
        return this.rawType;
    }

    public Map<String, Class<?>> getTypeParameters() {
        return this.typeParameters;
    }

    public Object intercept(Object obj, Method method, Object[] args, MethodProxy proxy) throws Throwable {
        if (method.getDeclaringClass().equals(Prototyped.class) || method.getDeclaringClass().equals(PrototypeValue.class)) {
            return method.invoke((Object)this, args);
        }
        return this.interceptor.intercept(obj, method, args, proxy, this);
    }

    @Override
    public String getLabel() {
        return this.rawType.getSimpleName();
    }

    @Override
    public Object getValue(Object actual) {
        return this;
    }

    public String toString() {
        return "Prototype [" + this.rawType.getSimpleName() + "]";
    }
}

