/*
 * Decompiled with CFR 0.152.
 */
package org.exparity.expectamundo.core;

import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.HashMap;
import java.util.Map;
import org.exparity.expectamundo.core.Prototype;
import org.exparity.expectamundo.core.PrototypeInterceptor;
import org.exparity.expectamundo.core.PrototypeInterceptorImpl;
import org.exparity.expectamundo.core.PrototypeProperty;
import org.exparity.expectamundo.core.PrototypeValue;
import org.exparity.expectamundo.core.Prototyped;
import org.exparity.expectamundo.core.ProxyFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrototypeFactory {
    private static final Logger LOG = LoggerFactory.getLogger(PrototypeFactory.class);
    private final ProxyFactory proxyFactory = new ProxyFactory();

    public <T> T createPrototype(Class<T> type) {
        if (Modifier.isFinal(type.getModifiers())) {
            throw new IllegalArgumentException("Final classes cannot be prototyped");
        }
        if (this.isGenericType(type)) {
            throw new IllegalArgumentException("Use Expectamundo.prototype(final TypeReference<T> typeRef) method to create prototypes for generic types. See javadocs on method for example.");
        }
        PrototypeInterceptor interceptor = this.createInterceptor(type);
        LOG.debug("Produce Interceptor [{}] for [{}]", (Object)interceptor.getClass().getSimpleName(), (Object)type.getName());
        T proxy = this.createProxy(new Prototype<T>(type, this.getGenericTypeArguments(type), interceptor));
        LOG.info("Proxied {} using [{}]", (Object)type.getSimpleName(), proxy);
        return proxy;
    }

    public Object createPrototype(Type genericType) {
        Class<?> type = this.getClassForPrototype(genericType);
        if (Modifier.isFinal(type.getModifiers())) {
            throw new IllegalArgumentException("Final classes cannot be prototyped");
        }
        PrototypeInterceptor interceptor = this.createInterceptor(type);
        LOG.debug("Produce Interceptor [{}] for [{}]", (Object)interceptor.getClass().getSimpleName(), (Object)type.getName());
        Prototype prototype = new Prototype(type, this.getGenericTypeArguments(genericType), interceptor);
        Object proxy = this.createProxy(prototype);
        LOG.info("Proxied {} using [{}]", (Object)type.getSimpleName(), proxy);
        return proxy;
    }

    public <T> T createPrototype(Class<T> type, PrototypeProperty activeProperty, Prototype<?> currentPrototype) {
        if (Modifier.isFinal(type.getModifiers())) {
            throw new IllegalArgumentException("Final classes cannot be prototyped");
        }
        PrototypeInterceptor interceptor = this.createInterceptor(type);
        LOG.debug("Produce Interceptor [{}] for [{}]", (Object)interceptor.getClass().getSimpleName(), (Object)type.getName());
        Prototype<T> prototype = new Prototype<T>(activeProperty, type, activeProperty.getGenericTypeArguments(), interceptor);
        T proxy = this.createProxy(prototype);
        LOG.debug("Produce Proxy [{}] for [{}]", proxy, (Object)type.getName());
        return proxy;
    }

    public Object createPrototype(PrototypeProperty activeProperty, Prototype<?> currentPrototype) {
        Class<?> type = this.getClassForPrototype(activeProperty, currentPrototype);
        if (Modifier.isFinal(type.getModifiers())) {
            throw new IllegalArgumentException("Final classes cannot be prototyped");
        }
        PrototypeInterceptor interceptor = this.createInterceptor(type);
        LOG.debug("Produce Interceptor [{}] for [{}]", (Object)interceptor.getClass().getSimpleName(), (Object)type.getName());
        Prototype prototype = new Prototype(activeProperty, type, activeProperty.getGenericTypeArguments(), interceptor);
        Object proxy = this.createProxy(prototype);
        LOG.debug("Produce Proxy [{}] for [{}]", proxy, (Object)type.getName());
        return proxy;
    }

    private Class<?> getClassForPrototype(PrototypeProperty activeProperty, Prototype<?> currentPrototype) {
        Type genericType = activeProperty.getGenericReturnType();
        if (genericType instanceof Class) {
            return (Class)genericType;
        }
        if (genericType instanceof ParameterizedType) {
            return (Class)((ParameterizedType)genericType).getRawType();
        }
        if (genericType instanceof TypeVariable) {
            return currentPrototype.getTypeParameters().get(((TypeVariable)genericType).getName());
        }
        throw new RuntimeException("Failed to get protype class for '" + genericType + "'");
    }

    private Class<?> getClassForPrototype(Type genericType) {
        if (genericType instanceof Class) {
            return (Class)genericType;
        }
        if (genericType instanceof ParameterizedType) {
            return (Class)((ParameterizedType)genericType).getRawType();
        }
        throw new RuntimeException("Failed to get protype class for '" + genericType + "'");
    }

    private <T> PrototypeInterceptor createInterceptor(Class<T> type) {
        return new PrototypeInterceptorImpl(this);
    }

    private <T> T createProxy(Prototype<T> prototype) {
        return this.proxyFactory.createProxy(prototype.getRawType(), prototype, Prototyped.class, PrototypeValue.class);
    }

    private Map<String, Class<?>> getGenericTypeArguments(Class<?> type) {
        if (!this.isGenericType(type) && type.getGenericSuperclass() instanceof ParameterizedType) {
            return this.getGenericTypeArguments(type.getGenericSuperclass());
        }
        return new HashMap();
    }

    private Map<String, Class<?>> getGenericTypeArguments(Type genericType) {
        HashMap parameterizedTypes = new HashMap();
        if (genericType instanceof ParameterizedType) {
            Type[] typeArguments = ((ParameterizedType)genericType).getActualTypeArguments();
            TypeVariable<Class<T>>[] typeKeys = ((Class)((ParameterizedType)genericType).getRawType()).getTypeParameters();
            for (int i = 0; i < typeKeys.length; ++i) {
                parameterizedTypes.put(typeKeys[i].getName(), (Class)typeArguments[i]);
            }
            return parameterizedTypes;
        }
        return parameterizedTypes;
    }

    private <T> boolean isGenericType(Class<T> type) {
        return type.getTypeParameters() != null && type.getTypeParameters().length > 0;
    }
}

