/*
 * Decompiled with CFR 0.152.
 */
package org.exparity.expectamundo.core;

import net.sf.cglib.proxy.Callback;
import net.sf.cglib.proxy.Enhancer;
import net.sf.cglib.proxy.MethodInterceptor;
import org.exparity.expectamundo.core.PrototypeValue;
import org.exparity.expectamundo.core.Prototyped;
import org.objenesis.ObjenesisStd;
import org.objenesis.instantiator.ObjectInstantiator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProxyFactory {
    private static final Logger LOG = LoggerFactory.getLogger(ProxyFactory.class);

    public <T> T createProxy(Class<T> rawType, MethodInterceptor callback, Class<?> ... interfaces) {
        return this.createProxyInstance(this.createProxyType(rawType, callback, interfaces));
    }

    private <T> T createProxyInstance(Class<T> proxyType) {
        ObjenesisStd instantiatorFactory = new ObjenesisStd();
        ObjectInstantiator instanceFactory = instantiatorFactory.getInstantiatorOf(proxyType);
        Object instance = instanceFactory.newInstance();
        LOG.debug("Produce Proxy Instance [{}] for [{}]", (Object)System.identityHashCode(instance), (Object)proxyType.getName());
        return (T)instance;
    }

    private <T> Class<T> createProxyType(Class<T> rawType, MethodInterceptor callback, Class<?> ... interfaces) {
        Enhancer classFactory = new Enhancer();
        if (rawType.isInterface()) {
            classFactory.setInterfaces(new Class[]{rawType, Prototyped.class, PrototypeValue.class});
        } else {
            classFactory.setSuperclass(rawType);
            classFactory.setInterfaces((Class[])interfaces);
        }
        classFactory.setCallbackType(callback.getClass());
        Class proxyType = classFactory.createClass();
        Enhancer.registerCallbacks((Class)proxyType, (Callback[])new Callback[]{callback});
        return proxyType;
    }
}

