/*
 * Decompiled with CFR 0.152.
 */
package org.exparity.expectamundo.core.collection;

import java.util.Collection;
import org.exparity.expectamundo.Expectamundo;
import org.exparity.expectamundo.core.Prototype;
import org.exparity.expectamundo.core.PrototypeValue;
import org.exparity.expectamundo.core.collection.Contains;
import org.exparity.expectamundo.core.collection.ContainsExpected;
import org.exparity.expectamundo.core.collection.HasSize;
import org.exparity.expectamundo.core.collection.IsEmpty;
import org.exparity.expectamundo.core.collection.IsNotEmpty;
import org.exparity.expectamundo.core.object.PrototypeObjectExpectation;

public class PrototypeCollectionExpectation<E, T extends Collection<E>>
extends PrototypeObjectExpectation<T> {
    public PrototypeCollectionExpectation(Prototype<?> prototype, PrototypeValue property) {
        super(prototype, property);
    }

    public void isEmpty() {
        this.hasExpectation(new IsEmpty());
    }

    public void isNotEmpty() {
        this.hasExpectation(new IsNotEmpty());
    }

    public void hasSize(int size) {
        this.hasExpectation(new HasSize(size));
    }

    public void contains(E element) {
        if (Expectamundo.isPrototype(element)) {
            this.containsExpected(element);
        } else {
            this.hasExpectation(new Contains(element));
        }
    }

    public void containsExpected(E element) {
        this.hasExpectation(new ContainsExpected(element));
    }
}

