/*
 * Decompiled with CFR 0.152.
 */
package org.exparity.expectamundo;

import java.util.Collection;
import org.exparity.expectamundo.core.PrototypeCollectionExpectation;
import org.exparity.expectamundo.core.PrototypeComparableExpectation;
import org.exparity.expectamundo.core.PrototypeFactory;
import org.exparity.expectamundo.core.PrototypeMatcherContext;
import org.exparity.expectamundo.core.PrototypeObjectExpectation;
import org.exparity.expectamundo.core.PrototypeVerifier;
import org.exparity.expectamundo.core.Prototyped;
import org.exparity.expectamundo.core.TypeReference;
import org.exparity.expectamundo.hamcrest.PrototypeMatcher;
import org.hamcrest.Matcher;

public class Expactamundo {
    private static PrototypeFactory factory = new PrototypeFactory();

    public static <T> T prototype(Class<T> type) {
        return factory.createPrototype(type);
    }

    public static <T> T prototype(TypeReference<T> typeRef) {
        return (T)factory.createPrototype(typeRef.getType());
    }

    public static <E, T extends Collection<E>> PrototypeCollectionExpectation<E, T> expect(T property) {
        Expactamundo.checkActivePrototype();
        return new PrototypeCollectionExpectation(PrototypeMatcherContext.currentPrototype(), PrototypeMatcherContext.currentPrototype().getActiveProperty());
    }

    public static <T extends Comparable<T>> PrototypeComparableExpectation<T> expect(T property) {
        Expactamundo.checkActivePrototype();
        return new PrototypeComparableExpectation(PrototypeMatcherContext.currentPrototype(), PrototypeMatcherContext.currentPrototype().getActiveProperty());
    }

    public static PrototypeObjectExpectation expect(Object property) {
        Expactamundo.checkActivePrototype();
        return new PrototypeObjectExpectation(PrototypeMatcherContext.currentPrototype(), PrototypeMatcherContext.currentPrototype().getActiveProperty());
    }

    public static <T> PrototypeVerifier<T> verify(T test) {
        return new PrototypeVerifier<T>(test);
    }

    private static void checkActivePrototype() {
        if (PrototypeMatcherContext.currentPrototype() == null) {
            throw new IllegalArgumentException("You can only set an expectation for a property created with Expactamundo.prototype()");
        }
        if (PrototypeMatcherContext.currentPrototype().getActiveProperty() == null) {
            throw new IllegalArgumentException("You can only set an expectation for a property created with Expactamundo.prototype()");
        }
    }

    public static <T> Matcher<T> matches(T expected) {
        if (!Prototyped.class.isInstance(expected)) {
            throw new IllegalArgumentException("You can only match an expectation for a type created with Expactamundo.prototype()");
        }
        return new PrototypeMatcher((Prototyped)expected);
    }
}

