/*
 * Decompiled with CFR 0.152.
 */
package org.exparity.expectamundo.core;

import org.exparity.expectamundo.core.PropertyExpectation;
import org.exparity.expectamundo.core.Prototype;
import org.exparity.expectamundo.core.PrototypeProperty;
import org.exparity.expectamundo.core.PrototypePropertyMatcher;
import org.exparity.expectamundo.expectations.EqualToExpectation;
import org.exparity.expectamundo.expectations.HamcrestExpectation;
import org.exparity.expectamundo.expectations.NotNullExpectation;
import org.exparity.expectamundo.expectations.NullExpectation;
import org.hamcrest.Matcher;

public class PrototypeObjectExpectation {
    private final Prototype<?> prototype;
    private final PrototypeProperty property;

    public PrototypeObjectExpectation(Prototype<?> prototype, PrototypeProperty property) {
        this.prototype = prototype;
        this.property = property;
    }

    public <T> void matches(Matcher<T> expected) {
        this.setExpectation(new HamcrestExpectation<T>(expected));
    }

    public <T> void equalTo(T expectedValue) {
        this.setExpectation(new EqualToExpectation<T>(expectedValue));
    }

    public void nullValue() {
        this.setExpectation(new NullExpectation());
    }

    public void notNullValue() {
        this.setExpectation(new NotNullExpectation());
    }

    protected void setExpectation(PropertyExpectation<?> expectation) {
        this.prototype.addExpectation(new PrototypePropertyMatcher(this.property, expectation));
        this.prototype.setActiveProperty(null);
    }
}

