/*
 * Decompiled with CFR 0.152.
 */
package org.exparity.expectamundo.core;

import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.HashMap;
import java.util.Map;
import net.sf.cglib.proxy.Callback;
import net.sf.cglib.proxy.Enhancer;
import org.exparity.expectamundo.core.Prototype;
import org.exparity.expectamundo.core.PrototypeInterceptor;
import org.exparity.expectamundo.core.PrototypeInterceptorImpl;
import org.exparity.expectamundo.core.PrototypeProperty;
import org.exparity.expectamundo.core.Prototyped;
import org.objenesis.ObjenesisStd;
import org.objenesis.instantiator.ObjectInstantiator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrototypeFactory {
    private static final Logger LOG = LoggerFactory.getLogger(PrototypeFactory.class);

    public <T> T createPrototype(Class<T> type) {
        if (Modifier.isFinal(type.getModifiers())) {
            throw new IllegalArgumentException("Final classes cannot be prototyped");
        }
        PrototypeInterceptor interceptor = this.createInterceptor(type);
        LOG.debug("Produce Interceptor [{}] for [{}]", (Object)interceptor.getClass().getSimpleName(), (Object)type.getName());
        Class<T> proxyType = this.createProxy(new Prototype<T>(type, new HashMap(), interceptor));
        T proxy = this.createProxyInstance(proxyType);
        LOG.debug("Produce Proxy [{}] for [{}]", proxy, (Object)type.getName());
        return proxy;
    }

    public Object createPrototype(Type genericType) {
        Class<?> type = this.getClassForPrototype(genericType);
        if (Modifier.isFinal(type.getModifiers())) {
            throw new IllegalArgumentException("Final classes cannot be prototyped");
        }
        PrototypeInterceptor interceptor = this.createInterceptor(type);
        LOG.debug("Produce Interceptor [{}] for [{}]", (Object)interceptor.getClass().getSimpleName(), (Object)type.getName());
        Prototype prototype = new Prototype(type, this.getGenericTypeArguments(genericType), interceptor);
        Class<?> proxyType = this.createProxy(prototype);
        Object proxy = this.createProxyInstance(proxyType);
        LOG.debug("Produce Proxy [{}] for [{}]", proxy, (Object)type.getName());
        return proxy;
    }

    public Object createPrototype(PrototypeProperty activeProperty, Prototype<?> currentPrototype) {
        Class<?> type = this.getClassForPrototype(activeProperty, currentPrototype);
        if (Modifier.isFinal(type.getModifiers())) {
            throw new IllegalArgumentException("Final classes cannot be prototyped");
        }
        PrototypeInterceptor interceptor = this.createInterceptor(type);
        LOG.debug("Produce Interceptor [{}] for [{}]", (Object)interceptor.getClass().getSimpleName(), (Object)type.getName());
        Prototype prototype = new Prototype(activeProperty, type, activeProperty.getGenericTypeArguments(), interceptor);
        Class<?> proxyType = this.createProxy(prototype);
        Object proxy = this.createProxyInstance(proxyType);
        LOG.debug("Produce Proxy [{}] for [{}]", proxy, (Object)type.getName());
        return proxy;
    }

    private Class<?> getClassForPrototype(PrototypeProperty activeProperty, Prototype<?> currentPrototype) {
        Type genericType = activeProperty.getGenericReturnType();
        if (genericType instanceof Class) {
            return (Class)genericType;
        }
        if (genericType instanceof ParameterizedType) {
            return (Class)((ParameterizedType)genericType).getRawType();
        }
        if (genericType instanceof TypeVariable) {
            return currentPrototype.getTypeParameters().get(((TypeVariable)genericType).getName());
        }
        throw new RuntimeException("Failed to get protype class for '" + genericType + "'");
    }

    private Class<?> getClassForPrototype(Type genericType) {
        if (genericType instanceof Class) {
            return (Class)genericType;
        }
        if (genericType instanceof ParameterizedType) {
            return (Class)((ParameterizedType)genericType).getRawType();
        }
        throw new RuntimeException("Failed to get protype class for '" + genericType + "'");
    }

    private <T> PrototypeInterceptor createInterceptor(Class<T> type) {
        return new PrototypeInterceptorImpl(this);
    }

    private <T> T createProxyInstance(Class<T> proxyType) {
        ObjenesisStd instantiatorFactory = new ObjenesisStd();
        ObjectInstantiator instanceFactory = instantiatorFactory.getInstantiatorOf(proxyType);
        Object instance = instanceFactory.newInstance();
        LOG.debug("Produce Proxy Instance [{}] for [{}]", (Object)System.identityHashCode(instance), (Object)proxyType.getName());
        return (T)instance;
    }

    private <T> Class<T> createProxy(Prototype<T> prototype) {
        Enhancer classFactory = new Enhancer();
        if (prototype.getRawType().isInterface()) {
            classFactory.setInterfaces(new Class[]{prototype.getRawType(), Prototyped.class});
        } else {
            classFactory.setSuperclass(prototype.getRawType());
            classFactory.setInterfaces(new Class[]{Prototyped.class});
        }
        classFactory.setCallbackType(prototype.getClass());
        Class proxyType = classFactory.createClass();
        Enhancer.registerCallbacks((Class)proxyType, (Callback[])new Callback[]{prototype});
        LOG.debug("Produce Proxy Type [{}] for [{}]", (Object)proxyType.getSimpleName(), prototype);
        return proxyType;
    }

    public Map<String, Class<?>> getGenericTypeArguments(Type genericType) {
        HashMap parameterizedTypes = new HashMap();
        if (genericType instanceof ParameterizedType) {
            Type[] typeArguments = ((ParameterizedType)genericType).getActualTypeArguments();
            TypeVariable<Class<T>>[] typeKeys = ((Class)((ParameterizedType)genericType).getRawType()).getTypeParameters();
            for (int i = 0; i < typeKeys.length; ++i) {
                parameterizedTypes.put(typeKeys[i].getName(), (Class)typeArguments[i]);
            }
            return parameterizedTypes;
        }
        return parameterizedTypes;
    }
}

