/*
 * Decompiled with CFR 0.152.
 */
package org.exparity.expectamundo.core;

import org.exparity.expectamundo.core.PropertyExpectation;
import org.exparity.expectamundo.core.Prototype;
import org.exparity.expectamundo.core.PrototypeProperty;
import org.exparity.expectamundo.core.PrototypePropertyMatcher;
import org.exparity.expectamundo.expectations.IsEqualTo;
import org.exparity.expectamundo.expectations.IsInstanceOf;
import org.exparity.expectamundo.expectations.IsNotNull;
import org.exparity.expectamundo.expectations.IsNull;
import org.exparity.expectamundo.expectations.Matches;
import org.hamcrest.Matcher;

public class PrototypeObjectExpectation {
    private final Prototype<?> prototype;
    private final PrototypeProperty property;

    public PrototypeObjectExpectation(Prototype<?> prototype, PrototypeProperty property) {
        this.prototype = prototype;
        this.property = property;
    }

    public <T> void matches(Matcher<T> expected) {
        this.setExpectation(new Matches<T>(expected));
    }

    public <T> void isEqualTo(T expectedValue) {
        this.setExpectation(new IsEqualTo<T>(expectedValue));
    }

    public <T> void isInstanceOf(Class<T> expectedValue) {
        this.setExpectation(new IsInstanceOf<T>(expectedValue));
    }

    public void isNull() {
        this.setExpectation(new IsNull());
    }

    public void isNotNull() {
        this.setExpectation(new IsNotNull());
    }

    protected void setExpectation(PropertyExpectation<?> expectation) {
        this.prototype.addExpectation(new PrototypePropertyMatcher(this.property, expectation));
        this.prototype.setActiveProperty(null);
    }
}

