/*
 * Decompiled with CFR 0.152.
 */
package org.exparity.expectamundo.core;

import org.exparity.expectamundo.core.PrototypePropertyMatcher;
import org.exparity.expectamundo.core.Prototyped;

public class PrototypeVerifier<T> {
    private final T actual;

    public PrototypeVerifier(T actual) {
        this.actual = actual;
    }

    public void matches(T prototype) {
        if (!Prototyped.class.isInstance(prototype)) {
            throw new IllegalArgumentException("Object does not implement Prototyped. Please construct using PrototypeMatcher.expected");
        }
        Prototyped prototyped = (Prototyped)prototype;
        StringBuffer mismatchDescription = new StringBuffer();
        if (!this.matchesPrototype(prototyped, mismatchDescription)) {
            StringBuffer buffer = new StringBuffer("\nExpected ");
            this.describeTo(buffer, prototyped);
            buffer.append("\nbut actual is ").append(mismatchDescription);
            throw new AssertionError((Object)buffer.toString());
        }
    }

    protected boolean matchesPrototype(Prototyped<?> prototyped, StringBuffer mismatchDescription) {
        mismatchDescription.append("a ").append(this.actual.getClass().getSimpleName()).append(" containing properties :\n");
        boolean matches = true;
        for (PrototypePropertyMatcher expectation : prototyped.getExpectations()) {
            Object actualValue;
            if (expectation.matches(actualValue = expectation.getPropertyValue(this.actual))) continue;
            mismatchDescription.append("\t").append(expectation.getPropertyPath()).append(" is ").append(actualValue);
            matches = false;
        }
        return matches;
    }

    private void describeTo(StringBuffer description, Prototyped<?> prototyped) {
        Class<?> rawType = prototyped.getRawType();
        description.append("a ").append(rawType.getSimpleName());
        if (!prototyped.getExpectations().isEmpty()) {
            description.append(" containing properties :");
            for (PrototypePropertyMatcher expecation : prototyped.getExpectations()) {
                description.append("\n\t").append(expecation.getPropertyPath()).append(" is ").append(expecation.getExpectation());
            }
        }
    }
}

