/*
 * Decompiled with CFR 0.152.
 */
package org.exparity.expectamundo;

import java.util.Collection;
import java.util.Date;
import org.exparity.expectamundo.core.PrototypeArrayExpectation;
import org.exparity.expectamundo.core.PrototypeChecker;
import org.exparity.expectamundo.core.PrototypeCollectionExpectation;
import org.exparity.expectamundo.core.PrototypeComparableExpectation;
import org.exparity.expectamundo.core.PrototypeDateExpectation;
import org.exparity.expectamundo.core.PrototypeFactory;
import org.exparity.expectamundo.core.PrototypeMatcherContext;
import org.exparity.expectamundo.core.PrototypeObjectExpectation;
import org.exparity.expectamundo.core.PrototypeStringExpectation;
import org.exparity.expectamundo.core.PrototypeVerifier;
import org.exparity.expectamundo.core.Prototyped;
import org.exparity.expectamundo.core.TypeReference;
import org.exparity.expectamundo.core.hamcrest.PrototypeMatcher;
import org.hamcrest.Matcher;

public class Expectamundo {
    private static PrototypeFactory factory = new PrototypeFactory();

    public static <T> T prototype(Class<T> type) {
        return factory.createPrototype(type);
    }

    public static <T> T prototype(TypeReference<T> typeRef) {
        return (T)factory.createPrototype(typeRef.getType());
    }

    public static <E, T extends Collection<E>> PrototypeCollectionExpectation<E, T> expect(T property) {
        Expectamundo.checkActivePrototype();
        return new PrototypeCollectionExpectation(PrototypeMatcherContext.currentPrototype(), PrototypeMatcherContext.currentPrototype().getActiveProperty());
    }

    public static <T extends Comparable<T>> PrototypeComparableExpectation<T> expect(T property) {
        Expectamundo.checkActivePrototype();
        return new PrototypeComparableExpectation(PrototypeMatcherContext.currentPrototype(), PrototypeMatcherContext.currentPrototype().getActiveProperty());
    }

    public static <T> PrototypeArrayExpectation<T> expect(T[] property) {
        Expectamundo.checkActivePrototype();
        return new PrototypeArrayExpectation(PrototypeMatcherContext.currentPrototype(), PrototypeMatcherContext.currentPrototype().getActiveProperty());
    }

    public static PrototypeStringExpectation expect(String property) {
        Expectamundo.checkActivePrototype();
        return new PrototypeStringExpectation(PrototypeMatcherContext.currentPrototype(), PrototypeMatcherContext.currentPrototype().getActiveProperty());
    }

    public static PrototypeDateExpectation expect(Date property) {
        Expectamundo.checkActivePrototype();
        return new PrototypeDateExpectation(PrototypeMatcherContext.currentPrototype(), PrototypeMatcherContext.currentPrototype().getActiveProperty());
    }

    public static <T> PrototypeObjectExpectation<T> expect(T property) {
        Expectamundo.checkActivePrototype();
        return new PrototypeObjectExpectation(PrototypeMatcherContext.currentPrototype(), PrototypeMatcherContext.currentPrototype().getActiveProperty());
    }

    public static <T> PrototypeVerifier<T> expectThat(T actual) {
        return new PrototypeVerifier<T>(actual);
    }

    public static <T> PrototypeChecker<T> checkThat(T actual) {
        return new PrototypeChecker<T>(actual);
    }

    public static <V, T extends V> T cast(V value, Class<T> type) {
        Expectamundo.checkActivePrototype();
        T prototype = factory.createPrototype(type, PrototypeMatcherContext.currentPrototype().getActiveProperty(), PrototypeMatcherContext.currentPrototype());
        PrototypeMatcherContext.currentPrototype().addChild((Prototyped)prototype);
        return prototype;
    }

    public static <T> Matcher<T> matcherFor(T expected) {
        if (!Prototyped.class.isInstance(expected)) {
            throw new IllegalArgumentException("You can only match an expectation for a type created with Expectamundo.prototype()");
        }
        return new PrototypeMatcher((Prototyped)expected);
    }

    public static boolean isPrototype(Object obj) {
        return obj instanceof Prototyped;
    }

    private static void checkActivePrototype() {
        if (PrototypeMatcherContext.currentPrototype() == null) {
            throw new IllegalArgumentException("You can only set an expectation on an instance created with Expectamundo.prototype()");
        }
        if (PrototypeMatcherContext.currentPrototype().getActiveProperty() == null) {
            throw new IllegalArgumentException("You can only set an expectation for a property");
        }
    }
}

