package org.exploit.blockbook.model.address;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import lombok.Data;
import org.exploit.blockbook.deserializer.BlockBookAddressDeserializer;

import java.util.List;

@Data
@JsonDeserialize(using = BlockBookAddressDeserializer.class)
public abstract class BlockBookAddress {
    private int page;
    private int totalPages;
    private int itemsOnPage;
    private String address;
    private String balance;
    private String unconfirmedBalance;
    private int unconfirmedTxs;
    private int txs;
    private List<String> txids;
}