package org.exploit.blockbook.model.address;

import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.List;

@Data
@EqualsAndHashCode(callSuper = true)
public class EvmTypeAddress extends BlockBookAddress {
    private int nonTokenTxs;
    private String nonce;
    private List<Token> tokens;

    @Data
    public static class Token {
        private String type;
        private String name;
        private String contract;
        private int transfers;
        private String symbol;
        private String balance;
    }
}