package org.exploit.blockbook.model;

import lombok.Data;

@Data
public class Status {
    private Blockbook blockbook;
    private Backend backend;

    @Data
    public static class Blockbook {
        private String coin;
        private String host;
        private String version;
        private String gitCommit;
        private String buildTime;
        private boolean syncMode;
        private boolean initialSync;
        private boolean inSync;
        private long bestHeight;
        private String lastBlockTime;
        private boolean inSyncMempool;
        private String lastMempoolTime;
        private long mempoolSize;
        private int decimals;
        private long dbSize;
        private String about;
    }

    @Data
    public static class Backend {
        private String chain;
        private long blocks;
        private long headers;
        private String bestBlockHash;
        private String difficulty;
        private long sizeOnDisk;
        private String version;
        private String subversion;
        private String protocolVersion;
        private int timeOffset;
        private String warnings;
    }
}
