package org.exploit.blockbook.deserializer;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import org.exploit.blockbook.model.address.BitcoinTypeAddress;
import org.exploit.blockbook.model.address.BlockBookAddress;
import org.exploit.blockbook.model.address.EvmTypeAddress;
import org.exploit.blockbook.model.address.XPubAddress;

import java.io.IOException;

public class BlockBookAddressDeserializer extends JsonDeserializer<BlockBookAddress> {
    @Override
    public BlockBookAddress deserialize(JsonParser jp, DeserializationContext ctx) throws IOException {
        var mapper = jp.getCodec();
        JsonNode node = mapper.readTree(jp);

        if (node.has("tokens")) {
            return node.has("secondaryValue") ? mapper.treeToValue(node, XPubAddress.class)
                    : mapper.treeToValue(node, EvmTypeAddress.class);
        } else {
            return mapper.treeToValue(node, BitcoinTypeAddress.class);
        }
    }
}