/*
 * Decompiled with CFR 0.152.
 */
package org.exploit.blockbook;

import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import org.exploit.blockbook.BlockBookApi;
import org.exploit.blockbook.BlockBookEventTransformer;
import org.exploit.blockbook.model.address.BlockBookAddress;
import org.exploit.blockbook.model.transaction.BlockBookTransaction;
import org.exploit.finja.core.EventFetcher;
import org.exploit.finja.core.event.TxnEvent;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class BlockBookEventFetcher
implements EventFetcher {
    private final BlockBookApi api;
    private final BlockBookEventTransformer eventTransformer;

    public Flux<TxnEvent> events(String address, long startTimestamp) {
        long timestampSeconds = Instant.ofEpochMilli(startTimestamp).getEpochSecond();
        return Mono.fromCallable(() -> this.api.getAddress(address, 1)).flatMap(this::fetchTxids).flatMapMany(transactions -> this.process(address, timestampSeconds, (List<String>)transactions));
    }

    private Flux<TxnEvent> process(String address, long start, List<String> transactions) {
        return Flux.fromIterable(transactions).flatMapSequential(txid -> Mono.fromCallable(() -> this.api.getTransaction((String)txid))).takeWhile(tx -> tx.getBlockTime() >= start).flatMapIterable(tx -> this.eventTransformer.transform(address, (BlockBookTransaction)tx));
    }

    private Mono<List<String>> fetchTxids(BlockBookAddress info) {
        String address = info.getAddress();
        int totalPages = info.getTotalPages();
        List<String> txids = info.getTxids();
        if (txids == null) {
            return Mono.just(new ArrayList());
        }
        ArrayList<String> transactions = new ArrayList<String>(txids);
        if (totalPages > 1) {
            return Flux.range((int)2, (int)(totalPages - 1)).flatMap(i -> Mono.fromCallable(() -> this.api.getAddress(address, (int)i))).doOnNext(addr -> transactions.addAll(addr.getTxids())).then().thenReturn(transactions);
        }
        return Mono.just(transactions);
    }

    public BlockBookEventFetcher(BlockBookApi api, BlockBookEventTransformer eventTransformer) {
        this.api = api;
        this.eventTransformer = eventTransformer;
    }
}

