package org.exploit.blockbook.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.JsonNode;
import lombok.Data;
import org.exploit.blockbook.model.transaction.BlockBookTransaction;

import java.util.List;

@Data
public class TransactionSpecific {
    private String hex;
    private String txid;
    private String authdigest;
    private int size;
    private boolean overwintered;
    private int version;
    
    @JsonProperty("versiongroupid")
    private String versionGroupId;
    
    private long locktime;
    private int expiryheight;
    private List<BlockBookTransaction.Vin> vin;
    private List<BlockBookTransaction.Vout> vout;
    private List<JsonNode> vjoinsplit;
    private double valueBalance;
    private long valueBalanceZat;
    
    @JsonProperty("vShieldedSpend")
    private List<VShieldedSpend> vShieldedSpend;

    @JsonProperty("vShieldedOutput")
    private List<VShieldedOutput> vShieldedOutput;

    private String bindingSig;
    private String blockhash;
    private int height;
    private int confirmations;
    private long time;
    private long blocktime;

    @Data
    public static class VShieldedSpend {
        private String cv;
        private String anchor;
        private String nullifier;
        private String rk;
        private String proof;
        private String spendAuthSig;
    }

    @Data
    public static class VShieldedOutput {
        private String cv;
        private String cmu;
        private String ephemeralKey;
        private String encCiphertext;
        private String outCiphertext;
        private String proof;
    }
}