package org.exploit.blockbook.model.address;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.List;

@Data
@EqualsAndHashCode(callSuper = true)
public class XPubAddress extends BlockBookAddress {
    private int usedTokens;
    private List<Token> tokens;
    private double secondaryValue;

    @Data
    public static class Token {
        private String type;
        private String name;
        private String path;
        private int transfers;
        private int decimals;
        private String balance;
        
        @JsonProperty("totalReceived")
        private String totalReceived;
        
        @JsonProperty("totalSent")
        private String totalSent;
    }
}