package org.exploit.blockbook.model.transaction;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.List;

@Data
@JsonIgnoreProperties(ignoreUnknown = true)
@EqualsAndHashCode(callSuper = true)
public class BitcoinUnconfirmedTransaction extends BlockBookTransaction {
    private int version;
    private int blockHeight;
    private int confirmationETABlocks;
    private int confirmationETASeconds;
    private int size;
    private int vsize;
    private long valueIn;
    private boolean rbf;
    private CoinSpecificData coinSpecificData;

    @Data
    public static class CoinSpecificData {
        private String txid;
        private String hash;
        private int version;
        private int size;
        private int vsize;
        private int weight;
        private long locktime;
        private List<Vin> vin;
        private List<Vout> vout;
        private String hex;
    }
}