package org.exploit.blockbook.model.transaction;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

import java.util.List;

@Data
@JsonIgnoreProperties(ignoreUnknown = true)
public abstract class BlockBookTransaction {
    private String txid;
    private List<Vin> vin;
    private List<Vout> vout;
    private int confirmations;
    private long blockTime;
    private long value;
    private long fees;

    @Data
    public static class Vin {
        private String txid;
        private int n;
        private int vout;
        private long sequence;
        private List<String> addresses;

        @JsonProperty("isAddress")
        private boolean address;

        private String value;
    }

    @Data
    public static class Vout {
        private String value;
        private int n;
        private String hex;
        private List<String> addresses;

        @JsonProperty("isAddress")
        private boolean address;
    }
}