package org.exploit.blockbook.model.transaction;

import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.List;

@Data
@EqualsAndHashCode(callSuper = true)
public class EvmTransaction extends BlockBookTransaction {
    private String blockHash;
    private int blockHeight;
    private EthereumSpecific ethereumSpecific;
    private List<TokenTransfer> tokenTransfers;
    private AddressAliases addressAliases;

    @Data
    public static class EthereumSpecific {
        private int status;
        private int nonce;
        private long gasLimit;
        private long gasUsed;
        private String gasPrice;
        private String data;
        private ParsedData parsedData;
        private List<InternalTransfer> internalTransfers;
    }

    @Data
    public static class TokenTransfer {
        private String type;
        private String from;
        private String to;
        private String contract;
        private String name;
        private String symbol;
        private int decimals;
        private String value;
    }

    @Data
    public static class ParsedData {
        private String methodId;
        private String name;
        private String function;
        private List<Param> params;

        @Data
        public static class Param {
            private String type;
            private List<String> values;
        }
    }

    @Data
    public static class InternalTransfer {
        private int type;
        private String from;
        private String to;
        private String value;
    }

    @Data
    public static class AddressAliases {
        private Alias wrappedEther;
        private Alias uniswapV3Positions;

        @Data
        public static class Alias {
            private String type;
            private String alias;
        }
    }
}