/*
 * Decompiled with CFR 0.152.
 */
package org.exploit.blockbook.deserializer;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import java.io.IOException;
import org.exploit.blockbook.model.transaction.BitcoinConfirmedTransaction;
import org.exploit.blockbook.model.transaction.BitcoinUnconfirmedTransaction;
import org.exploit.blockbook.model.transaction.BlockBookTransaction;
import org.exploit.blockbook.model.transaction.EvmTransaction;
import org.exploit.finja.utils.Jackson;

public class BlockBookTransactionDeserializer
extends JsonDeserializer<BlockBookTransaction> {
    private final ObjectMapper objectMapper = new ObjectMapper();

    public BlockBookTransaction deserialize(JsonParser jp, DeserializationContext ctx) throws IOException {
        ObjectCodec codec = jp.getCodec();
        JsonNode node = (JsonNode)codec.readTree(jp);
        ObjectReader reader = this.objectMapper.readerFor(BlockBookTransaction.class);
        if (node.has("ethereumSpecific")) {
            return (BlockBookTransaction)reader.forType(EvmTransaction.class).readValue(node);
        }
        if (node.has("blockHeight")) {
            int blockHeight = node.get("blockHeight").asInt();
            if (blockHeight == -1) {
                return (BlockBookTransaction)Jackson.convert((JsonNode)node, BitcoinUnconfirmedTransaction.class);
            }
            return (BlockBookTransaction)Jackson.convert((JsonNode)node, BitcoinConfirmedTransaction.class);
        }
        throw new IOException("Unknown transaction type: " + node);
    }
}

