/*
 * Decompiled with CFR 0.152.
 */
package org.exploit.blockbook.model;

import java.util.List;
import org.exploit.blockbook.model.transaction.BlockBookTransaction;

public class Block {
    private int page;
    private int totalPages;
    private int itemsOnPage;
    private String hash;
    private String previousBlockHash;
    private String nextBlockHash;
    private int height;
    private int confirmations;
    private long size;
    private long time;
    private int version;
    private String merkleRoot;
    private String nonce;
    private String bits;
    private String difficulty;
    private int txCount;
    private List<BlockBookTransaction> txs;

    public int getPage() {
        return this.page;
    }

    public int getTotalPages() {
        return this.totalPages;
    }

    public int getItemsOnPage() {
        return this.itemsOnPage;
    }

    public String getHash() {
        return this.hash;
    }

    public String getPreviousBlockHash() {
        return this.previousBlockHash;
    }

    public String getNextBlockHash() {
        return this.nextBlockHash;
    }

    public int getHeight() {
        return this.height;
    }

    public int getConfirmations() {
        return this.confirmations;
    }

    public long getSize() {
        return this.size;
    }

    public long getTime() {
        return this.time;
    }

    public int getVersion() {
        return this.version;
    }

    public String getMerkleRoot() {
        return this.merkleRoot;
    }

    public String getNonce() {
        return this.nonce;
    }

    public String getBits() {
        return this.bits;
    }

    public String getDifficulty() {
        return this.difficulty;
    }

    public int getTxCount() {
        return this.txCount;
    }

    public List<BlockBookTransaction> getTxs() {
        return this.txs;
    }

    public void setPage(int page) {
        this.page = page;
    }

    public void setTotalPages(int totalPages) {
        this.totalPages = totalPages;
    }

    public void setItemsOnPage(int itemsOnPage) {
        this.itemsOnPage = itemsOnPage;
    }

    public void setHash(String hash) {
        this.hash = hash;
    }

    public void setPreviousBlockHash(String previousBlockHash) {
        this.previousBlockHash = previousBlockHash;
    }

    public void setNextBlockHash(String nextBlockHash) {
        this.nextBlockHash = nextBlockHash;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public void setConfirmations(int confirmations) {
        this.confirmations = confirmations;
    }

    public void setSize(long size) {
        this.size = size;
    }

    public void setTime(long time) {
        this.time = time;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public void setMerkleRoot(String merkleRoot) {
        this.merkleRoot = merkleRoot;
    }

    public void setNonce(String nonce) {
        this.nonce = nonce;
    }

    public void setBits(String bits) {
        this.bits = bits;
    }

    public void setDifficulty(String difficulty) {
        this.difficulty = difficulty;
    }

    public void setTxCount(int txCount) {
        this.txCount = txCount;
    }

    public void setTxs(List<BlockBookTransaction> txs) {
        this.txs = txs;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Block)) {
            return false;
        }
        Block other = (Block)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getPage() != other.getPage()) {
            return false;
        }
        if (this.getTotalPages() != other.getTotalPages()) {
            return false;
        }
        if (this.getItemsOnPage() != other.getItemsOnPage()) {
            return false;
        }
        if (this.getHeight() != other.getHeight()) {
            return false;
        }
        if (this.getConfirmations() != other.getConfirmations()) {
            return false;
        }
        if (this.getSize() != other.getSize()) {
            return false;
        }
        if (this.getTime() != other.getTime()) {
            return false;
        }
        if (this.getVersion() != other.getVersion()) {
            return false;
        }
        if (this.getTxCount() != other.getTxCount()) {
            return false;
        }
        String this$hash = this.getHash();
        String other$hash = other.getHash();
        if (this$hash == null ? other$hash != null : !this$hash.equals(other$hash)) {
            return false;
        }
        String this$previousBlockHash = this.getPreviousBlockHash();
        String other$previousBlockHash = other.getPreviousBlockHash();
        if (this$previousBlockHash == null ? other$previousBlockHash != null : !this$previousBlockHash.equals(other$previousBlockHash)) {
            return false;
        }
        String this$nextBlockHash = this.getNextBlockHash();
        String other$nextBlockHash = other.getNextBlockHash();
        if (this$nextBlockHash == null ? other$nextBlockHash != null : !this$nextBlockHash.equals(other$nextBlockHash)) {
            return false;
        }
        String this$merkleRoot = this.getMerkleRoot();
        String other$merkleRoot = other.getMerkleRoot();
        if (this$merkleRoot == null ? other$merkleRoot != null : !this$merkleRoot.equals(other$merkleRoot)) {
            return false;
        }
        String this$nonce = this.getNonce();
        String other$nonce = other.getNonce();
        if (this$nonce == null ? other$nonce != null : !this$nonce.equals(other$nonce)) {
            return false;
        }
        String this$bits = this.getBits();
        String other$bits = other.getBits();
        if (this$bits == null ? other$bits != null : !this$bits.equals(other$bits)) {
            return false;
        }
        String this$difficulty = this.getDifficulty();
        String other$difficulty = other.getDifficulty();
        if (this$difficulty == null ? other$difficulty != null : !this$difficulty.equals(other$difficulty)) {
            return false;
        }
        List<BlockBookTransaction> this$txs = this.getTxs();
        List<BlockBookTransaction> other$txs = other.getTxs();
        return !(this$txs == null ? other$txs != null : !((Object)this$txs).equals(other$txs));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Block;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getPage();
        result = result * 59 + this.getTotalPages();
        result = result * 59 + this.getItemsOnPage();
        result = result * 59 + this.getHeight();
        result = result * 59 + this.getConfirmations();
        long $size = this.getSize();
        result = result * 59 + (int)($size >>> 32 ^ $size);
        long $time = this.getTime();
        result = result * 59 + (int)($time >>> 32 ^ $time);
        result = result * 59 + this.getVersion();
        result = result * 59 + this.getTxCount();
        String $hash = this.getHash();
        result = result * 59 + ($hash == null ? 43 : $hash.hashCode());
        String $previousBlockHash = this.getPreviousBlockHash();
        result = result * 59 + ($previousBlockHash == null ? 43 : $previousBlockHash.hashCode());
        String $nextBlockHash = this.getNextBlockHash();
        result = result * 59 + ($nextBlockHash == null ? 43 : $nextBlockHash.hashCode());
        String $merkleRoot = this.getMerkleRoot();
        result = result * 59 + ($merkleRoot == null ? 43 : $merkleRoot.hashCode());
        String $nonce = this.getNonce();
        result = result * 59 + ($nonce == null ? 43 : $nonce.hashCode());
        String $bits = this.getBits();
        result = result * 59 + ($bits == null ? 43 : $bits.hashCode());
        String $difficulty = this.getDifficulty();
        result = result * 59 + ($difficulty == null ? 43 : $difficulty.hashCode());
        List<BlockBookTransaction> $txs = this.getTxs();
        result = result * 59 + ($txs == null ? 43 : ((Object)$txs).hashCode());
        return result;
    }

    public String toString() {
        return "Block(page=" + this.getPage() + ", totalPages=" + this.getTotalPages() + ", itemsOnPage=" + this.getItemsOnPage() + ", hash=" + this.getHash() + ", previousBlockHash=" + this.getPreviousBlockHash() + ", nextBlockHash=" + this.getNextBlockHash() + ", height=" + this.getHeight() + ", confirmations=" + this.getConfirmations() + ", size=" + this.getSize() + ", time=" + this.getTime() + ", version=" + this.getVersion() + ", merkleRoot=" + this.getMerkleRoot() + ", nonce=" + this.getNonce() + ", bits=" + this.getBits() + ", difficulty=" + this.getDifficulty() + ", txCount=" + this.getTxCount() + ", txs=" + this.getTxs() + ")";
    }
}

