package org.exploit.blockbook;

import com.fasterxml.jackson.databind.module.SimpleModule;
import org.eclipse.jetty.http.HttpMethod;
import org.exploit.blockbook.deserializer.BlockBookTransactionDeserializer;
import org.exploit.blockbook.deserializer.PushResultDeserializer;
import org.exploit.blockbook.model.*;
import org.exploit.blockbook.model.address.BlockBookAddress;
import org.exploit.blockbook.model.address.XPubAddress;
import org.exploit.blockbook.model.result.PushResult;
import org.exploit.blockbook.model.transaction.BlockBookTransaction;
import org.exploit.finja.core.model.WebData;
import org.exploit.finja.utils.Jackson;
import org.exploit.jettyx.annotation.Body;
import org.exploit.jettyx.annotation.HttpRequest;
import org.exploit.jettyx.annotation.Path;
import org.exploit.jettyx.annotation.Query;

import java.util.List;

public interface BlockBookApi {
    @HttpRequest(path = "/api")
    Status getStatus();

    @HttpRequest(path = "/api/status")
    Status getApiStatus();

    @HttpRequest(path = "/api/v2/block-index/{height}")
    BlockHash getBlockHash(@Path("height") int height);

    @HttpRequest(path = "/api/v2/tx/{txid}")
    BlockBookTransaction getTransaction(@Path("txid") String txid);

    @HttpRequest(path = "/api/v2/address/{address}")
    BlockBookAddress getAddress(@Path("address") String address, @Query("page") int page);

    @HttpRequest(path = "/api/v2/xpub/{xpub}")
    XPubAddress getXPub(@Path("xpub") String xpub, @Query("page") int page);

    @HttpRequest(path = "/api/v2/block/{block}")
    Block getBlock(@Path("block") int block, @Query("page") int page);

    @HttpRequest(path = "/api/v2/utxo/{address}")
    List<UnspentOutput> getUnspentOutputs(@Path("address") String address);

    @HttpRequest(path = "/api/v2/sendtx/", method = HttpMethod.POST)
    PushResult push(@Body String hex);

    @HttpRequest(path = "/api/v2/balancehistory/{address}")
    List<BalanceHistoryEntry> getBalanceHistory(@Path("address") String address);

    static BlockBookApi create(WebData webData) {
        var blockBookModule = new SimpleModule()
                .addDeserializer(BlockBookTransaction.class, new BlockBookTransactionDeserializer())
                .addDeserializer(PushResult.class, new PushResultDeserializer());

        Jackson.getObjectMapper().registerModule(blockBookModule);

        return webData.newApiClient(BlockBookApi.class);
    }
}