package org.exploit.blockbook;

import lombok.RequiredArgsConstructor;
import org.exploit.finja.core.CoinProvider;
import org.exploit.finja.core.EventClient;
import org.exploit.finja.core.EventFetcher;
import org.exploit.finja.core.model.WebData;

@RequiredArgsConstructor
public class BlockBookEventClient<T extends CoinProvider> implements EventClient<T> {
    private final WebData webData;

    @Override
    public EventFetcher createEventFetcher(T provider) {
        return new BlockBookEventFetcher(webData.newApiClient(BlockBookApi.class),
                new BlockBookEventTransformer(provider.asset(), provider.converter())
        );
    }
}
