package org.exploit.blockbook.deserializer;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.exploit.blockbook.model.transaction.BitcoinConfirmedTransaction;
import org.exploit.blockbook.model.transaction.BitcoinUnconfirmedTransaction;
import org.exploit.blockbook.model.transaction.BlockBookTransaction;
import org.exploit.blockbook.model.transaction.EvmTransaction;
import org.exploit.finja.utils.Jackson;

import java.io.IOException;

public class BlockBookTransactionDeserializer extends JsonDeserializer<BlockBookTransaction> {
    private final ObjectMapper objectMapper = new ObjectMapper();

    @Override
    public BlockBookTransaction deserialize(JsonParser jp, DeserializationContext ctx) throws IOException {
        var codec = jp.getCodec();
        JsonNode node = codec.readTree(jp);

        var reader = objectMapper.readerFor(BlockBookTransaction.class);

        if (node.has("ethereumSpecific")) {
            return reader.forType(EvmTransaction.class).readValue(node);
        }

        if (node.has("blockHeight")) {
            var blockHeight = node.get("blockHeight").asInt();

            if (blockHeight == -1)
                return Jackson.convert(node, BitcoinUnconfirmedTransaction.class);

            return Jackson.convert(node, BitcoinConfirmedTransaction.class);
        }

        throw new IOException("Unknown transaction type: " + node);
    }
}