package org.exploit.blockbook.deserializer;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import org.exploit.blockbook.model.result.PushError;
import org.exploit.blockbook.model.result.PushResult;
import org.exploit.blockbook.model.result.PushSuccess;

import java.io.IOException;

public class PushResultDeserializer extends JsonDeserializer<PushResult> {
    @Override
    public PushResult deserialize(JsonParser jp, DeserializationContext ctx) throws IOException {
        var mapper = jp.getCodec();
        JsonNode node = mapper.readTree(jp);

        if (node.has("result")) {
            return mapper.treeToValue(node, PushSuccess.class);
        } else if (node.has("error")) {
            return mapper.treeToValue(node, PushError.class);
        } else {
            throw new IOException("Unknown push result type: " + node);
        }
    }
}
