/*
 * Decompiled with CFR 0.152.
 */
package org.exploit.blockbook;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.Instant;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.exploit.blockbook.model.transaction.BitcoinConfirmedTransaction;
import org.exploit.blockbook.model.transaction.BitcoinUnconfirmedTransaction;
import org.exploit.blockbook.model.transaction.BlockBookTransaction;
import org.exploit.blockbook.model.transaction.EvmTransaction;
import org.exploit.finja.core.ValueConverter;
import org.exploit.finja.core.constant.Asset;
import org.exploit.finja.core.constant.TxType;
import org.exploit.finja.core.converter.MathConstantConverter;
import org.exploit.finja.core.event.TxnEvent;
import org.exploit.finja.core.model.Value;

public class BlockBookEventTransformer {
    private final Asset asset;
    private final ValueConverter valueConverter;

    public BlockBookEventTransformer(Asset asset, ValueConverter valueConverter) {
        this.asset = asset;
        this.valueConverter = valueConverter;
    }

    public List<TxnEvent> transform(String address, BlockBookTransaction tx) {
        if (tx instanceof BitcoinUnconfirmedTransaction) {
            return this.transformBitcoin(address, tx);
        }
        if (tx instanceof BitcoinConfirmedTransaction) {
            return this.transformBitcoin(address, tx);
        }
        if (tx instanceof EvmTransaction) {
            EvmTransaction evm = (EvmTransaction)tx;
            return this.transformEthereum(address, evm);
        }
        throw new IllegalArgumentException("Unknown transaction type: " + tx.getClass());
    }

    private List<TxnEvent> transformBitcoin(String address, BlockBookTransaction tx) {
        return Optional.ofNullable(this.receiveEvent(address, tx)).map(Collections::singletonList).orElseGet(() -> Optional.ofNullable(this.sendEvent(address, tx)).map(Collections::singletonList).orElse(Collections.emptyList()));
    }

    private TxnEvent receiveEvent(String address, BlockBookTransaction tx) {
        long selfInputs = this.inputSum(address, tx);
        if (selfInputs != 0L) {
            return null;
        }
        long sum = this.outputSum(address, tx);
        if (sum == 0L) {
            return null;
        }
        return this.createTxnEvent(TxType.RECEIVE, address, tx, this.valueOf(sum));
    }

    private TxnEvent sendEvent(String address, BlockBookTransaction tx) {
        long sent = this.inputSum(address, tx);
        if (sent == 0L) {
            return null;
        }
        long change = this.outputSum(address, tx);
        long dif = sent - change;
        if (dif <= 0L) {
            return null;
        }
        return this.createTxnEvent(TxType.SEND, address, tx, this.valueOf(dif));
    }

    private long inputSum(String address, BlockBookTransaction tx) {
        return tx.getVin().stream().filter(vin -> vin.getAddresses().contains(address)).mapToLong(vin -> Long.parseLong(vin.getValue())).sum();
    }

    private long outputSum(String address, BlockBookTransaction tx) {
        return tx.getVout().stream().filter(vout -> vout.getAddresses().contains(address)).mapToLong(vout -> Long.parseLong(vout.getValue())).sum();
    }

    private Value valueOf(long unit) {
        BigInteger unitInt = BigInteger.valueOf(unit);
        BigDecimal converted = this.valueConverter.toHuman(unitInt);
        return new Value(converted, unitInt);
    }

    private TxnEvent createTxnEvent(TxType type, String address, BlockBookTransaction tx, Value value) {
        return TxnEvent.builder().type(type).asset(this.asset).address(address).value(value).txid(tx.getTxid()).confirmations(tx.getConfirmations()).timestamp(tx.getBlockTime()).build();
    }

    private List<TxnEvent> transformEthereum(String address, EvmTransaction tx) {
        List<EvmTransaction.TokenTransfer> tokenTransfers = tx.getTokenTransfers();
        if (tokenTransfers == null || tokenTransfers.isEmpty()) {
            return this.processEthTransfer(address, tx);
        }
        return this.processTokenTransfers(address, tx);
    }

    private List<TxnEvent> processEthTransfer(String address, EvmTransaction tx) {
        TxType type;
        BlockBookTransaction.Vin input = tx.getVin().get(0);
        BlockBookTransaction.Vout output = tx.getVout().get(0);
        String from = input.getAddresses().get(0);
        String to = output.getAddresses().get(0);
        Object object = from.equalsIgnoreCase(address) ? TxType.SEND : (type = to.equalsIgnoreCase(address) ? TxType.RECEIVE : null);
        if (type == null) {
            return Collections.emptyList();
        }
        BigInteger unit = new BigInteger(output.getValue());
        BigDecimal humanAmount = this.valueConverter.toHuman(unit);
        long timestamp = Instant.ofEpochSecond(tx.getBlockTime()).toEpochMilli();
        TxnEvent event = TxnEvent.builder().asset(this.asset).txid(tx.getTxid()).value(new Value(humanAmount, unit)).type(type).address(address).timestamp(timestamp).confirmations(tx.getConfirmations()).build();
        return List.of(event);
    }

    private List<TxnEvent> processTokenTransfers(String address, EvmTransaction tx) {
        List<EvmTransaction.TokenTransfer> transfers = tx.getTokenTransfers();
        return transfers.stream().map(transfer -> this.createEventFromTransfer(address, tx, (EvmTransaction.TokenTransfer)transfer)).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private TxnEvent createEventFromTransfer(String address, EvmTransaction tx, EvmTransaction.TokenTransfer transfer) {
        String from = transfer.getFrom();
        String to = transfer.getTo();
        BigInteger amount = new BigInteger(transfer.getValue());
        BigDecimal humanAmount = new MathConstantConverter(transfer.getDecimals()).toHuman(amount);
        TxType txType = this.typeOf(from, to, address);
        if (txType == null) {
            return null;
        }
        return TxnEvent.builder().address(address).timestamp(this.timestamp(tx.getBlockTime())).txid(tx.getTxid()).confirmations(tx.getConfirmations()).smartContract(transfer.getContract()).value(new Value(humanAmount, amount)).asset(this.asset).build();
    }

    private TxType typeOf(String from, String to, String address) {
        return from.equalsIgnoreCase(address) ? TxType.SEND : (to.equalsIgnoreCase(address) ? TxType.RECEIVE : null);
    }

    private long timestamp(long seconds) {
        return Instant.ofEpochSecond(seconds).toEpochMilli();
    }
}

