/*
 * Decompiled with CFR 0.152.
 */
package org.exploit.blockbook;

import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.module.SimpleModule;
import java.io.IOException;
import java.util.List;
import org.eclipse.jetty.http.HttpMethod;
import org.exploit.blockbook.deserializer.BlockBookTransactionDeserializer;
import org.exploit.blockbook.deserializer.PushResultDeserializer;
import org.exploit.blockbook.model.BalanceHistoryEntry;
import org.exploit.blockbook.model.Block;
import org.exploit.blockbook.model.BlockHash;
import org.exploit.blockbook.model.Status;
import org.exploit.blockbook.model.UnspentOutput;
import org.exploit.blockbook.model.address.BlockBookAddress;
import org.exploit.blockbook.model.address.XPubAddress;
import org.exploit.blockbook.model.error.BlockBookErrorMessage;
import org.exploit.blockbook.model.result.PushResult;
import org.exploit.blockbook.model.transaction.BlockBookTransaction;
import org.exploit.finja.core.model.WebData;
import org.exploit.finja.exception.FinjaException;
import org.exploit.finja.utils.Jackson;
import org.exploit.jettyx.annotation.Body;
import org.exploit.jettyx.annotation.HttpRequest;
import org.exploit.jettyx.annotation.Path;
import org.exploit.jettyx.annotation.Query;
import org.exploit.jettyx.exception.InvalidResponseBodyException;
import org.exploit.jettyx.model.HttpResponse;

public interface BlockBookApi {
    @HttpRequest(path="/api")
    public HttpResponse<Status> getStatus();

    @HttpRequest(path="/api/status")
    public HttpResponse<Status> getApiStatus();

    @HttpRequest(path="/api/v2/block-index/{height}")
    public HttpResponse<BlockHash> getBlockHash(@Path(value="height") int var1);

    @HttpRequest(path="/api/v2/tx/{txid}")
    public HttpResponse<BlockBookTransaction> getTransaction(@Path(value="txid") String var1);

    @HttpRequest(path="/api/v2/tx/{txid}")
    public HttpResponse<BlockBookTransaction> getTransactionR(@Path(value="txid") String var1);

    @HttpRequest(path="/api/v2/address/{address}")
    public HttpResponse<BlockBookAddress> getAddress(@Path(value="address") String var1, @Query(value="page") int var2);

    @HttpRequest(path="/api/v2/xpub/{xpub}")
    public HttpResponse<XPubAddress> getXPub(@Path(value="xpub") String var1, @Query(value="page") int var2);

    @HttpRequest(path="/api/v2/block/{block}")
    public HttpResponse<Block> getBlock(@Path(value="block") int var1, @Query(value="page") int var2);

    @HttpRequest(path="/api/v2/utxo/{address}")
    public HttpResponse<List<UnspentOutput>> getUnspentOutputs(@Path(value="address") String var1);

    @HttpRequest(path="/api/v2/sendtx/", method=HttpMethod.POST)
    public HttpResponse<JsonNode> push(@Body String var1);

    @HttpRequest(path="/api/v2/balancehistory/{address}")
    public HttpResponse<List<BalanceHistoryEntry>> getBalanceHistory(@Path(value="address") String var1);

    public static BlockBookApi create(WebData webData) {
        SimpleModule blockBookModule = new SimpleModule().addDeserializer(BlockBookTransaction.class, (JsonDeserializer)new BlockBookTransactionDeserializer()).addDeserializer(PushResult.class, (JsonDeserializer)new PushResultDeserializer());
        Jackson.getObjectMapper().registerModule((Module)blockBookModule);
        return (BlockBookApi)webData.newApiClient(BlockBookApi.class);
    }

    public static <T> T handle(HttpResponse<T> response) {
        Exception exception;
        if (response.exception() != null && (exception = response.exception()) instanceof InvalidResponseBodyException) {
            InvalidResponseBodyException resp = (InvalidResponseBodyException)exception;
            try {
                BlockBookErrorMessage errorMessage = BlockBookErrorMessage.from(response.rawResponse().getContent());
                throw new FinjaException(errorMessage.error());
            }
            catch (IOException e) {
                throw resp;
            }
        }
        return (T)response.body();
    }
}

