/*
 * Decompiled with CFR 0.152.
 */
package org.extendj.neobeaver;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.extendj.Trace;
import org.extendj.neobeaver.Grammar;
import org.extendj.neobeaver.ListComponent;
import org.extendj.neobeaver.OptionalComponent;
import org.extendj.neobeaver.Parser;
import org.extendj.neobeaver.Rule;
import org.extendj.neobeaver.Symbol;
import org.extendj.neobeaver.SymbolCache;
import org.extendj.neobeaver.Tuple;

public class BeaverParser {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Grammar buildParser(Trace trace, Parser.Symbol parseTree) {
        String embed;
        String header;
        String className;
        String packageName;
        HashSet<Symbol> terminals;
        HashMap<String, Integer> precedence;
        HashSet<String> nonassoc;
        HashSet<String> right;
        HashSet<String> left;
        ArrayList<Rule> rules;
        Symbol goalSym;
        try {
            trace.pushEvent("parse");
            goalSym = Symbol.EOF;
            rules = new ArrayList<Rule>();
            Stack<Parser.Symbol> stack = new Stack<Parser.Symbol>();
            HashMap<String, String> typeMap = new HashMap<String, String>();
            SymbolCache cache = new SymbolCache();
            left = new HashSet<String>();
            right = new HashSet<String>();
            nonassoc = new HashSet<String>();
            HashSet<String> assoc = new HashSet<String>();
            precedence = new HashMap<String, Integer>();
            terminals = new HashSet<Symbol>();
            HashSet<String> terminalNames = new HashSet<String>();
            try {
                trace.pushEvent("typeMap");
                stack.push(parseTree);
                block89: while (!stack.isEmpty()) {
                    Parser.Symbol top = (Parser.Symbol)stack.pop();
                    if (!(top instanceof Parser.Nonterminal)) continue;
                    Parser.Nonterminal nta = (Parser.Nonterminal)top;
                    block13 : switch (nta.name) {
                        case "productionList": {
                            if (nta.children.length > 1) {
                                stack.push(nta.children[1]);
                            }
                            stack.push(nta.children[0]);
                            break;
                        }
                        case "directive": {
                            String directive;
                            switch (directive = BeaverParser.literal(nta.children[0])) {
                                case "%class": 
                                case "%package": 
                                case "%header": 
                                case "%embed": 
                                case "%left": 
                                case "%right": 
                                case "%nonassoc": 
                                case "%terminals": {
                                    break block13;
                                }
                                case "%typeof": {
                                    BeaverParser.addType(cache, typeMap, nta, BeaverParser.literal(nta.children[1]), BeaverParser.literal(nta.children[3]));
                                    break block13;
                                }
                                case "%goal": {
                                    if (goalSym == Symbol.EOF) {
                                        goalSym = cache.nta(BeaverParser.literal(nta.children[1]));
                                        goalSym.setPosition(nta.getPosition());
                                        break block13;
                                    }
                                    System.err.format("WARNING: %s multiple goal symbols specified.%n", nta.getPosition());
                                    break block13;
                                }
                            }
                            throw new Error("Unknown directive: " + directive);
                        }
                        case "production": {
                            Symbol lhs;
                            String name = BeaverParser.literal(nta.children[1]);
                            Parser.Symbol type = nta.children[0];
                            if (!(type instanceof Parser.EmptyOpt)) {
                                BeaverParser.addType(cache, typeMap, nta, name, BeaverParser.literal(type));
                            }
                            if (cache.contains(name)) {
                                lhs = cache.get(name);
                            } else {
                                lhs = cache.nta(name);
                                lhs.setPosition(nta.getPosition());
                            }
                            lhs.setPosition(nta.getPosition());
                            if (goalSym != Symbol.EOF) continue block89;
                            goalSym = lhs;
                            break;
                        }
                        default: {
                            throw new Error("Unknown production: " + nta.name);
                        }
                    }
                }
            }
            finally {
                trace.popEvent();
            }
            try {
                trace.pushEvent("productions");
                int nextPrecedence = 1;
                stack.push(parseTree);
                block90: while (!stack.isEmpty()) {
                    Parser.Symbol top = (Parser.Symbol)stack.pop();
                    if (!(top instanceof Parser.Nonterminal)) continue;
                    Parser.Nonterminal nta = (Parser.Nonterminal)top;
                    block40 : switch (nta.name) {
                        case "productionList": {
                            if (nta.children.length > 1) {
                                stack.push(nta.children[1]);
                            }
                            stack.push(nta.children[0]);
                            break;
                        }
                        case "directive": {
                            String directive;
                            switch (directive = BeaverParser.literal(nta.children[0])) {
                                case "%class": 
                                case "%package": 
                                case "%header": 
                                case "%embed": {
                                    break block40;
                                }
                                case "%left": {
                                    nextPrecedence = BeaverParser.parseAssocRules(nta, assoc, left, precedence, nextPrecedence);
                                    break block40;
                                }
                                case "%right": {
                                    nextPrecedence = BeaverParser.parseAssocRules(nta, assoc, right, precedence, nextPrecedence);
                                    break block40;
                                }
                                case "%nonassoc": {
                                    nextPrecedence = BeaverParser.parseAssocRules(nta, assoc, nonassoc, precedence, nextPrecedence);
                                    break block40;
                                }
                                case "%terminals": {
                                    BeaverParser.parseTerminals(cache, nta, terminals, terminalNames);
                                    break block40;
                                }
                                case "%typeof": 
                                case "%goal": {
                                    break block40;
                                }
                            }
                            throw new Error("Unknown directive: " + directive);
                        }
                        case "production": {
                            Symbol lhs;
                            String name = BeaverParser.literal(nta.children[1]);
                            String lhsType = typeMap.containsKey(name) ? (String)typeMap.get(name) : "Symbol";
                            if (cache.contains(name)) {
                                lhs = cache.get(name);
                            } else {
                                lhs = cache.nta(name);
                                lhs.setPosition(nta.getPosition());
                            }
                            Stack<Parser.Symbol> rstack = new Stack<Parser.Symbol>();
                            rstack.push(nta.children[3]);
                            block91: while (!rstack.isEmpty()) {
                                Parser.Symbol rtop = (Parser.Symbol)rstack.pop();
                                if (rtop instanceof Parser.Nonterminal) {
                                    Parser.Nonterminal rnta = (Parser.Nonterminal)rtop;
                                    switch (rnta.name) {
                                        case "ruleList": {
                                            rstack.push(rnta.children[0]);
                                            if (rnta.children.length <= 2) continue block91;
                                            rstack.push(rnta.children[2]);
                                            break;
                                        }
                                        case "rule": {
                                            ArrayList<Symbol> rhs = new ArrayList<Symbol>();
                                            ArrayList<String> names = new ArrayList<String>();
                                            BeaverParser.parseComponents(cache, rnta.children[0], rhs, names);
                                            if (rnta.children.length > 1) {
                                                String action = BeaverParser.parseAction(rnta.children[1]);
                                                rules.add(new Rule(-1, lhs, rhs, action, names, lhsType));
                                                break;
                                            }
                                            rules.add(new Rule(-1, lhs, rhs, "", names, lhsType));
                                            break;
                                        }
                                        default: {
                                            throw new Error("Unknown production rule: " + rnta.name);
                                        }
                                    }
                                    continue;
                                }
                                throw new Error("Expected NTA.");
                            }
                            continue block90;
                        }
                        default: {
                            throw new Error("Unknown production: " + nta.name);
                        }
                    }
                }
            }
            finally {
                trace.popEvent();
            }
            try {
                trace.pushEvent("packageName");
                packageName = BeaverParser.parsePackageName(parseTree);
            }
            finally {
                trace.popEvent();
            }
            try {
                trace.pushEvent("className");
                className = BeaverParser.parseClassName(parseTree);
            }
            finally {
                trace.popEvent();
            }
            try {
                trace.pushEvent("header");
                header = BeaverParser.parseHeader(parseTree);
            }
            finally {
                trace.popEvent();
            }
            try {
                trace.pushEvent("embed");
                embed = BeaverParser.parseEmbed(parseTree);
            }
            finally {
                trace.popEvent();
            }
        }
        finally {
            trace.popEvent();
        }
        try {
            trace.pushEvent("Grammar.build");
            Grammar grammar = Grammar.build(trace, rules, terminals, goalSym, embed, header, className, packageName, left, right, nonassoc, precedence);
            return grammar;
        }
        finally {
            trace.popEvent();
        }
    }

    private static void addType(SymbolCache cache, Map<String, String> typeMap, Parser.Nonterminal nta, String name, String type) {
        if (typeMap.containsKey(name) && !typeMap.get(name).equals(type)) {
            System.err.format("%s: WARNING: conflicting type declarations for %s: new type %s is not same as previous type %s%n", nta.getPosition(), name, type, typeMap.get(name));
        }
        typeMap.put(name, type);
    }

    private static int parseAssocRules(Parser.Nonterminal nta, Set<String> assoc, Set<String> left, Map<String, Integer> precedence, int nextPrecedence) {
        Stack<Parser.Symbol> stack = new Stack<Parser.Symbol>();
        stack.push(nta.children[1]);
        block6: while (!stack.isEmpty()) {
            Parser.Symbol top = (Parser.Symbol)stack.pop();
            if (top instanceof Parser.Nonterminal) {
                Parser.Nonterminal rnta = (Parser.Nonterminal)top;
                switch (rnta.name) {
                    case "symList": {
                        stack.push(rnta.children[0]);
                        if (rnta.children.length <= 2) continue block6;
                        stack.push(rnta.children[2]);
                        break;
                    }
                    default: {
                        throw new Error("Unknown production rule: " + rnta.name);
                    }
                }
                continue;
            }
            String name = BeaverParser.literal(top);
            if (assoc.contains(name)) {
                System.err.format("WARNING: associativity already specified for %s%n", name);
                continue;
            }
            precedence.put(name, nextPrecedence);
            assoc.add(name);
            left.add(name);
        }
        return nextPrecedence + 1;
    }

    private static void parseTerminals(SymbolCache cache, Parser.Nonterminal nta, Set<Symbol> terminals, Set<String> terminalNames) {
        Stack<Parser.Symbol> stack = new Stack<Parser.Symbol>();
        stack.push(nta.children[1]);
        block6: while (!stack.isEmpty()) {
            Parser.Symbol top = (Parser.Symbol)stack.pop();
            if (top instanceof Parser.Nonterminal) {
                Parser.Nonterminal rnta = (Parser.Nonterminal)top;
                switch (rnta.name) {
                    case "symList": {
                        stack.push(rnta.children[0]);
                        if (rnta.children.length <= 2) continue block6;
                        stack.push(rnta.children[2]);
                        break;
                    }
                    default: {
                        throw new Error("Unknown production rule: " + rnta.name);
                    }
                }
                continue;
            }
            String name = BeaverParser.literal(top);
            if (terminalNames.contains(name)) {
                System.err.format("WARNING: duplicate terminal declared: %s%n", name);
                continue;
            }
            Symbol term = cache.terminal(name);
            term.setPosition(top.getPosition());
            terminals.add(term);
            terminalNames.add(name);
        }
    }

    private static String parseAction(Parser.Symbol child) {
        if (child instanceof Parser.Nonterminal) {
            Parser.Nonterminal nta = (Parser.Nonterminal)child;
            switch (nta.name) {
                case "semanticAction": {
                    return BeaverParser.literal(nta.children[1]).trim();
                }
            }
            throw new Error("Unexpected action type: " + nta.name);
        }
        throw new Error("Expected NTA, but found: " + child);
    }

    private static void parseComponents(SymbolCache cache, Parser.Symbol child, List<Symbol> rhs, List<String> names) {
        Stack<Parser.Symbol> stack = new Stack<Parser.Symbol>();
        stack.push(child);
        HashSet usedNames = new HashSet();
        block20: while (!stack.isEmpty()) {
            Parser.Symbol top = (Parser.Symbol)stack.pop();
            if (!(top instanceof Parser.Nonterminal)) continue;
            Parser.Nonterminal nta = (Parser.Nonterminal)top;
            switch (nta.name) {
                case "componentList": {
                    if (nta.children.length > 1) {
                        stack.push(nta.children[1]);
                    }
                    if (nta.children.length <= 0) continue block20;
                    stack.push(nta.children[0]);
                    continue block20;
                }
                case "precedence": {
                    continue block20;
                }
                case "component": {
                    Tuple<Symbol, String> sym = BeaverParser.parseSymbol(cache, nta.children[0]);
                    if (nta.children.length == 2) {
                        String quantifier;
                        switch (quantifier = BeaverParser.literal(nta.children[1])) {
                            case "*": {
                                rhs.add(ListComponent.buildOptional((Symbol)sym.first, cache));
                                break;
                            }
                            case "+": {
                                rhs.add(ListComponent.build((Symbol)sym.first, cache));
                                break;
                            }
                            case "?": {
                                rhs.add(OptionalComponent.build((Symbol)sym.first, cache));
                                break;
                            }
                            default: {
                                throw new Error("Unknown quantifier: " + quantifier);
                            }
                        }
                    } else {
                        rhs.add((Symbol)sym.first);
                    }
                    if (usedNames.contains(sym.second)) {
                        throw new SpecError(String.format("%s: can not reuse component name \"%s\" in this production!", nta.getPosition(), sym.second));
                    }
                    usedNames.add(sym.second);
                    names.add((String)sym.second);
                    continue block20;
                }
            }
            throw new Error("Unknown right-hand-side component: " + nta.name);
        }
    }

    private static Tuple<Symbol, String> parseSymbol(SymbolCache cache, Parser.Symbol sym) {
        if (sym instanceof Parser.Nonterminal) {
            Parser.Nonterminal nta = (Parser.Nonterminal)sym;
            switch (nta.name) {
                case "symbol": {
                    String name = BeaverParser.literal(nta.children[0]);
                    String actionName = nta.children.length == 3 ? BeaverParser.literal(nta.children[2]) : name;
                    if (cache.contains(name)) {
                        return new Tuple<Symbol, String>(cache.get(name), actionName);
                    }
                    Symbol tok = cache.terminal(name);
                    tok.setPosition(nta.getPosition());
                    return new Tuple<Symbol, String>(tok, actionName);
                }
            }
            throw new Error("Expected symbol production.");
        }
        throw new Error("Can't convert non-NTA to symbol.");
    }

    private static String parseEmbed(Parser.Symbol tree) {
        Stack<Parser.Symbol> stack = new Stack<Parser.Symbol>();
        stack.push(tree);
        while (!stack.isEmpty()) {
            Parser.Symbol top = (Parser.Symbol)stack.pop();
            if (!(top instanceof Parser.Nonterminal)) continue;
            Parser.Nonterminal nta = (Parser.Nonterminal)top;
            switch (nta.name) {
                case "productionList": {
                    if (nta.children.length > 1) {
                        stack.push(nta.children[1]);
                    }
                    stack.push(nta.children[0]);
                    break;
                }
                case "directive": {
                    String directive;
                    switch (directive = BeaverParser.literal(nta.children[0])) {
                        case "%embed": {
                            return BeaverParser.literal(nta.children[2]);
                        }
                    }
                }
            }
        }
        return "";
    }

    private static String parseHeader(Parser.Symbol tree) {
        Stack<Parser.Symbol> stack = new Stack<Parser.Symbol>();
        stack.push(tree);
        while (!stack.isEmpty()) {
            Parser.Symbol top = (Parser.Symbol)stack.pop();
            if (!(top instanceof Parser.Nonterminal)) continue;
            Parser.Nonterminal nta = (Parser.Nonterminal)top;
            switch (nta.name) {
                case "productionList": {
                    if (nta.children.length > 1) {
                        stack.push(nta.children[1]);
                    }
                    stack.push(nta.children[0]);
                    break;
                }
                case "directive": {
                    String directive;
                    switch (directive = BeaverParser.literal(nta.children[0])) {
                        case "%header": {
                            return BeaverParser.literal(nta.children[2]);
                        }
                    }
                }
            }
        }
        return "";
    }

    private static String parseClassName(Parser.Symbol tree) {
        Stack<Parser.Symbol> stack = new Stack<Parser.Symbol>();
        stack.push(tree);
        while (!stack.isEmpty()) {
            Parser.Symbol top = (Parser.Symbol)stack.pop();
            if (!(top instanceof Parser.Nonterminal)) continue;
            Parser.Nonterminal nta = (Parser.Nonterminal)top;
            switch (nta.name) {
                case "productionList": {
                    if (nta.children.length > 1) {
                        stack.push(nta.children[1]);
                    }
                    stack.push(nta.children[0]);
                    break;
                }
                case "directive": {
                    String directive;
                    switch (directive = BeaverParser.literal(nta.children[0])) {
                        case "%class": {
                            return BeaverParser.literal(nta.children[1]).trim();
                        }
                    }
                }
            }
        }
        return "Parser";
    }

    private static String parsePackageName(Parser.Symbol tree) {
        Stack<Parser.Symbol> stack = new Stack<Parser.Symbol>();
        stack.push(tree);
        while (!stack.isEmpty()) {
            Parser.Symbol top = (Parser.Symbol)stack.pop();
            if (!(top instanceof Parser.Nonterminal)) continue;
            Parser.Nonterminal nta = (Parser.Nonterminal)top;
            switch (nta.name) {
                case "productionList": {
                    if (nta.children.length > 1) {
                        stack.push(nta.children[1]);
                    }
                    stack.push(nta.children[0]);
                    break;
                }
                case "directive": {
                    String directive;
                    switch (directive = BeaverParser.literal(nta.children[0])) {
                        case "%package": {
                            return BeaverParser.literal(nta.children[1]).trim();
                        }
                    }
                }
            }
        }
        return "";
    }

    private static String literal(Parser.Symbol child) {
        return ((Parser.Token)child).literal;
    }

    public static class SpecError
    extends Error {
        public SpecError(String message) {
            super(message);
        }
    }
}

