/*
 * Decompiled with CFR 0.152.
 */
package org.extendj.neobeaver;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.extendj.neobeaver.Action;
import org.extendj.neobeaver.Grammar;
import org.extendj.neobeaver.Item;
import org.extendj.neobeaver.ItemSet;
import org.extendj.neobeaver.Reduce;
import org.extendj.neobeaver.Rule;
import org.extendj.neobeaver.Symbol;
import org.extendj.neobeaver.Tuple;
import org.extendj.neobeaver.Tuple3;

public class ItemLr1
extends Item {
    public final Symbol follow;

    public ItemLr1(Rule rule, int dot, Symbol follow) {
        super(rule, dot);
        this.follow = follow;
    }

    @Override
    public Collection<Item> extension(Grammar grammar) {
        if (this.dot < this.rule.rhs.size()) {
            Symbol afterDot = this.rule.rhs.get(this.dot);
            ArrayList<Item> result = new ArrayList<Item>();
            for (Symbol x : this.follows(grammar)) {
                result.addAll(grammar.extension(afterDot, x));
            }
            return result;
        }
        return Collections.emptyList();
    }

    private List<Symbol> follows(Grammar grammar) {
        ArrayList<Symbol> set = new ArrayList<Symbol>();
        for (int i = this.dot + 1; i < this.rule.rhs.size(); ++i) {
            Symbol x = this.rule.rhs.get(i);
            set.addAll(grammar.first(x));
            if (grammar.nullable(x)) continue;
            return set;
        }
        set.add(this.follow);
        return set;
    }

    @Override
    public Item advance() {
        if (this.dot >= this.rule.rhs.size()) {
            throw new Error("Can not advance dot in item past end.");
        }
        return new ItemLr1(this.rule, this.dot + 1, this.follow);
    }

    @Override
    public String toString() {
        return super.toString() + " [" + this.follow + "]";
    }

    @Override
    public Item baseItem() {
        return new Item(this.rule, this.dot);
    }

    @Override
    public int hashCode() {
        return this.rule.hashCode() ^ this.dot ^ this.follow.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof ItemLr1) {
            ItemLr1 other = (ItemLr1)obj;
            return this.dot == other.dot && this.rule.equals(other.rule) && this.follow == other.follow;
        }
        return false;
    }

    @Override
    public Collection<Symbol> followSyms() {
        return Collections.singleton(this.follow);
    }

    @Override
    public Collection<Tuple3<ItemSet, Symbol, Action>> reduceActions(Grammar grammar, ItemSet set) {
        return Collections.singleton(Tuple.of(set, this.follow, new Reduce(this.rule)));
    }
}

