/*
 * Decompiled with CFR 0.152.
 */
package org.extendj.neobeaver;

import java.io.ByteArrayOutputStream;

public class Util {
    private static final char[] BASE64 = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '#', '$'};

    public static String escape(String str) {
        return str.replace("\\", "\\\\").replace("\"", "\\\"");
    }

    public static String base64Encode(byte[] bytes) {
        ByteArrayOutputStream b64 = new ByteArrayOutputStream();
        for (int i = 0; i < bytes.length; i += 3) {
            int b1;
            int b0;
            if (i + 2 < bytes.length) {
                b0 = bytes[i + 0] & 0xFF;
                b1 = bytes[i + 1] & 0xFF;
                int b2 = bytes[i + 2] & 0xFF;
                Util.encode(b64, b0 >> 2 & 0x3F);
                Util.encode(b64, (b0 & 3) << 4 | b1 >> 4 & 0xF);
                Util.encode(b64, (b1 & 0xF) << 2 | b2 >> 6 & 3);
                Util.encode(b64, b2 & 0x3F);
                continue;
            }
            if (i + 1 < bytes.length) {
                b0 = bytes[i + 0] & 0xFF;
                b1 = bytes[i + 1] & 0xFF;
                Util.encode(b64, b0 >> 2 & 0x3F);
                Util.encode(b64, (b0 & 3) << 4 | b1 >> 4 & 0xF);
                Util.encode(b64, (b1 & 0xF) << 2);
                b64.write(61);
                continue;
            }
            b0 = bytes[i + 0] & 0xFF;
            Util.encode(b64, b0 >> 2 & 0x3F);
            Util.encode(b64, (b0 & 3) << 4);
            b64.write(61);
            b64.write(61);
        }
        return new String(b64.toByteArray());
    }

    public static byte[] base64Decode(String input) {
        int outputSize = (3 * input.length() + 3) / 4;
        byte[] output = new byte[outputSize];
        int outpos = 0;
        int step = 0;
        block6: for (int i = 0; i < input.length(); ++i) {
            int value;
            char ch = input.charAt(i);
            if (ch >= '0' && ch <= '9') {
                value = ch - 48;
            } else if (ch >= 'A' && ch <= 'Z') {
                value = 10 + (ch - 65);
            } else if (ch >= 'a' && ch <= 'z') {
                value = 36 + (ch - 97);
            } else if (ch == '#') {
                value = 62;
            } else if (ch == '$') {
                value = 63;
            } else if (ch == '=') {
                value = 0;
            } else {
                throw new Error(String.format("Unexpected Base64 character: '%c' in input.", Character.valueOf(ch)));
            }
            switch (step) {
                case 0: {
                    output[outpos] = (byte)(value << 2);
                    step = 1;
                    continue block6;
                }
                case 1: {
                    int n = outpos++;
                    output[n] = (byte)(output[n] | (byte)(value >> 4));
                    output[outpos] = (byte)(0xFF & value << 4);
                    step = 2;
                    continue block6;
                }
                case 2: {
                    int n = outpos++;
                    output[n] = (byte)(output[n] | (byte)(value >> 2));
                    output[outpos] = (byte)(0xFF & value << 6);
                    step = 3;
                    continue block6;
                }
                case 3: {
                    int n = outpos++;
                    output[n] = (byte)(output[n] | (byte)value);
                    step = 0;
                }
            }
        }
        return output;
    }

    private static void encode(ByteArrayOutputStream bytes, int b) {
        bytes.write(BASE64[b]);
    }
}

