/*
 * Decompiled with CFR 0.152.
 */
package beaver.comp.run;

import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.Set;
import org.extendj.neobeaver.NeoBeaver;
import org.extendj.neobeaver.ProblemHandler;
import org.extendj.neobeaver.ProblemLogger;
import org.extendj.neobeaver.TraceHandler;

public class Make {
    public static void main(String[] args) throws IOException {
        System.out.println("Welcome to NeoBeaver classic frontend!");
        ProblemLogger problems = new ProblemLogger();
        String destDirName = "";
        String filename = "";
        block14: for (int i = 0; i < args.length; ++i) {
            String arg;
            switch (arg = args[i]) {
                case "-h": {
                    System.out.println("Usage: nbfront [OPTIONS] <PARSER SPEC FILE>");
                    System.out.println("Options:");
                    System.out.println("  -d <DIR>    Generate parser in the named directory, DIR.");
                    System.out.println("  -h          Print help and exit.");
                    System.exit(0);
                    return;
                }
                case "-d": {
                    if (args.length > i + 1) {
                        destDirName = args[i + 1];
                        ++i;
                        continue block14;
                    }
                    System.err.println("Error: missing path argument to -d option.");
                    continue block14;
                }
                case "-t": {
                    continue block14;
                }
                case "-c": {
                    continue block14;
                }
                case "-w": {
                    continue block14;
                }
                default: {
                    if (arg.startsWith("-")) {
                        problems.warnf("ignoring option '%s'. It is probably an unsupported Beaver flag.", new Object[]{arg});
                        continue block14;
                    }
                    if (filename.isEmpty()) {
                        filename = arg;
                        continue block14;
                    }
                    problems.warnf("multiple filenames specified. Ignoring file: %s", new Object[]{arg});
                }
            }
        }
        if (filename.isEmpty()) {
            problems.error("no parser specification filename specified!");
        }
        if (!problems.errored()) {
            TraceHandler trace = NeoBeaver.nullTrace();
            Set<String> options = Collections.singleton("--beaver");
            NeoBeaver.process((TraceHandler)trace, (ProblemHandler)problems, (String)filename, (Path)Paths.get(destDirName, new String[0]), options);
        }
        problems.report();
        if (problems.errored()) {
            System.exit(1);
        }
    }
}

