/*
 * Decompiled with CFR 0.152.
 */
package org.extendj;

import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.zip.DeflaterOutputStream;

public class Trace {
    private long start;
    private static final int TRACE_FORMAT_VERSION = 2;
    public Stack<Event> events = new Stack();

    public Trace(String name) {
        this.start = System.nanoTime();
        Date timestamp = new Date();
        this.events.push(new Event(String.format("%s %tF %tT", name, timestamp, timestamp), System.nanoTime()));
    }

    public void setStart(long start) {
        this.start = start;
    }

    public void pushEvent(String name) {
        this.pushEvent(name, "");
    }

    public void pushEvent(String name, String metadata) {
        Event event = new Event(name, System.nanoTime(), metadata);
        this.events.peek().children.add(event);
        this.events.push(event);
    }

    public void popEvent() {
        this.events.pop().end = System.nanoTime();
    }

    public void dumpTrace(String prefix) {
        File dest;
        if (this.events.size() != 1) {
            System.err.format("Warning: tracing event stack has unexpected size %d. Only the top event will be reported.%n", this.events.size());
        }
        int suffix = 0;
        Date timestamp = new Date();
        String filename = String.format("%s.%tF.trace", prefix, timestamp);
        do {
            dest = new File(filename);
            filename = String.format("%s.%tF.%d.trace", prefix, new Date(), ++suffix);
        } while (dest.exists());
        try {
            System.err.format("Writing trace to %s%n", dest.getAbsolutePath());
            this.writeTrace(new DataOutputStream(new DeflaterOutputStream(new FileOutputStream(dest))), this.start);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void writeTrace(OutputStream output, long t0) throws IOException {
        DataOutputStream out = new DataOutputStream(output);
        out.writeInt(-2);
        Event root = this.events.peek();
        root.end = System.nanoTime();
        Set<String> eventNames = Trace.getEventNames(root);
        HashMap<String, Integer> nameMap = new HashMap<String, Integer>();
        out.writeInt(eventNames.size());
        int id = 0;
        for (String name : eventNames) {
            nameMap.put(name, id++);
            out.writeUTF(name);
        }
        Trace.writeEvent(out, root, nameMap, t0);
        out.close();
    }

    private static void writeEvent(DataOutputStream out, Event event, Map<String, Integer> nameMap, long t0) throws IOException {
        out.writeInt(nameMap.get(event.name));
        out.writeUTF(event.metadata);
        out.writeLong(event.start - t0);
        out.writeLong(event.end - t0);
        if (event.children.size() > Short.MAX_VALUE) {
            throw new Error(String.format("Event has too many children to serialize (%d)!", event.children.size()));
        }
        out.writeShort(event.children.size());
        for (Event child : event.children) {
            Trace.writeEvent(out, child, nameMap, t0);
        }
    }

    private static Set<String> getEventNames(Event root) {
        HashSet<String> names = new HashSet<String>();
        LinkedList<Event> queue = new LinkedList<Event>();
        queue.add(root);
        while (!queue.isEmpty()) {
            Event event = (Event)queue.poll();
            names.add(event.name);
            queue.addAll(event.children);
        }
        return names;
    }

    public void sendTo(String host, int port) throws IOException {
        System.err.format("Sending trace to: %s:%d%n", host, port);
        Socket socket = new Socket(host, port);
        this.writeTrace(socket.getOutputStream(), this.start);
    }

    public static class Event {
        public String name;
        public final long start;
        public final String metadata;
        public long end;
        public List<Event> children = new ArrayList<Event>();

        public Event(String name, long start) {
            this(name, start, "");
        }

        public Event(String name, long start, String metadata) {
            this.name = name;
            this.start = start;
            this.metadata = metadata;
        }
    }
}

