/*
 * Decompiled with CFR 0.152.
 */
package org.extendj.neobeaver;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.extendj.neobeaver.Grammar;
import org.extendj.neobeaver.ItemSet;
import org.extendj.neobeaver.ProblemHandler;
import org.extendj.neobeaver.Symbol;
import org.extendj.neobeaver.TransitionTable;
import org.extendj.neobeaver.Util;

public class MyParser {
    public final Grammar grammar;
    public final TransitionTable transitions;
    public final ItemSet renamedGoal;
    public final List<ItemSet> itemSets;

    public MyParser(Grammar grammar, TransitionTable table, ItemSet renamedGoal, List<ItemSet> itemSets) {
        this.grammar = grammar;
        this.transitions = table;
        this.renamedGoal = renamedGoal;
        this.itemSets = itemSets;
    }

    public void printTables() {
        this.grammar.printTables(this);
    }

    public void printGraph() {
        System.out.println("digraph Parser {");
        System.out.println("  node[shape=rectangle];");
        for (ItemSet set : this.itemSets) {
            set.printGraphNode();
        }
        System.out.println();
        for (ItemSet set : this.itemSets) {
            for (Map.Entry<Symbol, ItemSet> edge : this.transitions.map.get(set).entrySet()) {
                Symbol sym = edge.getKey();
                ItemSet next = edge.getValue();
                System.out.format("  S%d -> S%d [label=\"%s\"];%n", set.id(), next.id(), Util.escape(sym.toString()));
            }
        }
        System.out.println("}");
    }

    public void printParser() {
        this.grammar.printParser(System.out, this, false);
    }

    public void printItems() {
        for (ItemSet set : this.itemSets) {
            System.out.println(set);
        }
    }

    public void printBeaverSpec() throws IOException {
        this.grammar.printBeaverSpec(System.out, this);
    }

    public void printBeaverTestSpec() throws IOException {
        this.grammar.printBeaverTestSpec(System.out, this);
    }

    public void checkProblems(Grammar grammar, ProblemHandler problems, Set<Symbol> unused, boolean unreachableError) {
        this.transitions.checkProblems(grammar, problems, unused, unreachableError);
    }
}

