/*
 * Decompiled with CFR 0.152.
 */
package beaver.comp.run;

import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import org.extendj.Trace;
import org.extendj.neobeaver.BeaverParser;
import org.extendj.neobeaver.Grammar;
import org.extendj.neobeaver.MyParser;
import org.extendj.neobeaver.Parser;
import org.extendj.neobeaver.Scanner;

public class Make {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws IOException {
        System.out.println("Welcome to NeoBeaver classic frontend!");
        String destDirName = "";
        String filename = "";
        block70: for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            switch (arg) {
                case "-h": {
                    System.out.println("Usage: nbfront [OPTIONS] <PARSER SPEC FILE>");
                    System.out.println("Options:");
                    System.out.println("  -d <DIR>    Generate parser in the named directory, DIR.");
                    System.out.println("  -h          Print help and exit.");
                    System.exit(0);
                    return;
                }
                case "-d": {
                    if (args.length > i + 1) {
                        destDirName = args[i + 1];
                        ++i;
                        continue block70;
                    }
                    System.err.println("Error: missing path argument to -d option.");
                    continue block70;
                }
                case "-t": {
                    continue block70;
                }
                case "-c": {
                    continue block70;
                }
                case "-w": {
                    continue block70;
                }
                default: {
                    if (arg.startsWith("-")) {
                        System.err.format("Warning: ignoring option '%s'. It is probably an unsupported class Beaver flag.%n", arg);
                        continue block70;
                    }
                    if (filename.isEmpty()) {
                        filename = arg;
                        continue block70;
                    }
                    System.err.format("Warning: multiple filenames specified, ignoring file %s%n", arg);
                }
            }
        }
        if (filename.isEmpty()) {
            System.err.println("Error: no parser specification filename specified!");
            System.exit(1);
            return;
        }
        Trace trace = new Trace("NeoBeaverFrontend");
        try {
            FileReader reader = new FileReader(new File(filename));
            Object object = null;
            try (Scanner scanner = new Scanner((Reader)reader);){
                Path destPath;
                MyParser parser;
                Grammar grammar;
                Parser.Symbol parseTree;
                try {
                    trace.pushEvent("parseGrammar");
                    Parser grammarParser = new Parser();
                    parseTree = grammarParser.parse((Parser.TokenScanner)scanner);
                }
                finally {
                    trace.popEvent();
                }
                try {
                    trace.pushEvent("BP.buildParser");
                    grammar = BeaverParser.buildParser((Trace)trace, (Parser.Symbol)parseTree);
                }
                finally {
                    trace.popEvent();
                }
                try {
                    trace.pushEvent("checkProblems");
                    grammar.checkProblems();
                }
                finally {
                    trace.popEvent();
                }
                try {
                    trace.pushEvent("Grammar.buildParser");
                    parser = grammar.buildParser(trace);
                }
                finally {
                    trace.popEvent();
                }
                if (destDirName.isEmpty()) {
                    destPath = Paths.get("", new String[0]);
                } else {
                    destPath = Paths.get(destDirName, new String[0]);
                    if (!Files.exists(destPath, new LinkOption[0])) {
                        System.err.format("Error: the named destination directory %s does not exist.%n", destDirName);
                        System.exit(1);
                        return;
                    }
                }
                if (!grammar.packageName.isEmpty()) {
                    destPath = destPath.resolve(grammar.packageName.replaceAll("\\.", File.separator));
                }
                if (!Files.exists(destPath, new LinkOption[0])) {
                    System.out.println("Creating output directory: " + destPath);
                    Files.createDirectories(destPath, new FileAttribute[0]);
                }
                File dest = destPath.resolve(String.format("%s.java", grammar.className)).toFile();
                try (FileOutputStream fout = new FileOutputStream(dest);
                     PrintStream out = new PrintStream(fout);){
                    grammar.printBeaverParser(out, parser);
                }
                parser.transitions.printConflicts(grammar);
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (reader != null) {
                    if (object != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        reader.close();
                    }
                }
            }
        }
        catch (BeaverParser.SpecError e) {
            System.err.println("Error in parser specification:");
            System.err.println(e.getMessage());
            System.exit(1);
        }
    }
}

