/*
 * Decompiled with CFR 0.152.
 */
package org.extendj.neobeaver;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashSet;
import org.extendj.Trace;
import org.extendj.neobeaver.BeaverParser;
import org.extendj.neobeaver.Grammar;
import org.extendj.neobeaver.MyParser;
import org.extendj.neobeaver.Parser;
import org.extendj.neobeaver.Scanner;

public class NeoBeaver {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws IOException {
        block53: {
            HashSet<String> files = new HashSet<String>();
            HashSet<String> options = new HashSet<String>();
            for (String arg : args) {
                if (arg.startsWith("-")) {
                    options.add(arg);
                    continue;
                }
                files.add(arg);
            }
            if (args.length < 1) {
                System.err.println("No input files specified!");
                System.exit(1);
                return;
            }
            Trace trace = new Trace("NeoBeaver");
            try {
                Scanner scanner;
                if (options.contains("--tokenize") || options.contains("-t")) {
                    for (String filename : files) {
                        scanner = new Scanner(new FileReader(new File(filename)));
                        Throwable throwable = null;
                        try {
                            Parser.Token sym;
                            do {
                                sym = scanner.nextToken();
                                System.out.format("%4d: %s%n", sym.getId(), sym);
                            } while (sym.getId() != 1);
                        }
                        catch (Throwable sym) {
                            throwable = sym;
                            throw sym;
                        }
                        finally {
                            if (scanner == null) continue;
                            if (throwable != null) {
                                try {
                                    scanner.close();
                                }
                                catch (Throwable sym) {
                                    throwable.addSuppressed(sym);
                                }
                                continue;
                            }
                            scanner.close();
                        }
                    }
                    break block53;
                }
                for (String filename : files) {
                    scanner = new Scanner(new FileReader(new File(filename)));
                    Throwable throwable = null;
                    try {
                        MyParser parser;
                        Grammar grammar;
                        Parser.Symbol parseTree;
                        try {
                            trace.pushEvent("parseGrammar");
                            Parser grammarParser = new Parser();
                            parseTree = grammarParser.parse(scanner);
                        }
                        finally {
                            trace.popEvent();
                        }
                        try {
                            trace.pushEvent("BP.buildParser");
                            grammar = BeaverParser.buildParser(trace, parseTree);
                        }
                        finally {
                            trace.popEvent();
                        }
                        try {
                            trace.pushEvent("checkProblems");
                            grammar.checkProblems();
                        }
                        finally {
                            trace.popEvent();
                        }
                        try {
                            trace.pushEvent("Grammar.buildParser");
                            parser = grammar.buildParser(trace);
                        }
                        finally {
                            trace.popEvent();
                        }
                        if (options.contains("--print-table") || options.contains("-table")) {
                            parser.transitions.printTables(parser.grammar, parser.itemSets);
                            parser.printTables();
                        }
                        if (options.contains("--print-table") || options.contains("-p")) {
                            parser.printTables();
                        }
                        if (options.contains("-i")) {
                            parser.printItems();
                        }
                        if (options.contains("-g")) {
                            parser.printGraph();
                        }
                        if (options.contains("--beaver")) {
                            parser.printBeaverParser();
                        }
                        if (options.contains("--standalone") || options.contains("-s")) {
                            parser.printParser();
                        }
                        if (options.contains("--classic")) {
                            parser.printBeaverSpec();
                        }
                        if (options.contains("--test")) {
                            parser.printBeaverTestSpec();
                        }
                        parser.transitions.printConflicts(grammar);
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (scanner == null) continue;
                        if (throwable != null) {
                            try {
                                scanner.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        scanner.close();
                    }
                }
            }
            catch (BeaverParser.SpecError e) {
                System.err.println("Error in parser specification:");
                System.err.println(e.getMessage());
                System.exit(1);
            }
            finally {
                if (options.contains("--trace")) {
                    trace.sendTo("localhost", 8040);
                }
            }
        }
    }
}

