/*
 * Decompiled with CFR 0.152.
 */
package org.extendj.neobeaver;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.extendj.neobeaver.Action;
import org.extendj.neobeaver.ActionKind;
import org.extendj.neobeaver.Conflict;
import org.extendj.neobeaver.Grammar;
import org.extendj.neobeaver.Item;
import org.extendj.neobeaver.ItemSet;
import org.extendj.neobeaver.Reduce;
import org.extendj.neobeaver.Shift;
import org.extendj.neobeaver.Symbol;
import org.extendj.neobeaver.Tuple3;

public class TransitionTable {
    public final ItemSet goal;
    public final Map<ItemSet, Map<Symbol, ItemSet>> map;
    public final Map<ItemSet, Map<Symbol, Action>> actions;
    public final List<Conflict> conflicts;

    public TransitionTable(ItemSet goal, Map<ItemSet, Map<Symbol, ItemSet>> map, Map<ItemSet, Map<Symbol, Action>> actions, List<Conflict> conflicts) {
        this.goal = goal;
        this.map = map;
        this.actions = actions;
        this.conflicts = conflicts;
    }

    public static TransitionTable build(Grammar grammar, Set<Symbol> syms, List<ItemSet> itemSets, ItemSet goal, Map<ItemSet, ItemSet> coreMap, List<Tuple3<ItemSet, ItemSet, Symbol>> transitions, List<Tuple3<ItemSet, Symbol, Action>> extraActions) {
        HashMap<ItemSet, Map<Symbol, ItemSet>> map = new HashMap<ItemSet, Map<Symbol, ItemSet>>();
        HashMap<ItemSet, Map<Symbol, Action>> actions = new HashMap<ItemSet, Map<Symbol, Action>>();
        for (ItemSet itemSet : itemSets) {
            map.put(itemSet, new HashMap());
            actions.put(itemSet, new HashMap());
        }
        for (Tuple3 tuple3 : transitions) {
            ItemSet source = coreMap.get(tuple3.first);
            ItemSet dest = coreMap.get(tuple3.second);
            Symbol symbol = (Symbol)tuple3.third;
            ((Map)map.get(source)).put(symbol, dest);
        }
        ArrayList<Symbol> nonterminals = new ArrayList<Symbol>();
        ArrayList<Symbol> arrayList = new ArrayList<Symbol>();
        ArrayList<Conflict> conflicts = new ArrayList<Conflict>();
        for (Symbol symbol : syms) {
            if (symbol.isTerminal()) {
                arrayList.add(symbol);
                continue;
            }
            nonterminals.add(symbol);
        }
        for (ItemSet itemSet : itemSets) {
            for (Item item : itemSet.allItems()) {
                if (item.dot < item.rule.rhs.size()) continue;
                Collection<Tuple3<ItemSet, Symbol, Action>> reduceActs = item.reduceActions(grammar, itemSet);
                for (Tuple3<ItemSet, Symbol, Action> action : reduceActs) {
                    TransitionTable.addAction(grammar, actions, conflicts, (ItemSet)action.first, (Symbol)action.second, (Action)action.third);
                }
            }
            Map setTransitions = (Map)map.get(itemSet);
            for (Symbol sym : arrayList) {
                if (!setTransitions.containsKey(sym)) continue;
                TransitionTable.addAction(grammar, actions, conflicts, itemSet, sym, new Shift(sym, (ItemSet)setTransitions.get(sym)));
            }
        }
        for (Tuple3 tuple3 : extraActions) {
            TransitionTable.addAction(grammar, actions, conflicts, (ItemSet)tuple3.first, (Symbol)tuple3.second, (Action)tuple3.third);
        }
        return new TransitionTable(goal, map, actions, conflicts);
    }

    private static void addAction(Grammar grammar, Map<ItemSet, Map<Symbol, Action>> actions, Collection<Conflict> conflicts, ItemSet set, Symbol sym, Action action) {
        Map<Symbol, Action> setActions = actions.get(set);
        if (setActions.containsKey(sym)) {
            Action otherAction = setActions.get(sym);
            SelectedAction selected = TransitionTable.selectAction(action, otherAction, grammar);
            ActionKind kind = action.kind();
            ActionKind otherKind = otherAction.kind();
            if (selected == SelectedAction.SHIFT) {
                if (kind == ActionKind.SHIFT && otherKind == ActionKind.REDUCE) {
                    setActions.put(sym, action);
                    return;
                }
                if (kind == ActionKind.REDUCE && otherKind == ActionKind.SHIFT) {
                    return;
                }
            }
            if (selected == SelectedAction.REDUCE) {
                if (kind == ActionKind.SHIFT && otherKind == ActionKind.REDUCE) {
                    return;
                }
                if (kind == ActionKind.REDUCE && otherKind == ActionKind.SHIFT) {
                    setActions.put(sym, action);
                    return;
                }
            }
            conflicts.add(new Conflict(set, sym, action, setActions.get(sym)));
        } else {
            setActions.put(sym, action);
        }
    }

    public static SelectedAction selectAction(Action action, Action otherAction, Grammar grammar) {
        String first = TransitionTable.firstToken(action);
        String second = TransitionTable.firstToken(otherAction);
        if (grammar.precedence(first) < grammar.precedence(second)) {
            return SelectedAction.SHIFT;
        }
        if (grammar.precedence(first) > grammar.precedence(second)) {
            return SelectedAction.REDUCE;
        }
        if (grammar.left(first) && grammar.left(second)) {
            return SelectedAction.REDUCE;
        }
        if (grammar.right(first) && grammar.right(second)) {
            return SelectedAction.SHIFT;
        }
        return SelectedAction.NONE;
    }

    private static String firstToken(Action action) {
        if (action instanceof Shift) {
            return ((Shift)action).sym.name();
        }
        if (action instanceof Reduce) {
            for (Symbol sym : ((Reduce)action).rule.rhs) {
                if (!sym.isTerminal()) continue;
                return sym.name();
            }
        }
        return "?sym";
    }

    public void printTables(Grammar grammar, List<ItemSet> itemSets) {
        Map<Symbol, ItemSet> transitions;
        ArrayList<Symbol> nonterminals = new ArrayList<Symbol>();
        ArrayList<Symbol> terminals = new ArrayList<Symbol>();
        ArrayList conflicts = new ArrayList();
        for (Symbol sym : grammar.syms) {
            if (sym.isTerminal()) {
                terminals.add(sym);
                continue;
            }
            nonterminals.add(sym);
        }
        System.out.println("Transition Table");
        System.out.println("----------------");
        for (Symbol sym : grammar.syms) {
            System.out.print("\t" + sym + ",");
        }
        System.out.println();
        for (ItemSet set : itemSets) {
            transitions = this.map.get(set);
            System.out.print("S" + set.id());
            for (Symbol sym : grammar.syms) {
                if (transitions.containsKey(sym)) {
                    System.out.print("\tS" + transitions.get(sym).id() + ",");
                    continue;
                }
                System.out.print("\t,");
            }
            System.out.println();
        }
        System.out.println();
        System.out.println("Action Table");
        System.out.println("------------");
        for (Symbol sym : terminals) {
            System.out.print("\t" + sym + ",");
        }
        System.out.println();
        for (ItemSet set : itemSets) {
            System.out.print("S" + set.id());
            Map<Symbol, Action> setActions = this.actions.get(set);
            for (Symbol sym : terminals) {
                if (setActions.containsKey(sym)) {
                    Action action = setActions.get(sym);
                    System.out.print("\t" + action.code() + ",");
                    continue;
                }
                System.out.print("\t,");
            }
            System.out.println();
        }
        System.out.println();
        System.out.println("Goto Table");
        System.out.println("----------");
        for (Symbol sym : nonterminals) {
            System.out.print("\t" + sym + ",");
        }
        System.out.println();
        for (ItemSet set : itemSets) {
            transitions = this.map.get(set);
            System.out.print("S" + set.id());
            for (Symbol sym : nonterminals) {
                if (transitions.containsKey(sym)) {
                    System.out.print("\tS" + transitions.get(sym).id() + ",");
                    continue;
                }
                System.out.print("\t,");
            }
            System.out.println();
        }
    }

    public void printConflicts(Grammar grammar) {
        HashMap map = new HashMap();
        for (Conflict conflict : this.conflicts) {
            if (!map.containsKey(conflict.set)) {
                map.put(conflict.set, new ArrayList());
            }
            ((Collection)map.get(conflict.set)).add(conflict);
        }
        for (Map.Entry entry : map.entrySet()) {
            System.err.println("Conflicts:");
            for (Conflict conflict : (Collection)entry.getValue()) {
                System.err.print("  ");
                System.err.println(conflict);
            }
            System.err.format("Context: %s%n", entry.getKey());
        }
        for (Conflict conflict : this.conflicts) {
            if (grammar.nonassoc(conflict.sym.name())) {
                throw new Error(String.format("Symbol %s is nonassociative, but there are conflicts including the symbol.", conflict.sym.name()));
            }
            if (!(conflict.action instanceof Reduce) || !(conflict.otherAction instanceof Reduce)) continue;
            throw new Error("Parser contains reduce-reduce conflict.");
        }
    }

    static enum SelectedAction {
        SHIFT,
        REDUCE,
        NONE;

    }
}

