/*
 * Decompiled with CFR 0.152.
 */
package org.extendj.neobeaver;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.extendj.neobeaver.Grammar;
import org.extendj.neobeaver.Parser;
import org.extendj.neobeaver.Rule;
import org.extendj.neobeaver.Symbol;
import org.extendj.neobeaver.SymbolCache;

public class ListComponent
implements Symbol {
    public final Symbol sym;
    public final List<Rule> rules;
    public final List<Symbol> symbols;

    public static ListComponent build(Symbol sym, SymbolCache cache) {
        Symbol list = cache.list(sym);
        ArrayList<Rule> rules = new ArrayList<Rule>();
        rules.add(new Rule(-1, list, Collections.singletonList(sym), String.format("return new List().add(%s);", sym.actionName()), Collections.emptyList(), "List"));
        rules.add(new Rule(-1, list, Lists.asList((Object)list, (Object)sym, (Object[])new Symbol[0]), String.format("return %s.add(%s);", list.actionName(), sym.actionName()), Collections.emptyList(), "List"));
        rules = new ArrayList<Rule>(Grammar.canonicalRules(rules));
        return new ListComponent(list, rules, Collections.singletonList(sym));
    }

    public static ListComponent buildOptional(Symbol sym, SymbolCache cache) {
        Symbol opt = cache.opt(sym);
        Symbol list = cache.list(sym);
        ArrayList<Rule> rules = new ArrayList<Rule>();
        rules.add(new Rule(-1, opt, Collections.emptyList(), "return new List();", Collections.emptyList(), "List"));
        rules.add(new Rule(-1, opt, Collections.singletonList(list), String.format("return %s;", list.actionName()), Collections.emptyList(), "List"));
        rules.add(new Rule(-1, list, Collections.singletonList(sym), String.format("return new List().add(%s);", sym.actionName()), Collections.emptyList(), "List"));
        rules.add(new Rule(-1, list, Lists.asList((Object)list, (Object)sym, (Object[])new Symbol[0]), String.format("return %s.add(%s);", list.actionName(), sym.actionName()), Collections.emptyList(), "List"));
        rules = new ArrayList<Rule>(Grammar.canonicalRules(rules));
        return new ListComponent(list, rules, Collections.singletonList(sym));
    }

    public ListComponent(Symbol sym, List<Rule> rules, List<Symbol> symbols) {
        this.sym = sym;
        this.rules = rules;
        this.symbols = symbols;
    }

    @Override
    public String actionName() {
        return null;
    }

    @Override
    public boolean isTerminal() {
        return false;
    }

    @Override
    public int id() {
        return -1;
    }

    @Override
    public boolean isNamed() {
        return false;
    }

    @Override
    public String name() {
        return null;
    }

    @Override
    public Collection<? extends Rule> extraRules() {
        return this.rules;
    }

    public String toString() {
        return "<list>";
    }

    @Override
    public Parser.SourcePosition pos() {
        return new Parser.SourcePosition(0, 0);
    }

    @Override
    public void setPosition(Parser.SourcePosition position) {
    }
}

