/* Copyright (c) 2017, Jesper Öqvist
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 * this list of conditions and the following disclaimer in the documentation
 * and/or other materials provided with the distribution.
 *
 * 3. Neither the name of the copyright holder nor the names of its
 * contributors may be used to endorse or promote products derived from this
 * software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */
package org.extendj.neobeaver;
import java.io.IOException;
import java.util.Stack;

public class Parser {

  /** Interface implemented by scanners that this parser can use. */
  public interface TokenScanner {
    Symbol nextToken() throws IOException;
  }

  public static class SourcePosition {
    int line, column;

    public SourcePosition(int line, int column) {
      this.line = line;
      this.column = column;
    }

    @Override
    public String toString() {
      return "" + line + ":" + column;
    }
  }

  public interface Symbol {
    int getId();
    SourcePosition getPosition();
  }

  public static class Nonterminal implements Symbol {
    public final String name;
    public final Symbol[] children;

    public Nonterminal(String name, Symbol... children) {
      this.name = name;
      this.children = children;
    }

    void dump(StringBuilder result, String prefix) {
      result.append(name).append(":");
      if (children.length > 1) {
        prefix += "  ";
      }
      for (Symbol child : children) {
        if (children.length > 1) {
          result.append("\n").append(prefix);
        } else {
          result.append(" ");
        }
        if (child instanceof Nonterminal) {
          ((Nonterminal) child).dump(result, prefix);
        } else if (child instanceof Token) { // Avoid empty optional.
          result.append(child.toString());
        }
      }
    }

    @Override public String toString() {
      StringBuilder result = new StringBuilder();
      dump(result, "");
      return result.toString();
    }

    @Override
    public int getId() {
      return -1;
    }

    @Override
    public SourcePosition getPosition() {
      for (Symbol child : children) {
        SourcePosition pos = child.getPosition();
        if (pos != null) {
          return pos;
        }
      }
      return null;
    }
  }

  public static class EmptyOpt implements Symbol {
    @Override
    public int getId() {
      return -1;
    }

    @Override
    public SourcePosition getPosition() {
      return null;
    }
  }

  public static class Token implements Symbol {
    public final String literal;
    public final int id;
    public final SourcePosition position;

    public Token(int id, String literal, SourcePosition pos) {
      this.literal = literal;
      this.id = id;
      this.position = pos;
    }

    @Override
    public String toString() {
      return literal;
    }

    @Override
    public int getId() {
      return id;
    }

    @Override
    public SourcePosition getPosition() {
      return position;
    }
  }
  public interface Tokens {
    int EMBED = 0;
    int EOF = 1;
    int QUESTION = 2;
    int COMMA = 3;
    int PLUS = 4;
    int ID = 5;
    int CLASS = 6;
    int PACKAGE = 7;
    int STRING = 8;
    int TYPEOF = 9;
    int RIGHT = 10;
    int COLONEQ = 11;
    int CODE_END = 12;
    int TERMINALS = 13;
    int JAVA_CODE = 14;
    int DOT = 15;
    int SEMICOLON = 16;
    int OR = 17;
    int HEADER = 18;
    int ASTERISK = 19;
    int GOAL = 20;
    int CODE_START = 21;
    int NONASSOC = 22;
    int LEFT = 23;
    int EQ = 24;
    int AT = 25;
  }

  void syntaxError(Symbol sym) {
    throw new Error(String.format("syntax error at token \"%s\" at %s", sym, sym.getPosition()));
  }

  Symbol nextToken(TokenScanner in) throws IOException {
    return in.nextToken();
  }

  private static final boolean DEBUG = System.getProperty("debug", "").equalsIgnoreCase("true");

  public Symbol parse(TokenScanner in) throws IOException {
    Stack<Integer> stateStack = new Stack<Integer>();
    Stack<Symbol> stack = new Stack<Symbol>();
    int state = 1;
    Symbol next = nextToken(in);
    while (state != -1) {
      if (state == 0) throw new Error("parse error");
      if (DEBUG) {
        System.out.print("state:");
        for (int st : stateStack) {
          System.out.print(" " + st);
        }
        System.out.println(" " + state);
      }
      switch (state) {
        case 1:
          if (DEBUG) System.out.format("[%s] ", next);
          switch (next.getId()) {
            case 0: {
              stateStack.push(state);
              stack.push(next);
              state = 2;
              next = nextToken(in);
              break;
            }
            case 1: {
              syntaxError(next);
            }
            case 2: {
              syntaxError(next);
            }
            case 3: {
              syntaxError(next);
            }
            case 4: {
              syntaxError(next);
            }
            case 5: {
              stateStack.push(state);
              stack.push(next);
              state = 4;
              next = nextToken(in);
              break;
            }
            case 6: {
              stateStack.push(state);
              stack.push(next);
              state = 5;
              next = nextToken(in);
              break;
            }
            case 7: {
              stateStack.push(state);
              stack.push(next);
              state = 6;
              next = nextToken(in);
              break;
            }
            case 8: {
              syntaxError(next);
            }
            case 9: {
              stateStack.push(state);
              stack.push(next);
              state = 7;
              next = nextToken(in);
              break;
            }
            case 10: {
              stateStack.push(state);
              stack.push(next);
              state = 8;
              next = nextToken(in);
              break;
            }
            case 11: {
              syntaxError(next);
            }
            case 12: {
              syntaxError(next);
            }
            case 13: {
              stateStack.push(state);
              stack.push(next);
              state = 9;
              next = nextToken(in);
              break;
            }
            case 14: {
              syntaxError(next);
            }
            case 15: {
              syntaxError(next);
            }
            case 16: {
              syntaxError(next);
            }
            case 17: {
              syntaxError(next);
            }
            case 18: {
              stateStack.push(state);
              stack.push(next);
              state = 10;
              next = nextToken(in);
              break;
            }
            case 19: {
              syntaxError(next);
            }
            case 20: {
              stateStack.push(state);
              stack.push(next);
              state = 11;
              next = nextToken(in);
              break;
            }
            case 21: {
              syntaxError(next);
            }
            case 22: {
              stateStack.push(state);
              stack.push(next);
              state = 12;
              next = nextToken(in);
              break;
            }
            case 23: {
              stateStack.push(state);
              stack.push(next);
              state = 14;
              next = nextToken(in);
              break;
            }
            case 24: {
              syntaxError(next);
            }
            case 25: {
              syntaxError(next);
            }
          }
          break;
        case 2:
          if (DEBUG) System.out.format("[%s] ", next);
          switch (next.getId()) {
            case 0: {
              syntaxError(next);
            }
            case 1: {
              syntaxError(next);
            }
            case 2: {
              syntaxError(next);
            }
            case 3: {
              syntaxError(next);
            }
            case 4: {
              syntaxError(next);
            }
            case 5: {
              syntaxError(next);
            }
            case 6: {
              syntaxError(next);
            }
            case 7: {
              syntaxError(next);
            }
            case 8: {
              syntaxError(next);
            }
            case 9: {
              syntaxError(next);
            }
            case 10: {
              syntaxError(next);
            }
            case 11: {
              syntaxError(next);
            }
            case 12: {
              syntaxError(next);
            }
            case 13: {
              syntaxError(next);
            }
            case 14: {
              syntaxError(next);
            }
            case 15: {
              syntaxError(next);
            }
            case 16: {
              syntaxError(next);
            }
            case 17: {
              syntaxError(next);
            }
            case 18: {
              syntaxError(next);
            }
            case 19: {
              syntaxError(next);
            }
            case 20: {
              syntaxError(next);
            }
            case 21: {
              stateStack.push(state);
              stack.push(next);
              state = 30;
              next = nextToken(in);
              break;
            }
            case 22: {
              syntaxError(next);
            }
            case 23: {
              syntaxError(next);
            }
            case 24: {
              syntaxError(next);
            }
            case 25: {
              syntaxError(next);
            }
          }
          break;
        case 3:
          if (DEBUG) System.out.format("[%s] ", next);
          switch (next.getId()) {
            case 0: {
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce0(sym1);
              stack.push(_result);
              state = gotos[stateStack.peek()][9];
              break;
            }
            case 1: {
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce0(sym1);
              stack.push(_result);
              state = gotos[stateStack.peek()][9];
              break;
            }
            case 2: {
              syntaxError(next);
            }
            case 3: {
              syntaxError(next);
            }
            case 4: {
              syntaxError(next);
            }
            case 5: {
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce0(sym1);
              stack.push(_result);
              state = gotos[stateStack.peek()][9];
              break;
            }
            case 6: {
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce0(sym1);
              stack.push(_result);
              state = gotos[stateStack.peek()][9];
              break;
            }
            case 7: {
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce0(sym1);
              stack.push(_result);
              state = gotos[stateStack.peek()][9];
              break;
            }
            case 8: {
              syntaxError(next);
            }
            case 9: {
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce0(sym1);
              stack.push(_result);
              state = gotos[stateStack.peek()][9];
              break;
            }
            case 10: {
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce0(sym1);
              stack.push(_result);
              state = gotos[stateStack.peek()][9];
              break;
            }
            case 11: {
              syntaxError(next);
            }
            case 12: {
              syntaxError(next);
            }
            case 13: {
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce0(sym1);
              stack.push(_result);
              state = gotos[stateStack.peek()][9];
              break;
            }
            case 14: {
              syntaxError(next);
            }
            case 15: {
              syntaxError(next);
            }
            case 16: {
              syntaxError(next);
            }
            case 17: {
              syntaxError(next);
            }
            case 18: {
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce0(sym1);
              stack.push(_result);
              state = gotos[stateStack.peek()][9];
              break;
            }
            case 19: {
              syntaxError(next);
            }
            case 20: {
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce0(sym1);
              stack.push(_result);
              state = gotos[stateStack.peek()][9];
              break;
            }
            case 21: {
              syntaxError(next);
            }
            case 22: {
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce0(sym1);
              stack.push(_result);
              state = gotos[stateStack.peek()][9];
              break;
            }
            case 23: {
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce0(sym1);
              stack.push(_result);
              state = gotos[stateStack.peek()][9];
              break;
            }
            case 24: {
              syntaxError(next);
            }
            case 25: {
              syntaxError(next);
            }
          }
          break;
        case 4:
          if (DEBUG) System.out.format("[%s] ", next);
          switch (next.getId()) {
            case 0: {
              syntaxError(next);
            }
            case 1: {
              syntaxError(next);
            }
            case 2: {
              syntaxError(next);
            }
            case 3: {
              syntaxError(next);
            }
            case 4: {
              syntaxError(next);
            }
            case 5: {
              stateStack.push(state);
              stack.push(next);
              state = 29;
              next = nextToken(in);
              break;
            }
            case 6: {
              syntaxError(next);
            }
            case 7: {
              syntaxError(next);
            }
            case 8: {
              syntaxError(next);
            }
            case 9: {
              syntaxError(next);
            }
            case 10: {
              syntaxError(next);
            }
            case 11: {
              stateStack.push(state);
              stack.push(next);
              state = 27;
              next = nextToken(in);
              break;
            }
            case 12: {
              syntaxError(next);
            }
            case 13: {
              syntaxError(next);
            }
            case 14: {
              syntaxError(next);
            }
            case 15: {
              syntaxError(next);
            }
            case 16: {
              syntaxError(next);
            }
            case 17: {
              syntaxError(next);
            }
            case 18: {
              syntaxError(next);
            }
            case 19: {
              syntaxError(next);
            }
            case 20: {
              syntaxError(next);
            }
            case 21: {
              syntaxError(next);
            }
            case 22: {
              syntaxError(next);
            }
            case 23: {
              syntaxError(next);
            }
            case 24: {
              stateStack.push(state);
              stack.push(next);
              state = 28;
              next = nextToken(in);
              break;
            }
            case 25: {
              syntaxError(next);
            }
          }
          break;
        case 5:
          if (DEBUG) System.out.format("[%s] ", next);
          switch (next.getId()) {
            case 0: {
              syntaxError(next);
            }
            case 1: {
              syntaxError(next);
            }
            case 2: {
              syntaxError(next);
            }
            case 3: {
              syntaxError(next);
            }
            case 4: {
              syntaxError(next);
            }
            case 5: {
              syntaxError(next);
            }
            case 6: {
              syntaxError(next);
            }
            case 7: {
              syntaxError(next);
            }
            case 8: {
              stateStack.push(state);
              stack.push(next);
              state = 26;
              next = nextToken(in);
              break;
            }
            case 9: {
              syntaxError(next);
            }
            case 10: {
              syntaxError(next);
            }
            case 11: {
              syntaxError(next);
            }
            case 12: {
              syntaxError(next);
            }
            case 13: {
              syntaxError(next);
            }
            case 14: {
              syntaxError(next);
            }
            case 15: {
              syntaxError(next);
            }
            case 16: {
              syntaxError(next);
            }
            case 17: {
              syntaxError(next);
            }
            case 18: {
              syntaxError(next);
            }
            case 19: {
              syntaxError(next);
            }
            case 20: {
              syntaxError(next);
            }
            case 21: {
              syntaxError(next);
            }
            case 22: {
              syntaxError(next);
            }
            case 23: {
              syntaxError(next);
            }
            case 24: {
              syntaxError(next);
            }
            case 25: {
              syntaxError(next);
            }
          }
          break;
        case 6:
          if (DEBUG) System.out.format("[%s] ", next);
          switch (next.getId()) {
            case 0: {
              syntaxError(next);
            }
            case 1: {
              syntaxError(next);
            }
            case 2: {
              syntaxError(next);
            }
            case 3: {
              syntaxError(next);
            }
            case 4: {
              syntaxError(next);
            }
            case 5: {
              syntaxError(next);
            }
            case 6: {
              syntaxError(next);
            }
            case 7: {
              syntaxError(next);
            }
            case 8: {
              stateStack.push(state);
              stack.push(next);
              state = 25;
              next = nextToken(in);
              break;
            }
            case 9: {
              syntaxError(next);
            }
            case 10: {
              syntaxError(next);
            }
            case 11: {
              syntaxError(next);
            }
            case 12: {
              syntaxError(next);
            }
            case 13: {
              syntaxError(next);
            }
            case 14: {
              syntaxError(next);
            }
            case 15: {
              syntaxError(next);
            }
            case 16: {
              syntaxError(next);
            }
            case 17: {
              syntaxError(next);
            }
            case 18: {
              syntaxError(next);
            }
            case 19: {
              syntaxError(next);
            }
            case 20: {
              syntaxError(next);
            }
            case 21: {
              syntaxError(next);
            }
            case 22: {
              syntaxError(next);
            }
            case 23: {
              syntaxError(next);
            }
            case 24: {
              syntaxError(next);
            }
            case 25: {
              syntaxError(next);
            }
          }
          break;
        case 7:
          if (DEBUG) System.out.format("[%s] ", next);
          switch (next.getId()) {
            case 0: {
              syntaxError(next);
            }
            case 1: {
              syntaxError(next);
            }
            case 2: {
              syntaxError(next);
            }
            case 3: {
              syntaxError(next);
            }
            case 4: {
              syntaxError(next);
            }
            case 5: {
              stateStack.push(state);
              stack.push(next);
              state = 24;
              next = nextToken(in);
              break;
            }
            case 6: {
              syntaxError(next);
            }
            case 7: {
              syntaxError(next);
            }
            case 8: {
              syntaxError(next);
            }
            case 9: {
              syntaxError(next);
            }
            case 10: {
              syntaxError(next);
            }
            case 11: {
              syntaxError(next);
            }
            case 12: {
              syntaxError(next);
            }
            case 13: {
              syntaxError(next);
            }
            case 14: {
              syntaxError(next);
            }
            case 15: {
              syntaxError(next);
            }
            case 16: {
              syntaxError(next);
            }
            case 17: {
              syntaxError(next);
            }
            case 18: {
              syntaxError(next);
            }
            case 19: {
              syntaxError(next);
            }
            case 20: {
              syntaxError(next);
            }
            case 21: {
              syntaxError(next);
            }
            case 22: {
              syntaxError(next);
            }
            case 23: {
              syntaxError(next);
            }
            case 24: {
              syntaxError(next);
            }
            case 25: {
              syntaxError(next);
            }
          }
          break;
        case 8:
          if (DEBUG) System.out.format("[%s] ", next);
          switch (next.getId()) {
            case 0: {
              syntaxError(next);
            }
            case 1: {
              syntaxError(next);
            }
            case 2: {
              syntaxError(next);
            }
            case 3: {
              syntaxError(next);
            }
            case 4: {
              syntaxError(next);
            }
            case 5: {
              stateStack.push(state);
              stack.push(next);
              state = 16;
              next = nextToken(in);
              break;
            }
            case 6: {
              syntaxError(next);
            }
            case 7: {
              syntaxError(next);
            }
            case 8: {
              syntaxError(next);
            }
            case 9: {
              syntaxError(next);
            }
            case 10: {
              syntaxError(next);
            }
            case 11: {
              syntaxError(next);
            }
            case 12: {
              syntaxError(next);
            }
            case 13: {
              syntaxError(next);
            }
            case 14: {
              syntaxError(next);
            }
            case 15: {
              syntaxError(next);
            }
            case 16: {
              syntaxError(next);
            }
            case 17: {
              syntaxError(next);
            }
            case 18: {
              syntaxError(next);
            }
            case 19: {
              syntaxError(next);
            }
            case 20: {
              syntaxError(next);
            }
            case 21: {
              syntaxError(next);
            }
            case 22: {
              syntaxError(next);
            }
            case 23: {
              syntaxError(next);
            }
            case 24: {
              syntaxError(next);
            }
            case 25: {
              syntaxError(next);
            }
          }
          break;
        case 9:
          if (DEBUG) System.out.format("[%s] ", next);
          switch (next.getId()) {
            case 0: {
              syntaxError(next);
            }
            case 1: {
              syntaxError(next);
            }
            case 2: {
              syntaxError(next);
            }
            case 3: {
              syntaxError(next);
            }
            case 4: {
              syntaxError(next);
            }
            case 5: {
              stateStack.push(state);
              stack.push(next);
              state = 16;
              next = nextToken(in);
              break;
            }
            case 6: {
              syntaxError(next);
            }
            case 7: {
              syntaxError(next);
            }
            case 8: {
              syntaxError(next);
            }
            case 9: {
              syntaxError(next);
            }
            case 10: {
              syntaxError(next);
            }
            case 11: {
              syntaxError(next);
            }
            case 12: {
              syntaxError(next);
            }
            case 13: {
              syntaxError(next);
            }
            case 14: {
              syntaxError(next);
            }
            case 15: {
              syntaxError(next);
            }
            case 16: {
              syntaxError(next);
            }
            case 17: {
              syntaxError(next);
            }
            case 18: {
              syntaxError(next);
            }
            case 19: {
              syntaxError(next);
            }
            case 20: {
              syntaxError(next);
            }
            case 21: {
              syntaxError(next);
            }
            case 22: {
              syntaxError(next);
            }
            case 23: {
              syntaxError(next);
            }
            case 24: {
              syntaxError(next);
            }
            case 25: {
              syntaxError(next);
            }
          }
          break;
        case 10:
          if (DEBUG) System.out.format("[%s] ", next);
          switch (next.getId()) {
            case 0: {
              syntaxError(next);
            }
            case 1: {
              syntaxError(next);
            }
            case 2: {
              syntaxError(next);
            }
            case 3: {
              syntaxError(next);
            }
            case 4: {
              syntaxError(next);
            }
            case 5: {
              syntaxError(next);
            }
            case 6: {
              syntaxError(next);
            }
            case 7: {
              syntaxError(next);
            }
            case 8: {
              syntaxError(next);
            }
            case 9: {
              syntaxError(next);
            }
            case 10: {
              syntaxError(next);
            }
            case 11: {
              syntaxError(next);
            }
            case 12: {
              syntaxError(next);
            }
            case 13: {
              syntaxError(next);
            }
            case 14: {
              syntaxError(next);
            }
            case 15: {
              syntaxError(next);
            }
            case 16: {
              syntaxError(next);
            }
            case 17: {
              syntaxError(next);
            }
            case 18: {
              syntaxError(next);
            }
            case 19: {
              syntaxError(next);
            }
            case 20: {
              syntaxError(next);
            }
            case 21: {
              stateStack.push(state);
              stack.push(next);
              state = 21;
              next = nextToken(in);
              break;
            }
            case 22: {
              syntaxError(next);
            }
            case 23: {
              syntaxError(next);
            }
            case 24: {
              syntaxError(next);
            }
            case 25: {
              syntaxError(next);
            }
          }
          break;
        case 11:
          if (DEBUG) System.out.format("[%s] ", next);
          switch (next.getId()) {
            case 0: {
              syntaxError(next);
            }
            case 1: {
              syntaxError(next);
            }
            case 2: {
              syntaxError(next);
            }
            case 3: {
              syntaxError(next);
            }
            case 4: {
              syntaxError(next);
            }
            case 5: {
              stateStack.push(state);
              stack.push(next);
              state = 20;
              next = nextToken(in);
              break;
            }
            case 6: {
              syntaxError(next);
            }
            case 7: {
              syntaxError(next);
            }
            case 8: {
              syntaxError(next);
            }
            case 9: {
              syntaxError(next);
            }
            case 10: {
              syntaxError(next);
            }
            case 11: {
              syntaxError(next);
            }
            case 12: {
              syntaxError(next);
            }
            case 13: {
              syntaxError(next);
            }
            case 14: {
              syntaxError(next);
            }
            case 15: {
              syntaxError(next);
            }
            case 16: {
              syntaxError(next);
            }
            case 17: {
              syntaxError(next);
            }
            case 18: {
              syntaxError(next);
            }
            case 19: {
              syntaxError(next);
            }
            case 20: {
              syntaxError(next);
            }
            case 21: {
              syntaxError(next);
            }
            case 22: {
              syntaxError(next);
            }
            case 23: {
              syntaxError(next);
            }
            case 24: {
              syntaxError(next);
            }
            case 25: {
              syntaxError(next);
            }
          }
          break;
        case 12:
          if (DEBUG) System.out.format("[%s] ", next);
          switch (next.getId()) {
            case 0: {
              syntaxError(next);
            }
            case 1: {
              syntaxError(next);
            }
            case 2: {
              syntaxError(next);
            }
            case 3: {
              syntaxError(next);
            }
            case 4: {
              syntaxError(next);
            }
            case 5: {
              stateStack.push(state);
              stack.push(next);
              state = 16;
              next = nextToken(in);
              break;
            }
            case 6: {
              syntaxError(next);
            }
            case 7: {
              syntaxError(next);
            }
            case 8: {
              syntaxError(next);
            }
            case 9: {
              syntaxError(next);
            }
            case 10: {
              syntaxError(next);
            }
            case 11: {
              syntaxError(next);
            }
            case 12: {
              syntaxError(next);
            }
            case 13: {
              syntaxError(next);
            }
            case 14: {
              syntaxError(next);
            }
            case 15: {
              syntaxError(next);
            }
            case 16: {
              syntaxError(next);
            }
            case 17: {
              syntaxError(next);
            }
            case 18: {
              syntaxError(next);
            }
            case 19: {
              syntaxError(next);
            }
            case 20: {
              syntaxError(next);
            }
            case 21: {
              syntaxError(next);
            }
            case 22: {
              syntaxError(next);
            }
            case 23: {
              syntaxError(next);
            }
            case 24: {
              syntaxError(next);
            }
            case 25: {
              syntaxError(next);
            }
          }
          break;
        case 13:
          if (DEBUG) System.out.format("[%s] ", next);
          switch (next.getId()) {
            case 0: {
              stateStack.push(state);
              stack.push(next);
              state = 2;
              next = nextToken(in);
              break;
            }
            case 1: {
              stateStack.push(state);
              stack.push(next);
              state = 18;
              next = nextToken(in);
              break;
            }
            case 2: {
              syntaxError(next);
            }
            case 3: {
              syntaxError(next);
            }
            case 4: {
              syntaxError(next);
            }
            case 5: {
              stateStack.push(state);
              stack.push(next);
              state = 4;
              next = nextToken(in);
              break;
            }
            case 6: {
              stateStack.push(state);
              stack.push(next);
              state = 5;
              next = nextToken(in);
              break;
            }
            case 7: {
              stateStack.push(state);
              stack.push(next);
              state = 6;
              next = nextToken(in);
              break;
            }
            case 8: {
              syntaxError(next);
            }
            case 9: {
              stateStack.push(state);
              stack.push(next);
              state = 7;
              next = nextToken(in);
              break;
            }
            case 10: {
              stateStack.push(state);
              stack.push(next);
              state = 8;
              next = nextToken(in);
              break;
            }
            case 11: {
              syntaxError(next);
            }
            case 12: {
              syntaxError(next);
            }
            case 13: {
              stateStack.push(state);
              stack.push(next);
              state = 9;
              next = nextToken(in);
              break;
            }
            case 14: {
              syntaxError(next);
            }
            case 15: {
              syntaxError(next);
            }
            case 16: {
              syntaxError(next);
            }
            case 17: {
              syntaxError(next);
            }
            case 18: {
              stateStack.push(state);
              stack.push(next);
              state = 10;
              next = nextToken(in);
              break;
            }
            case 19: {
              syntaxError(next);
            }
            case 20: {
              stateStack.push(state);
              stack.push(next);
              state = 11;
              next = nextToken(in);
              break;
            }
            case 21: {
              syntaxError(next);
            }
            case 22: {
              stateStack.push(state);
              stack.push(next);
              state = 12;
              next = nextToken(in);
              break;
            }
            case 23: {
              stateStack.push(state);
              stack.push(next);
              state = 14;
              next = nextToken(in);
              break;
            }
            case 24: {
              syntaxError(next);
            }
            case 25: {
              syntaxError(next);
            }
          }
          break;
        case 14:
          if (DEBUG) System.out.format("[%s] ", next);
          switch (next.getId()) {
            case 0: {
              syntaxError(next);
            }
            case 1: {
              syntaxError(next);
            }
            case 2: {
              syntaxError(next);
            }
            case 3: {
              syntaxError(next);
            }
            case 4: {
              syntaxError(next);
            }
            case 5: {
              stateStack.push(state);
              stack.push(next);
              state = 16;
              next = nextToken(in);
              break;
            }
            case 6: {
              syntaxError(next);
            }
            case 7: {
              syntaxError(next);
            }
            case 8: {
              syntaxError(next);
            }
            case 9: {
              syntaxError(next);
            }
            case 10: {
              syntaxError(next);
            }
            case 11: {
              syntaxError(next);
            }
            case 12: {
              syntaxError(next);
            }
            case 13: {
              syntaxError(next);
            }
            case 14: {
              syntaxError(next);
            }
            case 15: {
              syntaxError(next);
            }
            case 16: {
              syntaxError(next);
            }
            case 17: {
              syntaxError(next);
            }
            case 18: {
              syntaxError(next);
            }
            case 19: {
              syntaxError(next);
            }
            case 20: {
              syntaxError(next);
            }
            case 21: {
              syntaxError(next);
            }
            case 22: {
              syntaxError(next);
            }
            case 23: {
              syntaxError(next);
            }
            case 24: {
              syntaxError(next);
            }
            case 25: {
              syntaxError(next);
            }
          }
          break;
        case 15:
          if (DEBUG) System.out.format("[%s] ", next);
          switch (next.getId()) {
            case 0: {
              syntaxError(next);
            }
            case 1: {
              syntaxError(next);
            }
            case 2: {
              syntaxError(next);
            }
            case 3: {
              stateStack.push(state);
              stack.push(next);
              state = 46;
              next = nextToken(in);
              break;
            }
            case 4: {
              syntaxError(next);
            }
            case 5: {
              syntaxError(next);
            }
            case 6: {
              syntaxError(next);
            }
            case 7: {
              syntaxError(next);
            }
            case 8: {
              syntaxError(next);
            }
            case 9: {
              syntaxError(next);
            }
            case 10: {
              syntaxError(next);
            }
            case 11: {
              syntaxError(next);
            }
            case 12: {
              syntaxError(next);
            }
            case 13: {
              syntaxError(next);
            }
            case 14: {
              syntaxError(next);
            }
            case 15: {
              syntaxError(next);
            }
            case 16: {
              stateStack.push(state);
              stack.push(next);
              state = 52;
              next = nextToken(in);
              break;
            }
            case 17: {
              syntaxError(next);
            }
            case 18: {
              syntaxError(next);
            }
            case 19: {
              syntaxError(next);
            }
            case 20: {
              syntaxError(next);
            }
            case 21: {
              syntaxError(next);
            }
            case 22: {
              syntaxError(next);
            }
            case 23: {
              syntaxError(next);
            }
            case 24: {
              syntaxError(next);
            }
            case 25: {
              syntaxError(next);
            }
          }
          break;
        case 16:
          if (DEBUG) System.out.format("[%s] ", next);
          switch (next.getId()) {
            case 0: {
              syntaxError(next);
            }
            case 1: {
              syntaxError(next);
            }
            case 2: {
              syntaxError(next);
            }
            case 3: {
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce1(sym1);
              stack.push(_result);
              state = gotos[stateStack.peek()][1];
              break;
            }
            case 4: {
              syntaxError(next);
            }
            case 5: {
              syntaxError(next);
            }
            case 6: {
              syntaxError(next);
            }
            case 7: {
              syntaxError(next);
            }
            case 8: {
              syntaxError(next);
            }
            case 9: {
              syntaxError(next);
            }
            case 10: {
              syntaxError(next);
            }
            case 11: {
              syntaxError(next);
            }
            case 12: {
              syntaxError(next);
            }
            case 13: {
              syntaxError(next);
            }
            case 14: {
              syntaxError(next);
            }
            case 15: {
              syntaxError(next);
            }
            case 16: {
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce1(sym1);
              stack.push(_result);
              state = gotos[stateStack.peek()][1];
              break;
            }
            case 17: {
              syntaxError(next);
            }
            case 18: {
              syntaxError(next);
            }
            case 19: {
              syntaxError(next);
            }
            case 20: {
              syntaxError(next);
            }
            case 21: {
              syntaxError(next);
            }
            case 22: {
              syntaxError(next);
            }
            case 23: {
              syntaxError(next);
            }
            case 24: {
              syntaxError(next);
            }
            case 25: {
              syntaxError(next);
            }
          }
          break;
        case 17:
          if (DEBUG) System.out.format("[%s] ", next);
          switch (next.getId()) {
            case 0: {
              Symbol sym2 = (Symbol) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce2(sym1, sym2);
              stack.push(_result);
              stateStack.pop();
              state = gotos[stateStack.peek()][9];
              break;
            }
            case 1: {
              Symbol sym2 = (Symbol) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce2(sym1, sym2);
              stack.push(_result);
              stateStack.pop();
              state = gotos[stateStack.peek()][9];
              break;
            }
            case 2: {
              syntaxError(next);
            }
            case 3: {
              syntaxError(next);
            }
            case 4: {
              syntaxError(next);
            }
            case 5: {
              Symbol sym2 = (Symbol) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce2(sym1, sym2);
              stack.push(_result);
              stateStack.pop();
              state = gotos[stateStack.peek()][9];
              break;
            }
            case 6: {
              Symbol sym2 = (Symbol) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce2(sym1, sym2);
              stack.push(_result);
              stateStack.pop();
              state = gotos[stateStack.peek()][9];
              break;
            }
            case 7: {
              Symbol sym2 = (Symbol) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce2(sym1, sym2);
              stack.push(_result);
              stateStack.pop();
              state = gotos[stateStack.peek()][9];
              break;
            }
            case 8: {
              syntaxError(next);
            }
            case 9: {
              Symbol sym2 = (Symbol) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce2(sym1, sym2);
              stack.push(_result);
              stateStack.pop();
              state = gotos[stateStack.peek()][9];
              break;
            }
            case 10: {
              Symbol sym2 = (Symbol) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce2(sym1, sym2);
              stack.push(_result);
              stateStack.pop();
              state = gotos[stateStack.peek()][9];
              break;
            }
            case 11: {
              syntaxError(next);
            }
            case 12: {
              syntaxError(next);
            }
            case 13: {
              Symbol sym2 = (Symbol) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce2(sym1, sym2);
              stack.push(_result);
              stateStack.pop();
              state = gotos[stateStack.peek()][9];
              break;
            }
            case 14: {
              syntaxError(next);
            }
            case 15: {
              syntaxError(next);
            }
            case 16: {
              syntaxError(next);
            }
            case 17: {
              syntaxError(next);
            }
            case 18: {
              Symbol sym2 = (Symbol) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce2(sym1, sym2);
              stack.push(_result);
              stateStack.pop();
              state = gotos[stateStack.peek()][9];
              break;
            }
            case 19: {
              syntaxError(next);
            }
            case 20: {
              Symbol sym2 = (Symbol) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce2(sym1, sym2);
              stack.push(_result);
              stateStack.pop();
              state = gotos[stateStack.peek()][9];
              break;
            }
            case 21: {
              syntaxError(next);
            }
            case 22: {
              Symbol sym2 = (Symbol) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce2(sym1, sym2);
              stack.push(_result);
              stateStack.pop();
              state = gotos[stateStack.peek()][9];
              break;
            }
            case 23: {
              Symbol sym2 = (Symbol) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce2(sym1, sym2);
              stack.push(_result);
              stateStack.pop();
              state = gotos[stateStack.peek()][9];
              break;
            }
            case 24: {
              syntaxError(next);
            }
            case 25: {
              syntaxError(next);
            }
          }
          break;
        case 18:
          if (DEBUG) System.out.format("[%s] ", next);
          switch (next.getId()) {
            case 0: {
              syntaxError(next);
            }
            case 1: {
              Symbol sym2 = (Symbol) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce3(sym1, sym2);
              stack.push(_result);
              stateStack.pop();
              state = gotos[stateStack.peek()][0];
              break;
            }
            case 2: {
              syntaxError(next);
            }
            case 3: {
              syntaxError(next);
            }
            case 4: {
              syntaxError(next);
            }
            case 5: {
              syntaxError(next);
            }
            case 6: {
              syntaxError(next);
            }
            case 7: {
              syntaxError(next);
            }
            case 8: {
              syntaxError(next);
            }
            case 9: {
              syntaxError(next);
            }
            case 10: {
              syntaxError(next);
            }
            case 11: {
              syntaxError(next);
            }
            case 12: {
              syntaxError(next);
            }
            case 13: {
              syntaxError(next);
            }
            case 14: {
              syntaxError(next);
            }
            case 15: {
              syntaxError(next);
            }
            case 16: {
              syntaxError(next);
            }
            case 17: {
              syntaxError(next);
            }
            case 18: {
              syntaxError(next);
            }
            case 19: {
              syntaxError(next);
            }
            case 20: {
              syntaxError(next);
            }
            case 21: {
              syntaxError(next);
            }
            case 22: {
              syntaxError(next);
            }
            case 23: {
              syntaxError(next);
            }
            case 24: {
              syntaxError(next);
            }
            case 25: {
              syntaxError(next);
            }
          }
          break;
        case 19:
          if (DEBUG) System.out.format("[%s] ", next);
          switch (next.getId()) {
            case 0: {
              syntaxError(next);
            }
            case 1: {
              syntaxError(next);
            }
            case 2: {
              syntaxError(next);
            }
            case 3: {
              stateStack.push(state);
              stack.push(next);
              state = 46;
              next = nextToken(in);
              break;
            }
            case 4: {
              syntaxError(next);
            }
            case 5: {
              syntaxError(next);
            }
            case 6: {
              syntaxError(next);
            }
            case 7: {
              syntaxError(next);
            }
            case 8: {
              syntaxError(next);
            }
            case 9: {
              syntaxError(next);
            }
            case 10: {
              syntaxError(next);
            }
            case 11: {
              syntaxError(next);
            }
            case 12: {
              syntaxError(next);
            }
            case 13: {
              syntaxError(next);
            }
            case 14: {
              syntaxError(next);
            }
            case 15: {
              syntaxError(next);
            }
            case 16: {
              stateStack.push(state);
              stack.push(next);
              state = 51;
              next = nextToken(in);
              break;
            }
            case 17: {
              syntaxError(next);
            }
            case 18: {
              syntaxError(next);
            }
            case 19: {
              syntaxError(next);
            }
            case 20: {
              syntaxError(next);
            }
            case 21: {
              syntaxError(next);
            }
            case 22: {
              syntaxError(next);
            }
            case 23: {
              syntaxError(next);
            }
            case 24: {
              syntaxError(next);
            }
            case 25: {
              syntaxError(next);
            }
          }
          break;
        case 20:
          if (DEBUG) System.out.format("[%s] ", next);
          switch (next.getId()) {
            case 0: {
              syntaxError(next);
            }
            case 1: {
              syntaxError(next);
            }
            case 2: {
              syntaxError(next);
            }
            case 3: {
              syntaxError(next);
            }
            case 4: {
              syntaxError(next);
            }
            case 5: {
              syntaxError(next);
            }
            case 6: {
              syntaxError(next);
            }
            case 7: {
              syntaxError(next);
            }
            case 8: {
              syntaxError(next);
            }
            case 9: {
              syntaxError(next);
            }
            case 10: {
              syntaxError(next);
            }
            case 11: {
              syntaxError(next);
            }
            case 12: {
              syntaxError(next);
            }
            case 13: {
              syntaxError(next);
            }
            case 14: {
              syntaxError(next);
            }
            case 15: {
              syntaxError(next);
            }
            case 16: {
              stateStack.push(state);
              stack.push(next);
              state = 50;
              next = nextToken(in);
              break;
            }
            case 17: {
              syntaxError(next);
            }
            case 18: {
              syntaxError(next);
            }
            case 19: {
              syntaxError(next);
            }
            case 20: {
              syntaxError(next);
            }
            case 21: {
              syntaxError(next);
            }
            case 22: {
              syntaxError(next);
            }
            case 23: {
              syntaxError(next);
            }
            case 24: {
              syntaxError(next);
            }
            case 25: {
              syntaxError(next);
            }
          }
          break;
        case 21:
          if (DEBUG) System.out.format("[%s] ", next);
          switch (next.getId()) {
            case 0: {
              syntaxError(next);
            }
            case 1: {
              syntaxError(next);
            }
            case 2: {
              syntaxError(next);
            }
            case 3: {
              syntaxError(next);
            }
            case 4: {
              syntaxError(next);
            }
            case 5: {
              syntaxError(next);
            }
            case 6: {
              syntaxError(next);
            }
            case 7: {
              syntaxError(next);
            }
            case 8: {
              syntaxError(next);
            }
            case 9: {
              syntaxError(next);
            }
            case 10: {
              syntaxError(next);
            }
            case 11: {
              syntaxError(next);
            }
            case 12: {
              syntaxError(next);
            }
            case 13: {
              syntaxError(next);
            }
            case 14: {
              stateStack.push(state);
              stack.push(next);
              state = 49;
              next = nextToken(in);
              break;
            }
            case 15: {
              syntaxError(next);
            }
            case 16: {
              syntaxError(next);
            }
            case 17: {
              syntaxError(next);
            }
            case 18: {
              syntaxError(next);
            }
            case 19: {
              syntaxError(next);
            }
            case 20: {
              syntaxError(next);
            }
            case 21: {
              syntaxError(next);
            }
            case 22: {
              syntaxError(next);
            }
            case 23: {
              syntaxError(next);
            }
            case 24: {
              syntaxError(next);
            }
            case 25: {
              syntaxError(next);
            }
          }
          break;
        case 22:
          if (DEBUG) System.out.format("[%s] ", next);
          switch (next.getId()) {
            case 0: {
              syntaxError(next);
            }
            case 1: {
              syntaxError(next);
            }
            case 2: {
              syntaxError(next);
            }
            case 3: {
              stateStack.push(state);
              stack.push(next);
              state = 46;
              next = nextToken(in);
              break;
            }
            case 4: {
              syntaxError(next);
            }
            case 5: {
              syntaxError(next);
            }
            case 6: {
              syntaxError(next);
            }
            case 7: {
              syntaxError(next);
            }
            case 8: {
              syntaxError(next);
            }
            case 9: {
              syntaxError(next);
            }
            case 10: {
              syntaxError(next);
            }
            case 11: {
              syntaxError(next);
            }
            case 12: {
              syntaxError(next);
            }
            case 13: {
              syntaxError(next);
            }
            case 14: {
              syntaxError(next);
            }
            case 15: {
              syntaxError(next);
            }
            case 16: {
              stateStack.push(state);
              stack.push(next);
              state = 48;
              next = nextToken(in);
              break;
            }
            case 17: {
              syntaxError(next);
            }
            case 18: {
              syntaxError(next);
            }
            case 19: {
              syntaxError(next);
            }
            case 20: {
              syntaxError(next);
            }
            case 21: {
              syntaxError(next);
            }
            case 22: {
              syntaxError(next);
            }
            case 23: {
              syntaxError(next);
            }
            case 24: {
              syntaxError(next);
            }
            case 25: {
              syntaxError(next);
            }
          }
          break;
        case 23:
          if (DEBUG) System.out.format("[%s] ", next);
          switch (next.getId()) {
            case 0: {
              syntaxError(next);
            }
            case 1: {
              syntaxError(next);
            }
            case 2: {
              syntaxError(next);
            }
            case 3: {
              stateStack.push(state);
              stack.push(next);
              state = 46;
              next = nextToken(in);
              break;
            }
            case 4: {
              syntaxError(next);
            }
            case 5: {
              syntaxError(next);
            }
            case 6: {
              syntaxError(next);
            }
            case 7: {
              syntaxError(next);
            }
            case 8: {
              syntaxError(next);
            }
            case 9: {
              syntaxError(next);
            }
            case 10: {
              syntaxError(next);
            }
            case 11: {
              syntaxError(next);
            }
            case 12: {
              syntaxError(next);
            }
            case 13: {
              syntaxError(next);
            }
            case 14: {
              syntaxError(next);
            }
            case 15: {
              syntaxError(next);
            }
            case 16: {
              stateStack.push(state);
              stack.push(next);
              state = 47;
              next = nextToken(in);
              break;
            }
            case 17: {
              syntaxError(next);
            }
            case 18: {
              syntaxError(next);
            }
            case 19: {
              syntaxError(next);
            }
            case 20: {
              syntaxError(next);
            }
            case 21: {
              syntaxError(next);
            }
            case 22: {
              syntaxError(next);
            }
            case 23: {
              syntaxError(next);
            }
            case 24: {
              syntaxError(next);
            }
            case 25: {
              syntaxError(next);
            }
          }
          break;
        case 24:
          if (DEBUG) System.out.format("[%s] ", next);
          switch (next.getId()) {
            case 0: {
              syntaxError(next);
            }
            case 1: {
              syntaxError(next);
            }
            case 2: {
              syntaxError(next);
            }
            case 3: {
              syntaxError(next);
            }
            case 4: {
              syntaxError(next);
            }
            case 5: {
              syntaxError(next);
            }
            case 6: {
              syntaxError(next);
            }
            case 7: {
              syntaxError(next);
            }
            case 8: {
              syntaxError(next);
            }
            case 9: {
              syntaxError(next);
            }
            case 10: {
              syntaxError(next);
            }
            case 11: {
              syntaxError(next);
            }
            case 12: {
              syntaxError(next);
            }
            case 13: {
              syntaxError(next);
            }
            case 14: {
              syntaxError(next);
            }
            case 15: {
              syntaxError(next);
            }
            case 16: {
              syntaxError(next);
            }
            case 17: {
              syntaxError(next);
            }
            case 18: {
              syntaxError(next);
            }
            case 19: {
              syntaxError(next);
            }
            case 20: {
              syntaxError(next);
            }
            case 21: {
              syntaxError(next);
            }
            case 22: {
              syntaxError(next);
            }
            case 23: {
              syntaxError(next);
            }
            case 24: {
              stateStack.push(state);
              stack.push(next);
              state = 45;
              next = nextToken(in);
              break;
            }
            case 25: {
              syntaxError(next);
            }
          }
          break;
        case 25:
          if (DEBUG) System.out.format("[%s] ", next);
          switch (next.getId()) {
            case 0: {
              syntaxError(next);
            }
            case 1: {
              syntaxError(next);
            }
            case 2: {
              syntaxError(next);
            }
            case 3: {
              syntaxError(next);
            }
            case 4: {
              syntaxError(next);
            }
            case 5: {
              syntaxError(next);
            }
            case 6: {
              syntaxError(next);
            }
            case 7: {
              syntaxError(next);
            }
            case 8: {
              syntaxError(next);
            }
            case 9: {
              syntaxError(next);
            }
            case 10: {
              syntaxError(next);
            }
            case 11: {
              syntaxError(next);
            }
            case 12: {
              syntaxError(next);
            }
            case 13: {
              syntaxError(next);
            }
            case 14: {
              syntaxError(next);
            }
            case 15: {
              syntaxError(next);
            }
            case 16: {
              stateStack.push(state);
              stack.push(next);
              state = 44;
              next = nextToken(in);
              break;
            }
            case 17: {
              syntaxError(next);
            }
            case 18: {
              syntaxError(next);
            }
            case 19: {
              syntaxError(next);
            }
            case 20: {
              syntaxError(next);
            }
            case 21: {
              syntaxError(next);
            }
            case 22: {
              syntaxError(next);
            }
            case 23: {
              syntaxError(next);
            }
            case 24: {
              syntaxError(next);
            }
            case 25: {
              syntaxError(next);
            }
          }
          break;
        case 26:
          if (DEBUG) System.out.format("[%s] ", next);
          switch (next.getId()) {
            case 0: {
              syntaxError(next);
            }
            case 1: {
              syntaxError(next);
            }
            case 2: {
              syntaxError(next);
            }
            case 3: {
              syntaxError(next);
            }
            case 4: {
              syntaxError(next);
            }
            case 5: {
              syntaxError(next);
            }
            case 6: {
              syntaxError(next);
            }
            case 7: {
              syntaxError(next);
            }
            case 8: {
              syntaxError(next);
            }
            case 9: {
              syntaxError(next);
            }
            case 10: {
              syntaxError(next);
            }
            case 11: {
              syntaxError(next);
            }
            case 12: {
              syntaxError(next);
            }
            case 13: {
              syntaxError(next);
            }
            case 14: {
              syntaxError(next);
            }
            case 15: {
              syntaxError(next);
            }
            case 16: {
              stateStack.push(state);
              stack.push(next);
              state = 43;
              next = nextToken(in);
              break;
            }
            case 17: {
              syntaxError(next);
            }
            case 18: {
              syntaxError(next);
            }
            case 19: {
              syntaxError(next);
            }
            case 20: {
              syntaxError(next);
            }
            case 21: {
              syntaxError(next);
            }
            case 22: {
              syntaxError(next);
            }
            case 23: {
              syntaxError(next);
            }
            case 24: {
              syntaxError(next);
            }
            case 25: {
              syntaxError(next);
            }
          }
          break;
        case 27:
          if (DEBUG) System.out.format("[%s] ", next);
          switch (next.getId()) {
            case 0: {
              syntaxError(next);
            }
            case 1: {
              syntaxError(next);
            }
            case 2: {
              syntaxError(next);
            }
            case 3: {
              syntaxError(next);
            }
            case 4: {
              syntaxError(next);
            }
            case 5: {
              stateStack.push(state);
              stack.push(next);
              state = 34;
              next = nextToken(in);
              break;
            }
            case 6: {
              syntaxError(next);
            }
            case 7: {
              syntaxError(next);
            }
            case 8: {
              syntaxError(next);
            }
            case 9: {
              syntaxError(next);
            }
            case 10: {
              syntaxError(next);
            }
            case 11: {
              syntaxError(next);
            }
            case 12: {
              syntaxError(next);
            }
            case 13: {
              syntaxError(next);
            }
            case 14: {
              syntaxError(next);
            }
            case 15: {
              syntaxError(next);
            }
            case 16: {
              Symbol _result = reduce4();
              stack.push(_result);
              stateStack.push(state);
              state = gotos[stateStack.peek()][6];
              break;
            }
            case 17: {
              Symbol _result = reduce4();
              stack.push(_result);
              stateStack.push(state);
              state = gotos[stateStack.peek()][6];
              break;
            }
            case 18: {
              syntaxError(next);
            }
            case 19: {
              syntaxError(next);
            }
            case 20: {
              syntaxError(next);
            }
            case 21: {
              Symbol _result = reduce4();
              stack.push(_result);
              stateStack.push(state);
              state = gotos[stateStack.peek()][6];
              break;
            }
            case 22: {
              syntaxError(next);
            }
            case 23: {
              syntaxError(next);
            }
            case 24: {
              syntaxError(next);
            }
            case 25: {
              stateStack.push(state);
              stack.push(next);
              state = 41;
              next = nextToken(in);
              break;
            }
          }
          break;
        case 28:
          if (DEBUG) System.out.format("[%s] ", next);
          switch (next.getId()) {
            case 0: {
              syntaxError(next);
            }
            case 1: {
              syntaxError(next);
            }
            case 2: {
              syntaxError(next);
            }
            case 3: {
              syntaxError(next);
            }
            case 4: {
              syntaxError(next);
            }
            case 5: {
              stateStack.push(state);
              stack.push(next);
              state = 34;
              next = nextToken(in);
              break;
            }
            case 6: {
              syntaxError(next);
            }
            case 7: {
              syntaxError(next);
            }
            case 8: {
              syntaxError(next);
            }
            case 9: {
              syntaxError(next);
            }
            case 10: {
              syntaxError(next);
            }
            case 11: {
              syntaxError(next);
            }
            case 12: {
              syntaxError(next);
            }
            case 13: {
              syntaxError(next);
            }
            case 14: {
              syntaxError(next);
            }
            case 15: {
              syntaxError(next);
            }
            case 16: {
              Symbol _result = reduce4();
              stack.push(_result);
              stateStack.push(state);
              state = gotos[stateStack.peek()][6];
              break;
            }
            case 17: {
              Symbol _result = reduce4();
              stack.push(_result);
              stateStack.push(state);
              state = gotos[stateStack.peek()][6];
              break;
            }
            case 18: {
              syntaxError(next);
            }
            case 19: {
              syntaxError(next);
            }
            case 20: {
              syntaxError(next);
            }
            case 21: {
              Symbol _result = reduce4();
              stack.push(_result);
              stateStack.push(state);
              state = gotos[stateStack.peek()][6];
              break;
            }
            case 22: {
              syntaxError(next);
            }
            case 23: {
              syntaxError(next);
            }
            case 24: {
              syntaxError(next);
            }
            case 25: {
              stateStack.push(state);
              stack.push(next);
              state = 41;
              next = nextToken(in);
              break;
            }
          }
          break;
        case 29:
          if (DEBUG) System.out.format("[%s] ", next);
          switch (next.getId()) {
            case 0: {
              syntaxError(next);
            }
            case 1: {
              syntaxError(next);
            }
            case 2: {
              syntaxError(next);
            }
            case 3: {
              syntaxError(next);
            }
            case 4: {
              syntaxError(next);
            }
            case 5: {
              syntaxError(next);
            }
            case 6: {
              syntaxError(next);
            }
            case 7: {
              syntaxError(next);
            }
            case 8: {
              syntaxError(next);
            }
            case 9: {
              syntaxError(next);
            }
            case 10: {
              syntaxError(next);
            }
            case 11: {
              stateStack.push(state);
              stack.push(next);
              state = 32;
              next = nextToken(in);
              break;
            }
            case 12: {
              syntaxError(next);
            }
            case 13: {
              syntaxError(next);
            }
            case 14: {
              syntaxError(next);
            }
            case 15: {
              syntaxError(next);
            }
            case 16: {
              syntaxError(next);
            }
            case 17: {
              syntaxError(next);
            }
            case 18: {
              syntaxError(next);
            }
            case 19: {
              syntaxError(next);
            }
            case 20: {
              syntaxError(next);
            }
            case 21: {
              syntaxError(next);
            }
            case 22: {
              syntaxError(next);
            }
            case 23: {
              syntaxError(next);
            }
            case 24: {
              stateStack.push(state);
              stack.push(next);
              state = 33;
              next = nextToken(in);
              break;
            }
            case 25: {
              syntaxError(next);
            }
          }
          break;
        case 30:
          if (DEBUG) System.out.format("[%s] ", next);
          switch (next.getId()) {
            case 0: {
              syntaxError(next);
            }
            case 1: {
              syntaxError(next);
            }
            case 2: {
              syntaxError(next);
            }
            case 3: {
              syntaxError(next);
            }
            case 4: {
              syntaxError(next);
            }
            case 5: {
              syntaxError(next);
            }
            case 6: {
              syntaxError(next);
            }
            case 7: {
              syntaxError(next);
            }
            case 8: {
              syntaxError(next);
            }
            case 9: {
              syntaxError(next);
            }
            case 10: {
              syntaxError(next);
            }
            case 11: {
              syntaxError(next);
            }
            case 12: {
              syntaxError(next);
            }
            case 13: {
              syntaxError(next);
            }
            case 14: {
              stateStack.push(state);
              stack.push(next);
              state = 31;
              next = nextToken(in);
              break;
            }
            case 15: {
              syntaxError(next);
            }
            case 16: {
              syntaxError(next);
            }
            case 17: {
              syntaxError(next);
            }
            case 18: {
              syntaxError(next);
            }
            case 19: {
              syntaxError(next);
            }
            case 20: {
              syntaxError(next);
            }
            case 21: {
              syntaxError(next);
            }
            case 22: {
              syntaxError(next);
            }
            case 23: {
              syntaxError(next);
            }
            case 24: {
              syntaxError(next);
            }
            case 25: {
              syntaxError(next);
            }
          }
          break;
        case 31:
          if (DEBUG) System.out.format("[%s] ", next);
          switch (next.getId()) {
            case 0: {
              syntaxError(next);
            }
            case 1: {
              syntaxError(next);
            }
            case 2: {
              syntaxError(next);
            }
            case 3: {
              syntaxError(next);
            }
            case 4: {
              syntaxError(next);
            }
            case 5: {
              syntaxError(next);
            }
            case 6: {
              syntaxError(next);
            }
            case 7: {
              syntaxError(next);
            }
            case 8: {
              syntaxError(next);
            }
            case 9: {
              syntaxError(next);
            }
            case 10: {
              syntaxError(next);
            }
            case 11: {
              syntaxError(next);
            }
            case 12: {
              stateStack.push(state);
              stack.push(next);
              state = 70;
              next = nextToken(in);
              break;
            }
            case 13: {
              syntaxError(next);
            }
            case 14: {
              syntaxError(next);
            }
            case 15: {
              syntaxError(next);
            }
            case 16: {
              syntaxError(next);
            }
            case 17: {
              syntaxError(next);
            }
            case 18: {
              syntaxError(next);
            }
            case 19: {
              syntaxError(next);
            }
            case 20: {
              syntaxError(next);
            }
            case 21: {
              syntaxError(next);
            }
            case 22: {
              syntaxError(next);
            }
            case 23: {
              syntaxError(next);
            }
            case 24: {
              syntaxError(next);
            }
            case 25: {
              syntaxError(next);
            }
          }
          break;
        case 32:
          if (DEBUG) System.out.format("[%s] ", next);
          switch (next.getId()) {
            case 0: {
              syntaxError(next);
            }
            case 1: {
              syntaxError(next);
            }
            case 2: {
              syntaxError(next);
            }
            case 3: {
              syntaxError(next);
            }
            case 4: {
              syntaxError(next);
            }
            case 5: {
              stateStack.push(state);
              stack.push(next);
              state = 34;
              next = nextToken(in);
              break;
            }
            case 6: {
              syntaxError(next);
            }
            case 7: {
              syntaxError(next);
            }
            case 8: {
              syntaxError(next);
            }
            case 9: {
              syntaxError(next);
            }
            case 10: {
              syntaxError(next);
            }
            case 11: {
              syntaxError(next);
            }
            case 12: {
              syntaxError(next);
            }
            case 13: {
              syntaxError(next);
            }
            case 14: {
              syntaxError(next);
            }
            case 15: {
              syntaxError(next);
            }
            case 16: {
              Symbol _result = reduce4();
              stack.push(_result);
              stateStack.push(state);
              state = gotos[stateStack.peek()][6];
              break;
            }
            case 17: {
              Symbol _result = reduce4();
              stack.push(_result);
              stateStack.push(state);
              state = gotos[stateStack.peek()][6];
              break;
            }
            case 18: {
              syntaxError(next);
            }
            case 19: {
              syntaxError(next);
            }
            case 20: {
              syntaxError(next);
            }
            case 21: {
              Symbol _result = reduce4();
              stack.push(_result);
              stateStack.push(state);
              state = gotos[stateStack.peek()][6];
              break;
            }
            case 22: {
              syntaxError(next);
            }
            case 23: {
              syntaxError(next);
            }
            case 24: {
              syntaxError(next);
            }
            case 25: {
              stateStack.push(state);
              stack.push(next);
              state = 41;
              next = nextToken(in);
              break;
            }
          }
          break;
        case 33:
          if (DEBUG) System.out.format("[%s] ", next);
          switch (next.getId()) {
            case 0: {
              syntaxError(next);
            }
            case 1: {
              syntaxError(next);
            }
            case 2: {
              syntaxError(next);
            }
            case 3: {
              syntaxError(next);
            }
            case 4: {
              syntaxError(next);
            }
            case 5: {
              stateStack.push(state);
              stack.push(next);
              state = 34;
              next = nextToken(in);
              break;
            }
            case 6: {
              syntaxError(next);
            }
            case 7: {
              syntaxError(next);
            }
            case 8: {
              syntaxError(next);
            }
            case 9: {
              syntaxError(next);
            }
            case 10: {
              syntaxError(next);
            }
            case 11: {
              syntaxError(next);
            }
            case 12: {
              syntaxError(next);
            }
            case 13: {
              syntaxError(next);
            }
            case 14: {
              syntaxError(next);
            }
            case 15: {
              syntaxError(next);
            }
            case 16: {
              Symbol _result = reduce4();
              stack.push(_result);
              stateStack.push(state);
              state = gotos[stateStack.peek()][6];
              break;
            }
            case 17: {
              Symbol _result = reduce4();
              stack.push(_result);
              stateStack.push(state);
              state = gotos[stateStack.peek()][6];
              break;
            }
            case 18: {
              syntaxError(next);
            }
            case 19: {
              syntaxError(next);
            }
            case 20: {
              syntaxError(next);
            }
            case 21: {
              Symbol _result = reduce4();
              stack.push(_result);
              stateStack.push(state);
              state = gotos[stateStack.peek()][6];
              break;
            }
            case 22: {
              syntaxError(next);
            }
            case 23: {
              syntaxError(next);
            }
            case 24: {
              syntaxError(next);
            }
            case 25: {
              stateStack.push(state);
              stack.push(next);
              state = 41;
              next = nextToken(in);
              break;
            }
          }
          break;
        case 34:
          if (DEBUG) System.out.format("[%s] ", next);
          switch (next.getId()) {
            case 0: {
              syntaxError(next);
            }
            case 1: {
              syntaxError(next);
            }
            case 2: {
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce5(sym1);
              stack.push(_result);
              state = gotos[stateStack.peek()][7];
              break;
            }
            case 3: {
              syntaxError(next);
            }
            case 4: {
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce5(sym1);
              stack.push(_result);
              state = gotos[stateStack.peek()][7];
              break;
            }
            case 5: {
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce5(sym1);
              stack.push(_result);
              state = gotos[stateStack.peek()][7];
              break;
            }
            case 6: {
              syntaxError(next);
            }
            case 7: {
              syntaxError(next);
            }
            case 8: {
              syntaxError(next);
            }
            case 9: {
              syntaxError(next);
            }
            case 10: {
              syntaxError(next);
            }
            case 11: {
              syntaxError(next);
            }
            case 12: {
              syntaxError(next);
            }
            case 13: {
              syntaxError(next);
            }
            case 14: {
              syntaxError(next);
            }
            case 15: {
              stateStack.push(state);
              stack.push(next);
              state = 67;
              next = nextToken(in);
              break;
            }
            case 16: {
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce5(sym1);
              stack.push(_result);
              state = gotos[stateStack.peek()][7];
              break;
            }
            case 17: {
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce5(sym1);
              stack.push(_result);
              state = gotos[stateStack.peek()][7];
              break;
            }
            case 18: {
              syntaxError(next);
            }
            case 19: {
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce5(sym1);
              stack.push(_result);
              state = gotos[stateStack.peek()][7];
              break;
            }
            case 20: {
              syntaxError(next);
            }
            case 21: {
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce5(sym1);
              stack.push(_result);
              state = gotos[stateStack.peek()][7];
              break;
            }
            case 22: {
              syntaxError(next);
            }
            case 23: {
              syntaxError(next);
            }
            case 24: {
              syntaxError(next);
            }
            case 25: {
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce5(sym1);
              stack.push(_result);
              state = gotos[stateStack.peek()][7];
              break;
            }
          }
          break;
        case 35:
          if (DEBUG) System.out.format("[%s] ", next);
          switch (next.getId()) {
            case 0: {
              syntaxError(next);
            }
            case 1: {
              syntaxError(next);
            }
            case 2: {
              syntaxError(next);
            }
            case 3: {
              syntaxError(next);
            }
            case 4: {
              syntaxError(next);
            }
            case 5: {
              syntaxError(next);
            }
            case 6: {
              syntaxError(next);
            }
            case 7: {
              syntaxError(next);
            }
            case 8: {
              syntaxError(next);
            }
            case 9: {
              syntaxError(next);
            }
            case 10: {
              syntaxError(next);
            }
            case 11: {
              syntaxError(next);
            }
            case 12: {
              syntaxError(next);
            }
            case 13: {
              syntaxError(next);
            }
            case 14: {
              syntaxError(next);
            }
            case 15: {
              syntaxError(next);
            }
            case 16: {
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce6(sym1);
              stack.push(_result);
              state = gotos[stateStack.peek()][8];
              break;
            }
            case 17: {
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce6(sym1);
              stack.push(_result);
              state = gotos[stateStack.peek()][8];
              break;
            }
            case 18: {
              syntaxError(next);
            }
            case 19: {
              syntaxError(next);
            }
            case 20: {
              syntaxError(next);
            }
            case 21: {
              syntaxError(next);
            }
            case 22: {
              syntaxError(next);
            }
            case 23: {
              syntaxError(next);
            }
            case 24: {
              syntaxError(next);
            }
            case 25: {
              syntaxError(next);
            }
          }
          break;
        case 36:
          if (DEBUG) System.out.format("[%s] ", next);
          switch (next.getId()) {
            case 0: {
              syntaxError(next);
            }
            case 1: {
              syntaxError(next);
            }
            case 2: {
              syntaxError(next);
            }
            case 3: {
              syntaxError(next);
            }
            case 4: {
              syntaxError(next);
            }
            case 5: {
              stateStack.push(state);
              stack.push(next);
              state = 34;
              next = nextToken(in);
              break;
            }
            case 6: {
              syntaxError(next);
            }
            case 7: {
              syntaxError(next);
            }
            case 8: {
              syntaxError(next);
            }
            case 9: {
              syntaxError(next);
            }
            case 10: {
              syntaxError(next);
            }
            case 11: {
              syntaxError(next);
            }
            case 12: {
              syntaxError(next);
            }
            case 13: {
              syntaxError(next);
            }
            case 14: {
              syntaxError(next);
            }
            case 15: {
              syntaxError(next);
            }
            case 16: {
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce7(sym1);
              stack.push(_result);
              state = gotos[stateStack.peek()][6];
              break;
            }
            case 17: {
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce7(sym1);
              stack.push(_result);
              state = gotos[stateStack.peek()][6];
              break;
            }
            case 18: {
              syntaxError(next);
            }
            case 19: {
              syntaxError(next);
            }
            case 20: {
              syntaxError(next);
            }
            case 21: {
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce7(sym1);
              stack.push(_result);
              state = gotos[stateStack.peek()][6];
              break;
            }
            case 22: {
              syntaxError(next);
            }
            case 23: {
              syntaxError(next);
            }
            case 24: {
              syntaxError(next);
            }
            case 25: {
              stateStack.push(state);
              stack.push(next);
              state = 41;
              next = nextToken(in);
              break;
            }
          }
          break;
        case 37:
          if (DEBUG) System.out.format("[%s] ", next);
          switch (next.getId()) {
            case 0: {
              syntaxError(next);
            }
            case 1: {
              syntaxError(next);
            }
            case 2: {
              syntaxError(next);
            }
            case 3: {
              syntaxError(next);
            }
            case 4: {
              syntaxError(next);
            }
            case 5: {
              syntaxError(next);
            }
            case 6: {
              syntaxError(next);
            }
            case 7: {
              syntaxError(next);
            }
            case 8: {
              syntaxError(next);
            }
            case 9: {
              syntaxError(next);
            }
            case 10: {
              syntaxError(next);
            }
            case 11: {
              syntaxError(next);
            }
            case 12: {
              syntaxError(next);
            }
            case 13: {
              syntaxError(next);
            }
            case 14: {
              syntaxError(next);
            }
            case 15: {
              syntaxError(next);
            }
            case 16: {
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce8(sym1);
              stack.push(_result);
              state = gotos[stateStack.peek()][4];
              break;
            }
            case 17: {
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce8(sym1);
              stack.push(_result);
              state = gotos[stateStack.peek()][4];
              break;
            }
            case 18: {
              syntaxError(next);
            }
            case 19: {
              syntaxError(next);
            }
            case 20: {
              syntaxError(next);
            }
            case 21: {
              stateStack.push(state);
              stack.push(next);
              state = 65;
              next = nextToken(in);
              break;
            }
            case 22: {
              syntaxError(next);
            }
            case 23: {
              syntaxError(next);
            }
            case 24: {
              syntaxError(next);
            }
            case 25: {
              syntaxError(next);
            }
          }
          break;
        case 38:
          if (DEBUG) System.out.format("[%s] ", next);
          switch (next.getId()) {
            case 0: {
              syntaxError(next);
            }
            case 1: {
              syntaxError(next);
            }
            case 2: {
              stateStack.push(state);
              stack.push(next);
              state = 62;
              next = nextToken(in);
              break;
            }
            case 3: {
              syntaxError(next);
            }
            case 4: {
              stateStack.push(state);
              stack.push(next);
              state = 63;
              next = nextToken(in);
              break;
            }
            case 5: {
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce9(sym1);
              stack.push(_result);
              state = gotos[stateStack.peek()][10];
              break;
            }
            case 6: {
              syntaxError(next);
            }
            case 7: {
              syntaxError(next);
            }
            case 8: {
              syntaxError(next);
            }
            case 9: {
              syntaxError(next);
            }
            case 10: {
              syntaxError(next);
            }
            case 11: {
              syntaxError(next);
            }
            case 12: {
              syntaxError(next);
            }
            case 13: {
              syntaxError(next);
            }
            case 14: {
              syntaxError(next);
            }
            case 15: {
              syntaxError(next);
            }
            case 16: {
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce9(sym1);
              stack.push(_result);
              state = gotos[stateStack.peek()][10];
              break;
            }
            case 17: {
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce9(sym1);
              stack.push(_result);
              state = gotos[stateStack.peek()][10];
              break;
            }
            case 18: {
              syntaxError(next);
            }
            case 19: {
              stateStack.push(state);
              stack.push(next);
              state = 61;
              next = nextToken(in);
              break;
            }
            case 20: {
              syntaxError(next);
            }
            case 21: {
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce9(sym1);
              stack.push(_result);
              state = gotos[stateStack.peek()][10];
              break;
            }
            case 22: {
              syntaxError(next);
            }
            case 23: {
              syntaxError(next);
            }
            case 24: {
              syntaxError(next);
            }
            case 25: {
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce9(sym1);
              stack.push(_result);
              state = gotos[stateStack.peek()][10];
              break;
            }
          }
          break;
        case 39:
          if (DEBUG) System.out.format("[%s] ", next);
          switch (next.getId()) {
            case 0: {
              syntaxError(next);
            }
            case 1: {
              syntaxError(next);
            }
            case 2: {
              syntaxError(next);
            }
            case 3: {
              syntaxError(next);
            }
            case 4: {
              syntaxError(next);
            }
            case 5: {
              syntaxError(next);
            }
            case 6: {
              syntaxError(next);
            }
            case 7: {
              syntaxError(next);
            }
            case 8: {
              syntaxError(next);
            }
            case 9: {
              syntaxError(next);
            }
            case 10: {
              syntaxError(next);
            }
            case 11: {
              syntaxError(next);
            }
            case 12: {
              syntaxError(next);
            }
            case 13: {
              syntaxError(next);
            }
            case 14: {
              syntaxError(next);
            }
            case 15: {
              syntaxError(next);
            }
            case 16: {
              stateStack.push(state);
              stack.push(next);
              state = 60;
              next = nextToken(in);
              break;
            }
            case 17: {
              stateStack.push(state);
              stack.push(next);
              state = 56;
              next = nextToken(in);
              break;
            }
            case 18: {
              syntaxError(next);
            }
            case 19: {
              syntaxError(next);
            }
            case 20: {
              syntaxError(next);
            }
            case 21: {
              syntaxError(next);
            }
            case 22: {
              syntaxError(next);
            }
            case 23: {
              syntaxError(next);
            }
            case 24: {
              syntaxError(next);
            }
            case 25: {
              syntaxError(next);
            }
          }
          break;
        case 40:
          if (DEBUG) System.out.format("[%s] ", next);
          switch (next.getId()) {
            case 0: {
              syntaxError(next);
            }
            case 1: {
              syntaxError(next);
            }
            case 2: {
              syntaxError(next);
            }
            case 3: {
              syntaxError(next);
            }
            case 4: {
              syntaxError(next);
            }
            case 5: {
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce10(sym1);
              stack.push(_result);
              state = gotos[stateStack.peek()][5];
              break;
            }
            case 6: {
              syntaxError(next);
            }
            case 7: {
              syntaxError(next);
            }
            case 8: {
              syntaxError(next);
            }
            case 9: {
              syntaxError(next);
            }
            case 10: {
              syntaxError(next);
            }
            case 11: {
              syntaxError(next);
            }
            case 12: {
              syntaxError(next);
            }
            case 13: {
              syntaxError(next);
            }
            case 14: {
              syntaxError(next);
            }
            case 15: {
              syntaxError(next);
            }
            case 16: {
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce10(sym1);
              stack.push(_result);
              state = gotos[stateStack.peek()][5];
              break;
            }
            case 17: {
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce10(sym1);
              stack.push(_result);
              state = gotos[stateStack.peek()][5];
              break;
            }
            case 18: {
              syntaxError(next);
            }
            case 19: {
              syntaxError(next);
            }
            case 20: {
              syntaxError(next);
            }
            case 21: {
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce10(sym1);
              stack.push(_result);
              state = gotos[stateStack.peek()][5];
              break;
            }
            case 22: {
              syntaxError(next);
            }
            case 23: {
              syntaxError(next);
            }
            case 24: {
              syntaxError(next);
            }
            case 25: {
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce10(sym1);
              stack.push(_result);
              state = gotos[stateStack.peek()][5];
              break;
            }
          }
          break;
        case 41:
          if (DEBUG) System.out.format("[%s] ", next);
          switch (next.getId()) {
            case 0: {
              syntaxError(next);
            }
            case 1: {
              syntaxError(next);
            }
            case 2: {
              syntaxError(next);
            }
            case 3: {
              syntaxError(next);
            }
            case 4: {
              syntaxError(next);
            }
            case 5: {
              stateStack.push(state);
              stack.push(next);
              state = 59;
              next = nextToken(in);
              break;
            }
            case 6: {
              syntaxError(next);
            }
            case 7: {
              syntaxError(next);
            }
            case 8: {
              syntaxError(next);
            }
            case 9: {
              syntaxError(next);
            }
            case 10: {
              syntaxError(next);
            }
            case 11: {
              syntaxError(next);
            }
            case 12: {
              syntaxError(next);
            }
            case 13: {
              syntaxError(next);
            }
            case 14: {
              syntaxError(next);
            }
            case 15: {
              syntaxError(next);
            }
            case 16: {
              syntaxError(next);
            }
            case 17: {
              syntaxError(next);
            }
            case 18: {
              syntaxError(next);
            }
            case 19: {
              syntaxError(next);
            }
            case 20: {
              syntaxError(next);
            }
            case 21: {
              syntaxError(next);
            }
            case 22: {
              syntaxError(next);
            }
            case 23: {
              syntaxError(next);
            }
            case 24: {
              syntaxError(next);
            }
            case 25: {
              syntaxError(next);
            }
          }
          break;
        case 42:
          if (DEBUG) System.out.format("[%s] ", next);
          switch (next.getId()) {
            case 0: {
              syntaxError(next);
            }
            case 1: {
              syntaxError(next);
            }
            case 2: {
              syntaxError(next);
            }
            case 3: {
              syntaxError(next);
            }
            case 4: {
              syntaxError(next);
            }
            case 5: {
              syntaxError(next);
            }
            case 6: {
              syntaxError(next);
            }
            case 7: {
              syntaxError(next);
            }
            case 8: {
              syntaxError(next);
            }
            case 9: {
              syntaxError(next);
            }
            case 10: {
              syntaxError(next);
            }
            case 11: {
              syntaxError(next);
            }
            case 12: {
              syntaxError(next);
            }
            case 13: {
              syntaxError(next);
            }
            case 14: {
              syntaxError(next);
            }
            case 15: {
              syntaxError(next);
            }
            case 16: {
              stateStack.push(state);
              stack.push(next);
              state = 57;
              next = nextToken(in);
              break;
            }
            case 17: {
              stateStack.push(state);
              stack.push(next);
              state = 56;
              next = nextToken(in);
              break;
            }
            case 18: {
              syntaxError(next);
            }
            case 19: {
              syntaxError(next);
            }
            case 20: {
              syntaxError(next);
            }
            case 21: {
              syntaxError(next);
            }
            case 22: {
              syntaxError(next);
            }
            case 23: {
              syntaxError(next);
            }
            case 24: {
              syntaxError(next);
            }
            case 25: {
              syntaxError(next);
            }
          }
          break;
        case 43:
          if (DEBUG) System.out.format("[%s] ", next);
          switch (next.getId()) {
            case 0: {
              Symbol sym3 = (Symbol) stack.pop();
              Symbol sym2 = (Symbol) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce11(sym1, sym2, sym3);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][2];
              break;
            }
            case 1: {
              Symbol sym3 = (Symbol) stack.pop();
              Symbol sym2 = (Symbol) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce11(sym1, sym2, sym3);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][2];
              break;
            }
            case 2: {
              syntaxError(next);
            }
            case 3: {
              syntaxError(next);
            }
            case 4: {
              syntaxError(next);
            }
            case 5: {
              Symbol sym3 = (Symbol) stack.pop();
              Symbol sym2 = (Symbol) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce11(sym1, sym2, sym3);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][2];
              break;
            }
            case 6: {
              Symbol sym3 = (Symbol) stack.pop();
              Symbol sym2 = (Symbol) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce11(sym1, sym2, sym3);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][2];
              break;
            }
            case 7: {
              Symbol sym3 = (Symbol) stack.pop();
              Symbol sym2 = (Symbol) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce11(sym1, sym2, sym3);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][2];
              break;
            }
            case 8: {
              syntaxError(next);
            }
            case 9: {
              Symbol sym3 = (Symbol) stack.pop();
              Symbol sym2 = (Symbol) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce11(sym1, sym2, sym3);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][2];
              break;
            }
            case 10: {
              Symbol sym3 = (Symbol) stack.pop();
              Symbol sym2 = (Symbol) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce11(sym1, sym2, sym3);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][2];
              break;
            }
            case 11: {
              syntaxError(next);
            }
            case 12: {
              syntaxError(next);
            }
            case 13: {
              Symbol sym3 = (Symbol) stack.pop();
              Symbol sym2 = (Symbol) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce11(sym1, sym2, sym3);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][2];
              break;
            }
            case 14: {
              syntaxError(next);
            }
            case 15: {
              syntaxError(next);
            }
            case 16: {
              syntaxError(next);
            }
            case 17: {
              syntaxError(next);
            }
            case 18: {
              Symbol sym3 = (Symbol) stack.pop();
              Symbol sym2 = (Symbol) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce11(sym1, sym2, sym3);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][2];
              break;
            }
            case 19: {
              syntaxError(next);
            }
            case 20: {
              Symbol sym3 = (Symbol) stack.pop();
              Symbol sym2 = (Symbol) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce11(sym1, sym2, sym3);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][2];
              break;
            }
            case 21: {
              syntaxError(next);
            }
            case 22: {
              Symbol sym3 = (Symbol) stack.pop();
              Symbol sym2 = (Symbol) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce11(sym1, sym2, sym3);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][2];
              break;
            }
            case 23: {
              Symbol sym3 = (Symbol) stack.pop();
              Symbol sym2 = (Symbol) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce11(sym1, sym2, sym3);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][2];
              break;
            }
            case 24: {
              syntaxError(next);
            }
            case 25: {
              syntaxError(next);
            }
          }
          break;
        case 44:
          if (DEBUG) System.out.format("[%s] ", next);
          switch (next.getId()) {
            case 0: {
              Symbol sym3 = (Symbol) stack.pop();
              Symbol sym2 = (Symbol) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce12(sym1, sym2, sym3);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][2];
              break;
            }
            case 1: {
              Symbol sym3 = (Symbol) stack.pop();
              Symbol sym2 = (Symbol) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce12(sym1, sym2, sym3);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][2];
              break;
            }
            case 2: {
              syntaxError(next);
            }
            case 3: {
              syntaxError(next);
            }
            case 4: {
              syntaxError(next);
            }
            case 5: {
              Symbol sym3 = (Symbol) stack.pop();
              Symbol sym2 = (Symbol) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce12(sym1, sym2, sym3);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][2];
              break;
            }
            case 6: {
              Symbol sym3 = (Symbol) stack.pop();
              Symbol sym2 = (Symbol) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce12(sym1, sym2, sym3);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][2];
              break;
            }
            case 7: {
              Symbol sym3 = (Symbol) stack.pop();
              Symbol sym2 = (Symbol) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce12(sym1, sym2, sym3);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][2];
              break;
            }
            case 8: {
              syntaxError(next);
            }
            case 9: {
              Symbol sym3 = (Symbol) stack.pop();
              Symbol sym2 = (Symbol) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce12(sym1, sym2, sym3);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][2];
              break;
            }
            case 10: {
              Symbol sym3 = (Symbol) stack.pop();
              Symbol sym2 = (Symbol) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce12(sym1, sym2, sym3);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][2];
              break;
            }
            case 11: {
              syntaxError(next);
            }
            case 12: {
              syntaxError(next);
            }
            case 13: {
              Symbol sym3 = (Symbol) stack.pop();
              Symbol sym2 = (Symbol) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce12(sym1, sym2, sym3);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][2];
              break;
            }
            case 14: {
              syntaxError(next);
            }
            case 15: {
              syntaxError(next);
            }
            case 16: {
              syntaxError(next);
            }
            case 17: {
              syntaxError(next);
            }
            case 18: {
              Symbol sym3 = (Symbol) stack.pop();
              Symbol sym2 = (Symbol) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce12(sym1, sym2, sym3);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][2];
              break;
            }
            case 19: {
              syntaxError(next);
            }
            case 20: {
              Symbol sym3 = (Symbol) stack.pop();
              Symbol sym2 = (Symbol) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce12(sym1, sym2, sym3);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][2];
              break;
            }
            case 21: {
              syntaxError(next);
            }
            case 22: {
              Symbol sym3 = (Symbol) stack.pop();
              Symbol sym2 = (Symbol) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce12(sym1, sym2, sym3);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][2];
              break;
            }
            case 23: {
              Symbol sym3 = (Symbol) stack.pop();
              Symbol sym2 = (Symbol) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce12(sym1, sym2, sym3);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][2];
              break;
            }
            case 24: {
              syntaxError(next);
            }
            case 25: {
              syntaxError(next);
            }
          }
          break;
        case 45:
          if (DEBUG) System.out.format("[%s] ", next);
          switch (next.getId()) {
            case 0: {
              syntaxError(next);
            }
            case 1: {
              syntaxError(next);
            }
            case 2: {
              syntaxError(next);
            }
            case 3: {
              syntaxError(next);
            }
            case 4: {
              syntaxError(next);
            }
            case 5: {
              syntaxError(next);
            }
            case 6: {
              syntaxError(next);
            }
            case 7: {
              syntaxError(next);
            }
            case 8: {
              stateStack.push(state);
              stack.push(next);
              state = 55;
              next = nextToken(in);
              break;
            }
            case 9: {
              syntaxError(next);
            }
            case 10: {
              syntaxError(next);
            }
            case 11: {
              syntaxError(next);
            }
            case 12: {
              syntaxError(next);
            }
            case 13: {
              syntaxError(next);
            }
            case 14: {
              syntaxError(next);
            }
            case 15: {
              syntaxError(next);
            }
            case 16: {
              syntaxError(next);
            }
            case 17: {
              syntaxError(next);
            }
            case 18: {
              syntaxError(next);
            }
            case 19: {
              syntaxError(next);
            }
            case 20: {
              syntaxError(next);
            }
            case 21: {
              syntaxError(next);
            }
            case 22: {
              syntaxError(next);
            }
            case 23: {
              syntaxError(next);
            }
            case 24: {
              syntaxError(next);
            }
            case 25: {
              syntaxError(next);
            }
          }
          break;
        case 46:
          if (DEBUG) System.out.format("[%s] ", next);
          switch (next.getId()) {
            case 0: {
              syntaxError(next);
            }
            case 1: {
              syntaxError(next);
            }
            case 2: {
              syntaxError(next);
            }
            case 3: {
              syntaxError(next);
            }
            case 4: {
              syntaxError(next);
            }
            case 5: {
              stateStack.push(state);
              stack.push(next);
              state = 54;
              next = nextToken(in);
              break;
            }
            case 6: {
              syntaxError(next);
            }
            case 7: {
              syntaxError(next);
            }
            case 8: {
              syntaxError(next);
            }
            case 9: {
              syntaxError(next);
            }
            case 10: {
              syntaxError(next);
            }
            case 11: {
              syntaxError(next);
            }
            case 12: {
              syntaxError(next);
            }
            case 13: {
              syntaxError(next);
            }
            case 14: {
              syntaxError(next);
            }
            case 15: {
              syntaxError(next);
            }
            case 16: {
              syntaxError(next);
            }
            case 17: {
              syntaxError(next);
            }
            case 18: {
              syntaxError(next);
            }
            case 19: {
              syntaxError(next);
            }
            case 20: {
              syntaxError(next);
            }
            case 21: {
              syntaxError(next);
            }
            case 22: {
              syntaxError(next);
            }
            case 23: {
              syntaxError(next);
            }
            case 24: {
              syntaxError(next);
            }
            case 25: {
              syntaxError(next);
            }
          }
          break;
        case 47:
          if (DEBUG) System.out.format("[%s] ", next);
          switch (next.getId()) {
            case 0: {
              Symbol sym3 = (Symbol) stack.pop();
              Symbol sym2 = (Symbol) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce13(sym1, sym2, sym3);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][2];
              break;
            }
            case 1: {
              Symbol sym3 = (Symbol) stack.pop();
              Symbol sym2 = (Symbol) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce13(sym1, sym2, sym3);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][2];
              break;
            }
            case 2: {
              syntaxError(next);
            }
            case 3: {
              syntaxError(next);
            }
            case 4: {
              syntaxError(next);
            }
            case 5: {
              Symbol sym3 = (Symbol) stack.pop();
              Symbol sym2 = (Symbol) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce13(sym1, sym2, sym3);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][2];
              break;
            }
            case 6: {
              Symbol sym3 = (Symbol) stack.pop();
              Symbol sym2 = (Symbol) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce13(sym1, sym2, sym3);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][2];
              break;
            }
            case 7: {
              Symbol sym3 = (Symbol) stack.pop();
              Symbol sym2 = (Symbol) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce13(sym1, sym2, sym3);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][2];
              break;
            }
            case 8: {
              syntaxError(next);
            }
            case 9: {
              Symbol sym3 = (Symbol) stack.pop();
              Symbol sym2 = (Symbol) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce13(sym1, sym2, sym3);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][2];
              break;
            }
            case 10: {
              Symbol sym3 = (Symbol) stack.pop();
              Symbol sym2 = (Symbol) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce13(sym1, sym2, sym3);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][2];
              break;
            }
            case 11: {
              syntaxError(next);
            }
            case 12: {
              syntaxError(next);
            }
            case 13: {
              Symbol sym3 = (Symbol) stack.pop();
              Symbol sym2 = (Symbol) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce13(sym1, sym2, sym3);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][2];
              break;
            }
            case 14: {
              syntaxError(next);
            }
            case 15: {
              syntaxError(next);
            }
            case 16: {
              syntaxError(next);
            }
            case 17: {
              syntaxError(next);
            }
            case 18: {
              Symbol sym3 = (Symbol) stack.pop();
              Symbol sym2 = (Symbol) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce13(sym1, sym2, sym3);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][2];
              break;
            }
            case 19: {
              syntaxError(next);
            }
            case 20: {
              Symbol sym3 = (Symbol) stack.pop();
              Symbol sym2 = (Symbol) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce13(sym1, sym2, sym3);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][2];
              break;
            }
            case 21: {
              syntaxError(next);
            }
            case 22: {
              Symbol sym3 = (Symbol) stack.pop();
              Symbol sym2 = (Symbol) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce13(sym1, sym2, sym3);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][2];
              break;
            }
            case 23: {
              Symbol sym3 = (Symbol) stack.pop();
              Symbol sym2 = (Symbol) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce13(sym1, sym2, sym3);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][2];
              break;
            }
            case 24: {
              syntaxError(next);
            }
            case 25: {
              syntaxError(next);
            }
          }
          break;
        case 48:
          if (DEBUG) System.out.format("[%s] ", next);
          switch (next.getId()) {
            case 0: {
              Symbol sym3 = (Symbol) stack.pop();
              Symbol sym2 = (Symbol) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce14(sym1, sym2, sym3);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][2];
              break;
            }
            case 1: {
              Symbol sym3 = (Symbol) stack.pop();
              Symbol sym2 = (Symbol) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce14(sym1, sym2, sym3);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][2];
              break;
            }
            case 2: {
              syntaxError(next);
            }
            case 3: {
              syntaxError(next);
            }
            case 4: {
              syntaxError(next);
            }
            case 5: {
              Symbol sym3 = (Symbol) stack.pop();
              Symbol sym2 = (Symbol) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce14(sym1, sym2, sym3);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][2];
              break;
            }
            case 6: {
              Symbol sym3 = (Symbol) stack.pop();
              Symbol sym2 = (Symbol) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce14(sym1, sym2, sym3);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][2];
              break;
            }
            case 7: {
              Symbol sym3 = (Symbol) stack.pop();
              Symbol sym2 = (Symbol) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce14(sym1, sym2, sym3);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][2];
              break;
            }
            case 8: {
              syntaxError(next);
            }
            case 9: {
              Symbol sym3 = (Symbol) stack.pop();
              Symbol sym2 = (Symbol) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce14(sym1, sym2, sym3);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][2];
              break;
            }
            case 10: {
              Symbol sym3 = (Symbol) stack.pop();
              Symbol sym2 = (Symbol) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce14(sym1, sym2, sym3);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][2];
              break;
            }
            case 11: {
              syntaxError(next);
            }
            case 12: {
              syntaxError(next);
            }
            case 13: {
              Symbol sym3 = (Symbol) stack.pop();
              Symbol sym2 = (Symbol) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce14(sym1, sym2, sym3);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][2];
              break;
            }
            case 14: {
              syntaxError(next);
            }
            case 15: {
              syntaxError(next);
            }
            case 16: {
              syntaxError(next);
            }
            case 17: {
              syntaxError(next);
            }
            case 18: {
              Symbol sym3 = (Symbol) stack.pop();
              Symbol sym2 = (Symbol) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce14(sym1, sym2, sym3);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][2];
              break;
            }
            case 19: {
              syntaxError(next);
            }
            case 20: {
              Symbol sym3 = (Symbol) stack.pop();
              Symbol sym2 = (Symbol) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce14(sym1, sym2, sym3);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][2];
              break;
            }
            case 21: {
              syntaxError(next);
            }
            case 22: {
              Symbol sym3 = (Symbol) stack.pop();
              Symbol sym2 = (Symbol) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce14(sym1, sym2, sym3);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][2];
              break;
            }
            case 23: {
              Symbol sym3 = (Symbol) stack.pop();
              Symbol sym2 = (Symbol) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce14(sym1, sym2, sym3);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][2];
              break;
            }
            case 24: {
              syntaxError(next);
            }
            case 25: {
              syntaxError(next);
            }
          }
          break;
        case 49:
          if (DEBUG) System.out.format("[%s] ", next);
          switch (next.getId()) {
            case 0: {
              syntaxError(next);
            }
            case 1: {
              syntaxError(next);
            }
            case 2: {
              syntaxError(next);
            }
            case 3: {
              syntaxError(next);
            }
            case 4: {
              syntaxError(next);
            }
            case 5: {
              syntaxError(next);
            }
            case 6: {
              syntaxError(next);
            }
            case 7: {
              syntaxError(next);
            }
            case 8: {
              syntaxError(next);
            }
            case 9: {
              syntaxError(next);
            }
            case 10: {
              syntaxError(next);
            }
            case 11: {
              syntaxError(next);
            }
            case 12: {
              stateStack.push(state);
              stack.push(next);
              state = 53;
              next = nextToken(in);
              break;
            }
            case 13: {
              syntaxError(next);
            }
            case 14: {
              syntaxError(next);
            }
            case 15: {
              syntaxError(next);
            }
            case 16: {
              syntaxError(next);
            }
            case 17: {
              syntaxError(next);
            }
            case 18: {
              syntaxError(next);
            }
            case 19: {
              syntaxError(next);
            }
            case 20: {
              syntaxError(next);
            }
            case 21: {
              syntaxError(next);
            }
            case 22: {
              syntaxError(next);
            }
            case 23: {
              syntaxError(next);
            }
            case 24: {
              syntaxError(next);
            }
            case 25: {
              syntaxError(next);
            }
          }
          break;
        case 50:
          if (DEBUG) System.out.format("[%s] ", next);
          switch (next.getId()) {
            case 0: {
              Symbol sym3 = (Symbol) stack.pop();
              Symbol sym2 = (Symbol) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce15(sym1, sym2, sym3);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][2];
              break;
            }
            case 1: {
              Symbol sym3 = (Symbol) stack.pop();
              Symbol sym2 = (Symbol) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce15(sym1, sym2, sym3);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][2];
              break;
            }
            case 2: {
              syntaxError(next);
            }
            case 3: {
              syntaxError(next);
            }
            case 4: {
              syntaxError(next);
            }
            case 5: {
              Symbol sym3 = (Symbol) stack.pop();
              Symbol sym2 = (Symbol) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce15(sym1, sym2, sym3);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][2];
              break;
            }
            case 6: {
              Symbol sym3 = (Symbol) stack.pop();
              Symbol sym2 = (Symbol) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce15(sym1, sym2, sym3);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][2];
              break;
            }
            case 7: {
              Symbol sym3 = (Symbol) stack.pop();
              Symbol sym2 = (Symbol) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce15(sym1, sym2, sym3);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][2];
              break;
            }
            case 8: {
              syntaxError(next);
            }
            case 9: {
              Symbol sym3 = (Symbol) stack.pop();
              Symbol sym2 = (Symbol) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce15(sym1, sym2, sym3);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][2];
              break;
            }
            case 10: {
              Symbol sym3 = (Symbol) stack.pop();
              Symbol sym2 = (Symbol) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce15(sym1, sym2, sym3);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][2];
              break;
            }
            case 11: {
              syntaxError(next);
            }
            case 12: {
              syntaxError(next);
            }
            case 13: {
              Symbol sym3 = (Symbol) stack.pop();
              Symbol sym2 = (Symbol) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce15(sym1, sym2, sym3);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][2];
              break;
            }
            case 14: {
              syntaxError(next);
            }
            case 15: {
              syntaxError(next);
            }
            case 16: {
              syntaxError(next);
            }
            case 17: {
              syntaxError(next);
            }
            case 18: {
              Symbol sym3 = (Symbol) stack.pop();
              Symbol sym2 = (Symbol) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce15(sym1, sym2, sym3);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][2];
              break;
            }
            case 19: {
              syntaxError(next);
            }
            case 20: {
              Symbol sym3 = (Symbol) stack.pop();
              Symbol sym2 = (Symbol) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce15(sym1, sym2, sym3);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][2];
              break;
            }
            case 21: {
              syntaxError(next);
            }
            case 22: {
              Symbol sym3 = (Symbol) stack.pop();
              Symbol sym2 = (Symbol) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce15(sym1, sym2, sym3);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][2];
              break;
            }
            case 23: {
              Symbol sym3 = (Symbol) stack.pop();
              Symbol sym2 = (Symbol) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce15(sym1, sym2, sym3);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][2];
              break;
            }
            case 24: {
              syntaxError(next);
            }
            case 25: {
              syntaxError(next);
            }
          }
          break;
        case 51:
          if (DEBUG) System.out.format("[%s] ", next);
          switch (next.getId()) {
            case 0: {
              Symbol sym3 = (Symbol) stack.pop();
              Symbol sym2 = (Symbol) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce16(sym1, sym2, sym3);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][2];
              break;
            }
            case 1: {
              Symbol sym3 = (Symbol) stack.pop();
              Symbol sym2 = (Symbol) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce16(sym1, sym2, sym3);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][2];
              break;
            }
            case 2: {
              syntaxError(next);
            }
            case 3: {
              syntaxError(next);
            }
            case 4: {
              syntaxError(next);
            }
            case 5: {
              Symbol sym3 = (Symbol) stack.pop();
              Symbol sym2 = (Symbol) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce16(sym1, sym2, sym3);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][2];
              break;
            }
            case 6: {
              Symbol sym3 = (Symbol) stack.pop();
              Symbol sym2 = (Symbol) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce16(sym1, sym2, sym3);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][2];
              break;
            }
            case 7: {
              Symbol sym3 = (Symbol) stack.pop();
              Symbol sym2 = (Symbol) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce16(sym1, sym2, sym3);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][2];
              break;
            }
            case 8: {
              syntaxError(next);
            }
            case 9: {
              Symbol sym3 = (Symbol) stack.pop();
              Symbol sym2 = (Symbol) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce16(sym1, sym2, sym3);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][2];
              break;
            }
            case 10: {
              Symbol sym3 = (Symbol) stack.pop();
              Symbol sym2 = (Symbol) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce16(sym1, sym2, sym3);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][2];
              break;
            }
            case 11: {
              syntaxError(next);
            }
            case 12: {
              syntaxError(next);
            }
            case 13: {
              Symbol sym3 = (Symbol) stack.pop();
              Symbol sym2 = (Symbol) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce16(sym1, sym2, sym3);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][2];
              break;
            }
            case 14: {
              syntaxError(next);
            }
            case 15: {
              syntaxError(next);
            }
            case 16: {
              syntaxError(next);
            }
            case 17: {
              syntaxError(next);
            }
            case 18: {
              Symbol sym3 = (Symbol) stack.pop();
              Symbol sym2 = (Symbol) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce16(sym1, sym2, sym3);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][2];
              break;
            }
            case 19: {
              syntaxError(next);
            }
            case 20: {
              Symbol sym3 = (Symbol) stack.pop();
              Symbol sym2 = (Symbol) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce16(sym1, sym2, sym3);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][2];
              break;
            }
            case 21: {
              syntaxError(next);
            }
            case 22: {
              Symbol sym3 = (Symbol) stack.pop();
              Symbol sym2 = (Symbol) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce16(sym1, sym2, sym3);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][2];
              break;
            }
            case 23: {
              Symbol sym3 = (Symbol) stack.pop();
              Symbol sym2 = (Symbol) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce16(sym1, sym2, sym3);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][2];
              break;
            }
            case 24: {
              syntaxError(next);
            }
            case 25: {
              syntaxError(next);
            }
          }
          break;
        case 52:
          if (DEBUG) System.out.format("[%s] ", next);
          switch (next.getId()) {
            case 0: {
              Symbol sym3 = (Symbol) stack.pop();
              Symbol sym2 = (Symbol) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce17(sym1, sym2, sym3);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][2];
              break;
            }
            case 1: {
              Symbol sym3 = (Symbol) stack.pop();
              Symbol sym2 = (Symbol) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce17(sym1, sym2, sym3);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][2];
              break;
            }
            case 2: {
              syntaxError(next);
            }
            case 3: {
              syntaxError(next);
            }
            case 4: {
              syntaxError(next);
            }
            case 5: {
              Symbol sym3 = (Symbol) stack.pop();
              Symbol sym2 = (Symbol) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce17(sym1, sym2, sym3);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][2];
              break;
            }
            case 6: {
              Symbol sym3 = (Symbol) stack.pop();
              Symbol sym2 = (Symbol) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce17(sym1, sym2, sym3);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][2];
              break;
            }
            case 7: {
              Symbol sym3 = (Symbol) stack.pop();
              Symbol sym2 = (Symbol) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce17(sym1, sym2, sym3);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][2];
              break;
            }
            case 8: {
              syntaxError(next);
            }
            case 9: {
              Symbol sym3 = (Symbol) stack.pop();
              Symbol sym2 = (Symbol) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce17(sym1, sym2, sym3);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][2];
              break;
            }
            case 10: {
              Symbol sym3 = (Symbol) stack.pop();
              Symbol sym2 = (Symbol) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce17(sym1, sym2, sym3);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][2];
              break;
            }
            case 11: {
              syntaxError(next);
            }
            case 12: {
              syntaxError(next);
            }
            case 13: {
              Symbol sym3 = (Symbol) stack.pop();
              Symbol sym2 = (Symbol) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce17(sym1, sym2, sym3);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][2];
              break;
            }
            case 14: {
              syntaxError(next);
            }
            case 15: {
              syntaxError(next);
            }
            case 16: {
              syntaxError(next);
            }
            case 17: {
              syntaxError(next);
            }
            case 18: {
              Symbol sym3 = (Symbol) stack.pop();
              Symbol sym2 = (Symbol) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce17(sym1, sym2, sym3);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][2];
              break;
            }
            case 19: {
              syntaxError(next);
            }
            case 20: {
              Symbol sym3 = (Symbol) stack.pop();
              Symbol sym2 = (Symbol) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce17(sym1, sym2, sym3);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][2];
              break;
            }
            case 21: {
              syntaxError(next);
            }
            case 22: {
              Symbol sym3 = (Symbol) stack.pop();
              Symbol sym2 = (Symbol) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce17(sym1, sym2, sym3);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][2];
              break;
            }
            case 23: {
              Symbol sym3 = (Symbol) stack.pop();
              Symbol sym2 = (Symbol) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce17(sym1, sym2, sym3);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][2];
              break;
            }
            case 24: {
              syntaxError(next);
            }
            case 25: {
              syntaxError(next);
            }
          }
          break;
        case 53:
          if (DEBUG) System.out.format("[%s] ", next);
          switch (next.getId()) {
            case 0: {
              syntaxError(next);
            }
            case 1: {
              syntaxError(next);
            }
            case 2: {
              syntaxError(next);
            }
            case 3: {
              syntaxError(next);
            }
            case 4: {
              syntaxError(next);
            }
            case 5: {
              syntaxError(next);
            }
            case 6: {
              syntaxError(next);
            }
            case 7: {
              syntaxError(next);
            }
            case 8: {
              syntaxError(next);
            }
            case 9: {
              syntaxError(next);
            }
            case 10: {
              syntaxError(next);
            }
            case 11: {
              syntaxError(next);
            }
            case 12: {
              syntaxError(next);
            }
            case 13: {
              syntaxError(next);
            }
            case 14: {
              syntaxError(next);
            }
            case 15: {
              syntaxError(next);
            }
            case 16: {
              stateStack.push(state);
              stack.push(next);
              state = 79;
              next = nextToken(in);
              break;
            }
            case 17: {
              syntaxError(next);
            }
            case 18: {
              syntaxError(next);
            }
            case 19: {
              syntaxError(next);
            }
            case 20: {
              syntaxError(next);
            }
            case 21: {
              syntaxError(next);
            }
            case 22: {
              syntaxError(next);
            }
            case 23: {
              syntaxError(next);
            }
            case 24: {
              syntaxError(next);
            }
            case 25: {
              syntaxError(next);
            }
          }
          break;
        case 54:
          if (DEBUG) System.out.format("[%s] ", next);
          switch (next.getId()) {
            case 0: {
              syntaxError(next);
            }
            case 1: {
              syntaxError(next);
            }
            case 2: {
              syntaxError(next);
            }
            case 3: {
              Symbol sym3 = (Symbol) stack.pop();
              Symbol sym2 = (Symbol) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce18(sym1, sym2, sym3);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][1];
              break;
            }
            case 4: {
              syntaxError(next);
            }
            case 5: {
              syntaxError(next);
            }
            case 6: {
              syntaxError(next);
            }
            case 7: {
              syntaxError(next);
            }
            case 8: {
              syntaxError(next);
            }
            case 9: {
              syntaxError(next);
            }
            case 10: {
              syntaxError(next);
            }
            case 11: {
              syntaxError(next);
            }
            case 12: {
              syntaxError(next);
            }
            case 13: {
              syntaxError(next);
            }
            case 14: {
              syntaxError(next);
            }
            case 15: {
              syntaxError(next);
            }
            case 16: {
              Symbol sym3 = (Symbol) stack.pop();
              Symbol sym2 = (Symbol) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce18(sym1, sym2, sym3);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][1];
              break;
            }
            case 17: {
              syntaxError(next);
            }
            case 18: {
              syntaxError(next);
            }
            case 19: {
              syntaxError(next);
            }
            case 20: {
              syntaxError(next);
            }
            case 21: {
              syntaxError(next);
            }
            case 22: {
              syntaxError(next);
            }
            case 23: {
              syntaxError(next);
            }
            case 24: {
              syntaxError(next);
            }
            case 25: {
              syntaxError(next);
            }
          }
          break;
        case 55:
          if (DEBUG) System.out.format("[%s] ", next);
          switch (next.getId()) {
            case 0: {
              syntaxError(next);
            }
            case 1: {
              syntaxError(next);
            }
            case 2: {
              syntaxError(next);
            }
            case 3: {
              syntaxError(next);
            }
            case 4: {
              syntaxError(next);
            }
            case 5: {
              syntaxError(next);
            }
            case 6: {
              syntaxError(next);
            }
            case 7: {
              syntaxError(next);
            }
            case 8: {
              syntaxError(next);
            }
            case 9: {
              syntaxError(next);
            }
            case 10: {
              syntaxError(next);
            }
            case 11: {
              syntaxError(next);
            }
            case 12: {
              syntaxError(next);
            }
            case 13: {
              syntaxError(next);
            }
            case 14: {
              syntaxError(next);
            }
            case 15: {
              syntaxError(next);
            }
            case 16: {
              stateStack.push(state);
              stack.push(next);
              state = 78;
              next = nextToken(in);
              break;
            }
            case 17: {
              syntaxError(next);
            }
            case 18: {
              syntaxError(next);
            }
            case 19: {
              syntaxError(next);
            }
            case 20: {
              syntaxError(next);
            }
            case 21: {
              syntaxError(next);
            }
            case 22: {
              syntaxError(next);
            }
            case 23: {
              syntaxError(next);
            }
            case 24: {
              syntaxError(next);
            }
            case 25: {
              syntaxError(next);
            }
          }
          break;
        case 56:
          if (DEBUG) System.out.format("[%s] ", next);
          switch (next.getId()) {
            case 0: {
              syntaxError(next);
            }
            case 1: {
              syntaxError(next);
            }
            case 2: {
              syntaxError(next);
            }
            case 3: {
              syntaxError(next);
            }
            case 4: {
              syntaxError(next);
            }
            case 5: {
              stateStack.push(state);
              stack.push(next);
              state = 34;
              next = nextToken(in);
              break;
            }
            case 6: {
              syntaxError(next);
            }
            case 7: {
              syntaxError(next);
            }
            case 8: {
              syntaxError(next);
            }
            case 9: {
              syntaxError(next);
            }
            case 10: {
              syntaxError(next);
            }
            case 11: {
              syntaxError(next);
            }
            case 12: {
              syntaxError(next);
            }
            case 13: {
              syntaxError(next);
            }
            case 14: {
              syntaxError(next);
            }
            case 15: {
              syntaxError(next);
            }
            case 16: {
              Symbol _result = reduce4();
              stack.push(_result);
              stateStack.push(state);
              state = gotos[stateStack.peek()][6];
              break;
            }
            case 17: {
              Symbol _result = reduce4();
              stack.push(_result);
              stateStack.push(state);
              state = gotos[stateStack.peek()][6];
              break;
            }
            case 18: {
              syntaxError(next);
            }
            case 19: {
              syntaxError(next);
            }
            case 20: {
              syntaxError(next);
            }
            case 21: {
              Symbol _result = reduce4();
              stack.push(_result);
              stateStack.push(state);
              state = gotos[stateStack.peek()][6];
              break;
            }
            case 22: {
              syntaxError(next);
            }
            case 23: {
              syntaxError(next);
            }
            case 24: {
              syntaxError(next);
            }
            case 25: {
              stateStack.push(state);
              stack.push(next);
              state = 41;
              next = nextToken(in);
              break;
            }
          }
          break;
        case 57:
          if (DEBUG) System.out.format("[%s] ", next);
          switch (next.getId()) {
            case 0: {
              Symbol sym4 = (Symbol) stack.pop();
              Symbol sym3 = (Symbol) stack.pop();
              Symbol sym2 = (Symbol) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce19(sym1, sym2, sym3, sym4);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][2];
              break;
            }
            case 1: {
              Symbol sym4 = (Symbol) stack.pop();
              Symbol sym3 = (Symbol) stack.pop();
              Symbol sym2 = (Symbol) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce19(sym1, sym2, sym3, sym4);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][2];
              break;
            }
            case 2: {
              syntaxError(next);
            }
            case 3: {
              syntaxError(next);
            }
            case 4: {
              syntaxError(next);
            }
            case 5: {
              Symbol sym4 = (Symbol) stack.pop();
              Symbol sym3 = (Symbol) stack.pop();
              Symbol sym2 = (Symbol) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce19(sym1, sym2, sym3, sym4);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][2];
              break;
            }
            case 6: {
              Symbol sym4 = (Symbol) stack.pop();
              Symbol sym3 = (Symbol) stack.pop();
              Symbol sym2 = (Symbol) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce19(sym1, sym2, sym3, sym4);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][2];
              break;
            }
            case 7: {
              Symbol sym4 = (Symbol) stack.pop();
              Symbol sym3 = (Symbol) stack.pop();
              Symbol sym2 = (Symbol) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce19(sym1, sym2, sym3, sym4);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][2];
              break;
            }
            case 8: {
              syntaxError(next);
            }
            case 9: {
              Symbol sym4 = (Symbol) stack.pop();
              Symbol sym3 = (Symbol) stack.pop();
              Symbol sym2 = (Symbol) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce19(sym1, sym2, sym3, sym4);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][2];
              break;
            }
            case 10: {
              Symbol sym4 = (Symbol) stack.pop();
              Symbol sym3 = (Symbol) stack.pop();
              Symbol sym2 = (Symbol) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce19(sym1, sym2, sym3, sym4);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][2];
              break;
            }
            case 11: {
              syntaxError(next);
            }
            case 12: {
              syntaxError(next);
            }
            case 13: {
              Symbol sym4 = (Symbol) stack.pop();
              Symbol sym3 = (Symbol) stack.pop();
              Symbol sym2 = (Symbol) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce19(sym1, sym2, sym3, sym4);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][2];
              break;
            }
            case 14: {
              syntaxError(next);
            }
            case 15: {
              syntaxError(next);
            }
            case 16: {
              syntaxError(next);
            }
            case 17: {
              syntaxError(next);
            }
            case 18: {
              Symbol sym4 = (Symbol) stack.pop();
              Symbol sym3 = (Symbol) stack.pop();
              Symbol sym2 = (Symbol) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce19(sym1, sym2, sym3, sym4);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][2];
              break;
            }
            case 19: {
              syntaxError(next);
            }
            case 20: {
              Symbol sym4 = (Symbol) stack.pop();
              Symbol sym3 = (Symbol) stack.pop();
              Symbol sym2 = (Symbol) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce19(sym1, sym2, sym3, sym4);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][2];
              break;
            }
            case 21: {
              syntaxError(next);
            }
            case 22: {
              Symbol sym4 = (Symbol) stack.pop();
              Symbol sym3 = (Symbol) stack.pop();
              Symbol sym2 = (Symbol) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce19(sym1, sym2, sym3, sym4);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][2];
              break;
            }
            case 23: {
              Symbol sym4 = (Symbol) stack.pop();
              Symbol sym3 = (Symbol) stack.pop();
              Symbol sym2 = (Symbol) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce19(sym1, sym2, sym3, sym4);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][2];
              break;
            }
            case 24: {
              syntaxError(next);
            }
            case 25: {
              syntaxError(next);
            }
          }
          break;
        case 58:
          if (DEBUG) System.out.format("[%s] ", next);
          switch (next.getId()) {
            case 0: {
              syntaxError(next);
            }
            case 1: {
              syntaxError(next);
            }
            case 2: {
              syntaxError(next);
            }
            case 3: {
              syntaxError(next);
            }
            case 4: {
              syntaxError(next);
            }
            case 5: {
              Symbol sym2 = (Symbol) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce20(sym1, sym2);
              stack.push(_result);
              stateStack.pop();
              state = gotos[stateStack.peek()][10];
              break;
            }
            case 6: {
              syntaxError(next);
            }
            case 7: {
              syntaxError(next);
            }
            case 8: {
              syntaxError(next);
            }
            case 9: {
              syntaxError(next);
            }
            case 10: {
              syntaxError(next);
            }
            case 11: {
              syntaxError(next);
            }
            case 12: {
              syntaxError(next);
            }
            case 13: {
              syntaxError(next);
            }
            case 14: {
              syntaxError(next);
            }
            case 15: {
              syntaxError(next);
            }
            case 16: {
              Symbol sym2 = (Symbol) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce20(sym1, sym2);
              stack.push(_result);
              stateStack.pop();
              state = gotos[stateStack.peek()][10];
              break;
            }
            case 17: {
              Symbol sym2 = (Symbol) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce20(sym1, sym2);
              stack.push(_result);
              stateStack.pop();
              state = gotos[stateStack.peek()][10];
              break;
            }
            case 18: {
              syntaxError(next);
            }
            case 19: {
              syntaxError(next);
            }
            case 20: {
              syntaxError(next);
            }
            case 21: {
              Symbol sym2 = (Symbol) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce20(sym1, sym2);
              stack.push(_result);
              stateStack.pop();
              state = gotos[stateStack.peek()][10];
              break;
            }
            case 22: {
              syntaxError(next);
            }
            case 23: {
              syntaxError(next);
            }
            case 24: {
              syntaxError(next);
            }
            case 25: {
              Symbol sym2 = (Symbol) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce20(sym1, sym2);
              stack.push(_result);
              stateStack.pop();
              state = gotos[stateStack.peek()][10];
              break;
            }
          }
          break;
        case 59:
          if (DEBUG) System.out.format("[%s] ", next);
          switch (next.getId()) {
            case 0: {
              syntaxError(next);
            }
            case 1: {
              syntaxError(next);
            }
            case 2: {
              syntaxError(next);
            }
            case 3: {
              syntaxError(next);
            }
            case 4: {
              syntaxError(next);
            }
            case 5: {
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce5(sym1);
              stack.push(_result);
              state = gotos[stateStack.peek()][7];
              break;
            }
            case 6: {
              syntaxError(next);
            }
            case 7: {
              syntaxError(next);
            }
            case 8: {
              syntaxError(next);
            }
            case 9: {
              syntaxError(next);
            }
            case 10: {
              syntaxError(next);
            }
            case 11: {
              syntaxError(next);
            }
            case 12: {
              syntaxError(next);
            }
            case 13: {
              syntaxError(next);
            }
            case 14: {
              syntaxError(next);
            }
            case 15: {
              stateStack.push(state);
              stack.push(next);
              state = 76;
              next = nextToken(in);
              break;
            }
            case 16: {
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce5(sym1);
              stack.push(_result);
              state = gotos[stateStack.peek()][7];
              break;
            }
            case 17: {
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce5(sym1);
              stack.push(_result);
              state = gotos[stateStack.peek()][7];
              break;
            }
            case 18: {
              syntaxError(next);
            }
            case 19: {
              syntaxError(next);
            }
            case 20: {
              syntaxError(next);
            }
            case 21: {
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce5(sym1);
              stack.push(_result);
              state = gotos[stateStack.peek()][7];
              break;
            }
            case 22: {
              syntaxError(next);
            }
            case 23: {
              syntaxError(next);
            }
            case 24: {
              syntaxError(next);
            }
            case 25: {
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce5(sym1);
              stack.push(_result);
              state = gotos[stateStack.peek()][7];
              break;
            }
          }
          break;
        case 60:
          if (DEBUG) System.out.format("[%s] ", next);
          switch (next.getId()) {
            case 0: {
              Symbol sym4 = (Symbol) stack.pop();
              Symbol sym3 = (Symbol) stack.pop();
              Symbol sym2 = (Symbol) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce21(sym1, sym2, sym3, sym4);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][2];
              break;
            }
            case 1: {
              Symbol sym4 = (Symbol) stack.pop();
              Symbol sym3 = (Symbol) stack.pop();
              Symbol sym2 = (Symbol) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce21(sym1, sym2, sym3, sym4);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][2];
              break;
            }
            case 2: {
              syntaxError(next);
            }
            case 3: {
              syntaxError(next);
            }
            case 4: {
              syntaxError(next);
            }
            case 5: {
              Symbol sym4 = (Symbol) stack.pop();
              Symbol sym3 = (Symbol) stack.pop();
              Symbol sym2 = (Symbol) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce21(sym1, sym2, sym3, sym4);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][2];
              break;
            }
            case 6: {
              Symbol sym4 = (Symbol) stack.pop();
              Symbol sym3 = (Symbol) stack.pop();
              Symbol sym2 = (Symbol) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce21(sym1, sym2, sym3, sym4);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][2];
              break;
            }
            case 7: {
              Symbol sym4 = (Symbol) stack.pop();
              Symbol sym3 = (Symbol) stack.pop();
              Symbol sym2 = (Symbol) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce21(sym1, sym2, sym3, sym4);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][2];
              break;
            }
            case 8: {
              syntaxError(next);
            }
            case 9: {
              Symbol sym4 = (Symbol) stack.pop();
              Symbol sym3 = (Symbol) stack.pop();
              Symbol sym2 = (Symbol) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce21(sym1, sym2, sym3, sym4);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][2];
              break;
            }
            case 10: {
              Symbol sym4 = (Symbol) stack.pop();
              Symbol sym3 = (Symbol) stack.pop();
              Symbol sym2 = (Symbol) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce21(sym1, sym2, sym3, sym4);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][2];
              break;
            }
            case 11: {
              syntaxError(next);
            }
            case 12: {
              syntaxError(next);
            }
            case 13: {
              Symbol sym4 = (Symbol) stack.pop();
              Symbol sym3 = (Symbol) stack.pop();
              Symbol sym2 = (Symbol) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce21(sym1, sym2, sym3, sym4);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][2];
              break;
            }
            case 14: {
              syntaxError(next);
            }
            case 15: {
              syntaxError(next);
            }
            case 16: {
              syntaxError(next);
            }
            case 17: {
              syntaxError(next);
            }
            case 18: {
              Symbol sym4 = (Symbol) stack.pop();
              Symbol sym3 = (Symbol) stack.pop();
              Symbol sym2 = (Symbol) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce21(sym1, sym2, sym3, sym4);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][2];
              break;
            }
            case 19: {
              syntaxError(next);
            }
            case 20: {
              Symbol sym4 = (Symbol) stack.pop();
              Symbol sym3 = (Symbol) stack.pop();
              Symbol sym2 = (Symbol) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce21(sym1, sym2, sym3, sym4);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][2];
              break;
            }
            case 21: {
              syntaxError(next);
            }
            case 22: {
              Symbol sym4 = (Symbol) stack.pop();
              Symbol sym3 = (Symbol) stack.pop();
              Symbol sym2 = (Symbol) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce21(sym1, sym2, sym3, sym4);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][2];
              break;
            }
            case 23: {
              Symbol sym4 = (Symbol) stack.pop();
              Symbol sym3 = (Symbol) stack.pop();
              Symbol sym2 = (Symbol) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce21(sym1, sym2, sym3, sym4);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][2];
              break;
            }
            case 24: {
              syntaxError(next);
            }
            case 25: {
              syntaxError(next);
            }
          }
          break;
        case 61:
          if (DEBUG) System.out.format("[%s] ", next);
          switch (next.getId()) {
            case 0: {
              syntaxError(next);
            }
            case 1: {
              syntaxError(next);
            }
            case 2: {
              syntaxError(next);
            }
            case 3: {
              syntaxError(next);
            }
            case 4: {
              syntaxError(next);
            }
            case 5: {
              Symbol sym2 = (Symbol) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce22(sym1, sym2);
              stack.push(_result);
              stateStack.pop();
              state = gotos[stateStack.peek()][10];
              break;
            }
            case 6: {
              syntaxError(next);
            }
            case 7: {
              syntaxError(next);
            }
            case 8: {
              syntaxError(next);
            }
            case 9: {
              syntaxError(next);
            }
            case 10: {
              syntaxError(next);
            }
            case 11: {
              syntaxError(next);
            }
            case 12: {
              syntaxError(next);
            }
            case 13: {
              syntaxError(next);
            }
            case 14: {
              syntaxError(next);
            }
            case 15: {
              syntaxError(next);
            }
            case 16: {
              Symbol sym2 = (Symbol) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce22(sym1, sym2);
              stack.push(_result);
              stateStack.pop();
              state = gotos[stateStack.peek()][10];
              break;
            }
            case 17: {
              Symbol sym2 = (Symbol) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce22(sym1, sym2);
              stack.push(_result);
              stateStack.pop();
              state = gotos[stateStack.peek()][10];
              break;
            }
            case 18: {
              syntaxError(next);
            }
            case 19: {
              syntaxError(next);
            }
            case 20: {
              syntaxError(next);
            }
            case 21: {
              Symbol sym2 = (Symbol) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce22(sym1, sym2);
              stack.push(_result);
              stateStack.pop();
              state = gotos[stateStack.peek()][10];
              break;
            }
            case 22: {
              syntaxError(next);
            }
            case 23: {
              syntaxError(next);
            }
            case 24: {
              syntaxError(next);
            }
            case 25: {
              Symbol sym2 = (Symbol) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce22(sym1, sym2);
              stack.push(_result);
              stateStack.pop();
              state = gotos[stateStack.peek()][10];
              break;
            }
          }
          break;
        case 62:
          if (DEBUG) System.out.format("[%s] ", next);
          switch (next.getId()) {
            case 0: {
              syntaxError(next);
            }
            case 1: {
              syntaxError(next);
            }
            case 2: {
              syntaxError(next);
            }
            case 3: {
              syntaxError(next);
            }
            case 4: {
              syntaxError(next);
            }
            case 5: {
              Symbol sym2 = (Symbol) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce23(sym1, sym2);
              stack.push(_result);
              stateStack.pop();
              state = gotos[stateStack.peek()][10];
              break;
            }
            case 6: {
              syntaxError(next);
            }
            case 7: {
              syntaxError(next);
            }
            case 8: {
              syntaxError(next);
            }
            case 9: {
              syntaxError(next);
            }
            case 10: {
              syntaxError(next);
            }
            case 11: {
              syntaxError(next);
            }
            case 12: {
              syntaxError(next);
            }
            case 13: {
              syntaxError(next);
            }
            case 14: {
              syntaxError(next);
            }
            case 15: {
              syntaxError(next);
            }
            case 16: {
              Symbol sym2 = (Symbol) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce23(sym1, sym2);
              stack.push(_result);
              stateStack.pop();
              state = gotos[stateStack.peek()][10];
              break;
            }
            case 17: {
              Symbol sym2 = (Symbol) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce23(sym1, sym2);
              stack.push(_result);
              stateStack.pop();
              state = gotos[stateStack.peek()][10];
              break;
            }
            case 18: {
              syntaxError(next);
            }
            case 19: {
              syntaxError(next);
            }
            case 20: {
              syntaxError(next);
            }
            case 21: {
              Symbol sym2 = (Symbol) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce23(sym1, sym2);
              stack.push(_result);
              stateStack.pop();
              state = gotos[stateStack.peek()][10];
              break;
            }
            case 22: {
              syntaxError(next);
            }
            case 23: {
              syntaxError(next);
            }
            case 24: {
              syntaxError(next);
            }
            case 25: {
              Symbol sym2 = (Symbol) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce23(sym1, sym2);
              stack.push(_result);
              stateStack.pop();
              state = gotos[stateStack.peek()][10];
              break;
            }
          }
          break;
        case 63:
          if (DEBUG) System.out.format("[%s] ", next);
          switch (next.getId()) {
            case 0: {
              syntaxError(next);
            }
            case 1: {
              syntaxError(next);
            }
            case 2: {
              syntaxError(next);
            }
            case 3: {
              syntaxError(next);
            }
            case 4: {
              syntaxError(next);
            }
            case 5: {
              Symbol sym2 = (Symbol) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce24(sym1, sym2);
              stack.push(_result);
              stateStack.pop();
              state = gotos[stateStack.peek()][10];
              break;
            }
            case 6: {
              syntaxError(next);
            }
            case 7: {
              syntaxError(next);
            }
            case 8: {
              syntaxError(next);
            }
            case 9: {
              syntaxError(next);
            }
            case 10: {
              syntaxError(next);
            }
            case 11: {
              syntaxError(next);
            }
            case 12: {
              syntaxError(next);
            }
            case 13: {
              syntaxError(next);
            }
            case 14: {
              syntaxError(next);
            }
            case 15: {
              syntaxError(next);
            }
            case 16: {
              Symbol sym2 = (Symbol) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce24(sym1, sym2);
              stack.push(_result);
              stateStack.pop();
              state = gotos[stateStack.peek()][10];
              break;
            }
            case 17: {
              Symbol sym2 = (Symbol) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce24(sym1, sym2);
              stack.push(_result);
              stateStack.pop();
              state = gotos[stateStack.peek()][10];
              break;
            }
            case 18: {
              syntaxError(next);
            }
            case 19: {
              syntaxError(next);
            }
            case 20: {
              syntaxError(next);
            }
            case 21: {
              Symbol sym2 = (Symbol) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce24(sym1, sym2);
              stack.push(_result);
              stateStack.pop();
              state = gotos[stateStack.peek()][10];
              break;
            }
            case 22: {
              syntaxError(next);
            }
            case 23: {
              syntaxError(next);
            }
            case 24: {
              syntaxError(next);
            }
            case 25: {
              Symbol sym2 = (Symbol) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce24(sym1, sym2);
              stack.push(_result);
              stateStack.pop();
              state = gotos[stateStack.peek()][10];
              break;
            }
          }
          break;
        case 64:
          if (DEBUG) System.out.format("[%s] ", next);
          switch (next.getId()) {
            case 0: {
              syntaxError(next);
            }
            case 1: {
              syntaxError(next);
            }
            case 2: {
              syntaxError(next);
            }
            case 3: {
              syntaxError(next);
            }
            case 4: {
              syntaxError(next);
            }
            case 5: {
              syntaxError(next);
            }
            case 6: {
              syntaxError(next);
            }
            case 7: {
              syntaxError(next);
            }
            case 8: {
              syntaxError(next);
            }
            case 9: {
              syntaxError(next);
            }
            case 10: {
              syntaxError(next);
            }
            case 11: {
              syntaxError(next);
            }
            case 12: {
              syntaxError(next);
            }
            case 13: {
              syntaxError(next);
            }
            case 14: {
              syntaxError(next);
            }
            case 15: {
              syntaxError(next);
            }
            case 16: {
              Symbol sym2 = (Symbol) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce25(sym1, sym2);
              stack.push(_result);
              stateStack.pop();
              state = gotos[stateStack.peek()][4];
              break;
            }
            case 17: {
              Symbol sym2 = (Symbol) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce25(sym1, sym2);
              stack.push(_result);
              stateStack.pop();
              state = gotos[stateStack.peek()][4];
              break;
            }
            case 18: {
              syntaxError(next);
            }
            case 19: {
              syntaxError(next);
            }
            case 20: {
              syntaxError(next);
            }
            case 21: {
              syntaxError(next);
            }
            case 22: {
              syntaxError(next);
            }
            case 23: {
              syntaxError(next);
            }
            case 24: {
              syntaxError(next);
            }
            case 25: {
              syntaxError(next);
            }
          }
          break;
        case 65:
          if (DEBUG) System.out.format("[%s] ", next);
          switch (next.getId()) {
            case 0: {
              syntaxError(next);
            }
            case 1: {
              syntaxError(next);
            }
            case 2: {
              syntaxError(next);
            }
            case 3: {
              syntaxError(next);
            }
            case 4: {
              syntaxError(next);
            }
            case 5: {
              syntaxError(next);
            }
            case 6: {
              syntaxError(next);
            }
            case 7: {
              syntaxError(next);
            }
            case 8: {
              syntaxError(next);
            }
            case 9: {
              syntaxError(next);
            }
            case 10: {
              syntaxError(next);
            }
            case 11: {
              syntaxError(next);
            }
            case 12: {
              syntaxError(next);
            }
            case 13: {
              syntaxError(next);
            }
            case 14: {
              stateStack.push(state);
              stack.push(next);
              state = 75;
              next = nextToken(in);
              break;
            }
            case 15: {
              syntaxError(next);
            }
            case 16: {
              syntaxError(next);
            }
            case 17: {
              syntaxError(next);
            }
            case 18: {
              syntaxError(next);
            }
            case 19: {
              syntaxError(next);
            }
            case 20: {
              syntaxError(next);
            }
            case 21: {
              syntaxError(next);
            }
            case 22: {
              syntaxError(next);
            }
            case 23: {
              syntaxError(next);
            }
            case 24: {
              syntaxError(next);
            }
            case 25: {
              syntaxError(next);
            }
          }
          break;
        case 66:
          if (DEBUG) System.out.format("[%s] ", next);
          switch (next.getId()) {
            case 0: {
              syntaxError(next);
            }
            case 1: {
              syntaxError(next);
            }
            case 2: {
              syntaxError(next);
            }
            case 3: {
              syntaxError(next);
            }
            case 4: {
              syntaxError(next);
            }
            case 5: {
              Symbol sym2 = (Symbol) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce26(sym1, sym2);
              stack.push(_result);
              stateStack.pop();
              state = gotos[stateStack.peek()][5];
              break;
            }
            case 6: {
              syntaxError(next);
            }
            case 7: {
              syntaxError(next);
            }
            case 8: {
              syntaxError(next);
            }
            case 9: {
              syntaxError(next);
            }
            case 10: {
              syntaxError(next);
            }
            case 11: {
              syntaxError(next);
            }
            case 12: {
              syntaxError(next);
            }
            case 13: {
              syntaxError(next);
            }
            case 14: {
              syntaxError(next);
            }
            case 15: {
              syntaxError(next);
            }
            case 16: {
              Symbol sym2 = (Symbol) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce26(sym1, sym2);
              stack.push(_result);
              stateStack.pop();
              state = gotos[stateStack.peek()][5];
              break;
            }
            case 17: {
              Symbol sym2 = (Symbol) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce26(sym1, sym2);
              stack.push(_result);
              stateStack.pop();
              state = gotos[stateStack.peek()][5];
              break;
            }
            case 18: {
              syntaxError(next);
            }
            case 19: {
              syntaxError(next);
            }
            case 20: {
              syntaxError(next);
            }
            case 21: {
              Symbol sym2 = (Symbol) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce26(sym1, sym2);
              stack.push(_result);
              stateStack.pop();
              state = gotos[stateStack.peek()][5];
              break;
            }
            case 22: {
              syntaxError(next);
            }
            case 23: {
              syntaxError(next);
            }
            case 24: {
              syntaxError(next);
            }
            case 25: {
              Symbol sym2 = (Symbol) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce26(sym1, sym2);
              stack.push(_result);
              stateStack.pop();
              state = gotos[stateStack.peek()][5];
              break;
            }
          }
          break;
        case 67:
          if (DEBUG) System.out.format("[%s] ", next);
          switch (next.getId()) {
            case 0: {
              syntaxError(next);
            }
            case 1: {
              syntaxError(next);
            }
            case 2: {
              syntaxError(next);
            }
            case 3: {
              syntaxError(next);
            }
            case 4: {
              syntaxError(next);
            }
            case 5: {
              stateStack.push(state);
              stack.push(next);
              state = 74;
              next = nextToken(in);
              break;
            }
            case 6: {
              syntaxError(next);
            }
            case 7: {
              syntaxError(next);
            }
            case 8: {
              syntaxError(next);
            }
            case 9: {
              syntaxError(next);
            }
            case 10: {
              syntaxError(next);
            }
            case 11: {
              syntaxError(next);
            }
            case 12: {
              syntaxError(next);
            }
            case 13: {
              syntaxError(next);
            }
            case 14: {
              syntaxError(next);
            }
            case 15: {
              syntaxError(next);
            }
            case 16: {
              syntaxError(next);
            }
            case 17: {
              syntaxError(next);
            }
            case 18: {
              syntaxError(next);
            }
            case 19: {
              syntaxError(next);
            }
            case 20: {
              syntaxError(next);
            }
            case 21: {
              syntaxError(next);
            }
            case 22: {
              syntaxError(next);
            }
            case 23: {
              syntaxError(next);
            }
            case 24: {
              syntaxError(next);
            }
            case 25: {
              syntaxError(next);
            }
          }
          break;
        case 68:
          if (DEBUG) System.out.format("[%s] ", next);
          switch (next.getId()) {
            case 0: {
              syntaxError(next);
            }
            case 1: {
              syntaxError(next);
            }
            case 2: {
              syntaxError(next);
            }
            case 3: {
              syntaxError(next);
            }
            case 4: {
              syntaxError(next);
            }
            case 5: {
              syntaxError(next);
            }
            case 6: {
              syntaxError(next);
            }
            case 7: {
              syntaxError(next);
            }
            case 8: {
              syntaxError(next);
            }
            case 9: {
              syntaxError(next);
            }
            case 10: {
              syntaxError(next);
            }
            case 11: {
              syntaxError(next);
            }
            case 12: {
              syntaxError(next);
            }
            case 13: {
              syntaxError(next);
            }
            case 14: {
              syntaxError(next);
            }
            case 15: {
              syntaxError(next);
            }
            case 16: {
              stateStack.push(state);
              stack.push(next);
              state = 73;
              next = nextToken(in);
              break;
            }
            case 17: {
              stateStack.push(state);
              stack.push(next);
              state = 56;
              next = nextToken(in);
              break;
            }
            case 18: {
              syntaxError(next);
            }
            case 19: {
              syntaxError(next);
            }
            case 20: {
              syntaxError(next);
            }
            case 21: {
              syntaxError(next);
            }
            case 22: {
              syntaxError(next);
            }
            case 23: {
              syntaxError(next);
            }
            case 24: {
              syntaxError(next);
            }
            case 25: {
              syntaxError(next);
            }
          }
          break;
        case 69:
          if (DEBUG) System.out.format("[%s] ", next);
          switch (next.getId()) {
            case 0: {
              syntaxError(next);
            }
            case 1: {
              syntaxError(next);
            }
            case 2: {
              syntaxError(next);
            }
            case 3: {
              syntaxError(next);
            }
            case 4: {
              syntaxError(next);
            }
            case 5: {
              syntaxError(next);
            }
            case 6: {
              syntaxError(next);
            }
            case 7: {
              syntaxError(next);
            }
            case 8: {
              syntaxError(next);
            }
            case 9: {
              syntaxError(next);
            }
            case 10: {
              syntaxError(next);
            }
            case 11: {
              syntaxError(next);
            }
            case 12: {
              syntaxError(next);
            }
            case 13: {
              syntaxError(next);
            }
            case 14: {
              syntaxError(next);
            }
            case 15: {
              syntaxError(next);
            }
            case 16: {
              stateStack.push(state);
              stack.push(next);
              state = 72;
              next = nextToken(in);
              break;
            }
            case 17: {
              stateStack.push(state);
              stack.push(next);
              state = 56;
              next = nextToken(in);
              break;
            }
            case 18: {
              syntaxError(next);
            }
            case 19: {
              syntaxError(next);
            }
            case 20: {
              syntaxError(next);
            }
            case 21: {
              syntaxError(next);
            }
            case 22: {
              syntaxError(next);
            }
            case 23: {
              syntaxError(next);
            }
            case 24: {
              syntaxError(next);
            }
            case 25: {
              syntaxError(next);
            }
          }
          break;
        case 70:
          if (DEBUG) System.out.format("[%s] ", next);
          switch (next.getId()) {
            case 0: {
              syntaxError(next);
            }
            case 1: {
              syntaxError(next);
            }
            case 2: {
              syntaxError(next);
            }
            case 3: {
              syntaxError(next);
            }
            case 4: {
              syntaxError(next);
            }
            case 5: {
              syntaxError(next);
            }
            case 6: {
              syntaxError(next);
            }
            case 7: {
              syntaxError(next);
            }
            case 8: {
              syntaxError(next);
            }
            case 9: {
              syntaxError(next);
            }
            case 10: {
              syntaxError(next);
            }
            case 11: {
              syntaxError(next);
            }
            case 12: {
              syntaxError(next);
            }
            case 13: {
              syntaxError(next);
            }
            case 14: {
              syntaxError(next);
            }
            case 15: {
              syntaxError(next);
            }
            case 16: {
              stateStack.push(state);
              stack.push(next);
              state = 71;
              next = nextToken(in);
              break;
            }
            case 17: {
              syntaxError(next);
            }
            case 18: {
              syntaxError(next);
            }
            case 19: {
              syntaxError(next);
            }
            case 20: {
              syntaxError(next);
            }
            case 21: {
              syntaxError(next);
            }
            case 22: {
              syntaxError(next);
            }
            case 23: {
              syntaxError(next);
            }
            case 24: {
              syntaxError(next);
            }
            case 25: {
              syntaxError(next);
            }
          }
          break;
        case 71:
          if (DEBUG) System.out.format("[%s] ", next);
          switch (next.getId()) {
            case 0: {
              Symbol sym5 = (Symbol) stack.pop();
              Symbol sym4 = (Symbol) stack.pop();
              Symbol sym3 = (Symbol) stack.pop();
              Symbol sym2 = (Symbol) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce27(sym1, sym2, sym3, sym4, sym5);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][2];
              break;
            }
            case 1: {
              Symbol sym5 = (Symbol) stack.pop();
              Symbol sym4 = (Symbol) stack.pop();
              Symbol sym3 = (Symbol) stack.pop();
              Symbol sym2 = (Symbol) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce27(sym1, sym2, sym3, sym4, sym5);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][2];
              break;
            }
            case 2: {
              syntaxError(next);
            }
            case 3: {
              syntaxError(next);
            }
            case 4: {
              syntaxError(next);
            }
            case 5: {
              Symbol sym5 = (Symbol) stack.pop();
              Symbol sym4 = (Symbol) stack.pop();
              Symbol sym3 = (Symbol) stack.pop();
              Symbol sym2 = (Symbol) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce27(sym1, sym2, sym3, sym4, sym5);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][2];
              break;
            }
            case 6: {
              Symbol sym5 = (Symbol) stack.pop();
              Symbol sym4 = (Symbol) stack.pop();
              Symbol sym3 = (Symbol) stack.pop();
              Symbol sym2 = (Symbol) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce27(sym1, sym2, sym3, sym4, sym5);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][2];
              break;
            }
            case 7: {
              Symbol sym5 = (Symbol) stack.pop();
              Symbol sym4 = (Symbol) stack.pop();
              Symbol sym3 = (Symbol) stack.pop();
              Symbol sym2 = (Symbol) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce27(sym1, sym2, sym3, sym4, sym5);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][2];
              break;
            }
            case 8: {
              syntaxError(next);
            }
            case 9: {
              Symbol sym5 = (Symbol) stack.pop();
              Symbol sym4 = (Symbol) stack.pop();
              Symbol sym3 = (Symbol) stack.pop();
              Symbol sym2 = (Symbol) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce27(sym1, sym2, sym3, sym4, sym5);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][2];
              break;
            }
            case 10: {
              Symbol sym5 = (Symbol) stack.pop();
              Symbol sym4 = (Symbol) stack.pop();
              Symbol sym3 = (Symbol) stack.pop();
              Symbol sym2 = (Symbol) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce27(sym1, sym2, sym3, sym4, sym5);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][2];
              break;
            }
            case 11: {
              syntaxError(next);
            }
            case 12: {
              syntaxError(next);
            }
            case 13: {
              Symbol sym5 = (Symbol) stack.pop();
              Symbol sym4 = (Symbol) stack.pop();
              Symbol sym3 = (Symbol) stack.pop();
              Symbol sym2 = (Symbol) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce27(sym1, sym2, sym3, sym4, sym5);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][2];
              break;
            }
            case 14: {
              syntaxError(next);
            }
            case 15: {
              syntaxError(next);
            }
            case 16: {
              syntaxError(next);
            }
            case 17: {
              syntaxError(next);
            }
            case 18: {
              Symbol sym5 = (Symbol) stack.pop();
              Symbol sym4 = (Symbol) stack.pop();
              Symbol sym3 = (Symbol) stack.pop();
              Symbol sym2 = (Symbol) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce27(sym1, sym2, sym3, sym4, sym5);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][2];
              break;
            }
            case 19: {
              syntaxError(next);
            }
            case 20: {
              Symbol sym5 = (Symbol) stack.pop();
              Symbol sym4 = (Symbol) stack.pop();
              Symbol sym3 = (Symbol) stack.pop();
              Symbol sym2 = (Symbol) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce27(sym1, sym2, sym3, sym4, sym5);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][2];
              break;
            }
            case 21: {
              syntaxError(next);
            }
            case 22: {
              Symbol sym5 = (Symbol) stack.pop();
              Symbol sym4 = (Symbol) stack.pop();
              Symbol sym3 = (Symbol) stack.pop();
              Symbol sym2 = (Symbol) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce27(sym1, sym2, sym3, sym4, sym5);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][2];
              break;
            }
            case 23: {
              Symbol sym5 = (Symbol) stack.pop();
              Symbol sym4 = (Symbol) stack.pop();
              Symbol sym3 = (Symbol) stack.pop();
              Symbol sym2 = (Symbol) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce27(sym1, sym2, sym3, sym4, sym5);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][2];
              break;
            }
            case 24: {
              syntaxError(next);
            }
            case 25: {
              syntaxError(next);
            }
          }
          break;
        case 72:
          if (DEBUG) System.out.format("[%s] ", next);
          switch (next.getId()) {
            case 0: {
              Symbol sym5 = (Symbol) stack.pop();
              Symbol sym4 = (Symbol) stack.pop();
              Symbol sym3 = (Symbol) stack.pop();
              Symbol sym2 = (Symbol) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce28(sym1, sym2, sym3, sym4, sym5);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][2];
              break;
            }
            case 1: {
              Symbol sym5 = (Symbol) stack.pop();
              Symbol sym4 = (Symbol) stack.pop();
              Symbol sym3 = (Symbol) stack.pop();
              Symbol sym2 = (Symbol) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce28(sym1, sym2, sym3, sym4, sym5);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][2];
              break;
            }
            case 2: {
              syntaxError(next);
            }
            case 3: {
              syntaxError(next);
            }
            case 4: {
              syntaxError(next);
            }
            case 5: {
              Symbol sym5 = (Symbol) stack.pop();
              Symbol sym4 = (Symbol) stack.pop();
              Symbol sym3 = (Symbol) stack.pop();
              Symbol sym2 = (Symbol) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce28(sym1, sym2, sym3, sym4, sym5);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][2];
              break;
            }
            case 6: {
              Symbol sym5 = (Symbol) stack.pop();
              Symbol sym4 = (Symbol) stack.pop();
              Symbol sym3 = (Symbol) stack.pop();
              Symbol sym2 = (Symbol) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce28(sym1, sym2, sym3, sym4, sym5);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][2];
              break;
            }
            case 7: {
              Symbol sym5 = (Symbol) stack.pop();
              Symbol sym4 = (Symbol) stack.pop();
              Symbol sym3 = (Symbol) stack.pop();
              Symbol sym2 = (Symbol) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce28(sym1, sym2, sym3, sym4, sym5);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][2];
              break;
            }
            case 8: {
              syntaxError(next);
            }
            case 9: {
              Symbol sym5 = (Symbol) stack.pop();
              Symbol sym4 = (Symbol) stack.pop();
              Symbol sym3 = (Symbol) stack.pop();
              Symbol sym2 = (Symbol) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce28(sym1, sym2, sym3, sym4, sym5);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][2];
              break;
            }
            case 10: {
              Symbol sym5 = (Symbol) stack.pop();
              Symbol sym4 = (Symbol) stack.pop();
              Symbol sym3 = (Symbol) stack.pop();
              Symbol sym2 = (Symbol) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce28(sym1, sym2, sym3, sym4, sym5);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][2];
              break;
            }
            case 11: {
              syntaxError(next);
            }
            case 12: {
              syntaxError(next);
            }
            case 13: {
              Symbol sym5 = (Symbol) stack.pop();
              Symbol sym4 = (Symbol) stack.pop();
              Symbol sym3 = (Symbol) stack.pop();
              Symbol sym2 = (Symbol) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce28(sym1, sym2, sym3, sym4, sym5);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][2];
              break;
            }
            case 14: {
              syntaxError(next);
            }
            case 15: {
              syntaxError(next);
            }
            case 16: {
              syntaxError(next);
            }
            case 17: {
              syntaxError(next);
            }
            case 18: {
              Symbol sym5 = (Symbol) stack.pop();
              Symbol sym4 = (Symbol) stack.pop();
              Symbol sym3 = (Symbol) stack.pop();
              Symbol sym2 = (Symbol) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce28(sym1, sym2, sym3, sym4, sym5);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][2];
              break;
            }
            case 19: {
              syntaxError(next);
            }
            case 20: {
              Symbol sym5 = (Symbol) stack.pop();
              Symbol sym4 = (Symbol) stack.pop();
              Symbol sym3 = (Symbol) stack.pop();
              Symbol sym2 = (Symbol) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce28(sym1, sym2, sym3, sym4, sym5);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][2];
              break;
            }
            case 21: {
              syntaxError(next);
            }
            case 22: {
              Symbol sym5 = (Symbol) stack.pop();
              Symbol sym4 = (Symbol) stack.pop();
              Symbol sym3 = (Symbol) stack.pop();
              Symbol sym2 = (Symbol) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce28(sym1, sym2, sym3, sym4, sym5);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][2];
              break;
            }
            case 23: {
              Symbol sym5 = (Symbol) stack.pop();
              Symbol sym4 = (Symbol) stack.pop();
              Symbol sym3 = (Symbol) stack.pop();
              Symbol sym2 = (Symbol) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce28(sym1, sym2, sym3, sym4, sym5);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][2];
              break;
            }
            case 24: {
              syntaxError(next);
            }
            case 25: {
              syntaxError(next);
            }
          }
          break;
        case 73:
          if (DEBUG) System.out.format("[%s] ", next);
          switch (next.getId()) {
            case 0: {
              Symbol sym5 = (Symbol) stack.pop();
              Symbol sym4 = (Symbol) stack.pop();
              Symbol sym3 = (Symbol) stack.pop();
              Symbol sym2 = (Symbol) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce29(sym1, sym2, sym3, sym4, sym5);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][2];
              break;
            }
            case 1: {
              Symbol sym5 = (Symbol) stack.pop();
              Symbol sym4 = (Symbol) stack.pop();
              Symbol sym3 = (Symbol) stack.pop();
              Symbol sym2 = (Symbol) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce29(sym1, sym2, sym3, sym4, sym5);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][2];
              break;
            }
            case 2: {
              syntaxError(next);
            }
            case 3: {
              syntaxError(next);
            }
            case 4: {
              syntaxError(next);
            }
            case 5: {
              Symbol sym5 = (Symbol) stack.pop();
              Symbol sym4 = (Symbol) stack.pop();
              Symbol sym3 = (Symbol) stack.pop();
              Symbol sym2 = (Symbol) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce29(sym1, sym2, sym3, sym4, sym5);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][2];
              break;
            }
            case 6: {
              Symbol sym5 = (Symbol) stack.pop();
              Symbol sym4 = (Symbol) stack.pop();
              Symbol sym3 = (Symbol) stack.pop();
              Symbol sym2 = (Symbol) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce29(sym1, sym2, sym3, sym4, sym5);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][2];
              break;
            }
            case 7: {
              Symbol sym5 = (Symbol) stack.pop();
              Symbol sym4 = (Symbol) stack.pop();
              Symbol sym3 = (Symbol) stack.pop();
              Symbol sym2 = (Symbol) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce29(sym1, sym2, sym3, sym4, sym5);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][2];
              break;
            }
            case 8: {
              syntaxError(next);
            }
            case 9: {
              Symbol sym5 = (Symbol) stack.pop();
              Symbol sym4 = (Symbol) stack.pop();
              Symbol sym3 = (Symbol) stack.pop();
              Symbol sym2 = (Symbol) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce29(sym1, sym2, sym3, sym4, sym5);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][2];
              break;
            }
            case 10: {
              Symbol sym5 = (Symbol) stack.pop();
              Symbol sym4 = (Symbol) stack.pop();
              Symbol sym3 = (Symbol) stack.pop();
              Symbol sym2 = (Symbol) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce29(sym1, sym2, sym3, sym4, sym5);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][2];
              break;
            }
            case 11: {
              syntaxError(next);
            }
            case 12: {
              syntaxError(next);
            }
            case 13: {
              Symbol sym5 = (Symbol) stack.pop();
              Symbol sym4 = (Symbol) stack.pop();
              Symbol sym3 = (Symbol) stack.pop();
              Symbol sym2 = (Symbol) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce29(sym1, sym2, sym3, sym4, sym5);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][2];
              break;
            }
            case 14: {
              syntaxError(next);
            }
            case 15: {
              syntaxError(next);
            }
            case 16: {
              syntaxError(next);
            }
            case 17: {
              syntaxError(next);
            }
            case 18: {
              Symbol sym5 = (Symbol) stack.pop();
              Symbol sym4 = (Symbol) stack.pop();
              Symbol sym3 = (Symbol) stack.pop();
              Symbol sym2 = (Symbol) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce29(sym1, sym2, sym3, sym4, sym5);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][2];
              break;
            }
            case 19: {
              syntaxError(next);
            }
            case 20: {
              Symbol sym5 = (Symbol) stack.pop();
              Symbol sym4 = (Symbol) stack.pop();
              Symbol sym3 = (Symbol) stack.pop();
              Symbol sym2 = (Symbol) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce29(sym1, sym2, sym3, sym4, sym5);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][2];
              break;
            }
            case 21: {
              syntaxError(next);
            }
            case 22: {
              Symbol sym5 = (Symbol) stack.pop();
              Symbol sym4 = (Symbol) stack.pop();
              Symbol sym3 = (Symbol) stack.pop();
              Symbol sym2 = (Symbol) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce29(sym1, sym2, sym3, sym4, sym5);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][2];
              break;
            }
            case 23: {
              Symbol sym5 = (Symbol) stack.pop();
              Symbol sym4 = (Symbol) stack.pop();
              Symbol sym3 = (Symbol) stack.pop();
              Symbol sym2 = (Symbol) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce29(sym1, sym2, sym3, sym4, sym5);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][2];
              break;
            }
            case 24: {
              syntaxError(next);
            }
            case 25: {
              syntaxError(next);
            }
          }
          break;
        case 74:
          if (DEBUG) System.out.format("[%s] ", next);
          switch (next.getId()) {
            case 0: {
              syntaxError(next);
            }
            case 1: {
              syntaxError(next);
            }
            case 2: {
              Symbol sym3 = (Symbol) stack.pop();
              Symbol sym2 = (Symbol) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce30(sym1, sym2, sym3);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][7];
              break;
            }
            case 3: {
              syntaxError(next);
            }
            case 4: {
              Symbol sym3 = (Symbol) stack.pop();
              Symbol sym2 = (Symbol) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce30(sym1, sym2, sym3);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][7];
              break;
            }
            case 5: {
              Symbol sym3 = (Symbol) stack.pop();
              Symbol sym2 = (Symbol) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce30(sym1, sym2, sym3);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][7];
              break;
            }
            case 6: {
              syntaxError(next);
            }
            case 7: {
              syntaxError(next);
            }
            case 8: {
              syntaxError(next);
            }
            case 9: {
              syntaxError(next);
            }
            case 10: {
              syntaxError(next);
            }
            case 11: {
              syntaxError(next);
            }
            case 12: {
              syntaxError(next);
            }
            case 13: {
              syntaxError(next);
            }
            case 14: {
              syntaxError(next);
            }
            case 15: {
              syntaxError(next);
            }
            case 16: {
              Symbol sym3 = (Symbol) stack.pop();
              Symbol sym2 = (Symbol) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce30(sym1, sym2, sym3);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][7];
              break;
            }
            case 17: {
              Symbol sym3 = (Symbol) stack.pop();
              Symbol sym2 = (Symbol) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce30(sym1, sym2, sym3);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][7];
              break;
            }
            case 18: {
              syntaxError(next);
            }
            case 19: {
              Symbol sym3 = (Symbol) stack.pop();
              Symbol sym2 = (Symbol) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce30(sym1, sym2, sym3);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][7];
              break;
            }
            case 20: {
              syntaxError(next);
            }
            case 21: {
              Symbol sym3 = (Symbol) stack.pop();
              Symbol sym2 = (Symbol) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce30(sym1, sym2, sym3);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][7];
              break;
            }
            case 22: {
              syntaxError(next);
            }
            case 23: {
              syntaxError(next);
            }
            case 24: {
              syntaxError(next);
            }
            case 25: {
              Symbol sym3 = (Symbol) stack.pop();
              Symbol sym2 = (Symbol) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce30(sym1, sym2, sym3);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][7];
              break;
            }
          }
          break;
        case 75:
          if (DEBUG) System.out.format("[%s] ", next);
          switch (next.getId()) {
            case 0: {
              syntaxError(next);
            }
            case 1: {
              syntaxError(next);
            }
            case 2: {
              syntaxError(next);
            }
            case 3: {
              syntaxError(next);
            }
            case 4: {
              syntaxError(next);
            }
            case 5: {
              syntaxError(next);
            }
            case 6: {
              syntaxError(next);
            }
            case 7: {
              syntaxError(next);
            }
            case 8: {
              syntaxError(next);
            }
            case 9: {
              syntaxError(next);
            }
            case 10: {
              syntaxError(next);
            }
            case 11: {
              syntaxError(next);
            }
            case 12: {
              stateStack.push(state);
              stack.push(next);
              state = 81;
              next = nextToken(in);
              break;
            }
            case 13: {
              syntaxError(next);
            }
            case 14: {
              syntaxError(next);
            }
            case 15: {
              syntaxError(next);
            }
            case 16: {
              syntaxError(next);
            }
            case 17: {
              syntaxError(next);
            }
            case 18: {
              syntaxError(next);
            }
            case 19: {
              syntaxError(next);
            }
            case 20: {
              syntaxError(next);
            }
            case 21: {
              syntaxError(next);
            }
            case 22: {
              syntaxError(next);
            }
            case 23: {
              syntaxError(next);
            }
            case 24: {
              syntaxError(next);
            }
            case 25: {
              syntaxError(next);
            }
          }
          break;
        case 76:
          if (DEBUG) System.out.format("[%s] ", next);
          switch (next.getId()) {
            case 0: {
              syntaxError(next);
            }
            case 1: {
              syntaxError(next);
            }
            case 2: {
              syntaxError(next);
            }
            case 3: {
              syntaxError(next);
            }
            case 4: {
              syntaxError(next);
            }
            case 5: {
              stateStack.push(state);
              stack.push(next);
              state = 80;
              next = nextToken(in);
              break;
            }
            case 6: {
              syntaxError(next);
            }
            case 7: {
              syntaxError(next);
            }
            case 8: {
              syntaxError(next);
            }
            case 9: {
              syntaxError(next);
            }
            case 10: {
              syntaxError(next);
            }
            case 11: {
              syntaxError(next);
            }
            case 12: {
              syntaxError(next);
            }
            case 13: {
              syntaxError(next);
            }
            case 14: {
              syntaxError(next);
            }
            case 15: {
              syntaxError(next);
            }
            case 16: {
              syntaxError(next);
            }
            case 17: {
              syntaxError(next);
            }
            case 18: {
              syntaxError(next);
            }
            case 19: {
              syntaxError(next);
            }
            case 20: {
              syntaxError(next);
            }
            case 21: {
              syntaxError(next);
            }
            case 22: {
              syntaxError(next);
            }
            case 23: {
              syntaxError(next);
            }
            case 24: {
              syntaxError(next);
            }
            case 25: {
              syntaxError(next);
            }
          }
          break;
        case 77:
          if (DEBUG) System.out.format("[%s] ", next);
          switch (next.getId()) {
            case 0: {
              syntaxError(next);
            }
            case 1: {
              syntaxError(next);
            }
            case 2: {
              syntaxError(next);
            }
            case 3: {
              syntaxError(next);
            }
            case 4: {
              syntaxError(next);
            }
            case 5: {
              syntaxError(next);
            }
            case 6: {
              syntaxError(next);
            }
            case 7: {
              syntaxError(next);
            }
            case 8: {
              syntaxError(next);
            }
            case 9: {
              syntaxError(next);
            }
            case 10: {
              syntaxError(next);
            }
            case 11: {
              syntaxError(next);
            }
            case 12: {
              syntaxError(next);
            }
            case 13: {
              syntaxError(next);
            }
            case 14: {
              syntaxError(next);
            }
            case 15: {
              syntaxError(next);
            }
            case 16: {
              Symbol sym3 = (Symbol) stack.pop();
              Symbol sym2 = (Symbol) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce31(sym1, sym2, sym3);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][8];
              break;
            }
            case 17: {
              Symbol sym3 = (Symbol) stack.pop();
              Symbol sym2 = (Symbol) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce31(sym1, sym2, sym3);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][8];
              break;
            }
            case 18: {
              syntaxError(next);
            }
            case 19: {
              syntaxError(next);
            }
            case 20: {
              syntaxError(next);
            }
            case 21: {
              syntaxError(next);
            }
            case 22: {
              syntaxError(next);
            }
            case 23: {
              syntaxError(next);
            }
            case 24: {
              syntaxError(next);
            }
            case 25: {
              syntaxError(next);
            }
          }
          break;
        case 78:
          if (DEBUG) System.out.format("[%s] ", next);
          switch (next.getId()) {
            case 0: {
              Symbol sym5 = (Symbol) stack.pop();
              Symbol sym4 = (Symbol) stack.pop();
              Symbol sym3 = (Symbol) stack.pop();
              Symbol sym2 = (Symbol) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce32(sym1, sym2, sym3, sym4, sym5);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][2];
              break;
            }
            case 1: {
              Symbol sym5 = (Symbol) stack.pop();
              Symbol sym4 = (Symbol) stack.pop();
              Symbol sym3 = (Symbol) stack.pop();
              Symbol sym2 = (Symbol) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce32(sym1, sym2, sym3, sym4, sym5);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][2];
              break;
            }
            case 2: {
              syntaxError(next);
            }
            case 3: {
              syntaxError(next);
            }
            case 4: {
              syntaxError(next);
            }
            case 5: {
              Symbol sym5 = (Symbol) stack.pop();
              Symbol sym4 = (Symbol) stack.pop();
              Symbol sym3 = (Symbol) stack.pop();
              Symbol sym2 = (Symbol) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce32(sym1, sym2, sym3, sym4, sym5);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][2];
              break;
            }
            case 6: {
              Symbol sym5 = (Symbol) stack.pop();
              Symbol sym4 = (Symbol) stack.pop();
              Symbol sym3 = (Symbol) stack.pop();
              Symbol sym2 = (Symbol) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce32(sym1, sym2, sym3, sym4, sym5);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][2];
              break;
            }
            case 7: {
              Symbol sym5 = (Symbol) stack.pop();
              Symbol sym4 = (Symbol) stack.pop();
              Symbol sym3 = (Symbol) stack.pop();
              Symbol sym2 = (Symbol) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce32(sym1, sym2, sym3, sym4, sym5);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][2];
              break;
            }
            case 8: {
              syntaxError(next);
            }
            case 9: {
              Symbol sym5 = (Symbol) stack.pop();
              Symbol sym4 = (Symbol) stack.pop();
              Symbol sym3 = (Symbol) stack.pop();
              Symbol sym2 = (Symbol) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce32(sym1, sym2, sym3, sym4, sym5);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][2];
              break;
            }
            case 10: {
              Symbol sym5 = (Symbol) stack.pop();
              Symbol sym4 = (Symbol) stack.pop();
              Symbol sym3 = (Symbol) stack.pop();
              Symbol sym2 = (Symbol) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce32(sym1, sym2, sym3, sym4, sym5);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][2];
              break;
            }
            case 11: {
              syntaxError(next);
            }
            case 12: {
              syntaxError(next);
            }
            case 13: {
              Symbol sym5 = (Symbol) stack.pop();
              Symbol sym4 = (Symbol) stack.pop();
              Symbol sym3 = (Symbol) stack.pop();
              Symbol sym2 = (Symbol) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce32(sym1, sym2, sym3, sym4, sym5);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][2];
              break;
            }
            case 14: {
              syntaxError(next);
            }
            case 15: {
              syntaxError(next);
            }
            case 16: {
              syntaxError(next);
            }
            case 17: {
              syntaxError(next);
            }
            case 18: {
              Symbol sym5 = (Symbol) stack.pop();
              Symbol sym4 = (Symbol) stack.pop();
              Symbol sym3 = (Symbol) stack.pop();
              Symbol sym2 = (Symbol) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce32(sym1, sym2, sym3, sym4, sym5);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][2];
              break;
            }
            case 19: {
              syntaxError(next);
            }
            case 20: {
              Symbol sym5 = (Symbol) stack.pop();
              Symbol sym4 = (Symbol) stack.pop();
              Symbol sym3 = (Symbol) stack.pop();
              Symbol sym2 = (Symbol) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce32(sym1, sym2, sym3, sym4, sym5);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][2];
              break;
            }
            case 21: {
              syntaxError(next);
            }
            case 22: {
              Symbol sym5 = (Symbol) stack.pop();
              Symbol sym4 = (Symbol) stack.pop();
              Symbol sym3 = (Symbol) stack.pop();
              Symbol sym2 = (Symbol) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce32(sym1, sym2, sym3, sym4, sym5);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][2];
              break;
            }
            case 23: {
              Symbol sym5 = (Symbol) stack.pop();
              Symbol sym4 = (Symbol) stack.pop();
              Symbol sym3 = (Symbol) stack.pop();
              Symbol sym2 = (Symbol) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce32(sym1, sym2, sym3, sym4, sym5);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][2];
              break;
            }
            case 24: {
              syntaxError(next);
            }
            case 25: {
              syntaxError(next);
            }
          }
          break;
        case 79:
          if (DEBUG) System.out.format("[%s] ", next);
          switch (next.getId()) {
            case 0: {
              Symbol sym5 = (Symbol) stack.pop();
              Symbol sym4 = (Symbol) stack.pop();
              Symbol sym3 = (Symbol) stack.pop();
              Symbol sym2 = (Symbol) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce33(sym1, sym2, sym3, sym4, sym5);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][2];
              break;
            }
            case 1: {
              Symbol sym5 = (Symbol) stack.pop();
              Symbol sym4 = (Symbol) stack.pop();
              Symbol sym3 = (Symbol) stack.pop();
              Symbol sym2 = (Symbol) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce33(sym1, sym2, sym3, sym4, sym5);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][2];
              break;
            }
            case 2: {
              syntaxError(next);
            }
            case 3: {
              syntaxError(next);
            }
            case 4: {
              syntaxError(next);
            }
            case 5: {
              Symbol sym5 = (Symbol) stack.pop();
              Symbol sym4 = (Symbol) stack.pop();
              Symbol sym3 = (Symbol) stack.pop();
              Symbol sym2 = (Symbol) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce33(sym1, sym2, sym3, sym4, sym5);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][2];
              break;
            }
            case 6: {
              Symbol sym5 = (Symbol) stack.pop();
              Symbol sym4 = (Symbol) stack.pop();
              Symbol sym3 = (Symbol) stack.pop();
              Symbol sym2 = (Symbol) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce33(sym1, sym2, sym3, sym4, sym5);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][2];
              break;
            }
            case 7: {
              Symbol sym5 = (Symbol) stack.pop();
              Symbol sym4 = (Symbol) stack.pop();
              Symbol sym3 = (Symbol) stack.pop();
              Symbol sym2 = (Symbol) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce33(sym1, sym2, sym3, sym4, sym5);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][2];
              break;
            }
            case 8: {
              syntaxError(next);
            }
            case 9: {
              Symbol sym5 = (Symbol) stack.pop();
              Symbol sym4 = (Symbol) stack.pop();
              Symbol sym3 = (Symbol) stack.pop();
              Symbol sym2 = (Symbol) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce33(sym1, sym2, sym3, sym4, sym5);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][2];
              break;
            }
            case 10: {
              Symbol sym5 = (Symbol) stack.pop();
              Symbol sym4 = (Symbol) stack.pop();
              Symbol sym3 = (Symbol) stack.pop();
              Symbol sym2 = (Symbol) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce33(sym1, sym2, sym3, sym4, sym5);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][2];
              break;
            }
            case 11: {
              syntaxError(next);
            }
            case 12: {
              syntaxError(next);
            }
            case 13: {
              Symbol sym5 = (Symbol) stack.pop();
              Symbol sym4 = (Symbol) stack.pop();
              Symbol sym3 = (Symbol) stack.pop();
              Symbol sym2 = (Symbol) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce33(sym1, sym2, sym3, sym4, sym5);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][2];
              break;
            }
            case 14: {
              syntaxError(next);
            }
            case 15: {
              syntaxError(next);
            }
            case 16: {
              syntaxError(next);
            }
            case 17: {
              syntaxError(next);
            }
            case 18: {
              Symbol sym5 = (Symbol) stack.pop();
              Symbol sym4 = (Symbol) stack.pop();
              Symbol sym3 = (Symbol) stack.pop();
              Symbol sym2 = (Symbol) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce33(sym1, sym2, sym3, sym4, sym5);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][2];
              break;
            }
            case 19: {
              syntaxError(next);
            }
            case 20: {
              Symbol sym5 = (Symbol) stack.pop();
              Symbol sym4 = (Symbol) stack.pop();
              Symbol sym3 = (Symbol) stack.pop();
              Symbol sym2 = (Symbol) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce33(sym1, sym2, sym3, sym4, sym5);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][2];
              break;
            }
            case 21: {
              syntaxError(next);
            }
            case 22: {
              Symbol sym5 = (Symbol) stack.pop();
              Symbol sym4 = (Symbol) stack.pop();
              Symbol sym3 = (Symbol) stack.pop();
              Symbol sym2 = (Symbol) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce33(sym1, sym2, sym3, sym4, sym5);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][2];
              break;
            }
            case 23: {
              Symbol sym5 = (Symbol) stack.pop();
              Symbol sym4 = (Symbol) stack.pop();
              Symbol sym3 = (Symbol) stack.pop();
              Symbol sym2 = (Symbol) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce33(sym1, sym2, sym3, sym4, sym5);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][2];
              break;
            }
            case 24: {
              syntaxError(next);
            }
            case 25: {
              syntaxError(next);
            }
          }
          break;
        case 80:
          if (DEBUG) System.out.format("[%s] ", next);
          switch (next.getId()) {
            case 0: {
              syntaxError(next);
            }
            case 1: {
              syntaxError(next);
            }
            case 2: {
              syntaxError(next);
            }
            case 3: {
              syntaxError(next);
            }
            case 4: {
              syntaxError(next);
            }
            case 5: {
              Symbol sym3 = (Symbol) stack.pop();
              Symbol sym2 = (Symbol) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce30(sym1, sym2, sym3);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][7];
              break;
            }
            case 6: {
              syntaxError(next);
            }
            case 7: {
              syntaxError(next);
            }
            case 8: {
              syntaxError(next);
            }
            case 9: {
              syntaxError(next);
            }
            case 10: {
              syntaxError(next);
            }
            case 11: {
              syntaxError(next);
            }
            case 12: {
              syntaxError(next);
            }
            case 13: {
              syntaxError(next);
            }
            case 14: {
              syntaxError(next);
            }
            case 15: {
              syntaxError(next);
            }
            case 16: {
              Symbol sym3 = (Symbol) stack.pop();
              Symbol sym2 = (Symbol) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce30(sym1, sym2, sym3);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][7];
              break;
            }
            case 17: {
              Symbol sym3 = (Symbol) stack.pop();
              Symbol sym2 = (Symbol) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce30(sym1, sym2, sym3);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][7];
              break;
            }
            case 18: {
              syntaxError(next);
            }
            case 19: {
              syntaxError(next);
            }
            case 20: {
              syntaxError(next);
            }
            case 21: {
              Symbol sym3 = (Symbol) stack.pop();
              Symbol sym2 = (Symbol) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce30(sym1, sym2, sym3);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][7];
              break;
            }
            case 22: {
              syntaxError(next);
            }
            case 23: {
              syntaxError(next);
            }
            case 24: {
              syntaxError(next);
            }
            case 25: {
              Symbol sym3 = (Symbol) stack.pop();
              Symbol sym2 = (Symbol) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce30(sym1, sym2, sym3);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][7];
              break;
            }
          }
          break;
        case 81:
          if (DEBUG) System.out.format("[%s] ", next);
          switch (next.getId()) {
            case 0: {
              syntaxError(next);
            }
            case 1: {
              syntaxError(next);
            }
            case 2: {
              syntaxError(next);
            }
            case 3: {
              syntaxError(next);
            }
            case 4: {
              syntaxError(next);
            }
            case 5: {
              syntaxError(next);
            }
            case 6: {
              syntaxError(next);
            }
            case 7: {
              syntaxError(next);
            }
            case 8: {
              syntaxError(next);
            }
            case 9: {
              syntaxError(next);
            }
            case 10: {
              syntaxError(next);
            }
            case 11: {
              syntaxError(next);
            }
            case 12: {
              syntaxError(next);
            }
            case 13: {
              syntaxError(next);
            }
            case 14: {
              syntaxError(next);
            }
            case 15: {
              syntaxError(next);
            }
            case 16: {
              Symbol sym3 = (Symbol) stack.pop();
              Symbol sym2 = (Symbol) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce34(sym1, sym2, sym3);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][3];
              break;
            }
            case 17: {
              Symbol sym3 = (Symbol) stack.pop();
              Symbol sym2 = (Symbol) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce34(sym1, sym2, sym3);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][3];
              break;
            }
            case 18: {
              syntaxError(next);
            }
            case 19: {
              syntaxError(next);
            }
            case 20: {
              syntaxError(next);
            }
            case 21: {
              syntaxError(next);
            }
            case 22: {
              syntaxError(next);
            }
            case 23: {
              syntaxError(next);
            }
            case 24: {
              syntaxError(next);
            }
            case 25: {
              syntaxError(next);
            }
          }
          break;
    }
    }
    return stack.pop();
  }


  Symbol reduce7(Symbol componentList) {
    // componentListOpt -> componentList
    if (DEBUG) System.out.println("componentListOpt -> componentList");
    return componentList;
  }

  Symbol reduce27(Symbol EMBED, Symbol CODE_START, Symbol JAVA_CODE, Symbol CODE_END, Symbol SEMICOLON) {
    // production -> EMBED CODE_START JAVA_CODE CODE_END SEMICOLON
    if (DEBUG) System.out.println("production -> EMBED CODE_START JAVA_CODE CODE_END SEMICOLON");
    return new Nonterminal("directive", EMBED, CODE_START, JAVA_CODE, CODE_END);
  }

  Symbol reduce30(Symbol id1, Symbol DOT, Symbol id2) {
    // symbol -> ID DOT ID
    if (DEBUG) System.out.println("symbol -> ID DOT ID");
    return new Nonterminal("symbol", id1, DOT, id2);
  }

  Symbol reduce1(Symbol ID) {
    // symList -> ID
    if (DEBUG) System.out.println("symList -> ID");
    return new Nonterminal("symList", ID);
  }

  Symbol reduce10(Symbol component) {
    // componentList -> component
    if (DEBUG) System.out.println("componentList -> component");
    return new Nonterminal("componentList", component);
  }

  Symbol reduce20(Symbol AT, Symbol symbol) {
    // component -> AT symbol
    if (DEBUG) System.out.println("component -> AT symbol");
    return new Nonterminal("precedence", AT, symbol);
  }

  Symbol reduce29(Symbol type, Symbol name, Symbol EQ, Symbol ruleList, Symbol SEMICOLON) {
    // production -> ID ID EQ ruleList SEMICOLON
    if (DEBUG) System.out.println("production -> ID ID EQ ruleList SEMICOLON");
    return new Nonterminal("production", type, name, EQ, ruleList, SEMICOLON);
  }

  Symbol reduce11(Symbol CLASS, Symbol STRING, Symbol SEMICOLON) {
    // production -> CLASS STRING SEMICOLON
    if (DEBUG) System.out.println("production -> CLASS STRING SEMICOLON");
    return new Nonterminal("directive", CLASS, STRING, SEMICOLON);
  }

  Symbol reduce13(Symbol RIGHT, Symbol symList, Symbol SEMICOLON) {
    // production -> RIGHT symList SEMICOLON
    if (DEBUG) System.out.println("production -> RIGHT symList SEMICOLON");
    return new Nonterminal("directive", RIGHT, symList, SEMICOLON);
  }

  Symbol reduce32(Symbol TYPEOF, Symbol ID, Symbol EQ, Symbol STRING, Symbol SEMICOLON) {
    // production -> TYPEOF ID EQ STRING SEMICOLON
    if (DEBUG) System.out.println("production -> TYPEOF ID EQ STRING SEMICOLON");
    return new Nonterminal("directive", TYPEOF, ID, EQ, STRING, SEMICOLON);
  }

  Symbol reduce12(Symbol PACKAGE, Symbol STRING, Symbol SEMICOLON) {
    // production -> PACKAGE STRING SEMICOLON
    if (DEBUG) System.out.println("production -> PACKAGE STRING SEMICOLON");
    return new Nonterminal("directive", PACKAGE, STRING, SEMICOLON);
  }

  Symbol reduce23(Symbol symbol, Symbol QUESTION) {
    // component -> symbol QUESTION
    if (DEBUG) System.out.println("component -> symbol QUESTION");
    return new Nonterminal("component", symbol, QUESTION);
  }

  Symbol reduce0(Symbol production) {
    // productionList -> production
    if (DEBUG) System.out.println("productionList -> production");
    return new Nonterminal("productionList", production);
  }

  Symbol reduce25(Symbol componentListOpt, Symbol semanticAction) {
    // rule -> componentListOpt semanticAction
    if (DEBUG) System.out.println("rule -> componentListOpt semanticAction");
    return new Nonterminal("rule", componentListOpt, semanticAction);
  }

  Symbol reduce24(Symbol symbol, Symbol PLUS) {
    // component -> symbol PLUS
    if (DEBUG) System.out.println("component -> symbol PLUS");
    return new Nonterminal("component", symbol, PLUS);
  }

  Symbol reduce5(Symbol ID) {
    // symbol -> ID
    if (DEBUG) System.out.println("symbol -> ID");
    return new Nonterminal("symbol", ID);
  }

  Symbol reduce8(Symbol componentListOpt) {
    // rule -> componentListOpt
    if (DEBUG) System.out.println("rule -> componentListOpt");
    return new Nonterminal("rule", componentListOpt);
  }

  Symbol reduce15(Symbol GOAL, Symbol ID, Symbol SEMICOLON) {
    // production -> GOAL ID SEMICOLON
    if (DEBUG) System.out.println("production -> GOAL ID SEMICOLON");
    return new Nonterminal("directive", GOAL, ID, SEMICOLON);
  }

  Symbol reduce26(Symbol componentList, Symbol component) {
    // componentList -> componentList component
    if (DEBUG) System.out.println("componentList -> componentList component");
    return new Nonterminal("componentList", componentList, component);
  }

  Symbol reduce19(Symbol name, Symbol COLONEQ, Symbol ruleList, Symbol SEMICOLON) {
    // production -> ID COLONEQ ruleList SEMICOLON
    if (DEBUG) System.out.println("production -> ID COLONEQ ruleList SEMICOLON");
    return new Nonterminal("production", new EmptyOpt(), name, COLONEQ, ruleList, SEMICOLON);
  }

  Symbol reduce34(Symbol CODE_START, Symbol JAVA_CODE, Symbol CODE_END) {
    // semanticAction -> CODE_START JAVA_CODE CODE_END
    if (DEBUG) System.out.println("semanticAction -> CODE_START JAVA_CODE CODE_END");
    return new Nonterminal("semanticAction", CODE_START, JAVA_CODE, CODE_END);
  }

  Symbol reduce31(Symbol ruleList, Symbol OR, Symbol rule) {
    // ruleList -> ruleList OR rule
    if (DEBUG) System.out.println("ruleList -> ruleList OR rule");
    return new Nonterminal("ruleList", ruleList, OR, rule);
  }

  Symbol reduce33(Symbol HEADER, Symbol CODE_START, Symbol JAVA_CODE, Symbol CODE_END, Symbol SEMICOLON) {
    // production -> HEADER CODE_START JAVA_CODE CODE_END SEMICOLON
    if (DEBUG) System.out.println("production -> HEADER CODE_START JAVA_CODE CODE_END SEMICOLON");
    return new Nonterminal("directive", HEADER, CODE_START, JAVA_CODE, CODE_END);
  }

  Symbol reduce4() {
    // componentListOpt -> 
    if (DEBUG) System.out.println("componentListOpt -> ");
    return new Nonterminal("componentList");
  }

  Symbol reduce16(Symbol NONASSOC, Symbol symList, Symbol SEMICOLON) {
    // production -> NONASSOC symList SEMICOLON
    if (DEBUG) System.out.println("production -> NONASSOC symList SEMICOLON");
    return new Nonterminal("directive", NONASSOC, symList, SEMICOLON);
  }

  Symbol reduce9(Symbol symbol) {
    // component -> symbol
    if (DEBUG) System.out.println("component -> symbol");
    return new Nonterminal("component", symbol);
  }

  Symbol reduce14(Symbol TERMINALS, Symbol symList, Symbol SEMICOLON) {
    // production -> TERMINALS symList SEMICOLON
    if (DEBUG) System.out.println("production -> TERMINALS symList SEMICOLON");
    return new Nonterminal("directive", TERMINALS, symList, SEMICOLON);
  }

  Symbol reduce22(Symbol symbol, Symbol ASTERISK) {
    // component -> symbol ASTERISK
    if (DEBUG) System.out.println("component -> symbol ASTERISK");
    return new Nonterminal("component", symbol, ASTERISK);
  }

  Symbol reduce2(Symbol productionList, Symbol production) {
    // productionList -> productionList production
    if (DEBUG) System.out.println("productionList -> productionList production");
    return new Nonterminal("productionList", productionList, production);
  }

  Symbol reduce3(Symbol productionList, Symbol sym2) {
    // S' -> productionList $
    if (DEBUG) System.out.println("S' -> productionList $");
    return productionList;
  }

  Symbol reduce28(Symbol type, Symbol name, Symbol COLONEQ, Symbol ruleList, Symbol SEMICOLON) {
    // production -> ID ID COLONEQ ruleList SEMICOLON
    if (DEBUG) System.out.println("production -> ID ID COLONEQ ruleList SEMICOLON");
    return new Nonterminal("production", type, name, COLONEQ, ruleList, SEMICOLON);
  }

  Symbol reduce21(Symbol name, Symbol EQ, Symbol ruleList, Symbol SEMICOLON) {
    // production -> ID EQ ruleList SEMICOLON
    if (DEBUG) System.out.println("production -> ID EQ ruleList SEMICOLON");
    return new Nonterminal("production", new EmptyOpt(), name, EQ, ruleList, SEMICOLON);
  }

  Symbol reduce18(Symbol symList, Symbol COMMA, Symbol ID) {
    // symList -> symList COMMA ID
    if (DEBUG) System.out.println("symList -> symList COMMA ID");
    return new Nonterminal("symList", symList, COMMA, ID);
  }

  Symbol reduce6(Symbol rule) {
    // ruleList -> rule
    if (DEBUG) System.out.println("ruleList -> rule");
    return new Nonterminal("ruleList", rule);
  }

  Symbol reduce17(Symbol LEFT, Symbol symList, Symbol SEMICOLON) {
    // production -> LEFT symList SEMICOLON
    if (DEBUG) System.out.println("production -> LEFT symList SEMICOLON");
    return new Nonterminal("directive", LEFT, symList, SEMICOLON);
  }

  private static final int[][] gotos = {
    { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, },
    { -1, 0, 3, 0, 0, 0, 0, 0, 0, 13, 0, },
    { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, },
    { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, },
    { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, },
    { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, },
    { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, },
    { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, },
    { 0, 23, 0, 0, 0, 0, 0, 0, 0, 0, 0, },
    { 0, 22, 0, 0, 0, 0, 0, 0, 0, 0, 0, },
    { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, },
    { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, },
    { 0, 19, 0, 0, 0, 0, 0, 0, 0, 0, 0, },
    { 0, 0, 17, 0, 0, 0, 0, 0, 0, 0, 0, },
    { 0, 15, 0, 0, 0, 0, 0, 0, 0, 0, 0, },
    { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, },
    { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, },
    { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, },
    { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, },
    { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, },
    { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, },
    { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, },
    { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, },
    { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, },
    { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, },
    { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, },
    { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, },
    { 0, 0, 0, 0, 35, 36, 37, 38, 42, 0, 40, },
    { 0, 0, 0, 0, 35, 36, 37, 38, 39, 0, 40, },
    { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, },
    { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, },
    { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, },
    { 0, 0, 0, 0, 35, 36, 37, 38, 69, 0, 40, },
    { 0, 0, 0, 0, 35, 36, 37, 38, 68, 0, 40, },
    { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, },
    { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, },
    { 0, 0, 0, 0, 0, 0, 0, 38, 0, 0, 66, },
    { 0, 0, 0, 64, 0, 0, 0, 0, 0, 0, 0, },
    { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, },
    { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, },
    { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, },
    { 0, 0, 0, 0, 0, 0, 0, 58, 0, 0, 0, },
    { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, },
    { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, },
    { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, },
    { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, },
    { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, },
    { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, },
    { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, },
    { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, },
    { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, },
    { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, },
    { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, },
    { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, },
    { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, },
    { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, },
    { 0, 0, 0, 0, 77, 36, 37, 38, 0, 0, 40, },
    { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, },
    { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, },
    { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, },
    { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, },
    { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, },
    { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, },
    { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, },
    { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, },
    { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, },
    { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, },
    { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, },
    { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, },
    { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, },
    { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, },
    { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, },
    { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, },
    { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, },
    { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, },
    { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, },
    { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, },
    { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, },
    { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, },
    { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, },
    { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, },
  };

/* Parser table:
Transition Table
----------------
	S',	EMBED,	symList,	production,	$,	QUESTION,	COMMA,	PLUS,	semanticAction,	ID,	CLASS,	PACKAGE,	STRING,	TYPEOF,	RIGHT,	rule,	componentList,	componentListOpt,	COLONEQ,	CODE_END,	TERMINALS,	symbol,	JAVA_CODE,	DOT,	SEMICOLON,	OR,	ruleList,	HEADER,	ASTERISK,	GOAL,	CODE_START,	NONASSOC,	productionList,	component,	LEFT,	EQ,	AT,
S1	,	S2,	,	S3,	,	,	,	,	,	S4,	S5,	S6,	,	S7,	S8,	,	,	,	,	,	S9,	,	,	,	,	,	,	S10,	,	S11,	,	S12,	S13,	,	S14,	,	,
S2	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	S30,	,	,	,	,	,	,
S3	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,
S4	,	,	,	,	,	,	,	,	,	S29,	,	,	,	,	,	,	,	,	S27,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	S28,	,
S5	,	,	,	,	,	,	,	,	,	,	,	,	S26,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,
S6	,	,	,	,	,	,	,	,	,	,	,	,	S25,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,
S7	,	,	,	,	,	,	,	,	,	S24,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,
S8	,	,	S23,	,	,	,	,	,	,	S16,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,
S9	,	,	S22,	,	,	,	,	,	,	S16,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,
S10	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	S21,	,	,	,	,	,	,
S11	,	,	,	,	,	,	,	,	,	S20,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,
S12	,	,	S19,	,	,	,	,	,	,	S16,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,
S13	,	S2,	,	S17,	S18,	,	,	,	,	S4,	S5,	S6,	,	S7,	S8,	,	,	,	,	,	S9,	,	,	,	,	,	,	S10,	,	S11,	,	S12,	,	,	S14,	,	,
S14	,	,	S15,	,	,	,	,	,	,	S16,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,
S15	,	,	,	,	,	,	S46,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	S52,	,	,	,	,	,	,	,	,	,	,	,	,
S16	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,
S17	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,
S18	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,
S19	,	,	,	,	,	,	S46,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	S51,	,	,	,	,	,	,	,	,	,	,	,	,
S20	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	S50,	,	,	,	,	,	,	,	,	,	,	,	,
S21	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	S49,	,	,	,	,	,	,	,	,	,	,	,	,	,	,
S22	,	,	,	,	,	,	S46,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	S48,	,	,	,	,	,	,	,	,	,	,	,	,
S23	,	,	,	,	,	,	S46,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	S47,	,	,	,	,	,	,	,	,	,	,	,	,
S24	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	S45,	,
S25	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	S44,	,	,	,	,	,	,	,	,	,	,	,	,
S26	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	S43,	,	,	,	,	,	,	,	,	,	,	,	,
S27	,	,	,	,	,	,	,	,	,	S34,	,	,	,	,	,	S35,	S36,	S37,	,	,	,	S38,	,	,	,	,	S42,	,	,	,	,	,	,	S40,	,	,	S41,
S28	,	,	,	,	,	,	,	,	,	S34,	,	,	,	,	,	S35,	S36,	S37,	,	,	,	S38,	,	,	,	,	S39,	,	,	,	,	,	,	S40,	,	,	S41,
S29	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	S32,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	S33,	,
S30	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	S31,	,	,	,	,	,	,	,	,	,	,	,	,	,	,
S31	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	S70,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,
S32	,	,	,	,	,	,	,	,	,	S34,	,	,	,	,	,	S35,	S36,	S37,	,	,	,	S38,	,	,	,	,	S69,	,	,	,	,	,	,	S40,	,	,	S41,
S33	,	,	,	,	,	,	,	,	,	S34,	,	,	,	,	,	S35,	S36,	S37,	,	,	,	S38,	,	,	,	,	S68,	,	,	,	,	,	,	S40,	,	,	S41,
S34	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	S67,	,	,	,	,	,	,	,	,	,	,	,	,	,
S35	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,
S36	,	,	,	,	,	,	,	,	,	S34,	,	,	,	,	,	,	,	,	,	,	,	S38,	,	,	,	,	,	,	,	,	,	,	,	S66,	,	,	S41,
S37	,	,	,	,	,	,	,	,	S64,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	S65,	,	,	,	,	,	,
S38	,	,	,	,	,	S62,	,	S63,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	S61,	,	,	,	,	,	,	,	,
S39	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	S60,	S56,	,	,	,	,	,	,	,	,	,	,	,
S40	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,
S41	,	,	,	,	,	,	,	,	,	S59,	,	,	,	,	,	,	,	,	,	,	,	S58,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,
S42	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	S57,	S56,	,	,	,	,	,	,	,	,	,	,	,
S43	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,
S44	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,
S45	,	,	,	,	,	,	,	,	,	,	,	,	S55,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,
S46	,	,	,	,	,	,	,	,	,	S54,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,
S47	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,
S48	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,
S49	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	S53,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,
S50	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,
S51	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,
S52	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,
S53	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	S79,	,	,	,	,	,	,	,	,	,	,	,	,
S54	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,
S55	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	S78,	,	,	,	,	,	,	,	,	,	,	,	,
S56	,	,	,	,	,	,	,	,	,	S34,	,	,	,	,	,	S77,	S36,	S37,	,	,	,	S38,	,	,	,	,	,	,	,	,	,	,	,	S40,	,	,	S41,
S57	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,
S58	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,
S59	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	S76,	,	,	,	,	,	,	,	,	,	,	,	,	,
S60	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,
S61	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,
S62	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,
S63	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,
S64	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,
S65	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	S75,	,	,	,	,	,	,	,	,	,	,	,	,	,	,
S66	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,
S67	,	,	,	,	,	,	,	,	,	S74,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,
S68	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	S73,	S56,	,	,	,	,	,	,	,	,	,	,	,
S69	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	S72,	S56,	,	,	,	,	,	,	,	,	,	,	,
S70	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	S71,	,	,	,	,	,	,	,	,	,	,	,	,
S71	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,
S72	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,
S73	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,
S74	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,
S75	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	S81,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,
S76	,	,	,	,	,	,	,	,	,	S80,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,
S77	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,
S78	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,
S79	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,
S80	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,
S81	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,

Action Table
------------
	EMBED,	$,	QUESTION,	COMMA,	PLUS,	ID,	CLASS,	PACKAGE,	STRING,	TYPEOF,	RIGHT,	COLONEQ,	CODE_END,	TERMINALS,	JAVA_CODE,	DOT,	SEMICOLON,	OR,	HEADER,	ASTERISK,	GOAL,	CODE_START,	NONASSOC,	LEFT,	EQ,	AT,
S1	s2,	,	,	,	,	s4,	s5,	s6,	,	s7,	s8,	,	,	s9,	,	,	,	,	s10,	,	s11,	,	s12,	s14,	,	,
S2	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	s30,	,	,	,	,
S3	r2,	r2,	,	,	,	r2,	r2,	r2,	,	r2,	r2,	,	,	r2,	,	,	,	,	r2,	,	r2,	,	r2,	r2,	,	,
S4	,	,	,	,	,	s29,	,	,	,	,	,	s27,	,	,	,	,	,	,	,	,	,	,	,	,	s28,	,
S5	,	,	,	,	,	,	,	,	s26,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,
S6	,	,	,	,	,	,	,	,	s25,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,
S7	,	,	,	,	,	s24,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,
S8	,	,	,	,	,	s16,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,
S9	,	,	,	,	,	s16,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,
S10	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	s21,	,	,	,	,
S11	,	,	,	,	,	s20,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,
S12	,	,	,	,	,	s16,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,
S13	s2,	s18,	,	,	,	s4,	s5,	s6,	,	s7,	s8,	,	,	s9,	,	,	,	,	s10,	,	s11,	,	s12,	s14,	,	,
S14	,	,	,	,	,	s16,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,
S15	,	,	,	s46,	,	,	,	,	,	,	,	,	,	,	,	,	s52,	,	,	,	,	,	,	,	,	,
S16	,	,	,	r18,	,	,	,	,	,	,	,	,	,	,	,	,	r18,	,	,	,	,	,	,	,	,	,
S17	r1,	r1,	,	,	,	r1,	r1,	r1,	,	r1,	r1,	,	,	r1,	,	,	,	,	r1,	,	r1,	,	r1,	r1,	,	,
S18	,	r0,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,
S19	,	,	,	s46,	,	,	,	,	,	,	,	,	,	,	,	,	s51,	,	,	,	,	,	,	,	,	,
S20	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	s50,	,	,	,	,	,	,	,	,	,
S21	,	,	,	,	,	,	,	,	,	,	,	,	,	,	s49,	,	,	,	,	,	,	,	,	,	,	,
S22	,	,	,	s46,	,	,	,	,	,	,	,	,	,	,	,	,	s48,	,	,	,	,	,	,	,	,	,
S23	,	,	,	s46,	,	,	,	,	,	,	,	,	,	,	,	,	s47,	,	,	,	,	,	,	,	,	,
S24	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	s45,	,
S25	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	s44,	,	,	,	,	,	,	,	,	,
S26	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	s43,	,	,	,	,	,	,	,	,	,
S27	,	,	,	,	,	s34,	,	,	,	,	,	,	,	,	,	,	r31,	r31,	,	,	,	r31,	,	,	,	s41,
S28	,	,	,	,	,	s34,	,	,	,	,	,	,	,	,	,	,	r31,	r31,	,	,	,	r31,	,	,	,	s41,
S29	,	,	,	,	,	,	,	,	,	,	,	s32,	,	,	,	,	,	,	,	,	,	,	,	,	s33,	,
S30	,	,	,	,	,	,	,	,	,	,	,	,	,	,	s31,	,	,	,	,	,	,	,	,	,	,	,
S31	,	,	,	,	,	,	,	,	,	,	,	,	s70,	,	,	,	,	,	,	,	,	,	,	,	,	,
S32	,	,	,	,	,	s34,	,	,	,	,	,	,	,	,	,	,	r31,	r31,	,	,	,	r31,	,	,	,	s41,
S33	,	,	,	,	,	s34,	,	,	,	,	,	,	,	,	,	,	r31,	r31,	,	,	,	r31,	,	,	,	s41,
S34	,	,	r29,	,	r29,	r29,	,	,	,	,	,	,	,	,	,	s67,	r29,	r29,	,	r29,	,	r29,	,	,	,	r29,
S35	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	r22,	r22,	,	,	,	,	,	,	,	,
S36	,	,	,	,	,	s34,	,	,	,	,	,	,	,	,	,	,	r30,	r30,	,	,	,	r30,	,	,	,	s41,
S37	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	r20,	r20,	,	,	,	s65,	,	,	,	,
S38	,	,	s62,	,	s63,	r27,	,	,	,	,	,	,	,	,	,	,	r27,	r27,	,	s61,	,	r27,	,	,	,	r27,
S39	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	s60,	s56,	,	,	,	,	,	,	,	,
S40	,	,	,	,	,	r33,	,	,	,	,	,	,	,	,	,	,	r33,	r33,	,	,	,	r33,	,	,	,	r33,
S41	,	,	,	,	,	s59,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,
S42	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	s57,	s56,	,	,	,	,	,	,	,	,
S43	r7,	r7,	,	,	,	r7,	r7,	r7,	,	r7,	r7,	,	,	r7,	,	,	,	,	r7,	,	r7,	,	r7,	r7,	,	,
S44	r6,	r6,	,	,	,	r6,	r6,	r6,	,	r6,	r6,	,	,	r6,	,	,	,	,	r6,	,	r6,	,	r6,	r6,	,	,
S45	,	,	,	,	,	,	,	,	s55,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,
S46	,	,	,	,	,	s54,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,
S47	r4,	r4,	,	,	,	r4,	r4,	r4,	,	r4,	r4,	,	,	r4,	,	,	,	,	r4,	,	r4,	,	r4,	r4,	,	,
S48	r11,	r11,	,	,	,	r11,	r11,	r11,	,	r11,	r11,	,	,	r11,	,	,	,	,	r11,	,	r11,	,	r11,	r11,	,	,
S49	,	,	,	,	,	,	,	,	,	,	,	,	s53,	,	,	,	,	,	,	,	,	,	,	,	,	,
S50	r8,	r8,	,	,	,	r8,	r8,	r8,	,	r8,	r8,	,	,	r8,	,	,	,	,	r8,	,	r8,	,	r8,	r8,	,	,
S51	r3,	r3,	,	,	,	r3,	r3,	r3,	,	r3,	r3,	,	,	r3,	,	,	,	,	r3,	,	r3,	,	r3,	r3,	,	,
S52	r5,	r5,	,	,	,	r5,	r5,	r5,	,	r5,	r5,	,	,	r5,	,	,	,	,	r5,	,	r5,	,	r5,	r5,	,	,
S53	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	s79,	,	,	,	,	,	,	,	,	,
S54	,	,	,	r17,	,	,	,	,	,	,	,	,	,	,	,	,	r17,	,	,	,	,	,	,	,	,	,
S55	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	s78,	,	,	,	,	,	,	,	,	,
S56	,	,	,	,	,	s34,	,	,	,	,	,	,	,	,	,	,	r31,	r31,	,	,	,	r31,	,	,	,	s41,
S57	r13,	r13,	,	,	,	r13,	r13,	r13,	,	r13,	r13,	,	,	r13,	,	,	,	,	r13,	,	r13,	,	r13,	r13,	,	,
S58	,	,	,	,	,	r23,	,	,	,	,	,	,	,	,	,	,	r23,	r23,	,	,	,	r23,	,	,	,	r23,
S59	,	,	,	,	,	r29,	,	,	,	,	,	,	,	,	,	s76,	r29,	r29,	,	,	,	r29,	,	,	,	r29,
S60	r15,	r15,	,	,	,	r15,	r15,	r15,	,	r15,	r15,	,	,	r15,	,	,	,	,	r15,	,	r15,	,	r15,	r15,	,	,
S61	,	,	,	,	,	r26,	,	,	,	,	,	,	,	,	,	,	r26,	r26,	,	,	,	r26,	,	,	,	r26,
S62	,	,	,	,	,	r25,	,	,	,	,	,	,	,	,	,	,	r25,	r25,	,	,	,	r25,	,	,	,	r25,
S63	,	,	,	,	,	r24,	,	,	,	,	,	,	,	,	,	,	r24,	r24,	,	,	,	r24,	,	,	,	r24,
S64	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	r19,	r19,	,	,	,	,	,	,	,	,
S65	,	,	,	,	,	,	,	,	,	,	,	,	,	,	s75,	,	,	,	,	,	,	,	,	,	,	,
S66	,	,	,	,	,	r32,	,	,	,	,	,	,	,	,	,	,	r32,	r32,	,	,	,	r32,	,	,	,	r32,
S67	,	,	,	,	,	s74,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,
S68	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	s73,	s56,	,	,	,	,	,	,	,	,
S69	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	s72,	s56,	,	,	,	,	,	,	,	,
S70	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	s71,	,	,	,	,	,	,	,	,	,
S71	r9,	r9,	,	,	,	r9,	r9,	r9,	,	r9,	r9,	,	,	r9,	,	,	,	,	r9,	,	r9,	,	r9,	r9,	,	,
S72	r14,	r14,	,	,	,	r14,	r14,	r14,	,	r14,	r14,	,	,	r14,	,	,	,	,	r14,	,	r14,	,	r14,	r14,	,	,
S73	r16,	r16,	,	,	,	r16,	r16,	r16,	,	r16,	r16,	,	,	r16,	,	,	,	,	r16,	,	r16,	,	r16,	r16,	,	,
S74	,	,	r28,	,	r28,	r28,	,	,	,	,	,	,	,	,	,	,	r28,	r28,	,	r28,	,	r28,	,	,	,	r28,
S75	,	,	,	,	,	,	,	,	,	,	,	,	s81,	,	,	,	,	,	,	,	,	,	,	,	,	,
S76	,	,	,	,	,	s80,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,
S77	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	r21,	r21,	,	,	,	,	,	,	,	,
S78	r10,	r10,	,	,	,	r10,	r10,	r10,	,	r10,	r10,	,	,	r10,	,	,	,	,	r10,	,	r10,	,	r10,	r10,	,	,
S79	r12,	r12,	,	,	,	r12,	r12,	r12,	,	r12,	r12,	,	,	r12,	,	,	,	,	r12,	,	r12,	,	r12,	r12,	,	,
S80	,	,	,	,	,	r28,	,	,	,	,	,	,	,	,	,	,	r28,	r28,	,	,	,	r28,	,	,	,	r28,
S81	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	,	r34,	r34,	,	,	,	,	,	,	,	,

Goto Table
----------
	S',	symList,	production,	semanticAction,	rule,	componentList,	componentListOpt,	symbol,	ruleList,	productionList,	component,
S1	,	,	S3,	,	,	,	,	,	,	S13,	,
S2	,	,	,	,	,	,	,	,	,	,	,
S3	,	,	,	,	,	,	,	,	,	,	,
S4	,	,	,	,	,	,	,	,	,	,	,
S5	,	,	,	,	,	,	,	,	,	,	,
S6	,	,	,	,	,	,	,	,	,	,	,
S7	,	,	,	,	,	,	,	,	,	,	,
S8	,	S23,	,	,	,	,	,	,	,	,	,
S9	,	S22,	,	,	,	,	,	,	,	,	,
S10	,	,	,	,	,	,	,	,	,	,	,
S11	,	,	,	,	,	,	,	,	,	,	,
S12	,	S19,	,	,	,	,	,	,	,	,	,
S13	,	,	S17,	,	,	,	,	,	,	,	,
S14	,	S15,	,	,	,	,	,	,	,	,	,
S15	,	,	,	,	,	,	,	,	,	,	,
S16	,	,	,	,	,	,	,	,	,	,	,
S17	,	,	,	,	,	,	,	,	,	,	,
S18	,	,	,	,	,	,	,	,	,	,	,
S19	,	,	,	,	,	,	,	,	,	,	,
S20	,	,	,	,	,	,	,	,	,	,	,
S21	,	,	,	,	,	,	,	,	,	,	,
S22	,	,	,	,	,	,	,	,	,	,	,
S23	,	,	,	,	,	,	,	,	,	,	,
S24	,	,	,	,	,	,	,	,	,	,	,
S25	,	,	,	,	,	,	,	,	,	,	,
S26	,	,	,	,	,	,	,	,	,	,	,
S27	,	,	,	,	S35,	S36,	S37,	S38,	S42,	,	S40,
S28	,	,	,	,	S35,	S36,	S37,	S38,	S39,	,	S40,
S29	,	,	,	,	,	,	,	,	,	,	,
S30	,	,	,	,	,	,	,	,	,	,	,
S31	,	,	,	,	,	,	,	,	,	,	,
S32	,	,	,	,	S35,	S36,	S37,	S38,	S69,	,	S40,
S33	,	,	,	,	S35,	S36,	S37,	S38,	S68,	,	S40,
S34	,	,	,	,	,	,	,	,	,	,	,
S35	,	,	,	,	,	,	,	,	,	,	,
S36	,	,	,	,	,	,	,	S38,	,	,	S66,
S37	,	,	,	S64,	,	,	,	,	,	,	,
S38	,	,	,	,	,	,	,	,	,	,	,
S39	,	,	,	,	,	,	,	,	,	,	,
S40	,	,	,	,	,	,	,	,	,	,	,
S41	,	,	,	,	,	,	,	S58,	,	,	,
S42	,	,	,	,	,	,	,	,	,	,	,
S43	,	,	,	,	,	,	,	,	,	,	,
S44	,	,	,	,	,	,	,	,	,	,	,
S45	,	,	,	,	,	,	,	,	,	,	,
S46	,	,	,	,	,	,	,	,	,	,	,
S47	,	,	,	,	,	,	,	,	,	,	,
S48	,	,	,	,	,	,	,	,	,	,	,
S49	,	,	,	,	,	,	,	,	,	,	,
S50	,	,	,	,	,	,	,	,	,	,	,
S51	,	,	,	,	,	,	,	,	,	,	,
S52	,	,	,	,	,	,	,	,	,	,	,
S53	,	,	,	,	,	,	,	,	,	,	,
S54	,	,	,	,	,	,	,	,	,	,	,
S55	,	,	,	,	,	,	,	,	,	,	,
S56	,	,	,	,	S77,	S36,	S37,	S38,	,	,	S40,
S57	,	,	,	,	,	,	,	,	,	,	,
S58	,	,	,	,	,	,	,	,	,	,	,
S59	,	,	,	,	,	,	,	,	,	,	,
S60	,	,	,	,	,	,	,	,	,	,	,
S61	,	,	,	,	,	,	,	,	,	,	,
S62	,	,	,	,	,	,	,	,	,	,	,
S63	,	,	,	,	,	,	,	,	,	,	,
S64	,	,	,	,	,	,	,	,	,	,	,
S65	,	,	,	,	,	,	,	,	,	,	,
S66	,	,	,	,	,	,	,	,	,	,	,
S67	,	,	,	,	,	,	,	,	,	,	,
S68	,	,	,	,	,	,	,	,	,	,	,
S69	,	,	,	,	,	,	,	,	,	,	,
S70	,	,	,	,	,	,	,	,	,	,	,
S71	,	,	,	,	,	,	,	,	,	,	,
S72	,	,	,	,	,	,	,	,	,	,	,
S73	,	,	,	,	,	,	,	,	,	,	,
S74	,	,	,	,	,	,	,	,	,	,	,
S75	,	,	,	,	,	,	,	,	,	,	,
S76	,	,	,	,	,	,	,	,	,	,	,
S77	,	,	,	,	,	,	,	,	,	,	,
S78	,	,	,	,	,	,	,	,	,	,	,
S79	,	,	,	,	,	,	,	,	,	,	,
S80	,	,	,	,	,	,	,	,	,	,	,
S81	,	,	,	,	,	,	,	,	,	,	,
*/
}
