/* The following code was generated by JFlex 1.6.1 */

package org.extendj.neobeaver;

import static org.extendj.neobeaver.Parser.Tokens.*;

import org.extendj.neobeaver.Parser.Token;
import org.extendj.neobeaver.Parser.Tokens;
import org.extendj.neobeaver.Parser.TokenScanner;
import org.extendj.neobeaver.Parser.SourcePosition;

import java.io.IOException;

/**
 * This class is a scanner generated by 
 * <a href="http://www.jflex.de/">JFlex</a> 1.6.1
 * from the specification file <tt>/home/jesper/git/neobeaver/core/src/scanner/Scanner.jflex</tt>
 */
public final class Scanner implements TokenScanner, AutoCloseable {

  /** This character denotes the end of file */
  public static final int YYEOF = -1;

  /** initial size of the lookahead buffer */
  private static final int ZZ_BUFFERSIZE = 16384;

  /** lexical states */
  public static final int YYINITIAL = 0;
  public static final int CODE = 2;
  public static final int STRING = 4;

  /**
   * ZZ_LEXSTATE[l] is the state in the DFA for the lexical state l
   * ZZ_LEXSTATE[l+1] is the state in the DFA for the lexical state l
   *                  at the beginning of a line
   * l is of the form l = 2*k, k a non negative integer
   */
  private static final int ZZ_LEXSTATE[] = { 
     0,  0,  1,  1,  2, 2
  };

  /** 
   * Translates characters to character classes
   */
  private static final String ZZ_CMAP_PACKED = 
    "\11\54\1\4\1\1\1\51\1\5\1\2\16\54\4\0\1\4\1\0"+
    "\1\46\1\0\1\53\1\10\1\0\1\50\2\0\1\7\1\37\1\34"+
    "\1\0\1\44\1\6\12\54\1\36\1\43\1\0\1\35\1\0\1\40"+
    "\1\45\32\53\1\0\1\3\2\0\1\53\1\0\1\13\1\17\1\23"+
    "\1\14\1\12\1\27\1\20\1\11\1\31\1\53\1\26\1\22\1\16"+
    "\1\32\1\21\1\25\1\53\1\15\1\24\1\30\4\53\1\33\1\53"+
    "\1\42\1\41\1\47\1\0\6\54\1\52\32\54\2\0\4\53\4\0"+
    "\1\53\2\0\1\54\7\0\1\53\4\0\1\53\5\0\27\53\1\0"+
    "\37\53\1\0\u01ca\53\4\0\14\53\16\0\5\53\7\0\1\53\1\0"+
    "\1\53\21\0\160\54\5\53\1\0\2\53\2\0\4\53\10\0\1\53"+
    "\1\0\3\53\1\0\1\53\1\0\24\53\1\0\123\53\1\0\213\53"+
    "\1\0\5\54\2\0\236\53\11\0\46\53\2\0\1\53\7\0\47\53"+
    "\7\0\1\53\1\0\55\54\1\0\1\54\1\0\2\54\1\0\2\54"+
    "\1\0\1\54\10\0\33\53\5\0\3\53\15\0\5\54\6\0\1\53"+
    "\4\0\13\54\5\0\53\53\37\54\4\0\2\53\1\54\143\53\1\0"+
    "\1\53\10\54\1\0\6\54\2\53\2\54\1\0\4\54\2\53\12\54"+
    "\3\53\2\0\1\53\17\0\1\54\1\53\1\54\36\53\33\54\2\0"+
    "\131\53\13\54\1\53\16\0\12\54\41\53\11\54\2\53\4\0\1\53"+
    "\5\0\26\53\4\54\1\53\11\54\1\53\3\54\1\53\5\54\22\0"+
    "\31\53\3\54\104\0\1\53\1\0\13\53\67\0\33\54\1\0\4\54"+
    "\66\53\3\54\1\53\22\54\1\53\7\54\12\53\2\54\2\0\12\54"+
    "\1\0\7\53\1\0\7\53\1\0\3\54\1\0\10\53\2\0\2\53"+
    "\2\0\26\53\1\0\7\53\1\0\1\53\3\0\4\53\2\0\1\54"+
    "\1\53\7\54\2\0\2\54\2\0\3\54\1\53\10\0\1\54\4\0"+
    "\2\53\1\0\3\53\2\54\2\0\12\54\4\53\7\0\1\53\5\0"+
    "\3\54\1\0\6\53\4\0\2\53\2\0\26\53\1\0\7\53\1\0"+
    "\2\53\1\0\2\53\1\0\2\53\2\0\1\54\1\0\5\54\4\0"+
    "\2\54\2\0\3\54\3\0\1\54\7\0\4\53\1\0\1\53\7\0"+
    "\14\54\3\53\1\54\13\0\3\54\1\0\11\53\1\0\3\53\1\0"+
    "\26\53\1\0\7\53\1\0\2\53\1\0\5\53\2\0\1\54\1\53"+
    "\10\54\1\0\3\54\1\0\3\54\2\0\1\53\17\0\2\53\2\54"+
    "\2\0\12\54\1\0\1\53\17\0\3\54\1\0\10\53\2\0\2\53"+
    "\2\0\26\53\1\0\7\53\1\0\2\53\1\0\5\53\2\0\1\54"+
    "\1\53\7\54\2\0\2\54\2\0\3\54\10\0\2\54\4\0\2\53"+
    "\1\0\3\53\2\54\2\0\12\54\1\0\1\53\20\0\1\54\1\53"+
    "\1\0\6\53\3\0\3\53\1\0\4\53\3\0\2\53\1\0\1\53"+
    "\1\0\2\53\3\0\2\53\3\0\3\53\3\0\14\53\4\0\5\54"+
    "\3\0\3\54\1\0\4\54\2\0\1\53\6\0\1\54\16\0\12\54"+
    "\11\0\1\53\7\0\3\54\1\0\10\53\1\0\3\53\1\0\27\53"+
    "\1\0\12\53\1\0\5\53\3\0\1\53\7\54\1\0\3\54\1\0"+
    "\4\54\7\0\2\54\1\0\2\53\6\0\2\53\2\54\2\0\12\54"+
    "\22\0\2\54\1\0\10\53\1\0\3\53\1\0\27\53\1\0\12\53"+
    "\1\0\5\53\2\0\1\54\1\53\7\54\1\0\3\54\1\0\4\54"+
    "\7\0\2\54\7\0\1\53\1\0\2\53\2\54\2\0\12\54\1\0"+
    "\2\53\17\0\2\54\1\0\10\53\1\0\3\53\1\0\51\53\2\0"+
    "\1\53\7\54\1\0\3\54\1\0\4\54\1\53\10\0\1\54\10\0"+
    "\2\53\2\54\2\0\12\54\12\0\6\53\2\0\2\54\1\0\22\53"+
    "\3\0\30\53\1\0\11\53\1\0\1\53\2\0\7\53\3\0\1\54"+
    "\4\0\6\54\1\0\1\54\1\0\10\54\22\0\2\54\15\0\60\53"+
    "\1\54\2\53\7\54\4\0\10\53\10\54\1\0\12\54\47\0\2\53"+
    "\1\0\1\53\2\0\2\53\1\0\1\53\2\0\1\53\6\0\4\53"+
    "\1\0\7\53\1\0\3\53\1\0\1\53\1\0\1\53\2\0\2\53"+
    "\1\0\4\53\1\54\2\53\6\54\1\0\2\54\1\53\2\0\5\53"+
    "\1\0\1\53\1\0\6\54\2\0\12\54\2\0\4\53\40\0\1\53"+
    "\27\0\2\54\6\0\12\54\13\0\1\54\1\0\1\54\1\0\1\54"+
    "\4\0\2\54\10\53\1\0\44\53\4\0\24\54\1\0\2\54\5\53"+
    "\13\54\1\0\44\54\11\0\1\54\71\0\53\53\24\54\1\53\12\54"+
    "\6\0\6\53\4\54\4\53\3\54\1\53\3\54\2\53\7\54\3\53"+
    "\4\54\15\53\14\54\1\53\17\54\2\0\46\53\1\0\1\53\5\0"+
    "\1\53\2\0\53\53\1\0\u014d\53\1\0\4\53\2\0\7\53\1\0"+
    "\1\53\1\0\4\53\2\0\51\53\1\0\4\53\2\0\41\53\1\0"+
    "\4\53\2\0\7\53\1\0\1\53\1\0\4\53\2\0\17\53\1\0"+
    "\71\53\1\0\4\53\2\0\103\53\2\0\3\54\40\0\20\53\20\0"+
    "\125\53\14\0\u026c\53\2\0\21\53\1\0\32\53\5\0\113\53\3\0"+
    "\3\53\17\0\15\53\1\0\4\53\3\54\13\0\22\53\3\54\13\0"+
    "\22\53\2\54\14\0\15\53\1\0\3\53\1\0\2\54\14\0\64\53"+
    "\40\54\3\0\1\53\3\0\2\53\1\54\2\0\12\54\41\0\3\54"+
    "\2\0\12\54\6\0\130\53\10\0\51\53\1\54\1\53\5\0\106\53"+
    "\12\0\35\53\3\0\14\54\4\0\14\54\12\0\12\54\36\53\2\0"+
    "\5\53\13\0\54\53\4\0\21\54\7\53\2\54\6\0\12\54\46\0"+
    "\27\53\5\54\4\0\65\53\12\54\1\0\35\54\2\0\13\54\6\0"+
    "\12\54\15\0\1\53\130\0\5\54\57\53\21\54\7\53\4\0\12\54"+
    "\21\0\11\54\14\0\3\54\36\53\15\54\2\53\12\54\54\53\16\54"+
    "\14\0\44\53\24\54\10\0\12\54\3\0\3\53\12\54\44\53\122\0"+
    "\3\54\1\0\25\54\4\53\1\54\4\53\3\54\2\53\11\0\300\53"+
    "\47\54\25\0\4\54\u0116\53\2\0\6\53\2\0\46\53\2\0\6\53"+
    "\2\0\10\53\1\0\1\53\1\0\1\53\1\0\1\53\1\0\37\53"+
    "\2\0\65\53\1\0\7\53\1\0\1\53\3\0\3\53\1\0\7\53"+
    "\3\0\4\53\2\0\6\53\4\0\15\53\5\0\3\53\1\0\7\53"+
    "\16\0\5\54\30\0\1\51\1\51\5\54\20\0\2\53\23\0\1\53"+
    "\13\0\5\54\5\0\6\54\1\0\1\53\15\0\1\53\20\0\15\53"+
    "\3\0\33\53\25\0\15\54\4\0\1\54\3\0\14\54\21\0\1\53"+
    "\4\0\1\53\2\0\12\53\1\0\1\53\3\0\5\53\6\0\1\53"+
    "\1\0\1\53\1\0\1\53\1\0\4\53\1\0\13\53\2\0\4\53"+
    "\5\0\5\53\4\0\1\53\21\0\51\53\u0a77\0\57\53\1\0\57\53"+
    "\1\0\205\53\6\0\4\53\3\54\2\53\14\0\46\53\1\0\1\53"+
    "\5\0\1\53\2\0\70\53\7\0\1\53\17\0\1\54\27\53\11\0"+
    "\7\53\1\0\7\53\1\0\7\53\1\0\7\53\1\0\7\53\1\0"+
    "\7\53\1\0\7\53\1\0\7\53\1\0\40\54\57\0\1\53\u01d5\0"+
    "\3\53\31\0\11\53\6\54\1\0\5\53\2\0\5\53\4\0\126\53"+
    "\2\0\2\54\2\0\3\53\1\0\132\53\1\0\4\53\5\0\51\53"+
    "\3\0\136\53\21\0\33\53\65\0\20\53\u0200\0\u19b6\53\112\0\u51cd\53"+
    "\63\0\u048d\53\103\0\56\53\2\0\u010d\53\3\0\20\53\12\54\2\53"+
    "\24\0\57\53\1\54\4\0\12\54\1\0\31\53\7\0\1\54\120\53"+
    "\2\54\45\0\11\53\2\0\147\53\2\0\4\53\1\0\4\53\14\0"+
    "\13\53\115\0\12\53\1\54\3\53\1\54\4\53\1\54\27\53\5\54"+
    "\20\0\1\53\7\0\64\53\14\0\2\54\62\53\21\54\13\0\12\54"+
    "\6\0\22\54\6\53\3\0\1\53\4\0\12\54\34\53\10\54\2\0"+
    "\27\53\15\54\14\0\35\53\3\0\4\54\57\53\16\54\16\0\1\53"+
    "\12\54\46\0\51\53\16\54\11\0\3\53\1\54\10\53\2\54\2\0"+
    "\12\54\6\0\27\53\3\0\1\53\1\54\4\0\60\53\1\54\1\53"+
    "\3\54\2\53\2\54\5\53\2\54\1\53\1\54\1\53\30\0\3\53"+
    "\2\0\13\53\5\54\2\0\3\53\2\54\12\0\6\53\2\0\6\53"+
    "\2\0\6\53\11\0\7\53\1\0\7\53\221\0\43\53\10\54\1\0"+
    "\2\54\2\0\12\54\6\0\u2ba4\53\14\0\27\53\4\0\61\53\4\0"+
    "\u0800\53\u1900\0\u016e\53\2\0\152\53\46\0\7\53\14\0\5\53\5\0"+
    "\1\53\1\54\12\53\1\0\15\53\1\0\5\53\1\0\1\53\1\0"+
    "\2\53\1\0\2\53\1\0\154\53\41\0\u016b\53\22\0\100\53\2\0"+
    "\66\53\50\0\15\53\3\0\20\54\20\0\7\54\14\0\2\53\30\0"+
    "\3\53\31\0\1\53\6\0\5\53\1\0\207\53\2\0\1\54\4\0"+
    "\1\53\13\0\12\54\7\0\32\53\4\0\1\53\1\0\32\53\13\0"+
    "\131\53\3\0\6\53\2\0\6\53\2\0\6\53\2\0\3\53\3\0"+
    "\2\53\3\0\2\53\22\0\3\54\4\0\14\53\1\0\32\53\1\0"+
    "\23\53\1\0\2\53\1\0\17\53\2\0\16\53\42\0\173\53\105\0"+
    "\65\53\210\0\1\54\202\0\35\53\3\0\61\53\57\0\37\53\21\0"+
    "\33\53\65\0\36\53\2\0\44\53\4\0\10\53\1\0\5\53\52\0"+
    "\236\53\2\0\12\54\u0356\0\6\53\2\0\1\53\1\0\54\53\1\0"+
    "\2\53\3\0\1\53\2\0\27\53\252\0\26\53\12\0\32\53\106\0"+
    "\70\53\6\0\2\53\100\0\1\53\3\54\1\0\2\54\5\0\4\54"+
    "\4\53\1\0\3\53\1\0\33\53\4\0\3\54\4\0\1\54\40\0"+
    "\35\53\203\0\66\53\12\0\26\53\12\0\23\53\215\0\111\53\u03b7\0"+
    "\3\54\65\53\17\54\37\0\12\54\20\0\3\54\55\53\13\54\2\0"+
    "\1\54\22\0\31\53\7\0\12\54\6\0\3\54\44\53\16\54\1\0"+
    "\12\54\100\0\3\54\60\53\16\54\4\53\13\0\12\54\u04a6\0\53\53"+
    "\15\54\10\0\12\54\u0936\0\u036f\53\221\0\143\53\u0b9d\0\u042f\53\u33d1\0"+
    "\u0239\53\u04c7\0\105\53\13\0\1\53\56\54\20\0\4\54\15\53\u4060\0"+
    "\2\53\u2163\0\5\54\3\0\26\54\2\0\7\54\36\0\4\54\224\0"+
    "\3\54\u01bb\0\125\53\1\0\107\53\1\0\2\53\2\0\1\53\2\0"+
    "\2\53\2\0\4\53\1\0\14\53\1\0\1\53\1\0\7\53\1\0"+
    "\101\53\1\0\4\53\2\0\10\53\1\0\7\53\1\0\34\53\1\0"+
    "\4\53\1\0\5\53\1\0\1\53\3\0\7\53\1\0\u0154\53\2\0"+
    "\31\53\1\0\31\53\1\0\37\53\1\0\31\53\1\0\37\53\1\0"+
    "\31\53\1\0\37\53\1\0\31\53\1\0\37\53\1\0\31\53\1\0"+
    "\10\53\2\0\62\54\u1600\0\4\53\1\0\33\53\1\0\2\53\1\0"+
    "\1\53\2\0\1\53\1\0\12\53\1\0\4\53\1\0\1\53\1\0"+
    "\1\53\6\0\1\53\4\0\1\53\1\0\1\53\1\0\1\53\1\0"+
    "\3\53\1\0\2\53\1\0\1\53\2\0\1\53\1\0\1\53\1\0"+
    "\1\53\1\0\1\53\1\0\1\53\1\0\2\53\1\0\1\53\2\0"+
    "\4\53\1\0\7\53\1\0\4\53\1\0\4\53\1\0\1\53\1\0"+
    "\12\53\1\0\21\53\5\0\3\53\1\0\5\53\1\0\21\53\u1144\0"+
    "\ua6d7\53\51\0\u1035\53\13\0\336\53\u3fe2\0\u021e\53\uffff\0\uffff\0\uffff\0\uffff\0\uffff\0\uffff\0\uffff\0\uffff\0\uffff\0\uffff\0\uffff\0\u05ee\0"+
    "\1\54\36\0\140\54\200\0\360\54\uffff\0\uffff\0\ufe12\0";

  /** 
   * Translates characters to character classes
   */
  private static final char [] ZZ_CMAP = zzUnpackCMap(ZZ_CMAP_PACKED);

  /** 
   * Translates DFA states to action switch labels.
   */
  private static final int [] ZZ_ACTION = zzUnpackAction();

  private static final String ZZ_ACTION_PACKED_0 =
    "\3\0\1\1\2\2\1\1\1\3\1\1\1\4\1\5"+
    "\1\6\1\1\1\7\1\10\1\11\1\1\1\12\1\13"+
    "\1\14\1\15\1\16\1\1\1\17\2\20\1\1\1\21"+
    "\1\2\12\0\1\22\1\23\1\0\1\24\1\25\1\26"+
    "\1\27\1\30\1\31\1\32\1\33\1\34\1\35\30\0"+
    "\1\36\1\37\6\0\1\40\1\41\1\42\4\0\1\43"+
    "\2\0\1\44\1\0\1\45\3\0\1\46\1\47";

  private static int [] zzUnpackAction() {
    int [] result = new int[102];
    int offset = 0;
    offset = zzUnpackAction(ZZ_ACTION_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAction(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /** 
   * Translates a state to a row index in the transition table
   */
  private static final int [] ZZ_ROWMAP = zzUnpackRowMap();

  private static final String ZZ_ROWMAP_PACKED_0 =
    "\0\0\0\55\0\132\0\207\0\207\0\264\0\341\0\207"+
    "\0\u010e\0\u013b\0\207\0\207\0\u0168\0\207\0\207\0\207"+
    "\0\u0195\0\207\0\207\0\207\0\207\0\u01c2\0\u01ef\0\u021c"+
    "\0\207\0\u0249\0\u0276\0\207\0\u02a3\0\u02d0\0\u02fd\0\u032a"+
    "\0\u0357\0\u0384\0\u03b1\0\u03de\0\u040b\0\u0438\0\u0465\0\207"+
    "\0\207\0\u0492\0\207\0\207\0\207\0\207\0\207\0\207"+
    "\0\207\0\207\0\207\0\207\0\u04bf\0\u04ec\0\u0519\0\u0546"+
    "\0\u0573\0\u05a0\0\u05cd\0\u05fa\0\u0627\0\u0654\0\u0681\0\u06ae"+
    "\0\u06db\0\u0708\0\u0735\0\u0762\0\u078f\0\u07bc\0\u07e9\0\u0816"+
    "\0\u0843\0\u0870\0\u089d\0\u08ca\0\207\0\207\0\u08f7\0\u0924"+
    "\0\u0951\0\u097e\0\u09ab\0\u09d8\0\207\0\207\0\207\0\u0a05"+
    "\0\u0a32\0\u0a5f\0\u0a8c\0\207\0\u0ab9\0\u0ae6\0\207\0\u0b13"+
    "\0\207\0\u0b40\0\u0b6d\0\u0b9a\0\207\0\207";

  private static int [] zzUnpackRowMap() {
    int [] result = new int[102];
    int offset = 0;
    offset = zzUnpackRowMap(ZZ_ROWMAP_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackRowMap(String packed, int offset, int [] result) {
    int i = 0;  /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int high = packed.charAt(i++) << 16;
      result[j++] = high | packed.charAt(i++);
    }
    return j;
  }

  /** 
   * The transition table of the DFA
   */
  private static final int [] ZZ_TRANS = zzUnpackTrans();

  private static final String ZZ_TRANS_PACKED_0 =
    "\1\4\1\5\1\6\1\4\2\5\1\7\1\10\1\11"+
    "\23\12\1\13\1\14\1\15\1\16\1\17\1\20\1\21"+
    "\1\22\1\23\1\24\1\25\4\4\1\12\1\4\36\26"+
    "\1\27\16\26\1\30\1\31\1\32\1\33\42\30\1\34"+
    "\6\30\56\0\1\5\61\0\1\35\1\36\56\0\1\37"+
    "\1\40\2\0\1\41\2\0\1\42\1\0\1\43\1\44"+
    "\1\0\1\45\2\0\1\46\1\0\1\47\33\0\23\12"+
    "\16\0\3\12\35\0\1\50\55\0\1\51\16\0\36\26"+
    "\1\52\65\26\1\53\5\26\1\30\3\0\42\30\1\0"+
    "\6\30\1\0\1\31\53\0\1\54\2\0\1\55\1\54"+
    "\1\0\7\54\1\56\1\54\1\57\7\54\1\60\1\61"+
    "\1\54\1\62\13\54\1\63\1\54\1\64\2\0\2\54"+
    "\1\35\1\5\1\6\52\35\7\36\1\65\45\36\12\0"+
    "\1\66\60\0\1\67\67\0\1\70\44\0\1\71\45\0"+
    "\1\72\64\0\1\73\45\0\1\74\53\0\1\75\20\0"+
    "\1\76\42\0\1\77\33\0\47\26\1\0\5\26\6\36"+
    "\1\5\1\65\45\36\13\0\1\100\60\0\1\101\55\0"+
    "\1\102\47\0\1\103\70\0\1\104\40\0\1\105\64\0"+
    "\1\106\46\0\1\107\64\0\1\110\61\0\1\111\36\0"+
    "\1\112\52\0\1\113\53\0\1\114\65\0\1\115\62\0"+
    "\1\116\50\0\1\117\56\0\1\120\44\0\1\121\50\0"+
    "\1\122\55\0\1\123\53\0\1\124\56\0\1\125\70\0"+
    "\1\126\50\0\1\127\43\0\1\130\72\0\1\131\44\0"+
    "\1\132\57\0\1\133\45\0\1\134\57\0\1\135\66\0"+
    "\1\136\51\0\1\137\51\0\1\140\42\0\1\141\55\0"+
    "\1\142\62\0\1\143\55\0\1\144\55\0\1\145\55\0"+
    "\1\146\30\0";

  private static int [] zzUnpackTrans() {
    int [] result = new int[3015];
    int offset = 0;
    offset = zzUnpackTrans(ZZ_TRANS_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackTrans(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      value--;
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /* error codes */
  private static final int ZZ_UNKNOWN_ERROR = 0;
  private static final int ZZ_NO_MATCH = 1;
  private static final int ZZ_PUSHBACK_2BIG = 2;

  /* error messages for the codes above */
  private static final String ZZ_ERROR_MSG[] = {
    "Unknown internal scanner error",
    "Error: could not match input",
    "Error: pushback value was too large"
  };

  /**
   * ZZ_ATTRIBUTE[aState] contains the attributes of state <code>aState</code>
   */
  private static final int [] ZZ_ATTRIBUTE = zzUnpackAttribute();

  private static final String ZZ_ATTRIBUTE_PACKED_0 =
    "\3\0\2\11\2\1\1\11\2\1\2\11\1\1\3\11"+
    "\1\1\4\11\3\1\1\11\2\1\1\11\1\1\12\0"+
    "\2\11\1\0\12\11\30\0\2\11\6\0\3\11\4\0"+
    "\1\11\2\0\1\11\1\0\1\11\3\0\2\11";

  private static int [] zzUnpackAttribute() {
    int [] result = new int[102];
    int offset = 0;
    offset = zzUnpackAttribute(ZZ_ATTRIBUTE_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAttribute(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }

  /** the input device */
  private java.io.Reader zzReader;

  /** the current state of the DFA */
  private int zzState;

  /** the current lexical state */
  private int zzLexicalState = YYINITIAL;

  /** this buffer contains the current text to be matched and is
      the source of the yytext() string */
  private char zzBuffer[] = new char[ZZ_BUFFERSIZE];

  /** the textposition at the last accepting state */
  private int zzMarkedPos;

  /** the current text position in the buffer */
  private int zzCurrentPos;

  /** startRead marks the beginning of the yytext() string in the buffer */
  private int zzStartRead;

  /** endRead marks the last character in the buffer, that has been read
      from input */
  private int zzEndRead;

  /** number of newlines encountered up to the start of the matched text */
  private int yyline;

  /** the number of characters up to the start of the matched text */
  private int yychar;

  /**
   * the number of characters from the last newline up to the start of the 
   * matched text
   */
  private int yycolumn;

  /** 
   * zzAtBOL == true <=> the scanner is currently at the beginning of a line
   */
  private boolean zzAtBOL = true;

  /** zzAtEOF == true <=> the scanner is at the EOF */
  private boolean zzAtEOF;

  /** denotes if the user-EOF-code has already been executed */
  private boolean zzEOFDone;
  
  /** 
   * The number of occupied positions in zzBuffer beyond zzEndRead.
   * When a lead/high surrogate has been read from the input stream
   * into the final zzBuffer position, this will have a value of 1;
   * otherwise, it will have a value of 0.
   */
  private int zzFinalHighSurrogate = 0;

  /* user code: */
  StringBuilder stringbuf = new StringBuilder(128);

  private Token sym(int id) {
    return new Token(id, yytext(), pos());
  }

  private Token sym(int id, String text) {
    return new Token(id, text, pos());
  }

  private SourcePosition pos() {
    return new SourcePosition(yyline + 1, yycolumn + 1);
  }

  private void error(String msg) throws IOException {
    throw new IOException(
        String.format("%d:%d: %s", yyline + 1, yycolumn + 1, msg));
  }

  @Override public void close() throws java.io.IOException {
  	yyclose();
  }


  /**
   * Creates a new scanner
   *
   * @param   in  the java.io.Reader to read input from.
   */
  public Scanner(java.io.Reader in) {
    this.zzReader = in;
  }


  /** 
   * Unpacks the compressed character translation table.
   *
   * @param packed   the packed character translation table
   * @return         the unpacked character translation table
   */
  private static char [] zzUnpackCMap(String packed) {
    char [] map = new char[0x110000];
    int i = 0;  /* index in packed string  */
    int j = 0;  /* index in unpacked array */
    while (i < 2854) {
      int  count = packed.charAt(i++);
      char value = packed.charAt(i++);
      do map[j++] = value; while (--count > 0);
    }
    return map;
  }


  /**
   * Refills the input buffer.
   *
   * @return      <code>false</code>, iff there was new input.
   * 
   * @exception   java.io.IOException  if any I/O-Error occurs
   */
  private boolean zzRefill() throws java.io.IOException {

    /* first: make room (if you can) */
    if (zzStartRead > 0) {
      zzEndRead += zzFinalHighSurrogate;
      zzFinalHighSurrogate = 0;
      System.arraycopy(zzBuffer, zzStartRead,
                       zzBuffer, 0,
                       zzEndRead-zzStartRead);

      /* translate stored positions */
      zzEndRead-= zzStartRead;
      zzCurrentPos-= zzStartRead;
      zzMarkedPos-= zzStartRead;
      zzStartRead = 0;
    }

    /* is the buffer big enough? */
    if (zzCurrentPos >= zzBuffer.length - zzFinalHighSurrogate) {
      /* if not: blow it up */
      char newBuffer[] = new char[zzBuffer.length*2];
      System.arraycopy(zzBuffer, 0, newBuffer, 0, zzBuffer.length);
      zzBuffer = newBuffer;
      zzEndRead += zzFinalHighSurrogate;
      zzFinalHighSurrogate = 0;
    }

    /* fill the buffer with new input */
    int requested = zzBuffer.length - zzEndRead;
    int numRead = zzReader.read(zzBuffer, zzEndRead, requested);

    /* not supposed to occur according to specification of java.io.Reader */
    if (numRead == 0) {
      throw new java.io.IOException("Reader returned 0 characters. See JFlex examples for workaround.");
    }
    if (numRead > 0) {
      zzEndRead += numRead;
      /* If numRead == requested, we might have requested to few chars to
         encode a full Unicode character. We assume that a Reader would
         otherwise never return half characters. */
      if (numRead == requested) {
        if (Character.isHighSurrogate(zzBuffer[zzEndRead - 1])) {
          --zzEndRead;
          zzFinalHighSurrogate = 1;
        }
      }
      /* potentially more input available */
      return false;
    }

    /* numRead < 0 ==> end of stream */
    return true;
  }

    
  /**
   * Closes the input stream.
   */
  public final void yyclose() throws java.io.IOException {
    zzAtEOF = true;            /* indicate end of file */
    zzEndRead = zzStartRead;  /* invalidate buffer    */

    if (zzReader != null)
      zzReader.close();
  }


  /**
   * Resets the scanner to read from a new input stream.
   * Does not close the old reader.
   *
   * All internal variables are reset, the old input stream 
   * <b>cannot</b> be reused (internal buffer is discarded and lost).
   * Lexical state is set to <tt>ZZ_INITIAL</tt>.
   *
   * Internal scan buffer is resized down to its initial length, if it has grown.
   *
   * @param reader   the new input stream 
   */
  public final void yyreset(java.io.Reader reader) {
    zzReader = reader;
    zzAtBOL  = true;
    zzAtEOF  = false;
    zzEOFDone = false;
    zzEndRead = zzStartRead = 0;
    zzCurrentPos = zzMarkedPos = 0;
    zzFinalHighSurrogate = 0;
    yyline = yychar = yycolumn = 0;
    zzLexicalState = YYINITIAL;
    if (zzBuffer.length > ZZ_BUFFERSIZE)
      zzBuffer = new char[ZZ_BUFFERSIZE];
  }


  /**
   * Returns the current lexical state.
   */
  public final int yystate() {
    return zzLexicalState;
  }


  /**
   * Enters a new lexical state
   *
   * @param newState the new lexical state
   */
  public final void yybegin(int newState) {
    zzLexicalState = newState;
  }


  /**
   * Returns the text matched by the current regular expression.
   */
  public final String yytext() {
    return new String( zzBuffer, zzStartRead, zzMarkedPos-zzStartRead );
  }


  /**
   * Returns the character at position <tt>pos</tt> from the 
   * matched text. 
   * 
   * It is equivalent to yytext().charAt(pos), but faster
   *
   * @param pos the position of the character to fetch. 
   *            A value from 0 to yylength()-1.
   *
   * @return the character at position pos
   */
  public final char yycharat(int pos) {
    return zzBuffer[zzStartRead+pos];
  }


  /**
   * Returns the length of the matched text region.
   */
  public final int yylength() {
    return zzMarkedPos-zzStartRead;
  }


  /**
   * Reports an error that occured while scanning.
   *
   * In a wellformed scanner (no or only correct usage of 
   * yypushback(int) and a match-all fallback rule) this method 
   * will only be called with things that "Can't Possibly Happen".
   * If this method is called, something is seriously wrong
   * (e.g. a JFlex bug producing a faulty scanner etc.).
   *
   * Usual syntax/scanner level error handling should be done
   * in error fallback rules.
   *
   * @param   errorCode  the code of the errormessage to display
   */
  private void zzScanError(int errorCode) {
    String message;
    try {
      message = ZZ_ERROR_MSG[errorCode];
    }
    catch (ArrayIndexOutOfBoundsException e) {
      message = ZZ_ERROR_MSG[ZZ_UNKNOWN_ERROR];
    }

    throw new Error(message);
  } 


  /**
   * Pushes the specified amount of characters back into the input stream.
   *
   * They will be read again by then next call of the scanning method
   *
   * @param number  the number of characters to be read again.
   *                This number must not be greater than yylength()!
   */
  public void yypushback(int number)  {
    if ( number > yylength() )
      zzScanError(ZZ_PUSHBACK_2BIG);

    zzMarkedPos -= number;
  }


  /**
   * Resumes scanning until the next regular expression is matched,
   * the end of input is encountered or an I/O-Error occurs.
   *
   * @return      the next token
   * @exception   java.io.IOException  if any I/O-Error occurs
   */
  public Token nextToken() throws java.io.IOException, IOException {
    int zzInput;
    int zzAction;

    // cached fields:
    int zzCurrentPosL;
    int zzMarkedPosL;
    int zzEndReadL = zzEndRead;
    char [] zzBufferL = zzBuffer;
    char [] zzCMapL = ZZ_CMAP;

    int [] zzTransL = ZZ_TRANS;
    int [] zzRowMapL = ZZ_ROWMAP;
    int [] zzAttrL = ZZ_ATTRIBUTE;

    while (true) {
      zzMarkedPosL = zzMarkedPos;

      boolean zzR = false;
      int zzCh;
      int zzCharCount;
      for (zzCurrentPosL = zzStartRead  ;
           zzCurrentPosL < zzMarkedPosL ;
           zzCurrentPosL += zzCharCount ) {
        zzCh = Character.codePointAt(zzBufferL, zzCurrentPosL, zzMarkedPosL);
        zzCharCount = Character.charCount(zzCh);
        switch (zzCh) {
        case '\u000B':
        case '\u000C':
        case '\u0085':
        case '\u2028':
        case '\u2029':
          yyline++;
          yycolumn = 0;
          zzR = false;
          break;
        case '\r':
          yyline++;
          yycolumn = 0;
          zzR = true;
          break;
        case '\n':
          if (zzR)
            zzR = false;
          else {
            yyline++;
            yycolumn = 0;
          }
          break;
        default:
          zzR = false;
          yycolumn += zzCharCount;
        }
      }

      if (zzR) {
        // peek one character ahead if it is \n (if we have counted one line too much)
        boolean zzPeek;
        if (zzMarkedPosL < zzEndReadL)
          zzPeek = zzBufferL[zzMarkedPosL] == '\n';
        else if (zzAtEOF)
          zzPeek = false;
        else {
          boolean eof = zzRefill();
          zzEndReadL = zzEndRead;
          zzMarkedPosL = zzMarkedPos;
          zzBufferL = zzBuffer;
          if (eof) 
            zzPeek = false;
          else 
            zzPeek = zzBufferL[zzMarkedPosL] == '\n';
        }
        if (zzPeek) yyline--;
      }
      zzAction = -1;

      zzCurrentPosL = zzCurrentPos = zzStartRead = zzMarkedPosL;
  
      zzState = ZZ_LEXSTATE[zzLexicalState];

      // set up zzAction for empty match case:
      int zzAttributes = zzAttrL[zzState];
      if ( (zzAttributes & 1) == 1 ) {
        zzAction = zzState;
      }


      zzForAction: {
        while (true) {
    
          if (zzCurrentPosL < zzEndReadL) {
            zzInput = Character.codePointAt(zzBufferL, zzCurrentPosL, zzEndReadL);
            zzCurrentPosL += Character.charCount(zzInput);
          }
          else if (zzAtEOF) {
            zzInput = YYEOF;
            break zzForAction;
          }
          else {
            // store back cached positions
            zzCurrentPos  = zzCurrentPosL;
            zzMarkedPos   = zzMarkedPosL;
            boolean eof = zzRefill();
            // get translated positions and possibly new buffer
            zzCurrentPosL  = zzCurrentPos;
            zzMarkedPosL   = zzMarkedPos;
            zzBufferL      = zzBuffer;
            zzEndReadL     = zzEndRead;
            if (eof) {
              zzInput = YYEOF;
              break zzForAction;
            }
            else {
              zzInput = Character.codePointAt(zzBufferL, zzCurrentPosL, zzEndReadL);
              zzCurrentPosL += Character.charCount(zzInput);
            }
          }
          int zzNext = zzTransL[ zzRowMapL[zzState] + zzCMapL[zzInput] ];
          if (zzNext == -1) break zzForAction;
          zzState = zzNext;

          zzAttributes = zzAttrL[zzState];
          if ( (zzAttributes & 1) == 1 ) {
            zzAction = zzState;
            zzMarkedPosL = zzCurrentPosL;
            if ( (zzAttributes & 8) == 8 ) break zzForAction;
          }

        }
      }

      // store back cached position
      zzMarkedPos = zzMarkedPosL;

      if (zzInput == YYEOF && zzStartRead == zzCurrentPos) {
        zzAtEOF = true;
              {
                return new Token(EOF, "EOF", pos());
              }
      }
      else {
        switch (zzAction < 0 ? zzAction : ZZ_ACTION[zzAction]) {
          case 1: 
            { error("illegal character \"" + yytext() +  "\"");
            }
          case 40: break;
          case 2: 
            { 
            }
          case 41: break;
          case 3: 
            { return sym(ASTERISK);
            }
          case 42: break;
          case 4: 
            { return sym(ID);
            }
          case 43: break;
          case 5: 
            { return sym(COMMA);
            }
          case 44: break;
          case 6: 
            { return sym(EQ);
            }
          case 45: break;
          case 7: 
            { return sym(PLUS);
            }
          case 46: break;
          case 8: 
            { return sym(QUESTION);
            }
          case 47: break;
          case 9: 
            { return sym(OR);
            }
          case 48: break;
          case 10: 
            { return sym(SEMICOLON);
            }
          case 49: break;
          case 11: 
            { return sym(DOT);
            }
          case 50: break;
          case 12: 
            { return sym(AT);
            }
          case 51: break;
          case 13: 
            { stringbuf.setLength(0); yybegin(STRING);
            }
          case 52: break;
          case 14: 
            { return sym(JAVA_CODE);
            }
          case 53: break;
          case 15: 
            { stringbuf.append(yytext());
            }
          case 54: break;
          case 16: 
            { error("unterminated string at end of line");
            }
          case 55: break;
          case 17: 
            { yybegin(YYINITIAL); return sym(Tokens.STRING, stringbuf.toString());
            }
          case 56: break;
          case 18: 
            { return sym(COLONEQ);
            }
          case 57: break;
          case 19: 
            { yybegin(CODE); return sym(CODE_START);
            }
          case 58: break;
          case 20: 
            { yybegin(YYINITIAL); return sym(CODE_END);
            }
          case 59: break;
          case 21: 
            { error("illegal escape sequence \"" + yytext() + "\"");
            }
          case 60: break;
          case 22: 
            { stringbuf.append('\\');
            }
          case 61: break;
          case 23: 
            { stringbuf.append('\r');
            }
          case 62: break;
          case 24: 
            { stringbuf.append('\b');
            }
          case 63: break;
          case 25: 
            { stringbuf.append('\f');
            }
          case 64: break;
          case 26: 
            { stringbuf.append('\t');
            }
          case 65: break;
          case 27: 
            { stringbuf.append('\n');
            }
          case 66: break;
          case 28: 
            { stringbuf.append('\"');
            }
          case 67: break;
          case 29: 
            { stringbuf.append('\'');
            }
          case 68: break;
          case 30: 
            { return sym(GOAL);
            }
          case 69: break;
          case 31: 
            { return sym(LEFT);
            }
          case 70: break;
          case 32: 
            { return sym(EMBED);
            }
          case 71: break;
          case 33: 
            { return sym(RIGHT);
            }
          case 72: break;
          case 34: 
            { return sym(CLASS);
            }
          case 73: break;
          case 35: 
            { return sym(HEADER);
            }
          case 74: break;
          case 36: 
            { return sym(TYPEOF);
            }
          case 75: break;
          case 37: 
            { return sym(PACKAGE);
            }
          case 76: break;
          case 38: 
            { return sym(NONASSOC);
            }
          case 77: break;
          case 39: 
            { return sym(TERMINALS);
            }
          case 78: break;
          default:
            zzScanError(ZZ_NO_MATCH);
        }
      }
    }
  }


}
