/*
 * Decompiled with CFR 0.152.
 */
package org.extendj.neobeaver.ast;

import java.util.IdentityHashMap;
import java.util.Map;

public class ASTState {
    public static final Cycle NON_CYCLE = new Cycle();
    private static final CircleState CIRCLE_BOTTOM = new CircleState(null);
    private CircleState circle = CIRCLE_BOTTOM;
    private Map<Object, Integer> visited = new IdentityHashMap<Object, Integer>();

    protected boolean inCircle() {
        return this.circle != CIRCLE_BOTTOM;
    }

    protected boolean calledByLazyAttribute() {
        return this.circle.lazyAttribute > 0;
    }

    protected void enterLazyAttribute() {
        ++this.circle.lazyAttribute;
    }

    protected void leaveLazyAttribute() {
        --this.circle.lazyAttribute;
    }

    protected void enterCircle() {
        CircleState next;
        this.circle = next = new CircleState(this.circle);
    }

    protected boolean checkAndSetVisited(Object attribute, int cycle) {
        boolean result = this.visited.containsKey(attribute) && this.visited.get(attribute) == cycle;
        this.visited.put(attribute, cycle);
        return result;
    }

    protected void clearVisited() {
        this.visited.clear();
    }

    protected void resetVisited(Object attribute) {
        this.visited.remove(attribute);
    }

    protected void leaveCircle() {
        this.circle = this.circle.next;
    }

    protected Cycle nextCycle() {
        Cycle cycle;
        this.circle.cycle = cycle = new Cycle();
        return cycle;
    }

    protected Cycle cycle() {
        return this.circle.cycle;
    }

    protected CircleState currentCircle() {
        return this.circle;
    }

    protected void setChangeInCycle() {
        this.circle.change = true;
    }

    protected boolean testAndClearChangeInCycle() {
        boolean change = this.circle.change;
        this.circle.change = false;
        return change;
    }

    protected boolean changeInCycle() {
        return this.circle.change;
    }

    protected boolean lastCycle() {
        return this.circle.lastCycle;
    }

    protected void startLastCycle() {
        this.circle.lastCycle = true;
    }

    protected ASTState() {
    }

    public void reset() {
        this.circle = CIRCLE_BOTTOM;
    }

    protected static class CircleState {
        final CircleState next;
        boolean change = false;
        int lazyAttribute = 0;
        boolean lastCycle = false;
        Cycle cycle = NON_CYCLE;

        protected CircleState(CircleState next) {
            this.next = next;
        }
    }

    protected static class Cycle {
        protected Cycle() {
        }
    }

    protected static class CircularValue {
        Object value;
        Cycle cycle;

        protected CircularValue() {
        }
    }
}

