/*
 * Decompiled with CFR 0.152.
 */
package org.extendj.neobeaver;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.extendj.neobeaver.Item;
import org.extendj.neobeaver.ItemLr1;
import org.extendj.neobeaver.Rule;
import org.extendj.neobeaver.Symbol;
import org.extendj.neobeaver.Tuple;

public class ExtensionBuilderLr1 {
    private final Map<Symbol, Collection<Rule>> byLhs;
    private final BitSet nullable;
    private final Map<Symbol, Set<Symbol>> first;
    private final Map<Symbol, Set<Symbol>> follow;
    private final Map<Tuple<Symbol, Symbol>, Set<Item>> cache = new HashMap<Tuple<Symbol, Symbol>, Set<Item>>();

    public ExtensionBuilderLr1(Map<Symbol, Collection<Rule>> byLhs, BitSet nullable, Map<Symbol, Set<Symbol>> first, Map<Symbol, Set<Symbol>> follow) {
        this.byLhs = byLhs;
        this.nullable = nullable;
        this.first = first;
        this.follow = follow;
    }

    public Collection<? extends Item> extension(Symbol sym, Symbol lookahead) {
        HashSet<? extends Item> nextExtension;
        Tuple<Symbol, Symbol> key = new Tuple<Symbol, Symbol>(sym, lookahead);
        if (this.cache.containsKey(key)) {
            return this.cache.get(key);
        }
        this.cache.put(key, new HashSet());
        do {
            nextExtension = new HashSet<Item>();
            for (Rule rule : this.byLhs.get(sym)) {
                Symbol x;
                ItemLr1 item = new ItemLr1(rule, 0, lookahead);
                nextExtension.add(item);
                if (rule.rhs.isEmpty() || (x = rule.rhs.get(0)).isTerminal()) continue;
                for (Symbol y : this.itemFollows(item)) {
                    nextExtension.addAll(this.extension(x, y));
                }
            }
        } while (this.cache.get(key).addAll(nextExtension));
        return this.cache.get(key);
    }

    private List<Symbol> itemFollows(ItemLr1 item) {
        ArrayList<Symbol> set = new ArrayList<Symbol>();
        for (int i = item.dot + 1; i < item.rule.rhs.size(); ++i) {
            Symbol x = item.rule.rhs.get(i);
            set.addAll((Collection<Symbol>)this.first.get(x));
            if (!x.isTerminal() && this.nullable.get(x.id())) continue;
            return set;
        }
        set.add(item.follow);
        return set;
    }
}

