/*
 * Decompiled with CFR 0.152.
 */
package org.extendj.neobeaver;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.extendj.neobeaver.ExtensionBuilderLr1;
import org.extendj.neobeaver.Grammar;
import org.extendj.neobeaver.Item;
import org.extendj.neobeaver.Rule;
import org.extendj.neobeaver.Symbol;
import org.extendj.neobeaver.TraceEvent;
import org.extendj.neobeaver.TraceHandler;

public class GrammarBuilder {
    public static Grammar build(TraceHandler trace, List<Rule> rules, Set<Symbol> extraTerminals, Symbol goalSym, String embed, String header, String className, String packageName, Set<String> left, Set<String> right, Set<String> nonassoc, Map<String, Integer> precedence) {
        HashMap<Symbol, Set<Item>> extension;
        BitSet nullable;
        HashMap<Symbol, Set<Symbol>> follow;
        HashMap<Symbol, Set<Symbol>> first;
        Map<Symbol, Collection<Rule>> byLhs;
        HashSet<Symbol> nonterminals;
        HashSet<Symbol> syms;
        List<Rule> enumerated;
        HashSet<Rule> canonical;
        Rule goalRule;
        try (TraceEvent ignored = trace.event("goal");){
            goalRule = new Rule(-1, Symbol.GOAL, GrammarBuilder.listOf(goalSym, Symbol.EOF), String.format("return %s;", goalSym.actionName()), Collections.emptyList(), Grammar.typeOf(goalSym, rules));
        }
        try (TraceEvent ignored = trace.event("canonical");){
            canonical = new HashSet<Rule>();
            canonical.addAll(goalRule.canonical());
            canonical.addAll(Grammar.canonicalRules(rules));
        }
        try (TraceEvent ignored = trace.event("enumerate");){
            enumerated = GrammarBuilder.enumerate(canonical);
            syms = new HashSet<Symbol>(extraTerminals);
            syms.addAll(GrammarBuilder.symbols(enumerated));
            nonterminals = new HashSet<Symbol>(syms.size());
            HashSet<Symbol> terminals = new HashSet<Symbol>(syms.size());
            for (Symbol sym : syms) {
                if (sym.isTerminal()) {
                    terminals.add(sym);
                    continue;
                }
                nonterminals.add(sym);
            }
        }
        try (TraceEvent ignored = trace.event("nullable");){
            byLhs = GrammarBuilder.mapByLhs(enumerated, syms);
            first = new HashMap<Symbol, Set<Symbol>>();
            follow = new HashMap<Symbol, Set<Symbol>>();
            nullable = new BitSet(syms.size());
            extension = new HashMap<Symbol, Set<Item>>();
            BitSet diff = new BitSet(syms.size());
            do {
                diff.clear();
                for (Symbol sym : nonterminals) {
                    if (nullable.get(sym.id())) continue;
                    for (Rule rule : byLhs.get(sym)) {
                        if (!rule.rhsNullable(nullable)) continue;
                        diff.set(sym.id());
                    }
                }
                nullable.or(diff);
            } while (!diff.isEmpty());
        }
        ignored = trace.event("first+follow");
        var24_36 = null;
        try {
            boolean change;
            for (Symbol sym : syms) {
                HashSet followSet = new HashSet();
                follow.put(sym, followSet);
                HashSet<Symbol> firstSet = new HashSet<Symbol>();
                first.put(sym, firstSet);
                if (!sym.isTerminal()) continue;
                firstSet.add(sym);
            }
            do {
                change = false;
                for (Symbol sym : nonterminals) {
                    Set followSet;
                    HashSet nextFirst = new HashSet();
                    block52: for (Rule rule : byLhs.get(sym)) {
                        for (Symbol rhs : rule.rhs) {
                            nextFirst.addAll((Collection)first.get(rhs));
                            if (nullable.get(rhs.id())) continue;
                            continue block52;
                        }
                    }
                    HashSet hashSet = new HashSet();
                    for (Rule rule : enumerated) {
                        int index = rule.rhs.indexOf(sym);
                        if (index < 0) continue;
                        boolean addLhs = true;
                        for (int j = index + 1; j < rule.rhs.size(); ++j) {
                            Symbol rhsSym = rule.rhs.get(j);
                            hashSet.addAll((Collection)first.get(rhsSym));
                            if (rhsSym != sym && nullable.get(rhsSym.id())) continue;
                            addLhs = false;
                            break;
                        }
                        if (!addLhs) continue;
                        hashSet.addAll((Collection)follow.get(rule.lhs));
                    }
                    Set set = (Set)first.get(sym);
                    if (!set.containsAll(nextFirst)) {
                        set.addAll(nextFirst);
                        change = true;
                    }
                    if ((followSet = (Set)follow.get(sym)).containsAll(hashSet)) continue;
                    followSet.addAll(hashSet);
                    change = true;
                }
            } while (change);
        }
        catch (Throwable throwable) {
            var24_36 = throwable;
            throw throwable;
        }
        finally {
            if (ignored != null) {
                if (var24_36 != null) {
                    try {
                        ignored.close();
                    }
                    catch (Throwable throwable) {
                        var24_36.addSuppressed(throwable);
                    }
                } else {
                    ignored.close();
                }
            }
        }
        return new Grammar(rules, enumerated, goalSym, goalRule, syms, nullable, first, follow, extension, new ExtensionBuilderLr1(byLhs, nullable, first, follow), embed, header, className, packageName, left, right, nonassoc, precedence);
    }

    private static <T> List<T> listOf(T ... items) {
        ArrayList<T> list = new ArrayList<T>();
        for (T item : items) {
            list.add(item);
        }
        return list;
    }

    private static Map<Symbol, Collection<Rule>> mapByLhs(Collection<Rule> rules, Collection<Symbol> syms) {
        HashMap<Symbol, Collection<Rule>> result = new HashMap<Symbol, Collection<Rule>>();
        for (Symbol sym : syms) {
            result.put(sym, new ArrayList());
        }
        for (Rule rule : rules) {
            ((Collection)result.get(rule.lhs)).add(rule);
        }
        return result;
    }

    private static Set<Symbol> symbols(Collection<Rule> rules) {
        HashSet<Symbol> symbols = new HashSet<Symbol>();
        for (Rule rule : rules) {
            symbols.add(rule.lhs);
            symbols.addAll(rule.rhs);
        }
        return symbols;
    }

    private static List<Rule> enumerate(Collection<Rule> rules) {
        int id = 0;
        ArrayList<Rule> result = new ArrayList<Rule>();
        for (Rule rule : rules) {
            result.add(new Rule(id, rule.lhs, rule.rhs, rule.action, rule.names, rule.type, rule.precedence));
            ++id;
        }
        return result;
    }
}

