/*
 * Decompiled with CFR 0.152.
 */
package org.extendj.neobeaver;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.extendj.neobeaver.Grammar;
import org.extendj.neobeaver.Item;
import org.extendj.neobeaver.Symbol;
import org.extendj.neobeaver.Tuple;
import org.extendj.neobeaver.Util;

public class ItemSet {
    private final int id;
    public final Set<Item> items;
    public final Set<Item> extension;
    public final ItemSet core;

    public ItemSet(int id, Set<Item> items) {
        this.id = id;
        this.items = items;
        this.extension = Collections.emptySet();
        this.core = this;
    }

    public ItemSet(int id, ItemSet core, Set<Item> extension) {
        this.id = id;
        this.items = core.items;
        this.extension = extension;
        this.core = core;
    }

    public int id() {
        return this.id;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(String.format("item set S%d%n", this.id));
        buf.append(this.setToString("  ", this.items));
        buf.append(this.setToString("+ ", this.extension));
        return buf.toString();
    }

    private String setToString(String prefix, Set<Item> set) {
        HashMap<Item, HashSet<Symbol>> followSets = new HashMap<Item, HashSet<Symbol>>();
        for (Item item : set) {
            Item item2 = item.baseItem();
            HashSet<Symbol> syms = (HashSet<Symbol>)followSets.get(item2);
            if (syms == null) {
                syms = new HashSet<Symbol>();
                followSets.put(item2, syms);
            }
            syms.addAll(item.followSyms());
        }
        ArrayList<String> items = new ArrayList<String>();
        for (Map.Entry entry : followSets.entrySet()) {
            String follows = "";
            Item item = (Item)entry.getKey();
            Collection followSyms = (Collection)entry.getValue();
            if (!followSyms.isEmpty()) {
                StringBuilder buf = new StringBuilder();
                for (Symbol follow : followSyms) {
                    if (buf.length() > 0) {
                        buf.append(", ");
                    }
                    buf.append(Util.escape(follow.toString()));
                }
                follows = String.format(" [%s]", buf.toString());
            }
            items.add(String.format("%s%s%s%n", prefix, Util.escape(item.toString()), follows));
        }
        Collections.sort(items);
        StringBuilder stringBuilder = new StringBuilder();
        for (String item : items) {
            stringBuilder.append(item);
        }
        return stringBuilder.toString();
    }

    public Collection<Tuple<Symbol, ItemSet>> followCores() {
        ArrayList<Tuple<Symbol, ItemSet>> result = new ArrayList<Tuple<Symbol, ItemSet>>();
        ArrayList<Item> advanced = new ArrayList<Item>();
        for (Item item : this.items) {
            if (!item.canAdvance()) continue;
            advanced.add(item.advance());
        }
        for (Item item : this.extension) {
            if (!item.canAdvance()) continue;
            advanced.add(item.advance());
        }
        HashMap<Symbol, HashSet<Item>> map = new HashMap<Symbol, HashSet<Item>>();
        for (Item item : advanced) {
            Symbol sym = item.rule.rhs.get(item.dot - 1);
            HashSet<Item> set = (HashSet<Item>)map.get(sym);
            if (set == null) {
                set = new HashSet<Item>();
                map.put(sym, set);
            }
            set.add(item);
        }
        for (Map.Entry entry : map.entrySet()) {
            result.add(new Tuple(entry.getKey(), new ItemSet(-1, (Set)entry.getValue())));
        }
        return result;
    }

    public int hashCode() {
        int hash = 0;
        for (Item item : this.items) {
            hash ^= item.hashCode();
        }
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj instanceof ItemSet) {
            ItemSet other = (ItemSet)obj;
            return other.items.containsAll(this.items) && this.items.containsAll(other.items);
        }
        return false;
    }

    public ItemSet core() {
        return this.core;
    }

    public ItemSet merge(Set<Item> other, Set<Item> extension, Grammar grammar) {
        HashSet<Item> newExtension = new HashSet<Item>(this.extension);
        newExtension.addAll(extension);
        HashSet<Item> coreItems = new HashSet<Item>(this.items);
        coreItems.addAll(other);
        ItemSet newCore = new ItemSet(this.id, coreItems);
        return new ItemSet(this.id, newCore, newExtension);
    }

    public void printGraphNode() {
        System.out.format("  S%d[label=\"\\N\\n", this.id());
        this.printDotSet("  ", this.items);
        this.printDotSet("+ ", this.extension);
        System.out.println("\"];");
    }

    private void printDotSet(String prefix, Set<Item> set) {
        HashMap<Item, HashSet<Symbol>> followSets = new HashMap<Item, HashSet<Symbol>>();
        for (Item item : set) {
            Item base = item.baseItem();
            HashSet<Symbol> syms = (HashSet<Symbol>)followSets.get(base);
            if (syms == null) {
                syms = new HashSet<Symbol>();
                followSets.put(base, syms);
            }
            syms.addAll(item.followSyms());
        }
        ArrayList<String> items = new ArrayList<String>();
        for (Map.Entry entry : followSets.entrySet()) {
            String follows = "";
            Item item = (Item)entry.getKey();
            Collection followSyms = (Collection)entry.getValue();
            if (!followSyms.isEmpty()) {
                StringBuilder buf = new StringBuilder();
                for (Symbol follow : followSyms) {
                    if (buf.length() > 0) {
                        buf.append(", ");
                    }
                    buf.append(Util.escape(follow.toString()));
                }
                follows = String.format(" [%s]", buf.toString());
            }
            items.add(String.format("%s%s%s\\l", prefix, Util.escape(item.toString()), follows));
        }
        Collections.sort(items);
        for (String item : items) {
            System.out.print(item);
        }
    }

    public ItemSet baseCore() {
        HashSet<Item> baseItems = new HashSet<Item>();
        for (Item item : this.items) {
            baseItems.add(item.baseItem());
        }
        return new ItemSet(-1, baseItems);
    }

    public Collection<Item> allItems() {
        ArrayList<Item> all = new ArrayList<Item>();
        all.addAll(this.items);
        all.addAll(this.extension);
        return all;
    }
}

