/*
 * Decompiled with CFR 0.152.
 */
package org.extendj.neobeaver;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.extendj.neobeaver.ListComponent;
import org.extendj.neobeaver.OptionalComponent;
import org.extendj.neobeaver.Symbol;

public class Rule {
    public final int id;
    public final Symbol lhs;
    public final List<Symbol> rhs;
    public final String action;
    public final List<String> names;
    public final String type;
    public final String precedence;

    public Rule(Symbol lhs, List<Symbol> rhs) {
        this(-1, lhs, rhs, "", Rule.defaultNames(rhs), "Symbol", "");
    }

    public Rule(int id, Symbol lhs, List<Symbol> rhs, String action, List<String> names, String type) {
        this(id, lhs, rhs, action, names, type, "");
    }

    public Rule(int id, Symbol lhs, List<Symbol> rhs, String action, List<String> names, String type, String precedence) {
        this.id = id;
        this.lhs = lhs;
        this.rhs = rhs;
        this.action = action.trim();
        this.names = names;
        this.type = type;
        this.precedence = precedence;
    }

    private static List<String> defaultNames(List<Symbol> rhs) {
        ArrayList<String> names = new ArrayList<String>();
        for (Symbol sym : rhs) {
            String name = sym.actionName();
            int id = 1;
            while (names.contains(name)) {
                name = name + id;
                ++id;
            }
            names.add(sym.actionName());
        }
        return names;
    }

    public Collection<? extends Rule> canonical() {
        ArrayList<Rule> result = new ArrayList<Rule>();
        for (List<Symbol> rhs : Rule.split(this.rhs)) {
            result.add(new Rule(-1, this.lhs, rhs, this.action, this.names, this.type, this.precedence));
        }
        return result;
    }

    static Collection<List<Symbol>> split(List<Symbol> rhs) {
        if (rhs.isEmpty()) {
            return Collections.singletonList(Collections.emptyList());
        }
        Symbol head = rhs.get(0);
        ArrayList<Symbol> tail = new ArrayList<Symbol>(rhs);
        tail.remove(0);
        ArrayList<List<Symbol>> result = new ArrayList<List<Symbol>>();
        if (head instanceof OptionalComponent) {
            OptionalComponent opt = (OptionalComponent)head;
            for (List<Symbol> suffix : Rule.split(tail)) {
                ArrayList<Symbol> add = new ArrayList<Symbol>(suffix.size() + 1);
                add.add(opt.sym);
                add.addAll(suffix);
                result.add(add);
            }
            return result;
        }
        if (head instanceof ListComponent) {
            ListComponent list = (ListComponent)head;
            for (List<Symbol> suffix : Rule.split(tail)) {
                ArrayList<Symbol> add = new ArrayList<Symbol>(suffix.size() + 1);
                add.add(list.sym);
                add.addAll(suffix);
                result.add(add);
            }
            return result;
        }
        for (List<Symbol> suffix : Rule.split(tail)) {
            ArrayList<Symbol> add = new ArrayList<Symbol>(suffix.size() + 1);
            add.add(head);
            add.addAll(suffix);
            result.add(add);
        }
        return result;
    }

    public String type() {
        return this.type;
    }

    public boolean rhsNullable(BitSet nullable) {
        for (Symbol sym : this.rhs) {
            if (nullable.get(sym.id())) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.lhs);
        sb.append(" -> ");
        boolean first = true;
        for (Symbol sym : this.rhs) {
            if (!first) {
                sb.append(" ");
            }
            first = false;
            sb.append(sym);
        }
        return sb.toString();
    }

    public String shortDesc() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.lhs);
        buf.append(" -> ");
        for (Symbol tok : this.rhs) {
            if (buf.length() != 0) {
                buf.append(" ");
            }
            buf.append(tok);
        }
        return buf.toString();
    }

    public Collection<? extends Rule> extraRules() {
        ArrayList<? extends Rule> extra = new ArrayList<Rule>();
        for (Symbol sym : this.rhs) {
            extra.addAll(sym.extraRules());
        }
        return extra;
    }

    public String name() {
        if (this.id == -1) {
            return "r?";
        }
        return "r" + this.id;
    }

    public int hashCode() {
        return this.id ^ this.lhs.hashCode() ^ this.rhs.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof Rule) {
            Rule other = (Rule)obj;
            return this.id == other.id && this.lhs == other.lhs && this.rhs.equals(other.rhs);
        }
        return false;
    }
}

