/*
 * Decompiled with CFR 0.152.
 */
package org.extendj.neobeaver;

import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.extendj.neobeaver.BeaverParser;
import org.extendj.neobeaver.Grammar;
import org.extendj.neobeaver.MyParser;
import org.extendj.neobeaver.Parser;
import org.extendj.neobeaver.ProblemHandler;
import org.extendj.neobeaver.ProblemLogger;
import org.extendj.neobeaver.ProblemScope;
import org.extendj.neobeaver.Scanner;
import org.extendj.neobeaver.Symbol;
import org.extendj.neobeaver.TraceEvent;
import org.extendj.neobeaver.TraceHandler;
import org.extendj.neobeaver.TraceHandlerImpl;
import org.extendj.neobeaver.ast.GGrammar;

public class NeoBeaver {
    public static void main(String[] args) throws IOException {
        HashSet<String> files = new HashSet<String>();
        HashSet<String> options = new HashSet<String>();
        for (String arg : args) {
            if (arg.startsWith("-")) {
                options.add(arg);
                continue;
            }
            files.add(arg);
        }
        if (args.length < 1) {
            System.err.println("No input files specified!");
            System.exit(1);
            return;
        }
        boolean errored = NeoBeaver.run(files, Paths.get("", new String[0]), options);
        if (errored) {
            System.exit(1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean run(Collection<String> files, Path destDir, Set<String> options) throws IOException {
        ProblemLogger problems;
        block17: {
            problems = new ProblemLogger();
            TraceHandler trace = options.contains("--trace") ? new TraceHandlerImpl("NeoBeaver") : NeoBeaver.nullTrace();
            try {
                if (options.contains("--tokenize") || options.contains("-t")) {
                    for (String filename : files) {
                        Scanner scanner = new Scanner(new FileReader(new File(filename)));
                        Throwable throwable = null;
                        try {
                            Parser.Token sym;
                            do {
                                sym = scanner.nextToken();
                                System.out.format("%4d: %s%n", sym.getId(), sym);
                            } while (sym.getId() != 17);
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            if (scanner == null) continue;
                            if (throwable != null) {
                                try {
                                    scanner.close();
                                }
                                catch (Throwable throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                                continue;
                            }
                            scanner.close();
                        }
                    }
                    break block17;
                }
                for (String filename : files) {
                    NeoBeaver.process(trace, problems, filename, destDir, options);
                    problems.report();
                }
            }
            finally {
                trace.sendTo("localhost", 6834);
            }
        }
        problems.report();
        return problems.errored();
    }

    public static TraceHandler nullTrace() {
        final TraceEvent nullClose = new TraceEvent(){

            @Override
            public void close() {
            }
        };
        return new TraceHandler(){

            @Override
            public TraceEvent event(String name) {
                return nullClose;
            }

            @Override
            public TraceEvent event(String name, String metadata) {
                return nullClose;
            }

            @Override
            public void sendTo(String host, int port) {
            }
        };
    }

    public static void process(TraceHandler trace, ProblemHandler problems, String filename, Path destDir, Set<String> options) throws IOException {
        block125: {
            try (Scanner scanner = new Scanner(new FileReader(new File(filename)));){
                MyParser parser;
                Grammar grammar;
                GGrammar grammarSpec;
                Object grammarParser;
                ProblemScope scope = new ProblemScope(problems);
                try (TraceEvent ignored = trace.event("parse grammar");){
                    grammarParser = new Parser();
                    grammarSpec = (GGrammar)((Parser)grammarParser).parse(scanner);
                }
                catch (Parser.SyntaxError e) {
                    scope.error(e.getMessage());
                    if (scanner != null) {
                        if (var6_6 != null) {
                            try {
                                scanner.close();
                            }
                            catch (Throwable throwable) {
                                var6_6.addSuppressed(throwable);
                            }
                        } else {
                            scanner.close();
                        }
                    }
                    return;
                }
                TraceEvent ignored = trace.event("build parser");
                grammarParser = null;
                try {
                    grammar = BeaverParser.buildParser(scope, trace, grammarSpec);
                }
                catch (Throwable throwable) {
                    grammarParser = throwable;
                    throw throwable;
                }
                finally {
                    if (ignored != null) {
                        if (grammarParser != null) {
                            try {
                                ignored.close();
                            }
                            catch (Throwable throwable) {
                                ((Throwable)grammarParser).addSuppressed(throwable);
                            }
                        } else {
                            ignored.close();
                        }
                    }
                }
                HashSet<Symbol> unused = new HashSet<Symbol>();
                try (TraceEvent ignored2 = trace.event("check problems");){
                    grammar.checkProblems(scope, unused);
                }
                try (TraceEvent ignored3 = trace.event("build parser");){
                    parser = grammar.buildParser(scope, trace);
                }
                ignored3 = trace.event("check problems");
                var13_27 = null;
                try {
                    parser.checkProblems(grammar, scope, unused, options.contains("--unreachable-error"));
                    parser.transitions.printConflicts(scope, grammar);
                }
                catch (Throwable throwable) {
                    var13_27 = throwable;
                    throw throwable;
                }
                finally {
                    if (ignored3 != null) {
                        if (var13_27 != null) {
                            try {
                                ignored3.close();
                            }
                            catch (Throwable throwable) {
                                var13_27.addSuppressed(throwable);
                            }
                        } else {
                            ignored3.close();
                        }
                    }
                }
                if (scope.errored()) {
                    return;
                }
                if (options.contains("--print-table") || options.contains("-table")) {
                    parser.transitions.printTables(parser.grammar, parser.itemSets);
                    parser.printTables();
                }
                if (options.contains("--print-table") || options.contains("-p")) {
                    parser.printTables();
                }
                if (options.contains("-i")) {
                    parser.printItems();
                }
                if (options.contains("-g")) {
                    parser.printGraph();
                }
                if (options.contains("--standalone") || options.contains("-s")) {
                    parser.printParser();
                }
                if (options.contains("--classic")) {
                    parser.printBeaverSpec();
                }
                if (options.contains("--test")) {
                    parser.printBeaverTestSpec();
                }
                if (!Files.exists(destDir, new LinkOption[0])) {
                    scope.errorf("Error: output directory %s does not exist.", destDir);
                    return;
                }
                if (!grammar.packageName.isEmpty() && !Files.exists(destDir = destDir.resolve(grammar.packageName.replaceAll("\\.", File.separator)), new LinkOption[0])) {
                    System.out.println("Creating output directory: " + destDir);
                    Files.createDirectories(destDir, new FileAttribute[0]);
                }
                Path dest = destDir.resolve(String.format("%s.java", grammar.className));
                if (!options.contains("--beaver")) break block125;
                try (FileOutputStream fout = new FileOutputStream(dest.toFile());
                     PrintStream out = new PrintStream(fout);){
                    grammar.printBeaverParser(out, parser);
                }
            }
        }
    }
}

