// Parser generated by NeoBeaver.

package org.extendj.neobeaver;
import org.extendj.neobeaver.ast.*;

import java.io.IOException;
import java.util.Stack;

public class Parser {

  /** Interface implemented by scanners that this parser can use. */
  public interface TokenScanner {
    Token nextToken() throws IOException;
  }

  public static class SourcePosition {
    int line, column;

    public SourcePosition(int line, int column) {
      this.line = line;
      this.column = column;
    }

    @Override public String toString() {
      return "" + line + ":" + column;
    }
  }

  public interface Symbol {
    SourcePosition getPosition();
  }

  public static class Token implements Symbol {
    public final String literal;
    public final int id;
    public final SourcePosition position;

    public Token(int id, String literal, SourcePosition pos) {
      this.literal = literal;
      this.id = id;
      this.position = pos;
    }

    @Override public String toString() {
      return literal;
    }

    public int getId() {
      return id;
    }

    @Override public SourcePosition getPosition() {
      return position;
    }
  }

  static <T extends ASTNode> T withPos(Symbol sym, T node) {
    return (T) node.setPosition(sym);
  }

  public interface Tokens {
    int HEADER = 0;
    int STRING = 1;
    int ASTERISK = 2;
    int TERMINALS = 3;
    int AT = 4;
    int PACKAGE = 5;
    int GOAL = 6;
    int DOT = 7;
    int QUESTION = 8;
    int ID = 9;
    int RIGHT = 10;
    int TYPEOF = 11;
    int CLASS = 12;
    int EMBED = 13;
    int COMMA = 14;
    int JAVA_CODE = 15;
    int CODE_END = 16;
    int EOF = 17;
    int LEFT = 18;
    int SEMICOLON = 19;
    int EQ = 20;
    int OR = 21;
    int NONASSOC = 22;
    int PLUS = 23;
    int CODE_START = 24;
    int COLONEQ = 25;
  }

  public static class SyntaxError extends Exception {
    private Symbol sym;

    public SyntaxError(Symbol sym) {
      this.sym = sym;
    }

    @Override
    public String getMessage() {
      return String.format("syntax error at token \"%s\" at %s", sym, sym.getPosition());
    }
  }

  void syntaxError(Symbol sym) throws SyntaxError {
    throw new SyntaxError(sym);
  }

  static Token nextToken(TokenScanner in) throws IOException {
    return in.nextToken();
  }

  private static final boolean DEBUG = System.getProperty("debug", "").equalsIgnoreCase("true");

  public Symbol parse(TokenScanner in) throws IOException, SyntaxError {
    Stack<Integer> stateStack = new Stack<Integer>();
    Stack<Symbol> stack = new Stack<Symbol>();
    int state = 1;
    Token next = nextToken(in);
    while (state != -1) {
      if (state == 0) throw new Error("parse error");
      if (DEBUG) {
        System.out.print("state:");
        for (int st : stateStack) {
          System.out.print(" " + st);
        }
        System.out.println(" " + state);
      }
      switch (state) {
        case 1:
          if (DEBUG) System.out.format("[%s] ", next);
          switch (next.getId()) {
            case 0: {
              stateStack.push(state);
              stack.push(next);
              state = 4;
              next = nextToken(in);
              break;
            }
            case 1: {
              syntaxError(next);
            }
            case 2: {
              syntaxError(next);
            }
            case 3: {
              stateStack.push(state);
              stack.push(next);
              state = 5;
              next = nextToken(in);
              break;
            }
            case 4: {
              syntaxError(next);
            }
            case 5: {
              stateStack.push(state);
              stack.push(next);
              state = 7;
              next = nextToken(in);
              break;
            }
            case 6: {
              stateStack.push(state);
              stack.push(next);
              state = 8;
              next = nextToken(in);
              break;
            }
            case 7: {
              syntaxError(next);
            }
            case 8: {
              syntaxError(next);
            }
            case 9: {
              stateStack.push(state);
              stack.push(next);
              state = 10;
              next = nextToken(in);
              break;
            }
            case 10: {
              stateStack.push(state);
              stack.push(next);
              state = 13;
              next = nextToken(in);
              break;
            }
            case 11: {
              stateStack.push(state);
              stack.push(next);
              state = 14;
              next = nextToken(in);
              break;
            }
            case 12: {
              stateStack.push(state);
              stack.push(next);
              state = 16;
              next = nextToken(in);
              break;
            }
            case 13: {
              stateStack.push(state);
              stack.push(next);
              state = 3;
              next = nextToken(in);
              break;
            }
            case 14: {
              syntaxError(next);
            }
            case 15: {
              syntaxError(next);
            }
            case 16: {
              syntaxError(next);
            }
            case 17: {
              syntaxError(next);
            }
            case 18: {
              stateStack.push(state);
              stack.push(next);
              state = 11;
              next = nextToken(in);
              break;
            }
            case 19: {
              syntaxError(next);
            }
            case 20: {
              syntaxError(next);
            }
            case 21: {
              syntaxError(next);
            }
            case 22: {
              stateStack.push(state);
              stack.push(next);
              state = 15;
              next = nextToken(in);
              break;
            }
            case 23: {
              syntaxError(next);
            }
            case 24: {
              syntaxError(next);
            }
            case 25: {
              syntaxError(next);
            }
          }
          break;
        case 2:
          if (DEBUG) System.out.format("[%s] ", next);
          switch (next.getId()) {
            case 0: {
              stateStack.push(state);
              stack.push(next);
              state = 4;
              next = nextToken(in);
              break;
            }
            case 1: {
              syntaxError(next);
            }
            case 2: {
              syntaxError(next);
            }
            case 3: {
              stateStack.push(state);
              stack.push(next);
              state = 5;
              next = nextToken(in);
              break;
            }
            case 4: {
              syntaxError(next);
            }
            case 5: {
              stateStack.push(state);
              stack.push(next);
              state = 7;
              next = nextToken(in);
              break;
            }
            case 6: {
              stateStack.push(state);
              stack.push(next);
              state = 8;
              next = nextToken(in);
              break;
            }
            case 7: {
              syntaxError(next);
            }
            case 8: {
              syntaxError(next);
            }
            case 9: {
              stateStack.push(state);
              stack.push(next);
              state = 10;
              next = nextToken(in);
              break;
            }
            case 10: {
              stateStack.push(state);
              stack.push(next);
              state = 13;
              next = nextToken(in);
              break;
            }
            case 11: {
              stateStack.push(state);
              stack.push(next);
              state = 14;
              next = nextToken(in);
              break;
            }
            case 12: {
              stateStack.push(state);
              stack.push(next);
              state = 16;
              next = nextToken(in);
              break;
            }
            case 13: {
              stateStack.push(state);
              stack.push(next);
              state = 3;
              next = nextToken(in);
              break;
            }
            case 14: {
              syntaxError(next);
            }
            case 15: {
              syntaxError(next);
            }
            case 16: {
              syntaxError(next);
            }
            case 17: {
              List sym1 = (List) stack.pop();
              Symbol _result = reduce0(sym1);
              stack.push(_result);
              state = gotos[stateStack.peek()][7];
              break;
            }
            case 18: {
              stateStack.push(state);
              stack.push(next);
              state = 11;
              next = nextToken(in);
              break;
            }
            case 19: {
              syntaxError(next);
            }
            case 20: {
              syntaxError(next);
            }
            case 21: {
              syntaxError(next);
            }
            case 22: {
              stateStack.push(state);
              stack.push(next);
              state = 15;
              next = nextToken(in);
              break;
            }
            case 23: {
              syntaxError(next);
            }
            case 24: {
              syntaxError(next);
            }
            case 25: {
              syntaxError(next);
            }
          }
          break;
        case 3:
          if (DEBUG) System.out.format("[%s] ", next);
          switch (next.getId()) {
            case 0: {
              syntaxError(next);
            }
            case 1: {
              syntaxError(next);
            }
            case 2: {
              syntaxError(next);
            }
            case 3: {
              syntaxError(next);
            }
            case 4: {
              syntaxError(next);
            }
            case 5: {
              syntaxError(next);
            }
            case 6: {
              syntaxError(next);
            }
            case 7: {
              syntaxError(next);
            }
            case 8: {
              syntaxError(next);
            }
            case 9: {
              syntaxError(next);
            }
            case 10: {
              syntaxError(next);
            }
            case 11: {
              syntaxError(next);
            }
            case 12: {
              syntaxError(next);
            }
            case 13: {
              syntaxError(next);
            }
            case 14: {
              syntaxError(next);
            }
            case 15: {
              syntaxError(next);
            }
            case 16: {
              syntaxError(next);
            }
            case 17: {
              syntaxError(next);
            }
            case 18: {
              syntaxError(next);
            }
            case 19: {
              syntaxError(next);
            }
            case 20: {
              syntaxError(next);
            }
            case 21: {
              syntaxError(next);
            }
            case 22: {
              syntaxError(next);
            }
            case 23: {
              syntaxError(next);
            }
            case 24: {
              stateStack.push(state);
              stack.push(next);
              state = 18;
              next = nextToken(in);
              break;
            }
            case 25: {
              syntaxError(next);
            }
          }
          break;
        case 4:
          if (DEBUG) System.out.format("[%s] ", next);
          switch (next.getId()) {
            case 0: {
              syntaxError(next);
            }
            case 1: {
              syntaxError(next);
            }
            case 2: {
              syntaxError(next);
            }
            case 3: {
              syntaxError(next);
            }
            case 4: {
              syntaxError(next);
            }
            case 5: {
              syntaxError(next);
            }
            case 6: {
              syntaxError(next);
            }
            case 7: {
              syntaxError(next);
            }
            case 8: {
              syntaxError(next);
            }
            case 9: {
              syntaxError(next);
            }
            case 10: {
              syntaxError(next);
            }
            case 11: {
              syntaxError(next);
            }
            case 12: {
              syntaxError(next);
            }
            case 13: {
              syntaxError(next);
            }
            case 14: {
              syntaxError(next);
            }
            case 15: {
              syntaxError(next);
            }
            case 16: {
              syntaxError(next);
            }
            case 17: {
              syntaxError(next);
            }
            case 18: {
              syntaxError(next);
            }
            case 19: {
              syntaxError(next);
            }
            case 20: {
              syntaxError(next);
            }
            case 21: {
              syntaxError(next);
            }
            case 22: {
              syntaxError(next);
            }
            case 23: {
              syntaxError(next);
            }
            case 24: {
              stateStack.push(state);
              stack.push(next);
              state = 19;
              next = nextToken(in);
              break;
            }
            case 25: {
              syntaxError(next);
            }
          }
          break;
        case 5:
          if (DEBUG) System.out.format("[%s] ", next);
          switch (next.getId()) {
            case 0: {
              syntaxError(next);
            }
            case 1: {
              syntaxError(next);
            }
            case 2: {
              syntaxError(next);
            }
            case 3: {
              syntaxError(next);
            }
            case 4: {
              syntaxError(next);
            }
            case 5: {
              syntaxError(next);
            }
            case 6: {
              syntaxError(next);
            }
            case 7: {
              syntaxError(next);
            }
            case 8: {
              syntaxError(next);
            }
            case 9: {
              stateStack.push(state);
              stack.push(next);
              state = 20;
              next = nextToken(in);
              break;
            }
            case 10: {
              syntaxError(next);
            }
            case 11: {
              syntaxError(next);
            }
            case 12: {
              syntaxError(next);
            }
            case 13: {
              syntaxError(next);
            }
            case 14: {
              syntaxError(next);
            }
            case 15: {
              syntaxError(next);
            }
            case 16: {
              syntaxError(next);
            }
            case 17: {
              syntaxError(next);
            }
            case 18: {
              syntaxError(next);
            }
            case 19: {
              syntaxError(next);
            }
            case 20: {
              syntaxError(next);
            }
            case 21: {
              syntaxError(next);
            }
            case 22: {
              syntaxError(next);
            }
            case 23: {
              syntaxError(next);
            }
            case 24: {
              syntaxError(next);
            }
            case 25: {
              syntaxError(next);
            }
          }
          break;
        case 6:
          if (DEBUG) System.out.format("[%s] ", next);
          switch (next.getId()) {
            case 0: {
              syntaxError(next);
            }
            case 1: {
              syntaxError(next);
            }
            case 2: {
              syntaxError(next);
            }
            case 3: {
              syntaxError(next);
            }
            case 4: {
              syntaxError(next);
            }
            case 5: {
              syntaxError(next);
            }
            case 6: {
              syntaxError(next);
            }
            case 7: {
              syntaxError(next);
            }
            case 8: {
              syntaxError(next);
            }
            case 9: {
              stateStack.push(state);
              stack.push(next);
              state = 23;
              next = nextToken(in);
              break;
            }
            case 10: {
              syntaxError(next);
            }
            case 11: {
              syntaxError(next);
            }
            case 12: {
              syntaxError(next);
            }
            case 13: {
              syntaxError(next);
            }
            case 14: {
              syntaxError(next);
            }
            case 15: {
              syntaxError(next);
            }
            case 16: {
              syntaxError(next);
            }
            case 17: {
              syntaxError(next);
            }
            case 18: {
              syntaxError(next);
            }
            case 19: {
              syntaxError(next);
            }
            case 20: {
              syntaxError(next);
            }
            case 21: {
              syntaxError(next);
            }
            case 22: {
              syntaxError(next);
            }
            case 23: {
              syntaxError(next);
            }
            case 24: {
              syntaxError(next);
            }
            case 25: {
              syntaxError(next);
            }
          }
          break;
        case 7:
          if (DEBUG) System.out.format("[%s] ", next);
          switch (next.getId()) {
            case 0: {
              syntaxError(next);
            }
            case 1: {
              stateStack.push(state);
              stack.push(next);
              state = 24;
              next = nextToken(in);
              break;
            }
            case 2: {
              syntaxError(next);
            }
            case 3: {
              syntaxError(next);
            }
            case 4: {
              syntaxError(next);
            }
            case 5: {
              syntaxError(next);
            }
            case 6: {
              syntaxError(next);
            }
            case 7: {
              syntaxError(next);
            }
            case 8: {
              syntaxError(next);
            }
            case 9: {
              syntaxError(next);
            }
            case 10: {
              syntaxError(next);
            }
            case 11: {
              syntaxError(next);
            }
            case 12: {
              syntaxError(next);
            }
            case 13: {
              syntaxError(next);
            }
            case 14: {
              syntaxError(next);
            }
            case 15: {
              syntaxError(next);
            }
            case 16: {
              syntaxError(next);
            }
            case 17: {
              syntaxError(next);
            }
            case 18: {
              syntaxError(next);
            }
            case 19: {
              syntaxError(next);
            }
            case 20: {
              syntaxError(next);
            }
            case 21: {
              syntaxError(next);
            }
            case 22: {
              syntaxError(next);
            }
            case 23: {
              syntaxError(next);
            }
            case 24: {
              syntaxError(next);
            }
            case 25: {
              syntaxError(next);
            }
          }
          break;
        case 8:
          if (DEBUG) System.out.format("[%s] ", next);
          switch (next.getId()) {
            case 0: {
              syntaxError(next);
            }
            case 1: {
              syntaxError(next);
            }
            case 2: {
              syntaxError(next);
            }
            case 3: {
              syntaxError(next);
            }
            case 4: {
              syntaxError(next);
            }
            case 5: {
              syntaxError(next);
            }
            case 6: {
              syntaxError(next);
            }
            case 7: {
              syntaxError(next);
            }
            case 8: {
              syntaxError(next);
            }
            case 9: {
              stateStack.push(state);
              stack.push(next);
              state = 25;
              next = nextToken(in);
              break;
            }
            case 10: {
              syntaxError(next);
            }
            case 11: {
              syntaxError(next);
            }
            case 12: {
              syntaxError(next);
            }
            case 13: {
              syntaxError(next);
            }
            case 14: {
              syntaxError(next);
            }
            case 15: {
              syntaxError(next);
            }
            case 16: {
              syntaxError(next);
            }
            case 17: {
              syntaxError(next);
            }
            case 18: {
              syntaxError(next);
            }
            case 19: {
              syntaxError(next);
            }
            case 20: {
              syntaxError(next);
            }
            case 21: {
              syntaxError(next);
            }
            case 22: {
              syntaxError(next);
            }
            case 23: {
              syntaxError(next);
            }
            case 24: {
              syntaxError(next);
            }
            case 25: {
              syntaxError(next);
            }
          }
          break;
        case 9:
          if (DEBUG) System.out.format("[%s] ", next);
          switch (next.getId()) {
            case 0: {
              GDecl sym1 = (GDecl) stack.pop();
              Symbol _result = reduce1(sym1);
              stack.push(_result);
              state = gotos[stateStack.peek()][0];
              break;
            }
            case 1: {
              syntaxError(next);
            }
            case 2: {
              syntaxError(next);
            }
            case 3: {
              GDecl sym1 = (GDecl) stack.pop();
              Symbol _result = reduce1(sym1);
              stack.push(_result);
              state = gotos[stateStack.peek()][0];
              break;
            }
            case 4: {
              syntaxError(next);
            }
            case 5: {
              GDecl sym1 = (GDecl) stack.pop();
              Symbol _result = reduce1(sym1);
              stack.push(_result);
              state = gotos[stateStack.peek()][0];
              break;
            }
            case 6: {
              GDecl sym1 = (GDecl) stack.pop();
              Symbol _result = reduce1(sym1);
              stack.push(_result);
              state = gotos[stateStack.peek()][0];
              break;
            }
            case 7: {
              syntaxError(next);
            }
            case 8: {
              syntaxError(next);
            }
            case 9: {
              GDecl sym1 = (GDecl) stack.pop();
              Symbol _result = reduce1(sym1);
              stack.push(_result);
              state = gotos[stateStack.peek()][0];
              break;
            }
            case 10: {
              GDecl sym1 = (GDecl) stack.pop();
              Symbol _result = reduce1(sym1);
              stack.push(_result);
              state = gotos[stateStack.peek()][0];
              break;
            }
            case 11: {
              GDecl sym1 = (GDecl) stack.pop();
              Symbol _result = reduce1(sym1);
              stack.push(_result);
              state = gotos[stateStack.peek()][0];
              break;
            }
            case 12: {
              GDecl sym1 = (GDecl) stack.pop();
              Symbol _result = reduce1(sym1);
              stack.push(_result);
              state = gotos[stateStack.peek()][0];
              break;
            }
            case 13: {
              GDecl sym1 = (GDecl) stack.pop();
              Symbol _result = reduce1(sym1);
              stack.push(_result);
              state = gotos[stateStack.peek()][0];
              break;
            }
            case 14: {
              syntaxError(next);
            }
            case 15: {
              syntaxError(next);
            }
            case 16: {
              syntaxError(next);
            }
            case 17: {
              GDecl sym1 = (GDecl) stack.pop();
              Symbol _result = reduce1(sym1);
              stack.push(_result);
              state = gotos[stateStack.peek()][0];
              break;
            }
            case 18: {
              GDecl sym1 = (GDecl) stack.pop();
              Symbol _result = reduce1(sym1);
              stack.push(_result);
              state = gotos[stateStack.peek()][0];
              break;
            }
            case 19: {
              syntaxError(next);
            }
            case 20: {
              syntaxError(next);
            }
            case 21: {
              syntaxError(next);
            }
            case 22: {
              GDecl sym1 = (GDecl) stack.pop();
              Symbol _result = reduce1(sym1);
              stack.push(_result);
              state = gotos[stateStack.peek()][0];
              break;
            }
            case 23: {
              syntaxError(next);
            }
            case 24: {
              syntaxError(next);
            }
            case 25: {
              syntaxError(next);
            }
          }
          break;
        case 10:
          if (DEBUG) System.out.format("[%s] ", next);
          switch (next.getId()) {
            case 0: {
              syntaxError(next);
            }
            case 1: {
              syntaxError(next);
            }
            case 2: {
              syntaxError(next);
            }
            case 3: {
              syntaxError(next);
            }
            case 4: {
              syntaxError(next);
            }
            case 5: {
              syntaxError(next);
            }
            case 6: {
              syntaxError(next);
            }
            case 7: {
              syntaxError(next);
            }
            case 8: {
              syntaxError(next);
            }
            case 9: {
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce2(sym1);
              stack.push(_result);
              state = gotos[stateStack.peek()][10];
              break;
            }
            case 10: {
              syntaxError(next);
            }
            case 11: {
              syntaxError(next);
            }
            case 12: {
              syntaxError(next);
            }
            case 13: {
              syntaxError(next);
            }
            case 14: {
              syntaxError(next);
            }
            case 15: {
              syntaxError(next);
            }
            case 16: {
              syntaxError(next);
            }
            case 17: {
              syntaxError(next);
            }
            case 18: {
              syntaxError(next);
            }
            case 19: {
              syntaxError(next);
            }
            case 20: {
              stateStack.push(state);
              stack.push(next);
              state = 26;
              next = nextToken(in);
              break;
            }
            case 21: {
              syntaxError(next);
            }
            case 22: {
              syntaxError(next);
            }
            case 23: {
              syntaxError(next);
            }
            case 24: {
              syntaxError(next);
            }
            case 25: {
              stateStack.push(state);
              stack.push(next);
              state = 27;
              next = nextToken(in);
              break;
            }
          }
          break;
        case 11:
          if (DEBUG) System.out.format("[%s] ", next);
          switch (next.getId()) {
            case 0: {
              syntaxError(next);
            }
            case 1: {
              syntaxError(next);
            }
            case 2: {
              syntaxError(next);
            }
            case 3: {
              syntaxError(next);
            }
            case 4: {
              syntaxError(next);
            }
            case 5: {
              syntaxError(next);
            }
            case 6: {
              syntaxError(next);
            }
            case 7: {
              syntaxError(next);
            }
            case 8: {
              syntaxError(next);
            }
            case 9: {
              stateStack.push(state);
              stack.push(next);
              state = 20;
              next = nextToken(in);
              break;
            }
            case 10: {
              syntaxError(next);
            }
            case 11: {
              syntaxError(next);
            }
            case 12: {
              syntaxError(next);
            }
            case 13: {
              syntaxError(next);
            }
            case 14: {
              syntaxError(next);
            }
            case 15: {
              syntaxError(next);
            }
            case 16: {
              syntaxError(next);
            }
            case 17: {
              syntaxError(next);
            }
            case 18: {
              syntaxError(next);
            }
            case 19: {
              syntaxError(next);
            }
            case 20: {
              syntaxError(next);
            }
            case 21: {
              syntaxError(next);
            }
            case 22: {
              syntaxError(next);
            }
            case 23: {
              syntaxError(next);
            }
            case 24: {
              syntaxError(next);
            }
            case 25: {
              syntaxError(next);
            }
          }
          break;
        case 12:
          if (DEBUG) System.out.format("[%s] ", next);
          switch (next.getId()) {
            case 0: {
              syntaxError(next);
            }
            case 1: {
              syntaxError(next);
            }
            case 2: {
              syntaxError(next);
            }
            case 3: {
              syntaxError(next);
            }
            case 4: {
              syntaxError(next);
            }
            case 5: {
              syntaxError(next);
            }
            case 6: {
              syntaxError(next);
            }
            case 7: {
              syntaxError(next);
            }
            case 8: {
              syntaxError(next);
            }
            case 9: {
              syntaxError(next);
            }
            case 10: {
              syntaxError(next);
            }
            case 11: {
              syntaxError(next);
            }
            case 12: {
              syntaxError(next);
            }
            case 13: {
              syntaxError(next);
            }
            case 14: {
              syntaxError(next);
            }
            case 15: {
              syntaxError(next);
            }
            case 16: {
              syntaxError(next);
            }
            case 17: {
              stateStack.push(state);
              stack.push(next);
              state = 29;
              next = nextToken(in);
              break;
            }
            case 18: {
              syntaxError(next);
            }
            case 19: {
              syntaxError(next);
            }
            case 20: {
              syntaxError(next);
            }
            case 21: {
              syntaxError(next);
            }
            case 22: {
              syntaxError(next);
            }
            case 23: {
              syntaxError(next);
            }
            case 24: {
              syntaxError(next);
            }
            case 25: {
              syntaxError(next);
            }
          }
          break;
        case 13:
          if (DEBUG) System.out.format("[%s] ", next);
          switch (next.getId()) {
            case 0: {
              syntaxError(next);
            }
            case 1: {
              syntaxError(next);
            }
            case 2: {
              syntaxError(next);
            }
            case 3: {
              syntaxError(next);
            }
            case 4: {
              syntaxError(next);
            }
            case 5: {
              syntaxError(next);
            }
            case 6: {
              syntaxError(next);
            }
            case 7: {
              syntaxError(next);
            }
            case 8: {
              syntaxError(next);
            }
            case 9: {
              stateStack.push(state);
              stack.push(next);
              state = 20;
              next = nextToken(in);
              break;
            }
            case 10: {
              syntaxError(next);
            }
            case 11: {
              syntaxError(next);
            }
            case 12: {
              syntaxError(next);
            }
            case 13: {
              syntaxError(next);
            }
            case 14: {
              syntaxError(next);
            }
            case 15: {
              syntaxError(next);
            }
            case 16: {
              syntaxError(next);
            }
            case 17: {
              syntaxError(next);
            }
            case 18: {
              syntaxError(next);
            }
            case 19: {
              syntaxError(next);
            }
            case 20: {
              syntaxError(next);
            }
            case 21: {
              syntaxError(next);
            }
            case 22: {
              syntaxError(next);
            }
            case 23: {
              syntaxError(next);
            }
            case 24: {
              syntaxError(next);
            }
            case 25: {
              syntaxError(next);
            }
          }
          break;
        case 14:
          if (DEBUG) System.out.format("[%s] ", next);
          switch (next.getId()) {
            case 0: {
              syntaxError(next);
            }
            case 1: {
              syntaxError(next);
            }
            case 2: {
              syntaxError(next);
            }
            case 3: {
              syntaxError(next);
            }
            case 4: {
              syntaxError(next);
            }
            case 5: {
              syntaxError(next);
            }
            case 6: {
              syntaxError(next);
            }
            case 7: {
              syntaxError(next);
            }
            case 8: {
              syntaxError(next);
            }
            case 9: {
              stateStack.push(state);
              stack.push(next);
              state = 31;
              next = nextToken(in);
              break;
            }
            case 10: {
              syntaxError(next);
            }
            case 11: {
              syntaxError(next);
            }
            case 12: {
              syntaxError(next);
            }
            case 13: {
              syntaxError(next);
            }
            case 14: {
              syntaxError(next);
            }
            case 15: {
              syntaxError(next);
            }
            case 16: {
              syntaxError(next);
            }
            case 17: {
              syntaxError(next);
            }
            case 18: {
              syntaxError(next);
            }
            case 19: {
              syntaxError(next);
            }
            case 20: {
              syntaxError(next);
            }
            case 21: {
              syntaxError(next);
            }
            case 22: {
              syntaxError(next);
            }
            case 23: {
              syntaxError(next);
            }
            case 24: {
              syntaxError(next);
            }
            case 25: {
              syntaxError(next);
            }
          }
          break;
        case 15:
          if (DEBUG) System.out.format("[%s] ", next);
          switch (next.getId()) {
            case 0: {
              syntaxError(next);
            }
            case 1: {
              syntaxError(next);
            }
            case 2: {
              syntaxError(next);
            }
            case 3: {
              syntaxError(next);
            }
            case 4: {
              syntaxError(next);
            }
            case 5: {
              syntaxError(next);
            }
            case 6: {
              syntaxError(next);
            }
            case 7: {
              syntaxError(next);
            }
            case 8: {
              syntaxError(next);
            }
            case 9: {
              stateStack.push(state);
              stack.push(next);
              state = 20;
              next = nextToken(in);
              break;
            }
            case 10: {
              syntaxError(next);
            }
            case 11: {
              syntaxError(next);
            }
            case 12: {
              syntaxError(next);
            }
            case 13: {
              syntaxError(next);
            }
            case 14: {
              syntaxError(next);
            }
            case 15: {
              syntaxError(next);
            }
            case 16: {
              syntaxError(next);
            }
            case 17: {
              syntaxError(next);
            }
            case 18: {
              syntaxError(next);
            }
            case 19: {
              syntaxError(next);
            }
            case 20: {
              syntaxError(next);
            }
            case 21: {
              syntaxError(next);
            }
            case 22: {
              syntaxError(next);
            }
            case 23: {
              syntaxError(next);
            }
            case 24: {
              syntaxError(next);
            }
            case 25: {
              syntaxError(next);
            }
          }
          break;
        case 16:
          if (DEBUG) System.out.format("[%s] ", next);
          switch (next.getId()) {
            case 0: {
              syntaxError(next);
            }
            case 1: {
              stateStack.push(state);
              stack.push(next);
              state = 33;
              next = nextToken(in);
              break;
            }
            case 2: {
              syntaxError(next);
            }
            case 3: {
              syntaxError(next);
            }
            case 4: {
              syntaxError(next);
            }
            case 5: {
              syntaxError(next);
            }
            case 6: {
              syntaxError(next);
            }
            case 7: {
              syntaxError(next);
            }
            case 8: {
              syntaxError(next);
            }
            case 9: {
              syntaxError(next);
            }
            case 10: {
              syntaxError(next);
            }
            case 11: {
              syntaxError(next);
            }
            case 12: {
              syntaxError(next);
            }
            case 13: {
              syntaxError(next);
            }
            case 14: {
              syntaxError(next);
            }
            case 15: {
              syntaxError(next);
            }
            case 16: {
              syntaxError(next);
            }
            case 17: {
              syntaxError(next);
            }
            case 18: {
              syntaxError(next);
            }
            case 19: {
              syntaxError(next);
            }
            case 20: {
              syntaxError(next);
            }
            case 21: {
              syntaxError(next);
            }
            case 22: {
              syntaxError(next);
            }
            case 23: {
              syntaxError(next);
            }
            case 24: {
              syntaxError(next);
            }
            case 25: {
              syntaxError(next);
            }
          }
          break;
        case 17:
          if (DEBUG) System.out.format("[%s] ", next);
          switch (next.getId()) {
            case 0: {
              GDecl sym2 = (GDecl) stack.pop();
              List sym1 = (List) stack.pop();
              Symbol _result = reduce3(sym1, sym2);
              stack.push(_result);
              stateStack.pop();
              state = gotos[stateStack.peek()][0];
              break;
            }
            case 1: {
              syntaxError(next);
            }
            case 2: {
              syntaxError(next);
            }
            case 3: {
              GDecl sym2 = (GDecl) stack.pop();
              List sym1 = (List) stack.pop();
              Symbol _result = reduce3(sym1, sym2);
              stack.push(_result);
              stateStack.pop();
              state = gotos[stateStack.peek()][0];
              break;
            }
            case 4: {
              syntaxError(next);
            }
            case 5: {
              GDecl sym2 = (GDecl) stack.pop();
              List sym1 = (List) stack.pop();
              Symbol _result = reduce3(sym1, sym2);
              stack.push(_result);
              stateStack.pop();
              state = gotos[stateStack.peek()][0];
              break;
            }
            case 6: {
              GDecl sym2 = (GDecl) stack.pop();
              List sym1 = (List) stack.pop();
              Symbol _result = reduce3(sym1, sym2);
              stack.push(_result);
              stateStack.pop();
              state = gotos[stateStack.peek()][0];
              break;
            }
            case 7: {
              syntaxError(next);
            }
            case 8: {
              syntaxError(next);
            }
            case 9: {
              GDecl sym2 = (GDecl) stack.pop();
              List sym1 = (List) stack.pop();
              Symbol _result = reduce3(sym1, sym2);
              stack.push(_result);
              stateStack.pop();
              state = gotos[stateStack.peek()][0];
              break;
            }
            case 10: {
              GDecl sym2 = (GDecl) stack.pop();
              List sym1 = (List) stack.pop();
              Symbol _result = reduce3(sym1, sym2);
              stack.push(_result);
              stateStack.pop();
              state = gotos[stateStack.peek()][0];
              break;
            }
            case 11: {
              GDecl sym2 = (GDecl) stack.pop();
              List sym1 = (List) stack.pop();
              Symbol _result = reduce3(sym1, sym2);
              stack.push(_result);
              stateStack.pop();
              state = gotos[stateStack.peek()][0];
              break;
            }
            case 12: {
              GDecl sym2 = (GDecl) stack.pop();
              List sym1 = (List) stack.pop();
              Symbol _result = reduce3(sym1, sym2);
              stack.push(_result);
              stateStack.pop();
              state = gotos[stateStack.peek()][0];
              break;
            }
            case 13: {
              GDecl sym2 = (GDecl) stack.pop();
              List sym1 = (List) stack.pop();
              Symbol _result = reduce3(sym1, sym2);
              stack.push(_result);
              stateStack.pop();
              state = gotos[stateStack.peek()][0];
              break;
            }
            case 14: {
              syntaxError(next);
            }
            case 15: {
              syntaxError(next);
            }
            case 16: {
              syntaxError(next);
            }
            case 17: {
              GDecl sym2 = (GDecl) stack.pop();
              List sym1 = (List) stack.pop();
              Symbol _result = reduce3(sym1, sym2);
              stack.push(_result);
              stateStack.pop();
              state = gotos[stateStack.peek()][0];
              break;
            }
            case 18: {
              GDecl sym2 = (GDecl) stack.pop();
              List sym1 = (List) stack.pop();
              Symbol _result = reduce3(sym1, sym2);
              stack.push(_result);
              stateStack.pop();
              state = gotos[stateStack.peek()][0];
              break;
            }
            case 19: {
              syntaxError(next);
            }
            case 20: {
              syntaxError(next);
            }
            case 21: {
              syntaxError(next);
            }
            case 22: {
              GDecl sym2 = (GDecl) stack.pop();
              List sym1 = (List) stack.pop();
              Symbol _result = reduce3(sym1, sym2);
              stack.push(_result);
              stateStack.pop();
              state = gotos[stateStack.peek()][0];
              break;
            }
            case 23: {
              syntaxError(next);
            }
            case 24: {
              syntaxError(next);
            }
            case 25: {
              syntaxError(next);
            }
          }
          break;
        case 18:
          if (DEBUG) System.out.format("[%s] ", next);
          switch (next.getId()) {
            case 0: {
              syntaxError(next);
            }
            case 1: {
              syntaxError(next);
            }
            case 2: {
              syntaxError(next);
            }
            case 3: {
              syntaxError(next);
            }
            case 4: {
              syntaxError(next);
            }
            case 5: {
              syntaxError(next);
            }
            case 6: {
              syntaxError(next);
            }
            case 7: {
              syntaxError(next);
            }
            case 8: {
              syntaxError(next);
            }
            case 9: {
              syntaxError(next);
            }
            case 10: {
              syntaxError(next);
            }
            case 11: {
              syntaxError(next);
            }
            case 12: {
              syntaxError(next);
            }
            case 13: {
              syntaxError(next);
            }
            case 14: {
              syntaxError(next);
            }
            case 15: {
              stateStack.push(state);
              stack.push(next);
              state = 34;
              next = nextToken(in);
              break;
            }
            case 16: {
              syntaxError(next);
            }
            case 17: {
              syntaxError(next);
            }
            case 18: {
              syntaxError(next);
            }
            case 19: {
              syntaxError(next);
            }
            case 20: {
              syntaxError(next);
            }
            case 21: {
              syntaxError(next);
            }
            case 22: {
              syntaxError(next);
            }
            case 23: {
              syntaxError(next);
            }
            case 24: {
              syntaxError(next);
            }
            case 25: {
              syntaxError(next);
            }
          }
          break;
        case 19:
          if (DEBUG) System.out.format("[%s] ", next);
          switch (next.getId()) {
            case 0: {
              syntaxError(next);
            }
            case 1: {
              syntaxError(next);
            }
            case 2: {
              syntaxError(next);
            }
            case 3: {
              syntaxError(next);
            }
            case 4: {
              syntaxError(next);
            }
            case 5: {
              syntaxError(next);
            }
            case 6: {
              syntaxError(next);
            }
            case 7: {
              syntaxError(next);
            }
            case 8: {
              syntaxError(next);
            }
            case 9: {
              syntaxError(next);
            }
            case 10: {
              syntaxError(next);
            }
            case 11: {
              syntaxError(next);
            }
            case 12: {
              syntaxError(next);
            }
            case 13: {
              syntaxError(next);
            }
            case 14: {
              syntaxError(next);
            }
            case 15: {
              stateStack.push(state);
              stack.push(next);
              state = 35;
              next = nextToken(in);
              break;
            }
            case 16: {
              syntaxError(next);
            }
            case 17: {
              syntaxError(next);
            }
            case 18: {
              syntaxError(next);
            }
            case 19: {
              syntaxError(next);
            }
            case 20: {
              syntaxError(next);
            }
            case 21: {
              syntaxError(next);
            }
            case 22: {
              syntaxError(next);
            }
            case 23: {
              syntaxError(next);
            }
            case 24: {
              syntaxError(next);
            }
            case 25: {
              syntaxError(next);
            }
          }
          break;
        case 20:
          if (DEBUG) System.out.format("[%s] ", next);
          switch (next.getId()) {
            case 0: {
              syntaxError(next);
            }
            case 1: {
              syntaxError(next);
            }
            case 2: {
              syntaxError(next);
            }
            case 3: {
              syntaxError(next);
            }
            case 4: {
              syntaxError(next);
            }
            case 5: {
              syntaxError(next);
            }
            case 6: {
              syntaxError(next);
            }
            case 7: {
              syntaxError(next);
            }
            case 8: {
              syntaxError(next);
            }
            case 9: {
              syntaxError(next);
            }
            case 10: {
              syntaxError(next);
            }
            case 11: {
              syntaxError(next);
            }
            case 12: {
              syntaxError(next);
            }
            case 13: {
              syntaxError(next);
            }
            case 14: {
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce4(sym1);
              stack.push(_result);
              state = gotos[stateStack.peek()][12];
              break;
            }
            case 15: {
              syntaxError(next);
            }
            case 16: {
              syntaxError(next);
            }
            case 17: {
              syntaxError(next);
            }
            case 18: {
              syntaxError(next);
            }
            case 19: {
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce4(sym1);
              stack.push(_result);
              state = gotos[stateStack.peek()][12];
              break;
            }
            case 20: {
              syntaxError(next);
            }
            case 21: {
              syntaxError(next);
            }
            case 22: {
              syntaxError(next);
            }
            case 23: {
              syntaxError(next);
            }
            case 24: {
              syntaxError(next);
            }
            case 25: {
              syntaxError(next);
            }
          }
          break;
        case 21:
          if (DEBUG) System.out.format("[%s] ", next);
          switch (next.getId()) {
            case 0: {
              syntaxError(next);
            }
            case 1: {
              syntaxError(next);
            }
            case 2: {
              syntaxError(next);
            }
            case 3: {
              syntaxError(next);
            }
            case 4: {
              syntaxError(next);
            }
            case 5: {
              syntaxError(next);
            }
            case 6: {
              syntaxError(next);
            }
            case 7: {
              syntaxError(next);
            }
            case 8: {
              syntaxError(next);
            }
            case 9: {
              syntaxError(next);
            }
            case 10: {
              syntaxError(next);
            }
            case 11: {
              syntaxError(next);
            }
            case 12: {
              syntaxError(next);
            }
            case 13: {
              syntaxError(next);
            }
            case 14: {
              GSym sym1 = (GSym) stack.pop();
              Symbol _result = reduce5(sym1);
              stack.push(_result);
              state = gotos[stateStack.peek()][13];
              break;
            }
            case 15: {
              syntaxError(next);
            }
            case 16: {
              syntaxError(next);
            }
            case 17: {
              syntaxError(next);
            }
            case 18: {
              syntaxError(next);
            }
            case 19: {
              GSym sym1 = (GSym) stack.pop();
              Symbol _result = reduce5(sym1);
              stack.push(_result);
              state = gotos[stateStack.peek()][13];
              break;
            }
            case 20: {
              syntaxError(next);
            }
            case 21: {
              syntaxError(next);
            }
            case 22: {
              syntaxError(next);
            }
            case 23: {
              syntaxError(next);
            }
            case 24: {
              syntaxError(next);
            }
            case 25: {
              syntaxError(next);
            }
          }
          break;
        case 22:
          if (DEBUG) System.out.format("[%s] ", next);
          switch (next.getId()) {
            case 0: {
              syntaxError(next);
            }
            case 1: {
              syntaxError(next);
            }
            case 2: {
              syntaxError(next);
            }
            case 3: {
              syntaxError(next);
            }
            case 4: {
              syntaxError(next);
            }
            case 5: {
              syntaxError(next);
            }
            case 6: {
              syntaxError(next);
            }
            case 7: {
              syntaxError(next);
            }
            case 8: {
              syntaxError(next);
            }
            case 9: {
              syntaxError(next);
            }
            case 10: {
              syntaxError(next);
            }
            case 11: {
              syntaxError(next);
            }
            case 12: {
              syntaxError(next);
            }
            case 13: {
              syntaxError(next);
            }
            case 14: {
              stateStack.push(state);
              stack.push(next);
              state = 37;
              next = nextToken(in);
              break;
            }
            case 15: {
              syntaxError(next);
            }
            case 16: {
              syntaxError(next);
            }
            case 17: {
              syntaxError(next);
            }
            case 18: {
              syntaxError(next);
            }
            case 19: {
              stateStack.push(state);
              stack.push(next);
              state = 36;
              next = nextToken(in);
              break;
            }
            case 20: {
              syntaxError(next);
            }
            case 21: {
              syntaxError(next);
            }
            case 22: {
              syntaxError(next);
            }
            case 23: {
              syntaxError(next);
            }
            case 24: {
              syntaxError(next);
            }
            case 25: {
              syntaxError(next);
            }
          }
          break;
        case 23:
          if (DEBUG) System.out.format("[%s] ", next);
          switch (next.getId()) {
            case 0: {
              syntaxError(next);
            }
            case 1: {
              syntaxError(next);
            }
            case 2: {
              syntaxError(next);
            }
            case 3: {
              syntaxError(next);
            }
            case 4: {
              syntaxError(next);
            }
            case 5: {
              syntaxError(next);
            }
            case 6: {
              syntaxError(next);
            }
            case 7: {
              syntaxError(next);
            }
            case 8: {
              syntaxError(next);
            }
            case 9: {
              syntaxError(next);
            }
            case 10: {
              syntaxError(next);
            }
            case 11: {
              syntaxError(next);
            }
            case 12: {
              syntaxError(next);
            }
            case 13: {
              syntaxError(next);
            }
            case 14: {
              syntaxError(next);
            }
            case 15: {
              syntaxError(next);
            }
            case 16: {
              syntaxError(next);
            }
            case 17: {
              syntaxError(next);
            }
            case 18: {
              syntaxError(next);
            }
            case 19: {
              syntaxError(next);
            }
            case 20: {
              stateStack.push(state);
              stack.push(next);
              state = 38;
              next = nextToken(in);
              break;
            }
            case 21: {
              syntaxError(next);
            }
            case 22: {
              syntaxError(next);
            }
            case 23: {
              syntaxError(next);
            }
            case 24: {
              syntaxError(next);
            }
            case 25: {
              stateStack.push(state);
              stack.push(next);
              state = 39;
              next = nextToken(in);
              break;
            }
          }
          break;
        case 24:
          if (DEBUG) System.out.format("[%s] ", next);
          switch (next.getId()) {
            case 0: {
              syntaxError(next);
            }
            case 1: {
              syntaxError(next);
            }
            case 2: {
              syntaxError(next);
            }
            case 3: {
              syntaxError(next);
            }
            case 4: {
              syntaxError(next);
            }
            case 5: {
              syntaxError(next);
            }
            case 6: {
              syntaxError(next);
            }
            case 7: {
              syntaxError(next);
            }
            case 8: {
              syntaxError(next);
            }
            case 9: {
              syntaxError(next);
            }
            case 10: {
              syntaxError(next);
            }
            case 11: {
              syntaxError(next);
            }
            case 12: {
              syntaxError(next);
            }
            case 13: {
              syntaxError(next);
            }
            case 14: {
              syntaxError(next);
            }
            case 15: {
              syntaxError(next);
            }
            case 16: {
              syntaxError(next);
            }
            case 17: {
              syntaxError(next);
            }
            case 18: {
              syntaxError(next);
            }
            case 19: {
              stateStack.push(state);
              stack.push(next);
              state = 40;
              next = nextToken(in);
              break;
            }
            case 20: {
              syntaxError(next);
            }
            case 21: {
              syntaxError(next);
            }
            case 22: {
              syntaxError(next);
            }
            case 23: {
              syntaxError(next);
            }
            case 24: {
              syntaxError(next);
            }
            case 25: {
              syntaxError(next);
            }
          }
          break;
        case 25:
          if (DEBUG) System.out.format("[%s] ", next);
          switch (next.getId()) {
            case 0: {
              syntaxError(next);
            }
            case 1: {
              syntaxError(next);
            }
            case 2: {
              syntaxError(next);
            }
            case 3: {
              syntaxError(next);
            }
            case 4: {
              syntaxError(next);
            }
            case 5: {
              syntaxError(next);
            }
            case 6: {
              syntaxError(next);
            }
            case 7: {
              syntaxError(next);
            }
            case 8: {
              syntaxError(next);
            }
            case 9: {
              syntaxError(next);
            }
            case 10: {
              syntaxError(next);
            }
            case 11: {
              syntaxError(next);
            }
            case 12: {
              syntaxError(next);
            }
            case 13: {
              syntaxError(next);
            }
            case 14: {
              syntaxError(next);
            }
            case 15: {
              syntaxError(next);
            }
            case 16: {
              syntaxError(next);
            }
            case 17: {
              syntaxError(next);
            }
            case 18: {
              syntaxError(next);
            }
            case 19: {
              stateStack.push(state);
              stack.push(next);
              state = 41;
              next = nextToken(in);
              break;
            }
            case 20: {
              syntaxError(next);
            }
            case 21: {
              syntaxError(next);
            }
            case 22: {
              syntaxError(next);
            }
            case 23: {
              syntaxError(next);
            }
            case 24: {
              syntaxError(next);
            }
            case 25: {
              syntaxError(next);
            }
          }
          break;
        case 26:
          if (DEBUG) System.out.format("[%s] ", next);
          switch (next.getId()) {
            case 0: {
              syntaxError(next);
            }
            case 1: {
              syntaxError(next);
            }
            case 2: {
              syntaxError(next);
            }
            case 3: {
              syntaxError(next);
            }
            case 4: {
              Symbol _result = reduce6();
              stack.push(_result);
              stateStack.push(state);
              state = gotos[stateStack.peek()][14];
              break;
            }
            case 5: {
              syntaxError(next);
            }
            case 6: {
              syntaxError(next);
            }
            case 7: {
              syntaxError(next);
            }
            case 8: {
              syntaxError(next);
            }
            case 9: {
              stateStack.push(state);
              stack.push(next);
              state = 42;
              next = nextToken(in);
              break;
            }
            case 10: {
              syntaxError(next);
            }
            case 11: {
              syntaxError(next);
            }
            case 12: {
              syntaxError(next);
            }
            case 13: {
              syntaxError(next);
            }
            case 14: {
              syntaxError(next);
            }
            case 15: {
              syntaxError(next);
            }
            case 16: {
              syntaxError(next);
            }
            case 17: {
              syntaxError(next);
            }
            case 18: {
              syntaxError(next);
            }
            case 19: {
              Symbol _result = reduce6();
              stack.push(_result);
              stateStack.push(state);
              state = gotos[stateStack.peek()][14];
              break;
            }
            case 20: {
              syntaxError(next);
            }
            case 21: {
              Symbol _result = reduce6();
              stack.push(_result);
              stateStack.push(state);
              state = gotos[stateStack.peek()][14];
              break;
            }
            case 22: {
              syntaxError(next);
            }
            case 23: {
              syntaxError(next);
            }
            case 24: {
              Symbol _result = reduce6();
              stack.push(_result);
              stateStack.push(state);
              state = gotos[stateStack.peek()][14];
              break;
            }
            case 25: {
              syntaxError(next);
            }
          }
          break;
        case 27:
          if (DEBUG) System.out.format("[%s] ", next);
          switch (next.getId()) {
            case 0: {
              syntaxError(next);
            }
            case 1: {
              syntaxError(next);
            }
            case 2: {
              syntaxError(next);
            }
            case 3: {
              syntaxError(next);
            }
            case 4: {
              Symbol _result = reduce6();
              stack.push(_result);
              stateStack.push(state);
              state = gotos[stateStack.peek()][14];
              break;
            }
            case 5: {
              syntaxError(next);
            }
            case 6: {
              syntaxError(next);
            }
            case 7: {
              syntaxError(next);
            }
            case 8: {
              syntaxError(next);
            }
            case 9: {
              stateStack.push(state);
              stack.push(next);
              state = 42;
              next = nextToken(in);
              break;
            }
            case 10: {
              syntaxError(next);
            }
            case 11: {
              syntaxError(next);
            }
            case 12: {
              syntaxError(next);
            }
            case 13: {
              syntaxError(next);
            }
            case 14: {
              syntaxError(next);
            }
            case 15: {
              syntaxError(next);
            }
            case 16: {
              syntaxError(next);
            }
            case 17: {
              syntaxError(next);
            }
            case 18: {
              syntaxError(next);
            }
            case 19: {
              Symbol _result = reduce6();
              stack.push(_result);
              stateStack.push(state);
              state = gotos[stateStack.peek()][14];
              break;
            }
            case 20: {
              syntaxError(next);
            }
            case 21: {
              Symbol _result = reduce6();
              stack.push(_result);
              stateStack.push(state);
              state = gotos[stateStack.peek()][14];
              break;
            }
            case 22: {
              syntaxError(next);
            }
            case 23: {
              syntaxError(next);
            }
            case 24: {
              Symbol _result = reduce6();
              stack.push(_result);
              stateStack.push(state);
              state = gotos[stateStack.peek()][14];
              break;
            }
            case 25: {
              syntaxError(next);
            }
          }
          break;
        case 28:
          if (DEBUG) System.out.format("[%s] ", next);
          switch (next.getId()) {
            case 0: {
              syntaxError(next);
            }
            case 1: {
              syntaxError(next);
            }
            case 2: {
              syntaxError(next);
            }
            case 3: {
              syntaxError(next);
            }
            case 4: {
              syntaxError(next);
            }
            case 5: {
              syntaxError(next);
            }
            case 6: {
              syntaxError(next);
            }
            case 7: {
              syntaxError(next);
            }
            case 8: {
              syntaxError(next);
            }
            case 9: {
              syntaxError(next);
            }
            case 10: {
              syntaxError(next);
            }
            case 11: {
              syntaxError(next);
            }
            case 12: {
              syntaxError(next);
            }
            case 13: {
              syntaxError(next);
            }
            case 14: {
              stateStack.push(state);
              stack.push(next);
              state = 37;
              next = nextToken(in);
              break;
            }
            case 15: {
              syntaxError(next);
            }
            case 16: {
              syntaxError(next);
            }
            case 17: {
              syntaxError(next);
            }
            case 18: {
              syntaxError(next);
            }
            case 19: {
              stateStack.push(state);
              stack.push(next);
              state = 49;
              next = nextToken(in);
              break;
            }
            case 20: {
              syntaxError(next);
            }
            case 21: {
              syntaxError(next);
            }
            case 22: {
              syntaxError(next);
            }
            case 23: {
              syntaxError(next);
            }
            case 24: {
              syntaxError(next);
            }
            case 25: {
              syntaxError(next);
            }
          }
          break;
        case 29:
          if (DEBUG) System.out.format("[%s] ", next);
          switch (next.getId()) {
            case 0: {
              syntaxError(next);
            }
            case 1: {
              syntaxError(next);
            }
            case 2: {
              syntaxError(next);
            }
            case 3: {
              syntaxError(next);
            }
            case 4: {
              syntaxError(next);
            }
            case 5: {
              syntaxError(next);
            }
            case 6: {
              syntaxError(next);
            }
            case 7: {
              syntaxError(next);
            }
            case 8: {
              syntaxError(next);
            }
            case 9: {
              syntaxError(next);
            }
            case 10: {
              syntaxError(next);
            }
            case 11: {
              syntaxError(next);
            }
            case 12: {
              syntaxError(next);
            }
            case 13: {
              syntaxError(next);
            }
            case 14: {
              syntaxError(next);
            }
            case 15: {
              syntaxError(next);
            }
            case 16: {
              syntaxError(next);
            }
            case 17: {
              Symbol sym2 = (Symbol) stack.pop();
              GGrammar sym1 = (GGrammar) stack.pop();
              Symbol _result = reduce7(sym1, sym2);
              stack.push(_result);
              stateStack.pop();
              state = gotos[stateStack.peek()][3];
              break;
            }
            case 18: {
              syntaxError(next);
            }
            case 19: {
              syntaxError(next);
            }
            case 20: {
              syntaxError(next);
            }
            case 21: {
              syntaxError(next);
            }
            case 22: {
              syntaxError(next);
            }
            case 23: {
              syntaxError(next);
            }
            case 24: {
              syntaxError(next);
            }
            case 25: {
              syntaxError(next);
            }
          }
          break;
        case 30:
          if (DEBUG) System.out.format("[%s] ", next);
          switch (next.getId()) {
            case 0: {
              syntaxError(next);
            }
            case 1: {
              syntaxError(next);
            }
            case 2: {
              syntaxError(next);
            }
            case 3: {
              syntaxError(next);
            }
            case 4: {
              syntaxError(next);
            }
            case 5: {
              syntaxError(next);
            }
            case 6: {
              syntaxError(next);
            }
            case 7: {
              syntaxError(next);
            }
            case 8: {
              syntaxError(next);
            }
            case 9: {
              syntaxError(next);
            }
            case 10: {
              syntaxError(next);
            }
            case 11: {
              syntaxError(next);
            }
            case 12: {
              syntaxError(next);
            }
            case 13: {
              syntaxError(next);
            }
            case 14: {
              stateStack.push(state);
              stack.push(next);
              state = 37;
              next = nextToken(in);
              break;
            }
            case 15: {
              syntaxError(next);
            }
            case 16: {
              syntaxError(next);
            }
            case 17: {
              syntaxError(next);
            }
            case 18: {
              syntaxError(next);
            }
            case 19: {
              stateStack.push(state);
              stack.push(next);
              state = 50;
              next = nextToken(in);
              break;
            }
            case 20: {
              syntaxError(next);
            }
            case 21: {
              syntaxError(next);
            }
            case 22: {
              syntaxError(next);
            }
            case 23: {
              syntaxError(next);
            }
            case 24: {
              syntaxError(next);
            }
            case 25: {
              syntaxError(next);
            }
          }
          break;
        case 31:
          if (DEBUG) System.out.format("[%s] ", next);
          switch (next.getId()) {
            case 0: {
              syntaxError(next);
            }
            case 1: {
              syntaxError(next);
            }
            case 2: {
              syntaxError(next);
            }
            case 3: {
              syntaxError(next);
            }
            case 4: {
              syntaxError(next);
            }
            case 5: {
              syntaxError(next);
            }
            case 6: {
              syntaxError(next);
            }
            case 7: {
              syntaxError(next);
            }
            case 8: {
              syntaxError(next);
            }
            case 9: {
              syntaxError(next);
            }
            case 10: {
              syntaxError(next);
            }
            case 11: {
              syntaxError(next);
            }
            case 12: {
              syntaxError(next);
            }
            case 13: {
              syntaxError(next);
            }
            case 14: {
              syntaxError(next);
            }
            case 15: {
              syntaxError(next);
            }
            case 16: {
              syntaxError(next);
            }
            case 17: {
              syntaxError(next);
            }
            case 18: {
              syntaxError(next);
            }
            case 19: {
              syntaxError(next);
            }
            case 20: {
              stateStack.push(state);
              stack.push(next);
              state = 51;
              next = nextToken(in);
              break;
            }
            case 21: {
              syntaxError(next);
            }
            case 22: {
              syntaxError(next);
            }
            case 23: {
              syntaxError(next);
            }
            case 24: {
              syntaxError(next);
            }
            case 25: {
              syntaxError(next);
            }
          }
          break;
        case 32:
          if (DEBUG) System.out.format("[%s] ", next);
          switch (next.getId()) {
            case 0: {
              syntaxError(next);
            }
            case 1: {
              syntaxError(next);
            }
            case 2: {
              syntaxError(next);
            }
            case 3: {
              syntaxError(next);
            }
            case 4: {
              syntaxError(next);
            }
            case 5: {
              syntaxError(next);
            }
            case 6: {
              syntaxError(next);
            }
            case 7: {
              syntaxError(next);
            }
            case 8: {
              syntaxError(next);
            }
            case 9: {
              syntaxError(next);
            }
            case 10: {
              syntaxError(next);
            }
            case 11: {
              syntaxError(next);
            }
            case 12: {
              syntaxError(next);
            }
            case 13: {
              syntaxError(next);
            }
            case 14: {
              stateStack.push(state);
              stack.push(next);
              state = 37;
              next = nextToken(in);
              break;
            }
            case 15: {
              syntaxError(next);
            }
            case 16: {
              syntaxError(next);
            }
            case 17: {
              syntaxError(next);
            }
            case 18: {
              syntaxError(next);
            }
            case 19: {
              stateStack.push(state);
              stack.push(next);
              state = 52;
              next = nextToken(in);
              break;
            }
            case 20: {
              syntaxError(next);
            }
            case 21: {
              syntaxError(next);
            }
            case 22: {
              syntaxError(next);
            }
            case 23: {
              syntaxError(next);
            }
            case 24: {
              syntaxError(next);
            }
            case 25: {
              syntaxError(next);
            }
          }
          break;
        case 33:
          if (DEBUG) System.out.format("[%s] ", next);
          switch (next.getId()) {
            case 0: {
              syntaxError(next);
            }
            case 1: {
              syntaxError(next);
            }
            case 2: {
              syntaxError(next);
            }
            case 3: {
              syntaxError(next);
            }
            case 4: {
              syntaxError(next);
            }
            case 5: {
              syntaxError(next);
            }
            case 6: {
              syntaxError(next);
            }
            case 7: {
              syntaxError(next);
            }
            case 8: {
              syntaxError(next);
            }
            case 9: {
              syntaxError(next);
            }
            case 10: {
              syntaxError(next);
            }
            case 11: {
              syntaxError(next);
            }
            case 12: {
              syntaxError(next);
            }
            case 13: {
              syntaxError(next);
            }
            case 14: {
              syntaxError(next);
            }
            case 15: {
              syntaxError(next);
            }
            case 16: {
              syntaxError(next);
            }
            case 17: {
              syntaxError(next);
            }
            case 18: {
              syntaxError(next);
            }
            case 19: {
              stateStack.push(state);
              stack.push(next);
              state = 53;
              next = nextToken(in);
              break;
            }
            case 20: {
              syntaxError(next);
            }
            case 21: {
              syntaxError(next);
            }
            case 22: {
              syntaxError(next);
            }
            case 23: {
              syntaxError(next);
            }
            case 24: {
              syntaxError(next);
            }
            case 25: {
              syntaxError(next);
            }
          }
          break;
        case 34:
          if (DEBUG) System.out.format("[%s] ", next);
          switch (next.getId()) {
            case 0: {
              syntaxError(next);
            }
            case 1: {
              syntaxError(next);
            }
            case 2: {
              syntaxError(next);
            }
            case 3: {
              syntaxError(next);
            }
            case 4: {
              syntaxError(next);
            }
            case 5: {
              syntaxError(next);
            }
            case 6: {
              syntaxError(next);
            }
            case 7: {
              syntaxError(next);
            }
            case 8: {
              syntaxError(next);
            }
            case 9: {
              syntaxError(next);
            }
            case 10: {
              syntaxError(next);
            }
            case 11: {
              syntaxError(next);
            }
            case 12: {
              syntaxError(next);
            }
            case 13: {
              syntaxError(next);
            }
            case 14: {
              syntaxError(next);
            }
            case 15: {
              syntaxError(next);
            }
            case 16: {
              stateStack.push(state);
              stack.push(next);
              state = 54;
              next = nextToken(in);
              break;
            }
            case 17: {
              syntaxError(next);
            }
            case 18: {
              syntaxError(next);
            }
            case 19: {
              syntaxError(next);
            }
            case 20: {
              syntaxError(next);
            }
            case 21: {
              syntaxError(next);
            }
            case 22: {
              syntaxError(next);
            }
            case 23: {
              syntaxError(next);
            }
            case 24: {
              syntaxError(next);
            }
            case 25: {
              syntaxError(next);
            }
          }
          break;
        case 35:
          if (DEBUG) System.out.format("[%s] ", next);
          switch (next.getId()) {
            case 0: {
              syntaxError(next);
            }
            case 1: {
              syntaxError(next);
            }
            case 2: {
              syntaxError(next);
            }
            case 3: {
              syntaxError(next);
            }
            case 4: {
              syntaxError(next);
            }
            case 5: {
              syntaxError(next);
            }
            case 6: {
              syntaxError(next);
            }
            case 7: {
              syntaxError(next);
            }
            case 8: {
              syntaxError(next);
            }
            case 9: {
              syntaxError(next);
            }
            case 10: {
              syntaxError(next);
            }
            case 11: {
              syntaxError(next);
            }
            case 12: {
              syntaxError(next);
            }
            case 13: {
              syntaxError(next);
            }
            case 14: {
              syntaxError(next);
            }
            case 15: {
              syntaxError(next);
            }
            case 16: {
              stateStack.push(state);
              stack.push(next);
              state = 55;
              next = nextToken(in);
              break;
            }
            case 17: {
              syntaxError(next);
            }
            case 18: {
              syntaxError(next);
            }
            case 19: {
              syntaxError(next);
            }
            case 20: {
              syntaxError(next);
            }
            case 21: {
              syntaxError(next);
            }
            case 22: {
              syntaxError(next);
            }
            case 23: {
              syntaxError(next);
            }
            case 24: {
              syntaxError(next);
            }
            case 25: {
              syntaxError(next);
            }
          }
          break;
        case 36:
          if (DEBUG) System.out.format("[%s] ", next);
          switch (next.getId()) {
            case 0: {
              Symbol sym3 = (Symbol) stack.pop();
              List sym2 = (List) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce8(sym1, sym2, sym3);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][11];
              break;
            }
            case 1: {
              syntaxError(next);
            }
            case 2: {
              syntaxError(next);
            }
            case 3: {
              Symbol sym3 = (Symbol) stack.pop();
              List sym2 = (List) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce8(sym1, sym2, sym3);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][11];
              break;
            }
            case 4: {
              syntaxError(next);
            }
            case 5: {
              Symbol sym3 = (Symbol) stack.pop();
              List sym2 = (List) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce8(sym1, sym2, sym3);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][11];
              break;
            }
            case 6: {
              Symbol sym3 = (Symbol) stack.pop();
              List sym2 = (List) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce8(sym1, sym2, sym3);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][11];
              break;
            }
            case 7: {
              syntaxError(next);
            }
            case 8: {
              syntaxError(next);
            }
            case 9: {
              Symbol sym3 = (Symbol) stack.pop();
              List sym2 = (List) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce8(sym1, sym2, sym3);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][11];
              break;
            }
            case 10: {
              Symbol sym3 = (Symbol) stack.pop();
              List sym2 = (List) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce8(sym1, sym2, sym3);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][11];
              break;
            }
            case 11: {
              Symbol sym3 = (Symbol) stack.pop();
              List sym2 = (List) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce8(sym1, sym2, sym3);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][11];
              break;
            }
            case 12: {
              Symbol sym3 = (Symbol) stack.pop();
              List sym2 = (List) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce8(sym1, sym2, sym3);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][11];
              break;
            }
            case 13: {
              Symbol sym3 = (Symbol) stack.pop();
              List sym2 = (List) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce8(sym1, sym2, sym3);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][11];
              break;
            }
            case 14: {
              syntaxError(next);
            }
            case 15: {
              syntaxError(next);
            }
            case 16: {
              syntaxError(next);
            }
            case 17: {
              Symbol sym3 = (Symbol) stack.pop();
              List sym2 = (List) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce8(sym1, sym2, sym3);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][11];
              break;
            }
            case 18: {
              Symbol sym3 = (Symbol) stack.pop();
              List sym2 = (List) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce8(sym1, sym2, sym3);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][11];
              break;
            }
            case 19: {
              syntaxError(next);
            }
            case 20: {
              syntaxError(next);
            }
            case 21: {
              syntaxError(next);
            }
            case 22: {
              Symbol sym3 = (Symbol) stack.pop();
              List sym2 = (List) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce8(sym1, sym2, sym3);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][11];
              break;
            }
            case 23: {
              syntaxError(next);
            }
            case 24: {
              syntaxError(next);
            }
            case 25: {
              syntaxError(next);
            }
          }
          break;
        case 37:
          if (DEBUG) System.out.format("[%s] ", next);
          switch (next.getId()) {
            case 0: {
              syntaxError(next);
            }
            case 1: {
              syntaxError(next);
            }
            case 2: {
              syntaxError(next);
            }
            case 3: {
              syntaxError(next);
            }
            case 4: {
              syntaxError(next);
            }
            case 5: {
              syntaxError(next);
            }
            case 6: {
              syntaxError(next);
            }
            case 7: {
              syntaxError(next);
            }
            case 8: {
              syntaxError(next);
            }
            case 9: {
              stateStack.push(state);
              stack.push(next);
              state = 20;
              next = nextToken(in);
              break;
            }
            case 10: {
              syntaxError(next);
            }
            case 11: {
              syntaxError(next);
            }
            case 12: {
              syntaxError(next);
            }
            case 13: {
              syntaxError(next);
            }
            case 14: {
              syntaxError(next);
            }
            case 15: {
              syntaxError(next);
            }
            case 16: {
              syntaxError(next);
            }
            case 17: {
              syntaxError(next);
            }
            case 18: {
              syntaxError(next);
            }
            case 19: {
              syntaxError(next);
            }
            case 20: {
              syntaxError(next);
            }
            case 21: {
              syntaxError(next);
            }
            case 22: {
              syntaxError(next);
            }
            case 23: {
              syntaxError(next);
            }
            case 24: {
              syntaxError(next);
            }
            case 25: {
              syntaxError(next);
            }
          }
          break;
        case 38:
          if (DEBUG) System.out.format("[%s] ", next);
          switch (next.getId()) {
            case 0: {
              syntaxError(next);
            }
            case 1: {
              syntaxError(next);
            }
            case 2: {
              syntaxError(next);
            }
            case 3: {
              syntaxError(next);
            }
            case 4: {
              Symbol _result = reduce6();
              stack.push(_result);
              stateStack.push(state);
              state = gotos[stateStack.peek()][14];
              break;
            }
            case 5: {
              syntaxError(next);
            }
            case 6: {
              syntaxError(next);
            }
            case 7: {
              syntaxError(next);
            }
            case 8: {
              syntaxError(next);
            }
            case 9: {
              stateStack.push(state);
              stack.push(next);
              state = 42;
              next = nextToken(in);
              break;
            }
            case 10: {
              syntaxError(next);
            }
            case 11: {
              syntaxError(next);
            }
            case 12: {
              syntaxError(next);
            }
            case 13: {
              syntaxError(next);
            }
            case 14: {
              syntaxError(next);
            }
            case 15: {
              syntaxError(next);
            }
            case 16: {
              syntaxError(next);
            }
            case 17: {
              syntaxError(next);
            }
            case 18: {
              syntaxError(next);
            }
            case 19: {
              Symbol _result = reduce6();
              stack.push(_result);
              stateStack.push(state);
              state = gotos[stateStack.peek()][14];
              break;
            }
            case 20: {
              syntaxError(next);
            }
            case 21: {
              Symbol _result = reduce6();
              stack.push(_result);
              stateStack.push(state);
              state = gotos[stateStack.peek()][14];
              break;
            }
            case 22: {
              syntaxError(next);
            }
            case 23: {
              syntaxError(next);
            }
            case 24: {
              Symbol _result = reduce6();
              stack.push(_result);
              stateStack.push(state);
              state = gotos[stateStack.peek()][14];
              break;
            }
            case 25: {
              syntaxError(next);
            }
          }
          break;
        case 39:
          if (DEBUG) System.out.format("[%s] ", next);
          switch (next.getId()) {
            case 0: {
              syntaxError(next);
            }
            case 1: {
              syntaxError(next);
            }
            case 2: {
              syntaxError(next);
            }
            case 3: {
              syntaxError(next);
            }
            case 4: {
              Symbol _result = reduce6();
              stack.push(_result);
              stateStack.push(state);
              state = gotos[stateStack.peek()][14];
              break;
            }
            case 5: {
              syntaxError(next);
            }
            case 6: {
              syntaxError(next);
            }
            case 7: {
              syntaxError(next);
            }
            case 8: {
              syntaxError(next);
            }
            case 9: {
              stateStack.push(state);
              stack.push(next);
              state = 42;
              next = nextToken(in);
              break;
            }
            case 10: {
              syntaxError(next);
            }
            case 11: {
              syntaxError(next);
            }
            case 12: {
              syntaxError(next);
            }
            case 13: {
              syntaxError(next);
            }
            case 14: {
              syntaxError(next);
            }
            case 15: {
              syntaxError(next);
            }
            case 16: {
              syntaxError(next);
            }
            case 17: {
              syntaxError(next);
            }
            case 18: {
              syntaxError(next);
            }
            case 19: {
              Symbol _result = reduce6();
              stack.push(_result);
              stateStack.push(state);
              state = gotos[stateStack.peek()][14];
              break;
            }
            case 20: {
              syntaxError(next);
            }
            case 21: {
              Symbol _result = reduce6();
              stack.push(_result);
              stateStack.push(state);
              state = gotos[stateStack.peek()][14];
              break;
            }
            case 22: {
              syntaxError(next);
            }
            case 23: {
              syntaxError(next);
            }
            case 24: {
              Symbol _result = reduce6();
              stack.push(_result);
              stateStack.push(state);
              state = gotos[stateStack.peek()][14];
              break;
            }
            case 25: {
              syntaxError(next);
            }
          }
          break;
        case 40:
          if (DEBUG) System.out.format("[%s] ", next);
          switch (next.getId()) {
            case 0: {
              Symbol sym3 = (Symbol) stack.pop();
              Symbol sym2 = (Symbol) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce9(sym1, sym2, sym3);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][11];
              break;
            }
            case 1: {
              syntaxError(next);
            }
            case 2: {
              syntaxError(next);
            }
            case 3: {
              Symbol sym3 = (Symbol) stack.pop();
              Symbol sym2 = (Symbol) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce9(sym1, sym2, sym3);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][11];
              break;
            }
            case 4: {
              syntaxError(next);
            }
            case 5: {
              Symbol sym3 = (Symbol) stack.pop();
              Symbol sym2 = (Symbol) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce9(sym1, sym2, sym3);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][11];
              break;
            }
            case 6: {
              Symbol sym3 = (Symbol) stack.pop();
              Symbol sym2 = (Symbol) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce9(sym1, sym2, sym3);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][11];
              break;
            }
            case 7: {
              syntaxError(next);
            }
            case 8: {
              syntaxError(next);
            }
            case 9: {
              Symbol sym3 = (Symbol) stack.pop();
              Symbol sym2 = (Symbol) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce9(sym1, sym2, sym3);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][11];
              break;
            }
            case 10: {
              Symbol sym3 = (Symbol) stack.pop();
              Symbol sym2 = (Symbol) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce9(sym1, sym2, sym3);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][11];
              break;
            }
            case 11: {
              Symbol sym3 = (Symbol) stack.pop();
              Symbol sym2 = (Symbol) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce9(sym1, sym2, sym3);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][11];
              break;
            }
            case 12: {
              Symbol sym3 = (Symbol) stack.pop();
              Symbol sym2 = (Symbol) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce9(sym1, sym2, sym3);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][11];
              break;
            }
            case 13: {
              Symbol sym3 = (Symbol) stack.pop();
              Symbol sym2 = (Symbol) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce9(sym1, sym2, sym3);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][11];
              break;
            }
            case 14: {
              syntaxError(next);
            }
            case 15: {
              syntaxError(next);
            }
            case 16: {
              syntaxError(next);
            }
            case 17: {
              Symbol sym3 = (Symbol) stack.pop();
              Symbol sym2 = (Symbol) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce9(sym1, sym2, sym3);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][11];
              break;
            }
            case 18: {
              Symbol sym3 = (Symbol) stack.pop();
              Symbol sym2 = (Symbol) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce9(sym1, sym2, sym3);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][11];
              break;
            }
            case 19: {
              syntaxError(next);
            }
            case 20: {
              syntaxError(next);
            }
            case 21: {
              syntaxError(next);
            }
            case 22: {
              Symbol sym3 = (Symbol) stack.pop();
              Symbol sym2 = (Symbol) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce9(sym1, sym2, sym3);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][11];
              break;
            }
            case 23: {
              syntaxError(next);
            }
            case 24: {
              syntaxError(next);
            }
            case 25: {
              syntaxError(next);
            }
          }
          break;
        case 41:
          if (DEBUG) System.out.format("[%s] ", next);
          switch (next.getId()) {
            case 0: {
              Symbol sym3 = (Symbol) stack.pop();
              Symbol sym2 = (Symbol) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce10(sym1, sym2, sym3);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][11];
              break;
            }
            case 1: {
              syntaxError(next);
            }
            case 2: {
              syntaxError(next);
            }
            case 3: {
              Symbol sym3 = (Symbol) stack.pop();
              Symbol sym2 = (Symbol) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce10(sym1, sym2, sym3);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][11];
              break;
            }
            case 4: {
              syntaxError(next);
            }
            case 5: {
              Symbol sym3 = (Symbol) stack.pop();
              Symbol sym2 = (Symbol) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce10(sym1, sym2, sym3);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][11];
              break;
            }
            case 6: {
              Symbol sym3 = (Symbol) stack.pop();
              Symbol sym2 = (Symbol) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce10(sym1, sym2, sym3);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][11];
              break;
            }
            case 7: {
              syntaxError(next);
            }
            case 8: {
              syntaxError(next);
            }
            case 9: {
              Symbol sym3 = (Symbol) stack.pop();
              Symbol sym2 = (Symbol) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce10(sym1, sym2, sym3);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][11];
              break;
            }
            case 10: {
              Symbol sym3 = (Symbol) stack.pop();
              Symbol sym2 = (Symbol) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce10(sym1, sym2, sym3);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][11];
              break;
            }
            case 11: {
              Symbol sym3 = (Symbol) stack.pop();
              Symbol sym2 = (Symbol) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce10(sym1, sym2, sym3);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][11];
              break;
            }
            case 12: {
              Symbol sym3 = (Symbol) stack.pop();
              Symbol sym2 = (Symbol) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce10(sym1, sym2, sym3);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][11];
              break;
            }
            case 13: {
              Symbol sym3 = (Symbol) stack.pop();
              Symbol sym2 = (Symbol) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce10(sym1, sym2, sym3);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][11];
              break;
            }
            case 14: {
              syntaxError(next);
            }
            case 15: {
              syntaxError(next);
            }
            case 16: {
              syntaxError(next);
            }
            case 17: {
              Symbol sym3 = (Symbol) stack.pop();
              Symbol sym2 = (Symbol) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce10(sym1, sym2, sym3);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][11];
              break;
            }
            case 18: {
              Symbol sym3 = (Symbol) stack.pop();
              Symbol sym2 = (Symbol) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce10(sym1, sym2, sym3);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][11];
              break;
            }
            case 19: {
              syntaxError(next);
            }
            case 20: {
              syntaxError(next);
            }
            case 21: {
              syntaxError(next);
            }
            case 22: {
              Symbol sym3 = (Symbol) stack.pop();
              Symbol sym2 = (Symbol) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce10(sym1, sym2, sym3);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][11];
              break;
            }
            case 23: {
              syntaxError(next);
            }
            case 24: {
              syntaxError(next);
            }
            case 25: {
              syntaxError(next);
            }
          }
          break;
        case 42:
          if (DEBUG) System.out.format("[%s] ", next);
          switch (next.getId()) {
            case 0: {
              syntaxError(next);
            }
            case 1: {
              syntaxError(next);
            }
            case 2: {
              Symbol _result = reduce11();
              stack.push(_result);
              stateStack.push(state);
              state = gotos[stateStack.peek()][5];
              break;
            }
            case 3: {
              syntaxError(next);
            }
            case 4: {
              Symbol _result = reduce11();
              stack.push(_result);
              stateStack.push(state);
              state = gotos[stateStack.peek()][5];
              break;
            }
            case 5: {
              syntaxError(next);
            }
            case 6: {
              syntaxError(next);
            }
            case 7: {
              stateStack.push(state);
              stack.push(next);
              state = 60;
              next = nextToken(in);
              break;
            }
            case 8: {
              Symbol _result = reduce11();
              stack.push(_result);
              stateStack.push(state);
              state = gotos[stateStack.peek()][5];
              break;
            }
            case 9: {
              Symbol _result = reduce11();
              stack.push(_result);
              stateStack.push(state);
              state = gotos[stateStack.peek()][5];
              break;
            }
            case 10: {
              syntaxError(next);
            }
            case 11: {
              syntaxError(next);
            }
            case 12: {
              syntaxError(next);
            }
            case 13: {
              syntaxError(next);
            }
            case 14: {
              syntaxError(next);
            }
            case 15: {
              syntaxError(next);
            }
            case 16: {
              syntaxError(next);
            }
            case 17: {
              syntaxError(next);
            }
            case 18: {
              syntaxError(next);
            }
            case 19: {
              Symbol _result = reduce11();
              stack.push(_result);
              stateStack.push(state);
              state = gotos[stateStack.peek()][5];
              break;
            }
            case 20: {
              syntaxError(next);
            }
            case 21: {
              Symbol _result = reduce11();
              stack.push(_result);
              stateStack.push(state);
              state = gotos[stateStack.peek()][5];
              break;
            }
            case 22: {
              syntaxError(next);
            }
            case 23: {
              Symbol _result = reduce11();
              stack.push(_result);
              stateStack.push(state);
              state = gotos[stateStack.peek()][5];
              break;
            }
            case 24: {
              Symbol _result = reduce11();
              stack.push(_result);
              stateStack.push(state);
              state = gotos[stateStack.peek()][5];
              break;
            }
            case 25: {
              syntaxError(next);
            }
          }
          break;
        case 43:
          if (DEBUG) System.out.format("[%s] ", next);
          switch (next.getId()) {
            case 0: {
              syntaxError(next);
            }
            case 1: {
              syntaxError(next);
            }
            case 2: {
              syntaxError(next);
            }
            case 3: {
              syntaxError(next);
            }
            case 4: {
              syntaxError(next);
            }
            case 5: {
              syntaxError(next);
            }
            case 6: {
              syntaxError(next);
            }
            case 7: {
              syntaxError(next);
            }
            case 8: {
              syntaxError(next);
            }
            case 9: {
              syntaxError(next);
            }
            case 10: {
              syntaxError(next);
            }
            case 11: {
              syntaxError(next);
            }
            case 12: {
              syntaxError(next);
            }
            case 13: {
              syntaxError(next);
            }
            case 14: {
              syntaxError(next);
            }
            case 15: {
              syntaxError(next);
            }
            case 16: {
              syntaxError(next);
            }
            case 17: {
              syntaxError(next);
            }
            case 18: {
              syntaxError(next);
            }
            case 19: {
              GRule sym1 = (GRule) stack.pop();
              Symbol _result = reduce12(sym1);
              stack.push(_result);
              state = gotos[stateStack.peek()][8];
              break;
            }
            case 20: {
              syntaxError(next);
            }
            case 21: {
              GRule sym1 = (GRule) stack.pop();
              Symbol _result = reduce12(sym1);
              stack.push(_result);
              state = gotos[stateStack.peek()][8];
              break;
            }
            case 22: {
              syntaxError(next);
            }
            case 23: {
              syntaxError(next);
            }
            case 24: {
              syntaxError(next);
            }
            case 25: {
              syntaxError(next);
            }
          }
          break;
        case 44:
          if (DEBUG) System.out.format("[%s] ", next);
          switch (next.getId()) {
            case 0: {
              syntaxError(next);
            }
            case 1: {
              syntaxError(next);
            }
            case 2: {
              syntaxError(next);
            }
            case 3: {
              syntaxError(next);
            }
            case 4: {
              List sym1 = (List) stack.pop();
              Symbol _result = reduce13(sym1);
              stack.push(_result);
              state = gotos[stateStack.peek()][14];
              break;
            }
            case 5: {
              syntaxError(next);
            }
            case 6: {
              syntaxError(next);
            }
            case 7: {
              syntaxError(next);
            }
            case 8: {
              syntaxError(next);
            }
            case 9: {
              stateStack.push(state);
              stack.push(next);
              state = 42;
              next = nextToken(in);
              break;
            }
            case 10: {
              syntaxError(next);
            }
            case 11: {
              syntaxError(next);
            }
            case 12: {
              syntaxError(next);
            }
            case 13: {
              syntaxError(next);
            }
            case 14: {
              syntaxError(next);
            }
            case 15: {
              syntaxError(next);
            }
            case 16: {
              syntaxError(next);
            }
            case 17: {
              syntaxError(next);
            }
            case 18: {
              syntaxError(next);
            }
            case 19: {
              List sym1 = (List) stack.pop();
              Symbol _result = reduce13(sym1);
              stack.push(_result);
              state = gotos[stateStack.peek()][14];
              break;
            }
            case 20: {
              syntaxError(next);
            }
            case 21: {
              List sym1 = (List) stack.pop();
              Symbol _result = reduce13(sym1);
              stack.push(_result);
              state = gotos[stateStack.peek()][14];
              break;
            }
            case 22: {
              syntaxError(next);
            }
            case 23: {
              syntaxError(next);
            }
            case 24: {
              List sym1 = (List) stack.pop();
              Symbol _result = reduce13(sym1);
              stack.push(_result);
              state = gotos[stateStack.peek()][14];
              break;
            }
            case 25: {
              syntaxError(next);
            }
          }
          break;
        case 45:
          if (DEBUG) System.out.format("[%s] ", next);
          switch (next.getId()) {
            case 0: {
              syntaxError(next);
            }
            case 1: {
              syntaxError(next);
            }
            case 2: {
              syntaxError(next);
            }
            case 3: {
              syntaxError(next);
            }
            case 4: {
              GComponent sym1 = (GComponent) stack.pop();
              Symbol _result = reduce14(sym1);
              stack.push(_result);
              state = gotos[stateStack.peek()][2];
              break;
            }
            case 5: {
              syntaxError(next);
            }
            case 6: {
              syntaxError(next);
            }
            case 7: {
              syntaxError(next);
            }
            case 8: {
              syntaxError(next);
            }
            case 9: {
              GComponent sym1 = (GComponent) stack.pop();
              Symbol _result = reduce14(sym1);
              stack.push(_result);
              state = gotos[stateStack.peek()][2];
              break;
            }
            case 10: {
              syntaxError(next);
            }
            case 11: {
              syntaxError(next);
            }
            case 12: {
              syntaxError(next);
            }
            case 13: {
              syntaxError(next);
            }
            case 14: {
              syntaxError(next);
            }
            case 15: {
              syntaxError(next);
            }
            case 16: {
              syntaxError(next);
            }
            case 17: {
              syntaxError(next);
            }
            case 18: {
              syntaxError(next);
            }
            case 19: {
              GComponent sym1 = (GComponent) stack.pop();
              Symbol _result = reduce14(sym1);
              stack.push(_result);
              state = gotos[stateStack.peek()][2];
              break;
            }
            case 20: {
              syntaxError(next);
            }
            case 21: {
              GComponent sym1 = (GComponent) stack.pop();
              Symbol _result = reduce14(sym1);
              stack.push(_result);
              state = gotos[stateStack.peek()][2];
              break;
            }
            case 22: {
              syntaxError(next);
            }
            case 23: {
              syntaxError(next);
            }
            case 24: {
              GComponent sym1 = (GComponent) stack.pop();
              Symbol _result = reduce14(sym1);
              stack.push(_result);
              state = gotos[stateStack.peek()][2];
              break;
            }
            case 25: {
              syntaxError(next);
            }
          }
          break;
        case 46:
          if (DEBUG) System.out.format("[%s] ", next);
          switch (next.getId()) {
            case 0: {
              syntaxError(next);
            }
            case 1: {
              syntaxError(next);
            }
            case 2: {
              syntaxError(next);
            }
            case 3: {
              syntaxError(next);
            }
            case 4: {
              syntaxError(next);
            }
            case 5: {
              syntaxError(next);
            }
            case 6: {
              syntaxError(next);
            }
            case 7: {
              syntaxError(next);
            }
            case 8: {
              syntaxError(next);
            }
            case 9: {
              syntaxError(next);
            }
            case 10: {
              syntaxError(next);
            }
            case 11: {
              syntaxError(next);
            }
            case 12: {
              syntaxError(next);
            }
            case 13: {
              syntaxError(next);
            }
            case 14: {
              syntaxError(next);
            }
            case 15: {
              syntaxError(next);
            }
            case 16: {
              syntaxError(next);
            }
            case 17: {
              syntaxError(next);
            }
            case 18: {
              syntaxError(next);
            }
            case 19: {
              stateStack.push(state);
              stack.push(next);
              state = 62;
              next = nextToken(in);
              break;
            }
            case 20: {
              syntaxError(next);
            }
            case 21: {
              stateStack.push(state);
              stack.push(next);
              state = 63;
              next = nextToken(in);
              break;
            }
            case 22: {
              syntaxError(next);
            }
            case 23: {
              syntaxError(next);
            }
            case 24: {
              syntaxError(next);
            }
            case 25: {
              syntaxError(next);
            }
          }
          break;
        case 47:
          if (DEBUG) System.out.format("[%s] ", next);
          switch (next.getId()) {
            case 0: {
              syntaxError(next);
            }
            case 1: {
              syntaxError(next);
            }
            case 2: {
              syntaxError(next);
            }
            case 3: {
              syntaxError(next);
            }
            case 4: {
              stateStack.push(state);
              stack.push(next);
              state = 65;
              next = nextToken(in);
              break;
            }
            case 5: {
              syntaxError(next);
            }
            case 6: {
              syntaxError(next);
            }
            case 7: {
              syntaxError(next);
            }
            case 8: {
              syntaxError(next);
            }
            case 9: {
              syntaxError(next);
            }
            case 10: {
              syntaxError(next);
            }
            case 11: {
              syntaxError(next);
            }
            case 12: {
              syntaxError(next);
            }
            case 13: {
              syntaxError(next);
            }
            case 14: {
              syntaxError(next);
            }
            case 15: {
              syntaxError(next);
            }
            case 16: {
              syntaxError(next);
            }
            case 17: {
              syntaxError(next);
            }
            case 18: {
              syntaxError(next);
            }
            case 19: {
              List sym1 = (List) stack.pop();
              Symbol _result = reduce15(sym1);
              stack.push(_result);
              state = gotos[stateStack.peek()][1];
              break;
            }
            case 20: {
              syntaxError(next);
            }
            case 21: {
              List sym1 = (List) stack.pop();
              Symbol _result = reduce15(sym1);
              stack.push(_result);
              state = gotos[stateStack.peek()][1];
              break;
            }
            case 22: {
              syntaxError(next);
            }
            case 23: {
              syntaxError(next);
            }
            case 24: {
              stateStack.push(state);
              stack.push(next);
              state = 67;
              next = nextToken(in);
              break;
            }
            case 25: {
              syntaxError(next);
            }
          }
          break;
        case 48:
          if (DEBUG) System.out.format("[%s] ", next);
          switch (next.getId()) {
            case 0: {
              syntaxError(next);
            }
            case 1: {
              syntaxError(next);
            }
            case 2: {
              syntaxError(next);
            }
            case 3: {
              syntaxError(next);
            }
            case 4: {
              syntaxError(next);
            }
            case 5: {
              syntaxError(next);
            }
            case 6: {
              syntaxError(next);
            }
            case 7: {
              syntaxError(next);
            }
            case 8: {
              syntaxError(next);
            }
            case 9: {
              syntaxError(next);
            }
            case 10: {
              syntaxError(next);
            }
            case 11: {
              syntaxError(next);
            }
            case 12: {
              syntaxError(next);
            }
            case 13: {
              syntaxError(next);
            }
            case 14: {
              syntaxError(next);
            }
            case 15: {
              syntaxError(next);
            }
            case 16: {
              syntaxError(next);
            }
            case 17: {
              syntaxError(next);
            }
            case 18: {
              syntaxError(next);
            }
            case 19: {
              stateStack.push(state);
              stack.push(next);
              state = 68;
              next = nextToken(in);
              break;
            }
            case 20: {
              syntaxError(next);
            }
            case 21: {
              stateStack.push(state);
              stack.push(next);
              state = 63;
              next = nextToken(in);
              break;
            }
            case 22: {
              syntaxError(next);
            }
            case 23: {
              syntaxError(next);
            }
            case 24: {
              syntaxError(next);
            }
            case 25: {
              syntaxError(next);
            }
          }
          break;
        case 49:
          if (DEBUG) System.out.format("[%s] ", next);
          switch (next.getId()) {
            case 0: {
              Symbol sym3 = (Symbol) stack.pop();
              List sym2 = (List) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce16(sym1, sym2, sym3);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][11];
              break;
            }
            case 1: {
              syntaxError(next);
            }
            case 2: {
              syntaxError(next);
            }
            case 3: {
              Symbol sym3 = (Symbol) stack.pop();
              List sym2 = (List) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce16(sym1, sym2, sym3);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][11];
              break;
            }
            case 4: {
              syntaxError(next);
            }
            case 5: {
              Symbol sym3 = (Symbol) stack.pop();
              List sym2 = (List) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce16(sym1, sym2, sym3);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][11];
              break;
            }
            case 6: {
              Symbol sym3 = (Symbol) stack.pop();
              List sym2 = (List) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce16(sym1, sym2, sym3);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][11];
              break;
            }
            case 7: {
              syntaxError(next);
            }
            case 8: {
              syntaxError(next);
            }
            case 9: {
              Symbol sym3 = (Symbol) stack.pop();
              List sym2 = (List) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce16(sym1, sym2, sym3);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][11];
              break;
            }
            case 10: {
              Symbol sym3 = (Symbol) stack.pop();
              List sym2 = (List) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce16(sym1, sym2, sym3);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][11];
              break;
            }
            case 11: {
              Symbol sym3 = (Symbol) stack.pop();
              List sym2 = (List) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce16(sym1, sym2, sym3);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][11];
              break;
            }
            case 12: {
              Symbol sym3 = (Symbol) stack.pop();
              List sym2 = (List) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce16(sym1, sym2, sym3);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][11];
              break;
            }
            case 13: {
              Symbol sym3 = (Symbol) stack.pop();
              List sym2 = (List) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce16(sym1, sym2, sym3);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][11];
              break;
            }
            case 14: {
              syntaxError(next);
            }
            case 15: {
              syntaxError(next);
            }
            case 16: {
              syntaxError(next);
            }
            case 17: {
              Symbol sym3 = (Symbol) stack.pop();
              List sym2 = (List) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce16(sym1, sym2, sym3);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][11];
              break;
            }
            case 18: {
              Symbol sym3 = (Symbol) stack.pop();
              List sym2 = (List) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce16(sym1, sym2, sym3);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][11];
              break;
            }
            case 19: {
              syntaxError(next);
            }
            case 20: {
              syntaxError(next);
            }
            case 21: {
              syntaxError(next);
            }
            case 22: {
              Symbol sym3 = (Symbol) stack.pop();
              List sym2 = (List) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce16(sym1, sym2, sym3);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][11];
              break;
            }
            case 23: {
              syntaxError(next);
            }
            case 24: {
              syntaxError(next);
            }
            case 25: {
              syntaxError(next);
            }
          }
          break;
        case 50:
          if (DEBUG) System.out.format("[%s] ", next);
          switch (next.getId()) {
            case 0: {
              Symbol sym3 = (Symbol) stack.pop();
              List sym2 = (List) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce17(sym1, sym2, sym3);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][11];
              break;
            }
            case 1: {
              syntaxError(next);
            }
            case 2: {
              syntaxError(next);
            }
            case 3: {
              Symbol sym3 = (Symbol) stack.pop();
              List sym2 = (List) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce17(sym1, sym2, sym3);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][11];
              break;
            }
            case 4: {
              syntaxError(next);
            }
            case 5: {
              Symbol sym3 = (Symbol) stack.pop();
              List sym2 = (List) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce17(sym1, sym2, sym3);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][11];
              break;
            }
            case 6: {
              Symbol sym3 = (Symbol) stack.pop();
              List sym2 = (List) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce17(sym1, sym2, sym3);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][11];
              break;
            }
            case 7: {
              syntaxError(next);
            }
            case 8: {
              syntaxError(next);
            }
            case 9: {
              Symbol sym3 = (Symbol) stack.pop();
              List sym2 = (List) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce17(sym1, sym2, sym3);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][11];
              break;
            }
            case 10: {
              Symbol sym3 = (Symbol) stack.pop();
              List sym2 = (List) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce17(sym1, sym2, sym3);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][11];
              break;
            }
            case 11: {
              Symbol sym3 = (Symbol) stack.pop();
              List sym2 = (List) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce17(sym1, sym2, sym3);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][11];
              break;
            }
            case 12: {
              Symbol sym3 = (Symbol) stack.pop();
              List sym2 = (List) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce17(sym1, sym2, sym3);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][11];
              break;
            }
            case 13: {
              Symbol sym3 = (Symbol) stack.pop();
              List sym2 = (List) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce17(sym1, sym2, sym3);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][11];
              break;
            }
            case 14: {
              syntaxError(next);
            }
            case 15: {
              syntaxError(next);
            }
            case 16: {
              syntaxError(next);
            }
            case 17: {
              Symbol sym3 = (Symbol) stack.pop();
              List sym2 = (List) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce17(sym1, sym2, sym3);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][11];
              break;
            }
            case 18: {
              Symbol sym3 = (Symbol) stack.pop();
              List sym2 = (List) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce17(sym1, sym2, sym3);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][11];
              break;
            }
            case 19: {
              syntaxError(next);
            }
            case 20: {
              syntaxError(next);
            }
            case 21: {
              syntaxError(next);
            }
            case 22: {
              Symbol sym3 = (Symbol) stack.pop();
              List sym2 = (List) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce17(sym1, sym2, sym3);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][11];
              break;
            }
            case 23: {
              syntaxError(next);
            }
            case 24: {
              syntaxError(next);
            }
            case 25: {
              syntaxError(next);
            }
          }
          break;
        case 51:
          if (DEBUG) System.out.format("[%s] ", next);
          switch (next.getId()) {
            case 0: {
              syntaxError(next);
            }
            case 1: {
              stateStack.push(state);
              stack.push(next);
              state = 69;
              next = nextToken(in);
              break;
            }
            case 2: {
              syntaxError(next);
            }
            case 3: {
              syntaxError(next);
            }
            case 4: {
              syntaxError(next);
            }
            case 5: {
              syntaxError(next);
            }
            case 6: {
              syntaxError(next);
            }
            case 7: {
              syntaxError(next);
            }
            case 8: {
              syntaxError(next);
            }
            case 9: {
              syntaxError(next);
            }
            case 10: {
              syntaxError(next);
            }
            case 11: {
              syntaxError(next);
            }
            case 12: {
              syntaxError(next);
            }
            case 13: {
              syntaxError(next);
            }
            case 14: {
              syntaxError(next);
            }
            case 15: {
              syntaxError(next);
            }
            case 16: {
              syntaxError(next);
            }
            case 17: {
              syntaxError(next);
            }
            case 18: {
              syntaxError(next);
            }
            case 19: {
              syntaxError(next);
            }
            case 20: {
              syntaxError(next);
            }
            case 21: {
              syntaxError(next);
            }
            case 22: {
              syntaxError(next);
            }
            case 23: {
              syntaxError(next);
            }
            case 24: {
              syntaxError(next);
            }
            case 25: {
              syntaxError(next);
            }
          }
          break;
        case 52:
          if (DEBUG) System.out.format("[%s] ", next);
          switch (next.getId()) {
            case 0: {
              Symbol sym3 = (Symbol) stack.pop();
              List sym2 = (List) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce18(sym1, sym2, sym3);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][11];
              break;
            }
            case 1: {
              syntaxError(next);
            }
            case 2: {
              syntaxError(next);
            }
            case 3: {
              Symbol sym3 = (Symbol) stack.pop();
              List sym2 = (List) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce18(sym1, sym2, sym3);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][11];
              break;
            }
            case 4: {
              syntaxError(next);
            }
            case 5: {
              Symbol sym3 = (Symbol) stack.pop();
              List sym2 = (List) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce18(sym1, sym2, sym3);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][11];
              break;
            }
            case 6: {
              Symbol sym3 = (Symbol) stack.pop();
              List sym2 = (List) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce18(sym1, sym2, sym3);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][11];
              break;
            }
            case 7: {
              syntaxError(next);
            }
            case 8: {
              syntaxError(next);
            }
            case 9: {
              Symbol sym3 = (Symbol) stack.pop();
              List sym2 = (List) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce18(sym1, sym2, sym3);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][11];
              break;
            }
            case 10: {
              Symbol sym3 = (Symbol) stack.pop();
              List sym2 = (List) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce18(sym1, sym2, sym3);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][11];
              break;
            }
            case 11: {
              Symbol sym3 = (Symbol) stack.pop();
              List sym2 = (List) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce18(sym1, sym2, sym3);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][11];
              break;
            }
            case 12: {
              Symbol sym3 = (Symbol) stack.pop();
              List sym2 = (List) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce18(sym1, sym2, sym3);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][11];
              break;
            }
            case 13: {
              Symbol sym3 = (Symbol) stack.pop();
              List sym2 = (List) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce18(sym1, sym2, sym3);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][11];
              break;
            }
            case 14: {
              syntaxError(next);
            }
            case 15: {
              syntaxError(next);
            }
            case 16: {
              syntaxError(next);
            }
            case 17: {
              Symbol sym3 = (Symbol) stack.pop();
              List sym2 = (List) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce18(sym1, sym2, sym3);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][11];
              break;
            }
            case 18: {
              Symbol sym3 = (Symbol) stack.pop();
              List sym2 = (List) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce18(sym1, sym2, sym3);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][11];
              break;
            }
            case 19: {
              syntaxError(next);
            }
            case 20: {
              syntaxError(next);
            }
            case 21: {
              syntaxError(next);
            }
            case 22: {
              Symbol sym3 = (Symbol) stack.pop();
              List sym2 = (List) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce18(sym1, sym2, sym3);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][11];
              break;
            }
            case 23: {
              syntaxError(next);
            }
            case 24: {
              syntaxError(next);
            }
            case 25: {
              syntaxError(next);
            }
          }
          break;
        case 53:
          if (DEBUG) System.out.format("[%s] ", next);
          switch (next.getId()) {
            case 0: {
              Symbol sym3 = (Symbol) stack.pop();
              Symbol sym2 = (Symbol) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce19(sym1, sym2, sym3);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][11];
              break;
            }
            case 1: {
              syntaxError(next);
            }
            case 2: {
              syntaxError(next);
            }
            case 3: {
              Symbol sym3 = (Symbol) stack.pop();
              Symbol sym2 = (Symbol) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce19(sym1, sym2, sym3);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][11];
              break;
            }
            case 4: {
              syntaxError(next);
            }
            case 5: {
              Symbol sym3 = (Symbol) stack.pop();
              Symbol sym2 = (Symbol) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce19(sym1, sym2, sym3);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][11];
              break;
            }
            case 6: {
              Symbol sym3 = (Symbol) stack.pop();
              Symbol sym2 = (Symbol) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce19(sym1, sym2, sym3);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][11];
              break;
            }
            case 7: {
              syntaxError(next);
            }
            case 8: {
              syntaxError(next);
            }
            case 9: {
              Symbol sym3 = (Symbol) stack.pop();
              Symbol sym2 = (Symbol) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce19(sym1, sym2, sym3);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][11];
              break;
            }
            case 10: {
              Symbol sym3 = (Symbol) stack.pop();
              Symbol sym2 = (Symbol) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce19(sym1, sym2, sym3);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][11];
              break;
            }
            case 11: {
              Symbol sym3 = (Symbol) stack.pop();
              Symbol sym2 = (Symbol) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce19(sym1, sym2, sym3);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][11];
              break;
            }
            case 12: {
              Symbol sym3 = (Symbol) stack.pop();
              Symbol sym2 = (Symbol) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce19(sym1, sym2, sym3);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][11];
              break;
            }
            case 13: {
              Symbol sym3 = (Symbol) stack.pop();
              Symbol sym2 = (Symbol) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce19(sym1, sym2, sym3);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][11];
              break;
            }
            case 14: {
              syntaxError(next);
            }
            case 15: {
              syntaxError(next);
            }
            case 16: {
              syntaxError(next);
            }
            case 17: {
              Symbol sym3 = (Symbol) stack.pop();
              Symbol sym2 = (Symbol) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce19(sym1, sym2, sym3);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][11];
              break;
            }
            case 18: {
              Symbol sym3 = (Symbol) stack.pop();
              Symbol sym2 = (Symbol) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce19(sym1, sym2, sym3);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][11];
              break;
            }
            case 19: {
              syntaxError(next);
            }
            case 20: {
              syntaxError(next);
            }
            case 21: {
              syntaxError(next);
            }
            case 22: {
              Symbol sym3 = (Symbol) stack.pop();
              Symbol sym2 = (Symbol) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce19(sym1, sym2, sym3);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][11];
              break;
            }
            case 23: {
              syntaxError(next);
            }
            case 24: {
              syntaxError(next);
            }
            case 25: {
              syntaxError(next);
            }
          }
          break;
        case 54:
          if (DEBUG) System.out.format("[%s] ", next);
          switch (next.getId()) {
            case 0: {
              syntaxError(next);
            }
            case 1: {
              syntaxError(next);
            }
            case 2: {
              syntaxError(next);
            }
            case 3: {
              syntaxError(next);
            }
            case 4: {
              syntaxError(next);
            }
            case 5: {
              syntaxError(next);
            }
            case 6: {
              syntaxError(next);
            }
            case 7: {
              syntaxError(next);
            }
            case 8: {
              syntaxError(next);
            }
            case 9: {
              syntaxError(next);
            }
            case 10: {
              syntaxError(next);
            }
            case 11: {
              syntaxError(next);
            }
            case 12: {
              syntaxError(next);
            }
            case 13: {
              syntaxError(next);
            }
            case 14: {
              syntaxError(next);
            }
            case 15: {
              syntaxError(next);
            }
            case 16: {
              syntaxError(next);
            }
            case 17: {
              syntaxError(next);
            }
            case 18: {
              syntaxError(next);
            }
            case 19: {
              stateStack.push(state);
              stack.push(next);
              state = 70;
              next = nextToken(in);
              break;
            }
            case 20: {
              syntaxError(next);
            }
            case 21: {
              syntaxError(next);
            }
            case 22: {
              syntaxError(next);
            }
            case 23: {
              syntaxError(next);
            }
            case 24: {
              syntaxError(next);
            }
            case 25: {
              syntaxError(next);
            }
          }
          break;
        case 55:
          if (DEBUG) System.out.format("[%s] ", next);
          switch (next.getId()) {
            case 0: {
              syntaxError(next);
            }
            case 1: {
              syntaxError(next);
            }
            case 2: {
              syntaxError(next);
            }
            case 3: {
              syntaxError(next);
            }
            case 4: {
              syntaxError(next);
            }
            case 5: {
              syntaxError(next);
            }
            case 6: {
              syntaxError(next);
            }
            case 7: {
              syntaxError(next);
            }
            case 8: {
              syntaxError(next);
            }
            case 9: {
              syntaxError(next);
            }
            case 10: {
              syntaxError(next);
            }
            case 11: {
              syntaxError(next);
            }
            case 12: {
              syntaxError(next);
            }
            case 13: {
              syntaxError(next);
            }
            case 14: {
              syntaxError(next);
            }
            case 15: {
              syntaxError(next);
            }
            case 16: {
              syntaxError(next);
            }
            case 17: {
              syntaxError(next);
            }
            case 18: {
              syntaxError(next);
            }
            case 19: {
              stateStack.push(state);
              stack.push(next);
              state = 71;
              next = nextToken(in);
              break;
            }
            case 20: {
              syntaxError(next);
            }
            case 21: {
              syntaxError(next);
            }
            case 22: {
              syntaxError(next);
            }
            case 23: {
              syntaxError(next);
            }
            case 24: {
              syntaxError(next);
            }
            case 25: {
              syntaxError(next);
            }
          }
          break;
        case 56:
          if (DEBUG) System.out.format("[%s] ", next);
          switch (next.getId()) {
            case 0: {
              syntaxError(next);
            }
            case 1: {
              syntaxError(next);
            }
            case 2: {
              syntaxError(next);
            }
            case 3: {
              syntaxError(next);
            }
            case 4: {
              syntaxError(next);
            }
            case 5: {
              syntaxError(next);
            }
            case 6: {
              syntaxError(next);
            }
            case 7: {
              syntaxError(next);
            }
            case 8: {
              syntaxError(next);
            }
            case 9: {
              syntaxError(next);
            }
            case 10: {
              syntaxError(next);
            }
            case 11: {
              syntaxError(next);
            }
            case 12: {
              syntaxError(next);
            }
            case 13: {
              syntaxError(next);
            }
            case 14: {
              GSym sym3 = (GSym) stack.pop();
              Symbol sym2 = (Symbol) stack.pop();
              List sym1 = (List) stack.pop();
              Symbol _result = reduce20(sym1, sym2, sym3);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][13];
              break;
            }
            case 15: {
              syntaxError(next);
            }
            case 16: {
              syntaxError(next);
            }
            case 17: {
              syntaxError(next);
            }
            case 18: {
              syntaxError(next);
            }
            case 19: {
              GSym sym3 = (GSym) stack.pop();
              Symbol sym2 = (Symbol) stack.pop();
              List sym1 = (List) stack.pop();
              Symbol _result = reduce20(sym1, sym2, sym3);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][13];
              break;
            }
            case 20: {
              syntaxError(next);
            }
            case 21: {
              syntaxError(next);
            }
            case 22: {
              syntaxError(next);
            }
            case 23: {
              syntaxError(next);
            }
            case 24: {
              syntaxError(next);
            }
            case 25: {
              syntaxError(next);
            }
          }
          break;
        case 57:
          if (DEBUG) System.out.format("[%s] ", next);
          switch (next.getId()) {
            case 0: {
              syntaxError(next);
            }
            case 1: {
              syntaxError(next);
            }
            case 2: {
              syntaxError(next);
            }
            case 3: {
              syntaxError(next);
            }
            case 4: {
              syntaxError(next);
            }
            case 5: {
              syntaxError(next);
            }
            case 6: {
              syntaxError(next);
            }
            case 7: {
              syntaxError(next);
            }
            case 8: {
              syntaxError(next);
            }
            case 9: {
              syntaxError(next);
            }
            case 10: {
              syntaxError(next);
            }
            case 11: {
              syntaxError(next);
            }
            case 12: {
              syntaxError(next);
            }
            case 13: {
              syntaxError(next);
            }
            case 14: {
              syntaxError(next);
            }
            case 15: {
              syntaxError(next);
            }
            case 16: {
              syntaxError(next);
            }
            case 17: {
              syntaxError(next);
            }
            case 18: {
              syntaxError(next);
            }
            case 19: {
              stateStack.push(state);
              stack.push(next);
              state = 72;
              next = nextToken(in);
              break;
            }
            case 20: {
              syntaxError(next);
            }
            case 21: {
              stateStack.push(state);
              stack.push(next);
              state = 63;
              next = nextToken(in);
              break;
            }
            case 22: {
              syntaxError(next);
            }
            case 23: {
              syntaxError(next);
            }
            case 24: {
              syntaxError(next);
            }
            case 25: {
              syntaxError(next);
            }
          }
          break;
        case 58:
          if (DEBUG) System.out.format("[%s] ", next);
          switch (next.getId()) {
            case 0: {
              syntaxError(next);
            }
            case 1: {
              syntaxError(next);
            }
            case 2: {
              syntaxError(next);
            }
            case 3: {
              syntaxError(next);
            }
            case 4: {
              syntaxError(next);
            }
            case 5: {
              syntaxError(next);
            }
            case 6: {
              syntaxError(next);
            }
            case 7: {
              syntaxError(next);
            }
            case 8: {
              syntaxError(next);
            }
            case 9: {
              syntaxError(next);
            }
            case 10: {
              syntaxError(next);
            }
            case 11: {
              syntaxError(next);
            }
            case 12: {
              syntaxError(next);
            }
            case 13: {
              syntaxError(next);
            }
            case 14: {
              syntaxError(next);
            }
            case 15: {
              syntaxError(next);
            }
            case 16: {
              syntaxError(next);
            }
            case 17: {
              syntaxError(next);
            }
            case 18: {
              syntaxError(next);
            }
            case 19: {
              stateStack.push(state);
              stack.push(next);
              state = 73;
              next = nextToken(in);
              break;
            }
            case 20: {
              syntaxError(next);
            }
            case 21: {
              stateStack.push(state);
              stack.push(next);
              state = 63;
              next = nextToken(in);
              break;
            }
            case 22: {
              syntaxError(next);
            }
            case 23: {
              syntaxError(next);
            }
            case 24: {
              syntaxError(next);
            }
            case 25: {
              syntaxError(next);
            }
          }
          break;
        case 59:
          if (DEBUG) System.out.format("[%s] ", next);
          switch (next.getId()) {
            case 0: {
              syntaxError(next);
            }
            case 1: {
              syntaxError(next);
            }
            case 2: {
              stateStack.push(state);
              stack.push(next);
              state = 74;
              next = nextToken(in);
              break;
            }
            case 3: {
              syntaxError(next);
            }
            case 4: {
              Opt sym2 = (Opt) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce21(sym1, sym2);
              stack.push(_result);
              stateStack.pop();
              state = gotos[stateStack.peek()][4];
              break;
            }
            case 5: {
              syntaxError(next);
            }
            case 6: {
              syntaxError(next);
            }
            case 7: {
              syntaxError(next);
            }
            case 8: {
              stateStack.push(state);
              stack.push(next);
              state = 76;
              next = nextToken(in);
              break;
            }
            case 9: {
              Opt sym2 = (Opt) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce21(sym1, sym2);
              stack.push(_result);
              stateStack.pop();
              state = gotos[stateStack.peek()][4];
              break;
            }
            case 10: {
              syntaxError(next);
            }
            case 11: {
              syntaxError(next);
            }
            case 12: {
              syntaxError(next);
            }
            case 13: {
              syntaxError(next);
            }
            case 14: {
              syntaxError(next);
            }
            case 15: {
              syntaxError(next);
            }
            case 16: {
              syntaxError(next);
            }
            case 17: {
              syntaxError(next);
            }
            case 18: {
              syntaxError(next);
            }
            case 19: {
              Opt sym2 = (Opt) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce21(sym1, sym2);
              stack.push(_result);
              stateStack.pop();
              state = gotos[stateStack.peek()][4];
              break;
            }
            case 20: {
              syntaxError(next);
            }
            case 21: {
              Opt sym2 = (Opt) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce21(sym1, sym2);
              stack.push(_result);
              stateStack.pop();
              state = gotos[stateStack.peek()][4];
              break;
            }
            case 22: {
              syntaxError(next);
            }
            case 23: {
              stateStack.push(state);
              stack.push(next);
              state = 75;
              next = nextToken(in);
              break;
            }
            case 24: {
              Opt sym2 = (Opt) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce21(sym1, sym2);
              stack.push(_result);
              stateStack.pop();
              state = gotos[stateStack.peek()][4];
              break;
            }
            case 25: {
              syntaxError(next);
            }
          }
          break;
        case 60:
          if (DEBUG) System.out.format("[%s] ", next);
          switch (next.getId()) {
            case 0: {
              syntaxError(next);
            }
            case 1: {
              syntaxError(next);
            }
            case 2: {
              syntaxError(next);
            }
            case 3: {
              syntaxError(next);
            }
            case 4: {
              syntaxError(next);
            }
            case 5: {
              syntaxError(next);
            }
            case 6: {
              syntaxError(next);
            }
            case 7: {
              syntaxError(next);
            }
            case 8: {
              syntaxError(next);
            }
            case 9: {
              stateStack.push(state);
              stack.push(next);
              state = 77;
              next = nextToken(in);
              break;
            }
            case 10: {
              syntaxError(next);
            }
            case 11: {
              syntaxError(next);
            }
            case 12: {
              syntaxError(next);
            }
            case 13: {
              syntaxError(next);
            }
            case 14: {
              syntaxError(next);
            }
            case 15: {
              syntaxError(next);
            }
            case 16: {
              syntaxError(next);
            }
            case 17: {
              syntaxError(next);
            }
            case 18: {
              syntaxError(next);
            }
            case 19: {
              syntaxError(next);
            }
            case 20: {
              syntaxError(next);
            }
            case 21: {
              syntaxError(next);
            }
            case 22: {
              syntaxError(next);
            }
            case 23: {
              syntaxError(next);
            }
            case 24: {
              syntaxError(next);
            }
            case 25: {
              syntaxError(next);
            }
          }
          break;
        case 61:
          if (DEBUG) System.out.format("[%s] ", next);
          switch (next.getId()) {
            case 0: {
              syntaxError(next);
            }
            case 1: {
              syntaxError(next);
            }
            case 2: {
              syntaxError(next);
            }
            case 3: {
              syntaxError(next);
            }
            case 4: {
              GComponent sym2 = (GComponent) stack.pop();
              List sym1 = (List) stack.pop();
              Symbol _result = reduce22(sym1, sym2);
              stack.push(_result);
              stateStack.pop();
              state = gotos[stateStack.peek()][2];
              break;
            }
            case 5: {
              syntaxError(next);
            }
            case 6: {
              syntaxError(next);
            }
            case 7: {
              syntaxError(next);
            }
            case 8: {
              syntaxError(next);
            }
            case 9: {
              GComponent sym2 = (GComponent) stack.pop();
              List sym1 = (List) stack.pop();
              Symbol _result = reduce22(sym1, sym2);
              stack.push(_result);
              stateStack.pop();
              state = gotos[stateStack.peek()][2];
              break;
            }
            case 10: {
              syntaxError(next);
            }
            case 11: {
              syntaxError(next);
            }
            case 12: {
              syntaxError(next);
            }
            case 13: {
              syntaxError(next);
            }
            case 14: {
              syntaxError(next);
            }
            case 15: {
              syntaxError(next);
            }
            case 16: {
              syntaxError(next);
            }
            case 17: {
              syntaxError(next);
            }
            case 18: {
              syntaxError(next);
            }
            case 19: {
              GComponent sym2 = (GComponent) stack.pop();
              List sym1 = (List) stack.pop();
              Symbol _result = reduce22(sym1, sym2);
              stack.push(_result);
              stateStack.pop();
              state = gotos[stateStack.peek()][2];
              break;
            }
            case 20: {
              syntaxError(next);
            }
            case 21: {
              GComponent sym2 = (GComponent) stack.pop();
              List sym1 = (List) stack.pop();
              Symbol _result = reduce22(sym1, sym2);
              stack.push(_result);
              stateStack.pop();
              state = gotos[stateStack.peek()][2];
              break;
            }
            case 22: {
              syntaxError(next);
            }
            case 23: {
              syntaxError(next);
            }
            case 24: {
              GComponent sym2 = (GComponent) stack.pop();
              List sym1 = (List) stack.pop();
              Symbol _result = reduce22(sym1, sym2);
              stack.push(_result);
              stateStack.pop();
              state = gotos[stateStack.peek()][2];
              break;
            }
            case 25: {
              syntaxError(next);
            }
          }
          break;
        case 62:
          if (DEBUG) System.out.format("[%s] ", next);
          switch (next.getId()) {
            case 0: {
              Symbol sym4 = (Symbol) stack.pop();
              List sym3 = (List) stack.pop();
              Symbol sym2 = (Symbol) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce23(sym1, sym2, sym3, sym4);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][11];
              break;
            }
            case 1: {
              syntaxError(next);
            }
            case 2: {
              syntaxError(next);
            }
            case 3: {
              Symbol sym4 = (Symbol) stack.pop();
              List sym3 = (List) stack.pop();
              Symbol sym2 = (Symbol) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce23(sym1, sym2, sym3, sym4);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][11];
              break;
            }
            case 4: {
              syntaxError(next);
            }
            case 5: {
              Symbol sym4 = (Symbol) stack.pop();
              List sym3 = (List) stack.pop();
              Symbol sym2 = (Symbol) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce23(sym1, sym2, sym3, sym4);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][11];
              break;
            }
            case 6: {
              Symbol sym4 = (Symbol) stack.pop();
              List sym3 = (List) stack.pop();
              Symbol sym2 = (Symbol) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce23(sym1, sym2, sym3, sym4);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][11];
              break;
            }
            case 7: {
              syntaxError(next);
            }
            case 8: {
              syntaxError(next);
            }
            case 9: {
              Symbol sym4 = (Symbol) stack.pop();
              List sym3 = (List) stack.pop();
              Symbol sym2 = (Symbol) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce23(sym1, sym2, sym3, sym4);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][11];
              break;
            }
            case 10: {
              Symbol sym4 = (Symbol) stack.pop();
              List sym3 = (List) stack.pop();
              Symbol sym2 = (Symbol) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce23(sym1, sym2, sym3, sym4);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][11];
              break;
            }
            case 11: {
              Symbol sym4 = (Symbol) stack.pop();
              List sym3 = (List) stack.pop();
              Symbol sym2 = (Symbol) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce23(sym1, sym2, sym3, sym4);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][11];
              break;
            }
            case 12: {
              Symbol sym4 = (Symbol) stack.pop();
              List sym3 = (List) stack.pop();
              Symbol sym2 = (Symbol) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce23(sym1, sym2, sym3, sym4);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][11];
              break;
            }
            case 13: {
              Symbol sym4 = (Symbol) stack.pop();
              List sym3 = (List) stack.pop();
              Symbol sym2 = (Symbol) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce23(sym1, sym2, sym3, sym4);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][11];
              break;
            }
            case 14: {
              syntaxError(next);
            }
            case 15: {
              syntaxError(next);
            }
            case 16: {
              syntaxError(next);
            }
            case 17: {
              Symbol sym4 = (Symbol) stack.pop();
              List sym3 = (List) stack.pop();
              Symbol sym2 = (Symbol) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce23(sym1, sym2, sym3, sym4);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][11];
              break;
            }
            case 18: {
              Symbol sym4 = (Symbol) stack.pop();
              List sym3 = (List) stack.pop();
              Symbol sym2 = (Symbol) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce23(sym1, sym2, sym3, sym4);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][11];
              break;
            }
            case 19: {
              syntaxError(next);
            }
            case 20: {
              syntaxError(next);
            }
            case 21: {
              syntaxError(next);
            }
            case 22: {
              Symbol sym4 = (Symbol) stack.pop();
              List sym3 = (List) stack.pop();
              Symbol sym2 = (Symbol) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce23(sym1, sym2, sym3, sym4);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][11];
              break;
            }
            case 23: {
              syntaxError(next);
            }
            case 24: {
              syntaxError(next);
            }
            case 25: {
              syntaxError(next);
            }
          }
          break;
        case 63:
          if (DEBUG) System.out.format("[%s] ", next);
          switch (next.getId()) {
            case 0: {
              syntaxError(next);
            }
            case 1: {
              syntaxError(next);
            }
            case 2: {
              syntaxError(next);
            }
            case 3: {
              syntaxError(next);
            }
            case 4: {
              Symbol _result = reduce6();
              stack.push(_result);
              stateStack.push(state);
              state = gotos[stateStack.peek()][14];
              break;
            }
            case 5: {
              syntaxError(next);
            }
            case 6: {
              syntaxError(next);
            }
            case 7: {
              syntaxError(next);
            }
            case 8: {
              syntaxError(next);
            }
            case 9: {
              stateStack.push(state);
              stack.push(next);
              state = 42;
              next = nextToken(in);
              break;
            }
            case 10: {
              syntaxError(next);
            }
            case 11: {
              syntaxError(next);
            }
            case 12: {
              syntaxError(next);
            }
            case 13: {
              syntaxError(next);
            }
            case 14: {
              syntaxError(next);
            }
            case 15: {
              syntaxError(next);
            }
            case 16: {
              syntaxError(next);
            }
            case 17: {
              syntaxError(next);
            }
            case 18: {
              syntaxError(next);
            }
            case 19: {
              Symbol _result = reduce6();
              stack.push(_result);
              stateStack.push(state);
              state = gotos[stateStack.peek()][14];
              break;
            }
            case 20: {
              syntaxError(next);
            }
            case 21: {
              Symbol _result = reduce6();
              stack.push(_result);
              stateStack.push(state);
              state = gotos[stateStack.peek()][14];
              break;
            }
            case 22: {
              syntaxError(next);
            }
            case 23: {
              syntaxError(next);
            }
            case 24: {
              Symbol _result = reduce6();
              stack.push(_result);
              stateStack.push(state);
              state = gotos[stateStack.peek()][14];
              break;
            }
            case 25: {
              syntaxError(next);
            }
          }
          break;
        case 64:
          if (DEBUG) System.out.format("[%s] ", next);
          switch (next.getId()) {
            case 0: {
              syntaxError(next);
            }
            case 1: {
              syntaxError(next);
            }
            case 2: {
              syntaxError(next);
            }
            case 3: {
              syntaxError(next);
            }
            case 4: {
              syntaxError(next);
            }
            case 5: {
              syntaxError(next);
            }
            case 6: {
              syntaxError(next);
            }
            case 7: {
              syntaxError(next);
            }
            case 8: {
              syntaxError(next);
            }
            case 9: {
              syntaxError(next);
            }
            case 10: {
              syntaxError(next);
            }
            case 11: {
              syntaxError(next);
            }
            case 12: {
              syntaxError(next);
            }
            case 13: {
              syntaxError(next);
            }
            case 14: {
              syntaxError(next);
            }
            case 15: {
              syntaxError(next);
            }
            case 16: {
              syntaxError(next);
            }
            case 17: {
              syntaxError(next);
            }
            case 18: {
              syntaxError(next);
            }
            case 19: {
              GAction sym2 = (GAction) stack.pop();
              List sym1 = (List) stack.pop();
              Symbol _result = reduce24(sym1, sym2);
              stack.push(_result);
              stateStack.pop();
              state = gotos[stateStack.peek()][1];
              break;
            }
            case 20: {
              syntaxError(next);
            }
            case 21: {
              GAction sym2 = (GAction) stack.pop();
              List sym1 = (List) stack.pop();
              Symbol _result = reduce24(sym1, sym2);
              stack.push(_result);
              stateStack.pop();
              state = gotos[stateStack.peek()][1];
              break;
            }
            case 22: {
              syntaxError(next);
            }
            case 23: {
              syntaxError(next);
            }
            case 24: {
              syntaxError(next);
            }
            case 25: {
              syntaxError(next);
            }
          }
          break;
        case 65:
          if (DEBUG) System.out.format("[%s] ", next);
          switch (next.getId()) {
            case 0: {
              syntaxError(next);
            }
            case 1: {
              syntaxError(next);
            }
            case 2: {
              syntaxError(next);
            }
            case 3: {
              syntaxError(next);
            }
            case 4: {
              syntaxError(next);
            }
            case 5: {
              syntaxError(next);
            }
            case 6: {
              syntaxError(next);
            }
            case 7: {
              syntaxError(next);
            }
            case 8: {
              syntaxError(next);
            }
            case 9: {
              stateStack.push(state);
              stack.push(next);
              state = 79;
              next = nextToken(in);
              break;
            }
            case 10: {
              syntaxError(next);
            }
            case 11: {
              syntaxError(next);
            }
            case 12: {
              syntaxError(next);
            }
            case 13: {
              syntaxError(next);
            }
            case 14: {
              syntaxError(next);
            }
            case 15: {
              syntaxError(next);
            }
            case 16: {
              syntaxError(next);
            }
            case 17: {
              syntaxError(next);
            }
            case 18: {
              syntaxError(next);
            }
            case 19: {
              syntaxError(next);
            }
            case 20: {
              syntaxError(next);
            }
            case 21: {
              syntaxError(next);
            }
            case 22: {
              syntaxError(next);
            }
            case 23: {
              syntaxError(next);
            }
            case 24: {
              syntaxError(next);
            }
            case 25: {
              syntaxError(next);
            }
          }
          break;
        case 66:
          if (DEBUG) System.out.format("[%s] ", next);
          switch (next.getId()) {
            case 0: {
              syntaxError(next);
            }
            case 1: {
              syntaxError(next);
            }
            case 2: {
              syntaxError(next);
            }
            case 3: {
              syntaxError(next);
            }
            case 4: {
              syntaxError(next);
            }
            case 5: {
              syntaxError(next);
            }
            case 6: {
              syntaxError(next);
            }
            case 7: {
              syntaxError(next);
            }
            case 8: {
              syntaxError(next);
            }
            case 9: {
              syntaxError(next);
            }
            case 10: {
              syntaxError(next);
            }
            case 11: {
              syntaxError(next);
            }
            case 12: {
              syntaxError(next);
            }
            case 13: {
              syntaxError(next);
            }
            case 14: {
              syntaxError(next);
            }
            case 15: {
              syntaxError(next);
            }
            case 16: {
              syntaxError(next);
            }
            case 17: {
              syntaxError(next);
            }
            case 18: {
              syntaxError(next);
            }
            case 19: {
              GPrecedence sym2 = (GPrecedence) stack.pop();
              List sym1 = (List) stack.pop();
              Symbol _result = reduce25(sym1, sym2);
              stack.push(_result);
              stateStack.pop();
              state = gotos[stateStack.peek()][1];
              break;
            }
            case 20: {
              syntaxError(next);
            }
            case 21: {
              GPrecedence sym2 = (GPrecedence) stack.pop();
              List sym1 = (List) stack.pop();
              Symbol _result = reduce25(sym1, sym2);
              stack.push(_result);
              stateStack.pop();
              state = gotos[stateStack.peek()][1];
              break;
            }
            case 22: {
              syntaxError(next);
            }
            case 23: {
              syntaxError(next);
            }
            case 24: {
              stateStack.push(state);
              stack.push(next);
              state = 67;
              next = nextToken(in);
              break;
            }
            case 25: {
              syntaxError(next);
            }
          }
          break;
        case 67:
          if (DEBUG) System.out.format("[%s] ", next);
          switch (next.getId()) {
            case 0: {
              syntaxError(next);
            }
            case 1: {
              syntaxError(next);
            }
            case 2: {
              syntaxError(next);
            }
            case 3: {
              syntaxError(next);
            }
            case 4: {
              syntaxError(next);
            }
            case 5: {
              syntaxError(next);
            }
            case 6: {
              syntaxError(next);
            }
            case 7: {
              syntaxError(next);
            }
            case 8: {
              syntaxError(next);
            }
            case 9: {
              syntaxError(next);
            }
            case 10: {
              syntaxError(next);
            }
            case 11: {
              syntaxError(next);
            }
            case 12: {
              syntaxError(next);
            }
            case 13: {
              syntaxError(next);
            }
            case 14: {
              syntaxError(next);
            }
            case 15: {
              stateStack.push(state);
              stack.push(next);
              state = 81;
              next = nextToken(in);
              break;
            }
            case 16: {
              syntaxError(next);
            }
            case 17: {
              syntaxError(next);
            }
            case 18: {
              syntaxError(next);
            }
            case 19: {
              syntaxError(next);
            }
            case 20: {
              syntaxError(next);
            }
            case 21: {
              syntaxError(next);
            }
            case 22: {
              syntaxError(next);
            }
            case 23: {
              syntaxError(next);
            }
            case 24: {
              syntaxError(next);
            }
            case 25: {
              syntaxError(next);
            }
          }
          break;
        case 68:
          if (DEBUG) System.out.format("[%s] ", next);
          switch (next.getId()) {
            case 0: {
              Symbol sym4 = (Symbol) stack.pop();
              List sym3 = (List) stack.pop();
              Symbol sym2 = (Symbol) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce26(sym1, sym2, sym3, sym4);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][11];
              break;
            }
            case 1: {
              syntaxError(next);
            }
            case 2: {
              syntaxError(next);
            }
            case 3: {
              Symbol sym4 = (Symbol) stack.pop();
              List sym3 = (List) stack.pop();
              Symbol sym2 = (Symbol) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce26(sym1, sym2, sym3, sym4);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][11];
              break;
            }
            case 4: {
              syntaxError(next);
            }
            case 5: {
              Symbol sym4 = (Symbol) stack.pop();
              List sym3 = (List) stack.pop();
              Symbol sym2 = (Symbol) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce26(sym1, sym2, sym3, sym4);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][11];
              break;
            }
            case 6: {
              Symbol sym4 = (Symbol) stack.pop();
              List sym3 = (List) stack.pop();
              Symbol sym2 = (Symbol) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce26(sym1, sym2, sym3, sym4);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][11];
              break;
            }
            case 7: {
              syntaxError(next);
            }
            case 8: {
              syntaxError(next);
            }
            case 9: {
              Symbol sym4 = (Symbol) stack.pop();
              List sym3 = (List) stack.pop();
              Symbol sym2 = (Symbol) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce26(sym1, sym2, sym3, sym4);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][11];
              break;
            }
            case 10: {
              Symbol sym4 = (Symbol) stack.pop();
              List sym3 = (List) stack.pop();
              Symbol sym2 = (Symbol) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce26(sym1, sym2, sym3, sym4);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][11];
              break;
            }
            case 11: {
              Symbol sym4 = (Symbol) stack.pop();
              List sym3 = (List) stack.pop();
              Symbol sym2 = (Symbol) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce26(sym1, sym2, sym3, sym4);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][11];
              break;
            }
            case 12: {
              Symbol sym4 = (Symbol) stack.pop();
              List sym3 = (List) stack.pop();
              Symbol sym2 = (Symbol) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce26(sym1, sym2, sym3, sym4);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][11];
              break;
            }
            case 13: {
              Symbol sym4 = (Symbol) stack.pop();
              List sym3 = (List) stack.pop();
              Symbol sym2 = (Symbol) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce26(sym1, sym2, sym3, sym4);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][11];
              break;
            }
            case 14: {
              syntaxError(next);
            }
            case 15: {
              syntaxError(next);
            }
            case 16: {
              syntaxError(next);
            }
            case 17: {
              Symbol sym4 = (Symbol) stack.pop();
              List sym3 = (List) stack.pop();
              Symbol sym2 = (Symbol) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce26(sym1, sym2, sym3, sym4);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][11];
              break;
            }
            case 18: {
              Symbol sym4 = (Symbol) stack.pop();
              List sym3 = (List) stack.pop();
              Symbol sym2 = (Symbol) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce26(sym1, sym2, sym3, sym4);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][11];
              break;
            }
            case 19: {
              syntaxError(next);
            }
            case 20: {
              syntaxError(next);
            }
            case 21: {
              syntaxError(next);
            }
            case 22: {
              Symbol sym4 = (Symbol) stack.pop();
              List sym3 = (List) stack.pop();
              Symbol sym2 = (Symbol) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce26(sym1, sym2, sym3, sym4);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][11];
              break;
            }
            case 23: {
              syntaxError(next);
            }
            case 24: {
              syntaxError(next);
            }
            case 25: {
              syntaxError(next);
            }
          }
          break;
        case 69:
          if (DEBUG) System.out.format("[%s] ", next);
          switch (next.getId()) {
            case 0: {
              syntaxError(next);
            }
            case 1: {
              syntaxError(next);
            }
            case 2: {
              syntaxError(next);
            }
            case 3: {
              syntaxError(next);
            }
            case 4: {
              syntaxError(next);
            }
            case 5: {
              syntaxError(next);
            }
            case 6: {
              syntaxError(next);
            }
            case 7: {
              syntaxError(next);
            }
            case 8: {
              syntaxError(next);
            }
            case 9: {
              syntaxError(next);
            }
            case 10: {
              syntaxError(next);
            }
            case 11: {
              syntaxError(next);
            }
            case 12: {
              syntaxError(next);
            }
            case 13: {
              syntaxError(next);
            }
            case 14: {
              syntaxError(next);
            }
            case 15: {
              syntaxError(next);
            }
            case 16: {
              syntaxError(next);
            }
            case 17: {
              syntaxError(next);
            }
            case 18: {
              syntaxError(next);
            }
            case 19: {
              stateStack.push(state);
              stack.push(next);
              state = 82;
              next = nextToken(in);
              break;
            }
            case 20: {
              syntaxError(next);
            }
            case 21: {
              syntaxError(next);
            }
            case 22: {
              syntaxError(next);
            }
            case 23: {
              syntaxError(next);
            }
            case 24: {
              syntaxError(next);
            }
            case 25: {
              syntaxError(next);
            }
          }
          break;
        case 70:
          if (DEBUG) System.out.format("[%s] ", next);
          switch (next.getId()) {
            case 0: {
              Symbol sym5 = (Symbol) stack.pop();
              Symbol sym4 = (Symbol) stack.pop();
              Symbol sym3 = (Symbol) stack.pop();
              Symbol sym2 = (Symbol) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce27(sym1, sym2, sym3, sym4, sym5);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][11];
              break;
            }
            case 1: {
              syntaxError(next);
            }
            case 2: {
              syntaxError(next);
            }
            case 3: {
              Symbol sym5 = (Symbol) stack.pop();
              Symbol sym4 = (Symbol) stack.pop();
              Symbol sym3 = (Symbol) stack.pop();
              Symbol sym2 = (Symbol) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce27(sym1, sym2, sym3, sym4, sym5);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][11];
              break;
            }
            case 4: {
              syntaxError(next);
            }
            case 5: {
              Symbol sym5 = (Symbol) stack.pop();
              Symbol sym4 = (Symbol) stack.pop();
              Symbol sym3 = (Symbol) stack.pop();
              Symbol sym2 = (Symbol) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce27(sym1, sym2, sym3, sym4, sym5);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][11];
              break;
            }
            case 6: {
              Symbol sym5 = (Symbol) stack.pop();
              Symbol sym4 = (Symbol) stack.pop();
              Symbol sym3 = (Symbol) stack.pop();
              Symbol sym2 = (Symbol) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce27(sym1, sym2, sym3, sym4, sym5);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][11];
              break;
            }
            case 7: {
              syntaxError(next);
            }
            case 8: {
              syntaxError(next);
            }
            case 9: {
              Symbol sym5 = (Symbol) stack.pop();
              Symbol sym4 = (Symbol) stack.pop();
              Symbol sym3 = (Symbol) stack.pop();
              Symbol sym2 = (Symbol) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce27(sym1, sym2, sym3, sym4, sym5);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][11];
              break;
            }
            case 10: {
              Symbol sym5 = (Symbol) stack.pop();
              Symbol sym4 = (Symbol) stack.pop();
              Symbol sym3 = (Symbol) stack.pop();
              Symbol sym2 = (Symbol) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce27(sym1, sym2, sym3, sym4, sym5);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][11];
              break;
            }
            case 11: {
              Symbol sym5 = (Symbol) stack.pop();
              Symbol sym4 = (Symbol) stack.pop();
              Symbol sym3 = (Symbol) stack.pop();
              Symbol sym2 = (Symbol) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce27(sym1, sym2, sym3, sym4, sym5);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][11];
              break;
            }
            case 12: {
              Symbol sym5 = (Symbol) stack.pop();
              Symbol sym4 = (Symbol) stack.pop();
              Symbol sym3 = (Symbol) stack.pop();
              Symbol sym2 = (Symbol) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce27(sym1, sym2, sym3, sym4, sym5);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][11];
              break;
            }
            case 13: {
              Symbol sym5 = (Symbol) stack.pop();
              Symbol sym4 = (Symbol) stack.pop();
              Symbol sym3 = (Symbol) stack.pop();
              Symbol sym2 = (Symbol) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce27(sym1, sym2, sym3, sym4, sym5);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][11];
              break;
            }
            case 14: {
              syntaxError(next);
            }
            case 15: {
              syntaxError(next);
            }
            case 16: {
              syntaxError(next);
            }
            case 17: {
              Symbol sym5 = (Symbol) stack.pop();
              Symbol sym4 = (Symbol) stack.pop();
              Symbol sym3 = (Symbol) stack.pop();
              Symbol sym2 = (Symbol) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce27(sym1, sym2, sym3, sym4, sym5);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][11];
              break;
            }
            case 18: {
              Symbol sym5 = (Symbol) stack.pop();
              Symbol sym4 = (Symbol) stack.pop();
              Symbol sym3 = (Symbol) stack.pop();
              Symbol sym2 = (Symbol) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce27(sym1, sym2, sym3, sym4, sym5);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][11];
              break;
            }
            case 19: {
              syntaxError(next);
            }
            case 20: {
              syntaxError(next);
            }
            case 21: {
              syntaxError(next);
            }
            case 22: {
              Symbol sym5 = (Symbol) stack.pop();
              Symbol sym4 = (Symbol) stack.pop();
              Symbol sym3 = (Symbol) stack.pop();
              Symbol sym2 = (Symbol) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce27(sym1, sym2, sym3, sym4, sym5);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][11];
              break;
            }
            case 23: {
              syntaxError(next);
            }
            case 24: {
              syntaxError(next);
            }
            case 25: {
              syntaxError(next);
            }
          }
          break;
        case 71:
          if (DEBUG) System.out.format("[%s] ", next);
          switch (next.getId()) {
            case 0: {
              Symbol sym5 = (Symbol) stack.pop();
              Symbol sym4 = (Symbol) stack.pop();
              Symbol sym3 = (Symbol) stack.pop();
              Symbol sym2 = (Symbol) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce28(sym1, sym2, sym3, sym4, sym5);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][11];
              break;
            }
            case 1: {
              syntaxError(next);
            }
            case 2: {
              syntaxError(next);
            }
            case 3: {
              Symbol sym5 = (Symbol) stack.pop();
              Symbol sym4 = (Symbol) stack.pop();
              Symbol sym3 = (Symbol) stack.pop();
              Symbol sym2 = (Symbol) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce28(sym1, sym2, sym3, sym4, sym5);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][11];
              break;
            }
            case 4: {
              syntaxError(next);
            }
            case 5: {
              Symbol sym5 = (Symbol) stack.pop();
              Symbol sym4 = (Symbol) stack.pop();
              Symbol sym3 = (Symbol) stack.pop();
              Symbol sym2 = (Symbol) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce28(sym1, sym2, sym3, sym4, sym5);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][11];
              break;
            }
            case 6: {
              Symbol sym5 = (Symbol) stack.pop();
              Symbol sym4 = (Symbol) stack.pop();
              Symbol sym3 = (Symbol) stack.pop();
              Symbol sym2 = (Symbol) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce28(sym1, sym2, sym3, sym4, sym5);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][11];
              break;
            }
            case 7: {
              syntaxError(next);
            }
            case 8: {
              syntaxError(next);
            }
            case 9: {
              Symbol sym5 = (Symbol) stack.pop();
              Symbol sym4 = (Symbol) stack.pop();
              Symbol sym3 = (Symbol) stack.pop();
              Symbol sym2 = (Symbol) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce28(sym1, sym2, sym3, sym4, sym5);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][11];
              break;
            }
            case 10: {
              Symbol sym5 = (Symbol) stack.pop();
              Symbol sym4 = (Symbol) stack.pop();
              Symbol sym3 = (Symbol) stack.pop();
              Symbol sym2 = (Symbol) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce28(sym1, sym2, sym3, sym4, sym5);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][11];
              break;
            }
            case 11: {
              Symbol sym5 = (Symbol) stack.pop();
              Symbol sym4 = (Symbol) stack.pop();
              Symbol sym3 = (Symbol) stack.pop();
              Symbol sym2 = (Symbol) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce28(sym1, sym2, sym3, sym4, sym5);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][11];
              break;
            }
            case 12: {
              Symbol sym5 = (Symbol) stack.pop();
              Symbol sym4 = (Symbol) stack.pop();
              Symbol sym3 = (Symbol) stack.pop();
              Symbol sym2 = (Symbol) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce28(sym1, sym2, sym3, sym4, sym5);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][11];
              break;
            }
            case 13: {
              Symbol sym5 = (Symbol) stack.pop();
              Symbol sym4 = (Symbol) stack.pop();
              Symbol sym3 = (Symbol) stack.pop();
              Symbol sym2 = (Symbol) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce28(sym1, sym2, sym3, sym4, sym5);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][11];
              break;
            }
            case 14: {
              syntaxError(next);
            }
            case 15: {
              syntaxError(next);
            }
            case 16: {
              syntaxError(next);
            }
            case 17: {
              Symbol sym5 = (Symbol) stack.pop();
              Symbol sym4 = (Symbol) stack.pop();
              Symbol sym3 = (Symbol) stack.pop();
              Symbol sym2 = (Symbol) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce28(sym1, sym2, sym3, sym4, sym5);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][11];
              break;
            }
            case 18: {
              Symbol sym5 = (Symbol) stack.pop();
              Symbol sym4 = (Symbol) stack.pop();
              Symbol sym3 = (Symbol) stack.pop();
              Symbol sym2 = (Symbol) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce28(sym1, sym2, sym3, sym4, sym5);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][11];
              break;
            }
            case 19: {
              syntaxError(next);
            }
            case 20: {
              syntaxError(next);
            }
            case 21: {
              syntaxError(next);
            }
            case 22: {
              Symbol sym5 = (Symbol) stack.pop();
              Symbol sym4 = (Symbol) stack.pop();
              Symbol sym3 = (Symbol) stack.pop();
              Symbol sym2 = (Symbol) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce28(sym1, sym2, sym3, sym4, sym5);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][11];
              break;
            }
            case 23: {
              syntaxError(next);
            }
            case 24: {
              syntaxError(next);
            }
            case 25: {
              syntaxError(next);
            }
          }
          break;
        case 72:
          if (DEBUG) System.out.format("[%s] ", next);
          switch (next.getId()) {
            case 0: {
              Symbol sym5 = (Symbol) stack.pop();
              List sym4 = (List) stack.pop();
              Symbol sym3 = (Symbol) stack.pop();
              Symbol sym2 = (Symbol) stack.pop();
              Type sym1 = (Type) stack.pop();
              Symbol _result = reduce29(sym1, sym2, sym3, sym4, sym5);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][11];
              break;
            }
            case 1: {
              syntaxError(next);
            }
            case 2: {
              syntaxError(next);
            }
            case 3: {
              Symbol sym5 = (Symbol) stack.pop();
              List sym4 = (List) stack.pop();
              Symbol sym3 = (Symbol) stack.pop();
              Symbol sym2 = (Symbol) stack.pop();
              Type sym1 = (Type) stack.pop();
              Symbol _result = reduce29(sym1, sym2, sym3, sym4, sym5);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][11];
              break;
            }
            case 4: {
              syntaxError(next);
            }
            case 5: {
              Symbol sym5 = (Symbol) stack.pop();
              List sym4 = (List) stack.pop();
              Symbol sym3 = (Symbol) stack.pop();
              Symbol sym2 = (Symbol) stack.pop();
              Type sym1 = (Type) stack.pop();
              Symbol _result = reduce29(sym1, sym2, sym3, sym4, sym5);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][11];
              break;
            }
            case 6: {
              Symbol sym5 = (Symbol) stack.pop();
              List sym4 = (List) stack.pop();
              Symbol sym3 = (Symbol) stack.pop();
              Symbol sym2 = (Symbol) stack.pop();
              Type sym1 = (Type) stack.pop();
              Symbol _result = reduce29(sym1, sym2, sym3, sym4, sym5);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][11];
              break;
            }
            case 7: {
              syntaxError(next);
            }
            case 8: {
              syntaxError(next);
            }
            case 9: {
              Symbol sym5 = (Symbol) stack.pop();
              List sym4 = (List) stack.pop();
              Symbol sym3 = (Symbol) stack.pop();
              Symbol sym2 = (Symbol) stack.pop();
              Type sym1 = (Type) stack.pop();
              Symbol _result = reduce29(sym1, sym2, sym3, sym4, sym5);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][11];
              break;
            }
            case 10: {
              Symbol sym5 = (Symbol) stack.pop();
              List sym4 = (List) stack.pop();
              Symbol sym3 = (Symbol) stack.pop();
              Symbol sym2 = (Symbol) stack.pop();
              Type sym1 = (Type) stack.pop();
              Symbol _result = reduce29(sym1, sym2, sym3, sym4, sym5);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][11];
              break;
            }
            case 11: {
              Symbol sym5 = (Symbol) stack.pop();
              List sym4 = (List) stack.pop();
              Symbol sym3 = (Symbol) stack.pop();
              Symbol sym2 = (Symbol) stack.pop();
              Type sym1 = (Type) stack.pop();
              Symbol _result = reduce29(sym1, sym2, sym3, sym4, sym5);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][11];
              break;
            }
            case 12: {
              Symbol sym5 = (Symbol) stack.pop();
              List sym4 = (List) stack.pop();
              Symbol sym3 = (Symbol) stack.pop();
              Symbol sym2 = (Symbol) stack.pop();
              Type sym1 = (Type) stack.pop();
              Symbol _result = reduce29(sym1, sym2, sym3, sym4, sym5);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][11];
              break;
            }
            case 13: {
              Symbol sym5 = (Symbol) stack.pop();
              List sym4 = (List) stack.pop();
              Symbol sym3 = (Symbol) stack.pop();
              Symbol sym2 = (Symbol) stack.pop();
              Type sym1 = (Type) stack.pop();
              Symbol _result = reduce29(sym1, sym2, sym3, sym4, sym5);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][11];
              break;
            }
            case 14: {
              syntaxError(next);
            }
            case 15: {
              syntaxError(next);
            }
            case 16: {
              syntaxError(next);
            }
            case 17: {
              Symbol sym5 = (Symbol) stack.pop();
              List sym4 = (List) stack.pop();
              Symbol sym3 = (Symbol) stack.pop();
              Symbol sym2 = (Symbol) stack.pop();
              Type sym1 = (Type) stack.pop();
              Symbol _result = reduce29(sym1, sym2, sym3, sym4, sym5);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][11];
              break;
            }
            case 18: {
              Symbol sym5 = (Symbol) stack.pop();
              List sym4 = (List) stack.pop();
              Symbol sym3 = (Symbol) stack.pop();
              Symbol sym2 = (Symbol) stack.pop();
              Type sym1 = (Type) stack.pop();
              Symbol _result = reduce29(sym1, sym2, sym3, sym4, sym5);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][11];
              break;
            }
            case 19: {
              syntaxError(next);
            }
            case 20: {
              syntaxError(next);
            }
            case 21: {
              syntaxError(next);
            }
            case 22: {
              Symbol sym5 = (Symbol) stack.pop();
              List sym4 = (List) stack.pop();
              Symbol sym3 = (Symbol) stack.pop();
              Symbol sym2 = (Symbol) stack.pop();
              Type sym1 = (Type) stack.pop();
              Symbol _result = reduce29(sym1, sym2, sym3, sym4, sym5);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][11];
              break;
            }
            case 23: {
              syntaxError(next);
            }
            case 24: {
              syntaxError(next);
            }
            case 25: {
              syntaxError(next);
            }
          }
          break;
        case 73:
          if (DEBUG) System.out.format("[%s] ", next);
          switch (next.getId()) {
            case 0: {
              Symbol sym5 = (Symbol) stack.pop();
              List sym4 = (List) stack.pop();
              Symbol sym3 = (Symbol) stack.pop();
              Symbol sym2 = (Symbol) stack.pop();
              Type sym1 = (Type) stack.pop();
              Symbol _result = reduce30(sym1, sym2, sym3, sym4, sym5);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][11];
              break;
            }
            case 1: {
              syntaxError(next);
            }
            case 2: {
              syntaxError(next);
            }
            case 3: {
              Symbol sym5 = (Symbol) stack.pop();
              List sym4 = (List) stack.pop();
              Symbol sym3 = (Symbol) stack.pop();
              Symbol sym2 = (Symbol) stack.pop();
              Type sym1 = (Type) stack.pop();
              Symbol _result = reduce30(sym1, sym2, sym3, sym4, sym5);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][11];
              break;
            }
            case 4: {
              syntaxError(next);
            }
            case 5: {
              Symbol sym5 = (Symbol) stack.pop();
              List sym4 = (List) stack.pop();
              Symbol sym3 = (Symbol) stack.pop();
              Symbol sym2 = (Symbol) stack.pop();
              Type sym1 = (Type) stack.pop();
              Symbol _result = reduce30(sym1, sym2, sym3, sym4, sym5);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][11];
              break;
            }
            case 6: {
              Symbol sym5 = (Symbol) stack.pop();
              List sym4 = (List) stack.pop();
              Symbol sym3 = (Symbol) stack.pop();
              Symbol sym2 = (Symbol) stack.pop();
              Type sym1 = (Type) stack.pop();
              Symbol _result = reduce30(sym1, sym2, sym3, sym4, sym5);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][11];
              break;
            }
            case 7: {
              syntaxError(next);
            }
            case 8: {
              syntaxError(next);
            }
            case 9: {
              Symbol sym5 = (Symbol) stack.pop();
              List sym4 = (List) stack.pop();
              Symbol sym3 = (Symbol) stack.pop();
              Symbol sym2 = (Symbol) stack.pop();
              Type sym1 = (Type) stack.pop();
              Symbol _result = reduce30(sym1, sym2, sym3, sym4, sym5);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][11];
              break;
            }
            case 10: {
              Symbol sym5 = (Symbol) stack.pop();
              List sym4 = (List) stack.pop();
              Symbol sym3 = (Symbol) stack.pop();
              Symbol sym2 = (Symbol) stack.pop();
              Type sym1 = (Type) stack.pop();
              Symbol _result = reduce30(sym1, sym2, sym3, sym4, sym5);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][11];
              break;
            }
            case 11: {
              Symbol sym5 = (Symbol) stack.pop();
              List sym4 = (List) stack.pop();
              Symbol sym3 = (Symbol) stack.pop();
              Symbol sym2 = (Symbol) stack.pop();
              Type sym1 = (Type) stack.pop();
              Symbol _result = reduce30(sym1, sym2, sym3, sym4, sym5);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][11];
              break;
            }
            case 12: {
              Symbol sym5 = (Symbol) stack.pop();
              List sym4 = (List) stack.pop();
              Symbol sym3 = (Symbol) stack.pop();
              Symbol sym2 = (Symbol) stack.pop();
              Type sym1 = (Type) stack.pop();
              Symbol _result = reduce30(sym1, sym2, sym3, sym4, sym5);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][11];
              break;
            }
            case 13: {
              Symbol sym5 = (Symbol) stack.pop();
              List sym4 = (List) stack.pop();
              Symbol sym3 = (Symbol) stack.pop();
              Symbol sym2 = (Symbol) stack.pop();
              Type sym1 = (Type) stack.pop();
              Symbol _result = reduce30(sym1, sym2, sym3, sym4, sym5);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][11];
              break;
            }
            case 14: {
              syntaxError(next);
            }
            case 15: {
              syntaxError(next);
            }
            case 16: {
              syntaxError(next);
            }
            case 17: {
              Symbol sym5 = (Symbol) stack.pop();
              List sym4 = (List) stack.pop();
              Symbol sym3 = (Symbol) stack.pop();
              Symbol sym2 = (Symbol) stack.pop();
              Type sym1 = (Type) stack.pop();
              Symbol _result = reduce30(sym1, sym2, sym3, sym4, sym5);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][11];
              break;
            }
            case 18: {
              Symbol sym5 = (Symbol) stack.pop();
              List sym4 = (List) stack.pop();
              Symbol sym3 = (Symbol) stack.pop();
              Symbol sym2 = (Symbol) stack.pop();
              Type sym1 = (Type) stack.pop();
              Symbol _result = reduce30(sym1, sym2, sym3, sym4, sym5);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][11];
              break;
            }
            case 19: {
              syntaxError(next);
            }
            case 20: {
              syntaxError(next);
            }
            case 21: {
              syntaxError(next);
            }
            case 22: {
              Symbol sym5 = (Symbol) stack.pop();
              List sym4 = (List) stack.pop();
              Symbol sym3 = (Symbol) stack.pop();
              Symbol sym2 = (Symbol) stack.pop();
              Type sym1 = (Type) stack.pop();
              Symbol _result = reduce30(sym1, sym2, sym3, sym4, sym5);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][11];
              break;
            }
            case 23: {
              syntaxError(next);
            }
            case 24: {
              syntaxError(next);
            }
            case 25: {
              syntaxError(next);
            }
          }
          break;
        case 74:
          if (DEBUG) System.out.format("[%s] ", next);
          switch (next.getId()) {
            case 0: {
              syntaxError(next);
            }
            case 1: {
              syntaxError(next);
            }
            case 2: {
              syntaxError(next);
            }
            case 3: {
              syntaxError(next);
            }
            case 4: {
              Symbol sym3 = (Symbol) stack.pop();
              Opt sym2 = (Opt) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce31(sym1, sym2, sym3);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][4];
              break;
            }
            case 5: {
              syntaxError(next);
            }
            case 6: {
              syntaxError(next);
            }
            case 7: {
              syntaxError(next);
            }
            case 8: {
              syntaxError(next);
            }
            case 9: {
              Symbol sym3 = (Symbol) stack.pop();
              Opt sym2 = (Opt) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce31(sym1, sym2, sym3);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][4];
              break;
            }
            case 10: {
              syntaxError(next);
            }
            case 11: {
              syntaxError(next);
            }
            case 12: {
              syntaxError(next);
            }
            case 13: {
              syntaxError(next);
            }
            case 14: {
              syntaxError(next);
            }
            case 15: {
              syntaxError(next);
            }
            case 16: {
              syntaxError(next);
            }
            case 17: {
              syntaxError(next);
            }
            case 18: {
              syntaxError(next);
            }
            case 19: {
              Symbol sym3 = (Symbol) stack.pop();
              Opt sym2 = (Opt) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce31(sym1, sym2, sym3);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][4];
              break;
            }
            case 20: {
              syntaxError(next);
            }
            case 21: {
              Symbol sym3 = (Symbol) stack.pop();
              Opt sym2 = (Opt) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce31(sym1, sym2, sym3);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][4];
              break;
            }
            case 22: {
              syntaxError(next);
            }
            case 23: {
              syntaxError(next);
            }
            case 24: {
              Symbol sym3 = (Symbol) stack.pop();
              Opt sym2 = (Opt) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce31(sym1, sym2, sym3);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][4];
              break;
            }
            case 25: {
              syntaxError(next);
            }
          }
          break;
        case 75:
          if (DEBUG) System.out.format("[%s] ", next);
          switch (next.getId()) {
            case 0: {
              syntaxError(next);
            }
            case 1: {
              syntaxError(next);
            }
            case 2: {
              syntaxError(next);
            }
            case 3: {
              syntaxError(next);
            }
            case 4: {
              Symbol sym3 = (Symbol) stack.pop();
              Opt sym2 = (Opt) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce32(sym1, sym2, sym3);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][4];
              break;
            }
            case 5: {
              syntaxError(next);
            }
            case 6: {
              syntaxError(next);
            }
            case 7: {
              syntaxError(next);
            }
            case 8: {
              syntaxError(next);
            }
            case 9: {
              Symbol sym3 = (Symbol) stack.pop();
              Opt sym2 = (Opt) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce32(sym1, sym2, sym3);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][4];
              break;
            }
            case 10: {
              syntaxError(next);
            }
            case 11: {
              syntaxError(next);
            }
            case 12: {
              syntaxError(next);
            }
            case 13: {
              syntaxError(next);
            }
            case 14: {
              syntaxError(next);
            }
            case 15: {
              syntaxError(next);
            }
            case 16: {
              syntaxError(next);
            }
            case 17: {
              syntaxError(next);
            }
            case 18: {
              syntaxError(next);
            }
            case 19: {
              Symbol sym3 = (Symbol) stack.pop();
              Opt sym2 = (Opt) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce32(sym1, sym2, sym3);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][4];
              break;
            }
            case 20: {
              syntaxError(next);
            }
            case 21: {
              Symbol sym3 = (Symbol) stack.pop();
              Opt sym2 = (Opt) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce32(sym1, sym2, sym3);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][4];
              break;
            }
            case 22: {
              syntaxError(next);
            }
            case 23: {
              syntaxError(next);
            }
            case 24: {
              Symbol sym3 = (Symbol) stack.pop();
              Opt sym2 = (Opt) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce32(sym1, sym2, sym3);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][4];
              break;
            }
            case 25: {
              syntaxError(next);
            }
          }
          break;
        case 76:
          if (DEBUG) System.out.format("[%s] ", next);
          switch (next.getId()) {
            case 0: {
              syntaxError(next);
            }
            case 1: {
              syntaxError(next);
            }
            case 2: {
              syntaxError(next);
            }
            case 3: {
              syntaxError(next);
            }
            case 4: {
              Symbol sym3 = (Symbol) stack.pop();
              Opt sym2 = (Opt) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce33(sym1, sym2, sym3);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][4];
              break;
            }
            case 5: {
              syntaxError(next);
            }
            case 6: {
              syntaxError(next);
            }
            case 7: {
              syntaxError(next);
            }
            case 8: {
              syntaxError(next);
            }
            case 9: {
              Symbol sym3 = (Symbol) stack.pop();
              Opt sym2 = (Opt) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce33(sym1, sym2, sym3);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][4];
              break;
            }
            case 10: {
              syntaxError(next);
            }
            case 11: {
              syntaxError(next);
            }
            case 12: {
              syntaxError(next);
            }
            case 13: {
              syntaxError(next);
            }
            case 14: {
              syntaxError(next);
            }
            case 15: {
              syntaxError(next);
            }
            case 16: {
              syntaxError(next);
            }
            case 17: {
              syntaxError(next);
            }
            case 18: {
              syntaxError(next);
            }
            case 19: {
              Symbol sym3 = (Symbol) stack.pop();
              Opt sym2 = (Opt) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce33(sym1, sym2, sym3);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][4];
              break;
            }
            case 20: {
              syntaxError(next);
            }
            case 21: {
              Symbol sym3 = (Symbol) stack.pop();
              Opt sym2 = (Opt) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce33(sym1, sym2, sym3);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][4];
              break;
            }
            case 22: {
              syntaxError(next);
            }
            case 23: {
              syntaxError(next);
            }
            case 24: {
              Symbol sym3 = (Symbol) stack.pop();
              Opt sym2 = (Opt) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce33(sym1, sym2, sym3);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][4];
              break;
            }
            case 25: {
              syntaxError(next);
            }
          }
          break;
        case 77:
          if (DEBUG) System.out.format("[%s] ", next);
          switch (next.getId()) {
            case 0: {
              syntaxError(next);
            }
            case 1: {
              syntaxError(next);
            }
            case 2: {
              Symbol sym2 = (Symbol) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce34(sym1, sym2);
              stack.push(_result);
              stateStack.pop();
              state = gotos[stateStack.peek()][5];
              break;
            }
            case 3: {
              syntaxError(next);
            }
            case 4: {
              Symbol sym2 = (Symbol) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce34(sym1, sym2);
              stack.push(_result);
              stateStack.pop();
              state = gotos[stateStack.peek()][5];
              break;
            }
            case 5: {
              syntaxError(next);
            }
            case 6: {
              syntaxError(next);
            }
            case 7: {
              syntaxError(next);
            }
            case 8: {
              Symbol sym2 = (Symbol) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce34(sym1, sym2);
              stack.push(_result);
              stateStack.pop();
              state = gotos[stateStack.peek()][5];
              break;
            }
            case 9: {
              Symbol sym2 = (Symbol) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce34(sym1, sym2);
              stack.push(_result);
              stateStack.pop();
              state = gotos[stateStack.peek()][5];
              break;
            }
            case 10: {
              syntaxError(next);
            }
            case 11: {
              syntaxError(next);
            }
            case 12: {
              syntaxError(next);
            }
            case 13: {
              syntaxError(next);
            }
            case 14: {
              syntaxError(next);
            }
            case 15: {
              syntaxError(next);
            }
            case 16: {
              syntaxError(next);
            }
            case 17: {
              syntaxError(next);
            }
            case 18: {
              syntaxError(next);
            }
            case 19: {
              Symbol sym2 = (Symbol) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce34(sym1, sym2);
              stack.push(_result);
              stateStack.pop();
              state = gotos[stateStack.peek()][5];
              break;
            }
            case 20: {
              syntaxError(next);
            }
            case 21: {
              Symbol sym2 = (Symbol) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce34(sym1, sym2);
              stack.push(_result);
              stateStack.pop();
              state = gotos[stateStack.peek()][5];
              break;
            }
            case 22: {
              syntaxError(next);
            }
            case 23: {
              Symbol sym2 = (Symbol) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce34(sym1, sym2);
              stack.push(_result);
              stateStack.pop();
              state = gotos[stateStack.peek()][5];
              break;
            }
            case 24: {
              Symbol sym2 = (Symbol) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce34(sym1, sym2);
              stack.push(_result);
              stateStack.pop();
              state = gotos[stateStack.peek()][5];
              break;
            }
            case 25: {
              syntaxError(next);
            }
          }
          break;
        case 78:
          if (DEBUG) System.out.format("[%s] ", next);
          switch (next.getId()) {
            case 0: {
              syntaxError(next);
            }
            case 1: {
              syntaxError(next);
            }
            case 2: {
              syntaxError(next);
            }
            case 3: {
              syntaxError(next);
            }
            case 4: {
              syntaxError(next);
            }
            case 5: {
              syntaxError(next);
            }
            case 6: {
              syntaxError(next);
            }
            case 7: {
              syntaxError(next);
            }
            case 8: {
              syntaxError(next);
            }
            case 9: {
              syntaxError(next);
            }
            case 10: {
              syntaxError(next);
            }
            case 11: {
              syntaxError(next);
            }
            case 12: {
              syntaxError(next);
            }
            case 13: {
              syntaxError(next);
            }
            case 14: {
              syntaxError(next);
            }
            case 15: {
              syntaxError(next);
            }
            case 16: {
              syntaxError(next);
            }
            case 17: {
              syntaxError(next);
            }
            case 18: {
              syntaxError(next);
            }
            case 19: {
              GRule sym3 = (GRule) stack.pop();
              Symbol sym2 = (Symbol) stack.pop();
              List sym1 = (List) stack.pop();
              Symbol _result = reduce35(sym1, sym2, sym3);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][8];
              break;
            }
            case 20: {
              syntaxError(next);
            }
            case 21: {
              GRule sym3 = (GRule) stack.pop();
              Symbol sym2 = (Symbol) stack.pop();
              List sym1 = (List) stack.pop();
              Symbol _result = reduce35(sym1, sym2, sym3);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][8];
              break;
            }
            case 22: {
              syntaxError(next);
            }
            case 23: {
              syntaxError(next);
            }
            case 24: {
              syntaxError(next);
            }
            case 25: {
              syntaxError(next);
            }
          }
          break;
        case 79:
          if (DEBUG) System.out.format("[%s] ", next);
          switch (next.getId()) {
            case 0: {
              syntaxError(next);
            }
            case 1: {
              syntaxError(next);
            }
            case 2: {
              syntaxError(next);
            }
            case 3: {
              syntaxError(next);
            }
            case 4: {
              syntaxError(next);
            }
            case 5: {
              syntaxError(next);
            }
            case 6: {
              syntaxError(next);
            }
            case 7: {
              syntaxError(next);
            }
            case 8: {
              syntaxError(next);
            }
            case 9: {
              syntaxError(next);
            }
            case 10: {
              syntaxError(next);
            }
            case 11: {
              syntaxError(next);
            }
            case 12: {
              syntaxError(next);
            }
            case 13: {
              syntaxError(next);
            }
            case 14: {
              syntaxError(next);
            }
            case 15: {
              syntaxError(next);
            }
            case 16: {
              syntaxError(next);
            }
            case 17: {
              syntaxError(next);
            }
            case 18: {
              syntaxError(next);
            }
            case 19: {
              Symbol sym2 = (Symbol) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce36(sym1, sym2);
              stack.push(_result);
              stateStack.pop();
              state = gotos[stateStack.peek()][9];
              break;
            }
            case 20: {
              syntaxError(next);
            }
            case 21: {
              Symbol sym2 = (Symbol) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce36(sym1, sym2);
              stack.push(_result);
              stateStack.pop();
              state = gotos[stateStack.peek()][9];
              break;
            }
            case 22: {
              syntaxError(next);
            }
            case 23: {
              syntaxError(next);
            }
            case 24: {
              Symbol sym2 = (Symbol) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce36(sym1, sym2);
              stack.push(_result);
              stateStack.pop();
              state = gotos[stateStack.peek()][9];
              break;
            }
            case 25: {
              syntaxError(next);
            }
          }
          break;
        case 80:
          if (DEBUG) System.out.format("[%s] ", next);
          switch (next.getId()) {
            case 0: {
              syntaxError(next);
            }
            case 1: {
              syntaxError(next);
            }
            case 2: {
              syntaxError(next);
            }
            case 3: {
              syntaxError(next);
            }
            case 4: {
              syntaxError(next);
            }
            case 5: {
              syntaxError(next);
            }
            case 6: {
              syntaxError(next);
            }
            case 7: {
              syntaxError(next);
            }
            case 8: {
              syntaxError(next);
            }
            case 9: {
              syntaxError(next);
            }
            case 10: {
              syntaxError(next);
            }
            case 11: {
              syntaxError(next);
            }
            case 12: {
              syntaxError(next);
            }
            case 13: {
              syntaxError(next);
            }
            case 14: {
              syntaxError(next);
            }
            case 15: {
              syntaxError(next);
            }
            case 16: {
              syntaxError(next);
            }
            case 17: {
              syntaxError(next);
            }
            case 18: {
              syntaxError(next);
            }
            case 19: {
              GAction sym3 = (GAction) stack.pop();
              GPrecedence sym2 = (GPrecedence) stack.pop();
              List sym1 = (List) stack.pop();
              Symbol _result = reduce37(sym1, sym2, sym3);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][1];
              break;
            }
            case 20: {
              syntaxError(next);
            }
            case 21: {
              GAction sym3 = (GAction) stack.pop();
              GPrecedence sym2 = (GPrecedence) stack.pop();
              List sym1 = (List) stack.pop();
              Symbol _result = reduce37(sym1, sym2, sym3);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][1];
              break;
            }
            case 22: {
              syntaxError(next);
            }
            case 23: {
              syntaxError(next);
            }
            case 24: {
              syntaxError(next);
            }
            case 25: {
              syntaxError(next);
            }
          }
          break;
        case 81:
          if (DEBUG) System.out.format("[%s] ", next);
          switch (next.getId()) {
            case 0: {
              syntaxError(next);
            }
            case 1: {
              syntaxError(next);
            }
            case 2: {
              syntaxError(next);
            }
            case 3: {
              syntaxError(next);
            }
            case 4: {
              syntaxError(next);
            }
            case 5: {
              syntaxError(next);
            }
            case 6: {
              syntaxError(next);
            }
            case 7: {
              syntaxError(next);
            }
            case 8: {
              syntaxError(next);
            }
            case 9: {
              syntaxError(next);
            }
            case 10: {
              syntaxError(next);
            }
            case 11: {
              syntaxError(next);
            }
            case 12: {
              syntaxError(next);
            }
            case 13: {
              syntaxError(next);
            }
            case 14: {
              syntaxError(next);
            }
            case 15: {
              syntaxError(next);
            }
            case 16: {
              stateStack.push(state);
              stack.push(next);
              state = 83;
              next = nextToken(in);
              break;
            }
            case 17: {
              syntaxError(next);
            }
            case 18: {
              syntaxError(next);
            }
            case 19: {
              syntaxError(next);
            }
            case 20: {
              syntaxError(next);
            }
            case 21: {
              syntaxError(next);
            }
            case 22: {
              syntaxError(next);
            }
            case 23: {
              syntaxError(next);
            }
            case 24: {
              syntaxError(next);
            }
            case 25: {
              syntaxError(next);
            }
          }
          break;
        case 82:
          if (DEBUG) System.out.format("[%s] ", next);
          switch (next.getId()) {
            case 0: {
              Symbol sym5 = (Symbol) stack.pop();
              Symbol sym4 = (Symbol) stack.pop();
              Symbol sym3 = (Symbol) stack.pop();
              Symbol sym2 = (Symbol) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce38(sym1, sym2, sym3, sym4, sym5);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][11];
              break;
            }
            case 1: {
              syntaxError(next);
            }
            case 2: {
              syntaxError(next);
            }
            case 3: {
              Symbol sym5 = (Symbol) stack.pop();
              Symbol sym4 = (Symbol) stack.pop();
              Symbol sym3 = (Symbol) stack.pop();
              Symbol sym2 = (Symbol) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce38(sym1, sym2, sym3, sym4, sym5);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][11];
              break;
            }
            case 4: {
              syntaxError(next);
            }
            case 5: {
              Symbol sym5 = (Symbol) stack.pop();
              Symbol sym4 = (Symbol) stack.pop();
              Symbol sym3 = (Symbol) stack.pop();
              Symbol sym2 = (Symbol) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce38(sym1, sym2, sym3, sym4, sym5);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][11];
              break;
            }
            case 6: {
              Symbol sym5 = (Symbol) stack.pop();
              Symbol sym4 = (Symbol) stack.pop();
              Symbol sym3 = (Symbol) stack.pop();
              Symbol sym2 = (Symbol) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce38(sym1, sym2, sym3, sym4, sym5);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][11];
              break;
            }
            case 7: {
              syntaxError(next);
            }
            case 8: {
              syntaxError(next);
            }
            case 9: {
              Symbol sym5 = (Symbol) stack.pop();
              Symbol sym4 = (Symbol) stack.pop();
              Symbol sym3 = (Symbol) stack.pop();
              Symbol sym2 = (Symbol) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce38(sym1, sym2, sym3, sym4, sym5);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][11];
              break;
            }
            case 10: {
              Symbol sym5 = (Symbol) stack.pop();
              Symbol sym4 = (Symbol) stack.pop();
              Symbol sym3 = (Symbol) stack.pop();
              Symbol sym2 = (Symbol) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce38(sym1, sym2, sym3, sym4, sym5);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][11];
              break;
            }
            case 11: {
              Symbol sym5 = (Symbol) stack.pop();
              Symbol sym4 = (Symbol) stack.pop();
              Symbol sym3 = (Symbol) stack.pop();
              Symbol sym2 = (Symbol) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce38(sym1, sym2, sym3, sym4, sym5);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][11];
              break;
            }
            case 12: {
              Symbol sym5 = (Symbol) stack.pop();
              Symbol sym4 = (Symbol) stack.pop();
              Symbol sym3 = (Symbol) stack.pop();
              Symbol sym2 = (Symbol) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce38(sym1, sym2, sym3, sym4, sym5);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][11];
              break;
            }
            case 13: {
              Symbol sym5 = (Symbol) stack.pop();
              Symbol sym4 = (Symbol) stack.pop();
              Symbol sym3 = (Symbol) stack.pop();
              Symbol sym2 = (Symbol) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce38(sym1, sym2, sym3, sym4, sym5);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][11];
              break;
            }
            case 14: {
              syntaxError(next);
            }
            case 15: {
              syntaxError(next);
            }
            case 16: {
              syntaxError(next);
            }
            case 17: {
              Symbol sym5 = (Symbol) stack.pop();
              Symbol sym4 = (Symbol) stack.pop();
              Symbol sym3 = (Symbol) stack.pop();
              Symbol sym2 = (Symbol) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce38(sym1, sym2, sym3, sym4, sym5);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][11];
              break;
            }
            case 18: {
              Symbol sym5 = (Symbol) stack.pop();
              Symbol sym4 = (Symbol) stack.pop();
              Symbol sym3 = (Symbol) stack.pop();
              Symbol sym2 = (Symbol) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce38(sym1, sym2, sym3, sym4, sym5);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][11];
              break;
            }
            case 19: {
              syntaxError(next);
            }
            case 20: {
              syntaxError(next);
            }
            case 21: {
              syntaxError(next);
            }
            case 22: {
              Symbol sym5 = (Symbol) stack.pop();
              Symbol sym4 = (Symbol) stack.pop();
              Symbol sym3 = (Symbol) stack.pop();
              Symbol sym2 = (Symbol) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce38(sym1, sym2, sym3, sym4, sym5);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][11];
              break;
            }
            case 23: {
              syntaxError(next);
            }
            case 24: {
              syntaxError(next);
            }
            case 25: {
              syntaxError(next);
            }
          }
          break;
        case 83:
          if (DEBUG) System.out.format("[%s] ", next);
          switch (next.getId()) {
            case 0: {
              syntaxError(next);
            }
            case 1: {
              syntaxError(next);
            }
            case 2: {
              syntaxError(next);
            }
            case 3: {
              syntaxError(next);
            }
            case 4: {
              syntaxError(next);
            }
            case 5: {
              syntaxError(next);
            }
            case 6: {
              syntaxError(next);
            }
            case 7: {
              syntaxError(next);
            }
            case 8: {
              syntaxError(next);
            }
            case 9: {
              syntaxError(next);
            }
            case 10: {
              syntaxError(next);
            }
            case 11: {
              syntaxError(next);
            }
            case 12: {
              syntaxError(next);
            }
            case 13: {
              syntaxError(next);
            }
            case 14: {
              syntaxError(next);
            }
            case 15: {
              syntaxError(next);
            }
            case 16: {
              syntaxError(next);
            }
            case 17: {
              syntaxError(next);
            }
            case 18: {
              syntaxError(next);
            }
            case 19: {
              Symbol sym3 = (Symbol) stack.pop();
              Symbol sym2 = (Symbol) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce39(sym1, sym2, sym3);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][6];
              break;
            }
            case 20: {
              syntaxError(next);
            }
            case 21: {
              Symbol sym3 = (Symbol) stack.pop();
              Symbol sym2 = (Symbol) stack.pop();
              Symbol sym1 = (Symbol) stack.pop();
              Symbol _result = reduce39(sym1, sym2, sym3);
              stack.push(_result);
              stateStack.pop();
              stateStack.pop();
              state = gotos[stateStack.peek()][6];
              break;
            }
            case 22: {
              syntaxError(next);
            }
            case 23: {
              syntaxError(next);
            }
            case 24: {
              syntaxError(next);
            }
            case 25: {
              syntaxError(next);
            }
          }
          break;
    }
    }
    return stack.pop();
  }


  GDecl reduce8(Symbol TERMINALS, List symList, Symbol SEMICOLON) {
    // decl -> TERMINALS symList SEMICOLON
    if (DEBUG) System.out.println("decl -> TERMINALS symList SEMICOLON");
    return new Terminals(symList);
  }

  GDecl reduce23(Symbol name, Symbol EQ, List ruleList, Symbol SEMICOLON) {
    // decl -> ID EQ ruleList SEMICOLON
    if (DEBUG) System.out.println("decl -> ID EQ ruleList SEMICOLON");
    return withPos(name, new GProduction(new Opt(), name.toString(), ruleList));
  }

  GSym reduce4(Symbol ID) {
    // sym -> ID
    if (DEBUG) System.out.println("sym -> ID");
    return (GSym) new GSym(ID.toString()).setPosition(ID);
  }

  List reduce3(List declList, GDecl decl) {
    // declList -> declList decl
    if (DEBUG) System.out.println("declList -> declList decl");
    return declList.add(decl);
  }

  GDecl reduce9(Symbol PACKAGE, Symbol name, Symbol SEMICOLON) {
    // decl -> PACKAGE STRING SEMICOLON
    if (DEBUG) System.out.println("decl -> PACKAGE STRING SEMICOLON");
    return new PackageDecl(name.toString());
  }

  Opt reduce11() {
    // actName -> 
    if (DEBUG) System.out.println("actName -> ");
    return new Opt();
  }

  GDecl reduce30(Type type, Symbol name, Symbol COLONEQ, List ruleList, Symbol SEMICOLON) {
    // decl -> type ID COLONEQ ruleList SEMICOLON
    if (DEBUG) System.out.println("decl -> type ID COLONEQ ruleList SEMICOLON");
    return new GProduction(new Opt(type), name.toString(), ruleList);
  }

  List reduce22(List list, GComponent component) {
    // componentList -> componentList component
    if (DEBUG) System.out.println("componentList -> componentList component");
    return list.add(component);
  }

  GRule reduce15(List componentListOpt) {
    // rule -> componentListOpt
    if (DEBUG) System.out.println("rule -> componentListOpt");
    return new GRule(componentListOpt, new Opt(), new Opt());
  }

  GRule reduce37(List componentListOpt, GPrecedence precedence, GAction semanticAction) {
    // rule -> componentListOpt precedence semanticAction
    if (DEBUG) System.out.println("rule -> componentListOpt precedence semanticAction");
    return new GRule(componentListOpt, new Opt(precedence), new Opt(semanticAction));
  }

  GDecl reduce19(Symbol CLASS, Symbol name, Symbol SEMICOLON) {
    // decl -> CLASS STRING SEMICOLON
    if (DEBUG) System.out.println("decl -> CLASS STRING SEMICOLON");
    return new ClassDecl(name.toString());
  }

  GDecl reduce27(Symbol EMBED, Symbol CODE_START, Symbol code, Symbol CODE_END, Symbol SEMICOLON) {
    // decl -> EMBED CODE_START JAVA_CODE CODE_END SEMICOLON
    if (DEBUG) System.out.println("decl -> EMBED CODE_START JAVA_CODE CODE_END SEMICOLON");
    return new EmbedCode(code.toString());
  }

  List reduce1(GDecl decl) {
    // declList -> decl
    if (DEBUG) System.out.println("declList -> decl");
    return new List<GDecl>(decl);
  }

  GGrammar reduce0(List declList) {
    // grammar -> declList
    if (DEBUG) System.out.println("grammar -> declList");
    return new GGrammar(declList);
  }

  Type reduce2(Symbol typename) {
    // type -> ID
    if (DEBUG) System.out.println("type -> ID");
    return (Type) new Type(typename.toString()).setPosition(typename);
  }

  List reduce13(List componentList) {
    // componentListOpt -> componentList
    if (DEBUG) System.out.println("componentListOpt -> componentList");
    return componentList;
  }

  List reduce6() {
    // componentListOpt -> 
    if (DEBUG) System.out.println("componentListOpt -> ");
    return new List<GComponent>();
  }

  List reduce12(GRule rule) {
    // ruleList -> rule
    if (DEBUG) System.out.println("ruleList -> rule");
    return new List().add(rule);
  }

  GRule reduce25(List componentListOpt, GPrecedence precedence) {
    // rule -> componentListOpt precedence
    if (DEBUG) System.out.println("rule -> componentListOpt precedence");
    return new GRule(componentListOpt, new Opt(precedence), new Opt());
  }

  List reduce35(List list, Symbol OR, GRule rule) {
    // ruleList -> ruleList OR rule
    if (DEBUG) System.out.println("ruleList -> ruleList OR rule");
    return list.add(rule);
  }

  GDecl reduce17(Symbol RIGHT, List symList, Symbol SEMICOLON) {
    // decl -> RIGHT symList SEMICOLON
    if (DEBUG) System.out.println("decl -> RIGHT symList SEMICOLON");
    return new RightAssoc(symList);
  }

  GDecl reduce38(Symbol TYPEOF, Symbol ID, Symbol EQ, Symbol STRING, Symbol SEMICOLON) {
    // decl -> TYPEOF ID EQ STRING SEMICOLON
    if (DEBUG) System.out.println("decl -> TYPEOF ID EQ STRING SEMICOLON");
    return new TypeOf(ID.toString(), STRING.toString());
  }

  GDecl reduce16(Symbol LEFT, List symList, Symbol SEMICOLON) {
    // decl -> LEFT symList SEMICOLON
    if (DEBUG) System.out.println("decl -> LEFT symList SEMICOLON");
    return new LeftAssoc(symList);
  }

  List reduce20(List list, Symbol COMMA, GSym sym) {
    // symList -> symList COMMA sym
    if (DEBUG) System.out.println("symList -> symList COMMA sym");
    return list.add(sym);
  }

  GAction reduce39(Symbol CODE_START, Symbol code, Symbol CODE_END) {
    // semanticAction -> CODE_START JAVA_CODE CODE_END
    if (DEBUG) System.out.println("semanticAction -> CODE_START JAVA_CODE CODE_END");
    return new GAction(code.toString());
  }

  GComponent reduce21(Symbol id, Opt an) {
    // component -> ID actName
    if (DEBUG) System.out.println("component -> ID actName");
    return withPos(id, new GComponent(id.toString(), an, ""));
  }

  GGrammar reduce7(GGrammar grammar, Symbol sym2) {
    // GOAL -> grammar EOF
    if (DEBUG) System.out.println("GOAL -> grammar EOF");
    return grammar;
  }

  GComponent reduce32(Symbol id, Opt an, Symbol PLUS) {
    // component -> ID actName PLUS
    if (DEBUG) System.out.println("component -> ID actName PLUS");
    return withPos(id, new GComponent(id.toString(), an, "+"));
  }

  GDecl reduce10(Symbol GOAL, Symbol ID, Symbol SEMICOLON) {
    // decl -> GOAL ID SEMICOLON
    if (DEBUG) System.out.println("decl -> GOAL ID SEMICOLON");
    return new Goal(ID.toString());
  }

  GComponent reduce31(Symbol id, Opt an, Symbol ASTERISK) {
    // component -> ID actName ASTERISK
    if (DEBUG) System.out.println("component -> ID actName ASTERISK");
    return withPos(id, new GComponent(id.toString(), an, "*"));
  }

  GRule reduce24(List componentListOpt, GAction semanticAction) {
    // rule -> componentListOpt semanticAction
    if (DEBUG) System.out.println("rule -> componentListOpt semanticAction");
    return new GRule(componentListOpt, new Opt(), new Opt(semanticAction));
  }

  GDecl reduce26(Symbol name, Symbol COLONEQ, List ruleList, Symbol SEMICOLON) {
    // decl -> ID COLONEQ ruleList SEMICOLON
    if (DEBUG) System.out.println("decl -> ID COLONEQ ruleList SEMICOLON");
    return withPos(name, new GProduction(new Opt(), name.toString(), ruleList));
  }

  GPrecedence reduce36(Symbol at, Symbol id) {
    // precedence -> AT ID
    if (DEBUG) System.out.println("precedence -> AT ID");
    return withPos(at, new GPrecedence(id.toString()));
  }

  GComponent reduce33(Symbol id, Opt an, Symbol QUESTION) {
    // component -> ID actName QUESTION
    if (DEBUG) System.out.println("component -> ID actName QUESTION");
    return withPos(id, new GComponent(id.toString(), an, "?"));
  }

  List reduce14(GComponent component) {
    // componentList -> component
    if (DEBUG) System.out.println("componentList -> component");
    return new List().add(component);
  }

  GDecl reduce18(Symbol NONASSOC, List symList, Symbol SEMICOLON) {
    // decl -> NONASSOC symList SEMICOLON
    if (DEBUG) System.out.println("decl -> NONASSOC symList SEMICOLON");
    return new NonAssoc(symList);
  }

  GDecl reduce29(Type type, Symbol name, Symbol EQ, List ruleList, Symbol SEMICOLON) {
    // decl -> type ID EQ ruleList SEMICOLON
    if (DEBUG) System.out.println("decl -> type ID EQ ruleList SEMICOLON");
    return new GProduction(new Opt(type), name.toString(), ruleList);
  }

  GDecl reduce28(Symbol HEADER, Symbol CODE_START, Symbol code, Symbol CODE_END, Symbol SEMICOLON) {
    // decl -> HEADER CODE_START JAVA_CODE CODE_END SEMICOLON
    if (DEBUG) System.out.println("decl -> HEADER CODE_START JAVA_CODE CODE_END SEMICOLON");
    return new HeaderCode(code.toString());
  }

  List reduce5(GSym sym) {
    // symList -> sym
    if (DEBUG) System.out.println("symList -> sym");
    return new List().add(sym);
  }

  Opt reduce34(Symbol DOT, Symbol id) {
    // actName -> DOT ID
    if (DEBUG) System.out.println("actName -> DOT ID");
    return new Opt(new ActionName(id.toString()));
  }

  private static final int[][] gotos = {
    { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, },
    { 2, 0, 0, -1, 0, 0, 0, 12, 0, 0, 6, 9, 0, 0, 0, },
    { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 6, 17, 0, 0, 0, },
    { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, },
    { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, },
    { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 21, 22, 0, },
    { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, },
    { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, },
    { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, },
    { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, },
    { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, },
    { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 21, 28, 0, },
    { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, },
    { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 21, 30, 0, },
    { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, },
    { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 21, 32, 0, },
    { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, },
    { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, },
    { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, },
    { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, },
    { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, },
    { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, },
    { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, },
    { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, },
    { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, },
    { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, },
    { 0, 43, 44, 0, 45, 0, 0, 0, 46, 0, 0, 0, 0, 0, 47, },
    { 0, 43, 44, 0, 45, 0, 0, 0, 48, 0, 0, 0, 0, 0, 47, },
    { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, },
    { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, },
    { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, },
    { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, },
    { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, },
    { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, },
    { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, },
    { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, },
    { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, },
    { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 56, 0, 0, },
    { 0, 43, 44, 0, 45, 0, 0, 0, 57, 0, 0, 0, 0, 0, 47, },
    { 0, 43, 44, 0, 45, 0, 0, 0, 58, 0, 0, 0, 0, 0, 47, },
    { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, },
    { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, },
    { 0, 0, 0, 0, 0, 59, 0, 0, 0, 0, 0, 0, 0, 0, 0, },
    { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, },
    { 0, 0, 0, 0, 61, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, },
    { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, },
    { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, },
    { 0, 0, 0, 0, 0, 0, 64, 0, 0, 66, 0, 0, 0, 0, 0, },
    { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, },
    { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, },
    { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, },
    { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, },
    { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, },
    { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, },
    { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, },
    { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, },
    { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, },
    { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, },
    { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, },
    { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, },
    { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, },
    { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, },
    { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, },
    { 0, 78, 44, 0, 45, 0, 0, 0, 0, 0, 0, 0, 0, 0, 47, },
    { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, },
    { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, },
    { 0, 0, 0, 0, 0, 0, 80, 0, 0, 0, 0, 0, 0, 0, 0, },
    { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, },
    { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, },
    { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, },
    { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, },
    { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, },
    { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, },
    { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, },
    { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, },
    { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, },
    { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, },
    { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, },
    { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, },
    { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, },
    { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, },
    { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, },
    { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, },
    { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, },
  };

}
